/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.api.lnf.LookAndFeelProvider;
import ancestris.app.App;
import ancestris.app.AppOptions;
import ancestris.app.OptionDisplayOptionsPanelController;
import ancestris.core.TextOptions;
import ancestris.startup.settings.StartupOptions;
import ancestris.util.Lifecycle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

final class OptionDisplayPanel
extends JPanel {
    private final OptionDisplayOptionsPanelController controller;
    Locale[] locales = new Locale[]{new Locale("br"), new Locale("es"), new Locale("ca"), new Locale("cs"), new Locale("da"), Locale.GERMAN, Locale.ENGLISH, new Locale("el"), new Locale("fi"), Locale.FRENCH, new Locale("hu"), Locale.ITALIAN, new Locale("lv"), new Locale("nl"), new Locale("no"), new Locale("pl"), new Locale("pt"), new Locale("ru"), new Locale("sv"), new Locale("tr")};
    private static final LookAndFeelProvider[] SKINS = LookAndFeelProvider.getProviders();
    private long memTotal;
    private String xmx = "";
    private JCheckBox jCheckBoxWindow;
    private JComboBox jComboBoxAppearance;
    private JLabel jLabel5;
    private JLabel jLabelAppearance;
    private JLabel jLabelFontsize;
    private JLabel jLabelLanguage;
    private JLabel jLabelMemsize;
    private JLabel jLabelOutput;
    private JLabel jLabelWindow;
    private JLabel jLabelcMemsize;
    private JPanel jPanelDemo;
    private JSpinner jSpinnerFontsize;
    private JSpinner jSpinnerMemsize;
    private JComboBox jcbLanguage;
    private JComboBox jcbOutputLanguage;

    OptionDisplayPanel(OptionDisplayOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.jComboBoxAppearanceActionPerformed(null);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    private void initComponents() {
        this.jLabelLanguage = new JLabel();
        this.jcbLanguage = new JComboBox<String>(this.initLanguages(NbBundle.getMessage(App.class, (String)"options.lang.system")));
        this.jLabelOutput = new JLabel();
        this.jcbOutputLanguage = new JComboBox<String>(this.initLanguages(NbBundle.getMessage(App.class, (String)"options.lang.gui")));
        this.jLabelAppearance = new JLabel();
        this.jComboBoxAppearance = new JComboBox<LookAndFeelProvider>(SKINS);
        this.jLabelFontsize = new JLabel();
        this.jSpinnerFontsize = new JSpinner();
        this.jLabelWindow = new JLabel();
        this.jCheckBoxWindow = new JCheckBox();
        this.jLabelMemsize = new JLabel();
        this.jSpinnerMemsize = new JSpinner();
        this.jLabelcMemsize = new JLabel();
        this.jPanelDemo = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabelLanguage.setFont(this.jLabelLanguage.getFont().deriveFont(this.jLabelLanguage.getFont().getStyle() | 1, this.jLabelLanguage.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelLanguage, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelLanguage.text"));
        this.jcbLanguage.setMaximumRowCount(25);
        this.jcbLanguage.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jcbLanguage.toolTipText"));
        this.jLabelOutput.setFont(this.jLabelOutput.getFont().deriveFont(this.jLabelOutput.getFont().getStyle() | 1, this.jLabelOutput.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelOutput, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelOutput.text"));
        this.jcbOutputLanguage.setMaximumRowCount(25);
        this.jcbOutputLanguage.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jcbOutputLanguage.toolTipText"));
        this.jLabelAppearance.setFont(this.jLabelAppearance.getFont().deriveFont(this.jLabelAppearance.getFont().getStyle() | 1, this.jLabelAppearance.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelAppearance, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelAppearance.text"));
        this.jComboBoxAppearance.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jComboBoxAppearance.toolTipText"));
        this.jComboBoxAppearance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDisplayPanel.this.jComboBoxAppearanceActionPerformed(evt);
            }
        });
        this.jLabelFontsize.setFont(this.jLabelFontsize.getFont().deriveFont(this.jLabelFontsize.getFont().getStyle() | 1, this.jLabelFontsize.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelFontsize, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelFontsize.text"));
        this.jSpinnerFontsize.setModel(new SpinnerNumberModel(12, 5, 40, 1));
        this.jLabelWindow.setFont(this.jLabelWindow.getFont().deriveFont(this.jLabelWindow.getFont().getStyle() | 1, this.jLabelWindow.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelWindow, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelWindow.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxWindow, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jCheckBoxWindow.text"));
        this.jCheckBoxWindow.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jCheckBoxWindow.toolTipText"));
        this.jLabelMemsize.setFont(this.jLabelMemsize.getFont().deriveFont(this.jLabelMemsize.getFont().getStyle() | 1, this.jLabelMemsize.getFont().getSize() + 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelMemsize, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelMemsize.text"));
        this.jSpinnerMemsize.setModel(new SpinnerNumberModel(1, 1, 12, 1));
        Mnemonics.setLocalizedText((JLabel)this.jLabelcMemsize, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelcMemsize.text"));
        this.jPanelDemo.setBackground(new Color(179, 179, 179));
        this.jPanelDemo.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelDemo.setPreferredSize(new Dimension(199, 224));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabel5.text"));
        GroupLayout jPanelDemoLayout = new GroupLayout(this.jPanelDemo);
        this.jPanelDemo.setLayout(jPanelDemoLayout);
        jPanelDemoLayout.setHorizontalGroup(jPanelDemoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDemoLayout.createSequentialGroup().addComponent(this.jLabel5, -2, 177, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDemoLayout.setVerticalGroup(jPanelDemoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDemoLayout.createSequentialGroup().addComponent(this.jLabel5, -2, 214, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelWindow).addComponent(this.jLabelMemsize).addComponent(this.jLabelOutput).addComponent(this.jLabelLanguage).addComponent(this.jLabelAppearance).addComponent(this.jLabelFontsize)).addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxAppearance, 0, -1, Short.MAX_VALUE).addComponent(this.jcbOutputLanguage, 0, -1, Short.MAX_VALUE).addComponent(this.jcbLanguage, 0, -1, Short.MAX_VALUE)).addGap(32, 32, 32)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxWindow).addComponent(this.jSpinnerFontsize, -2, 90, -2).addGroup(layout.createSequentialGroup().addComponent(this.jSpinnerMemsize, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelcMemsize))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addComponent(this.jPanelDemo, -2, 182, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDemo, -2, 219, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelLanguage).addComponent(this.jcbLanguage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOutput).addComponent(this.jcbOutputLanguage, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAppearance).addComponent(this.jComboBoxAppearance, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerFontsize, -2, -1, -2).addComponent(this.jLabelFontsize)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelWindow).addComponent(this.jCheckBoxWindow)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMemsize).addComponent(this.jSpinnerMemsize, -2, -1, -2).addComponent(this.jLabelcMemsize)))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jComboBoxAppearanceActionPerformed(ActionEvent evt) {
        LookAndFeelProvider provider = (LookAndFeelProvider)this.jComboBoxAppearance.getSelectedItem();
        this.jLabel5.setIcon(provider == null ? null : provider.getSampleImage());
    }

    void load() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        String currentXmx = "";
        List<String> arguments = runtimeMxBean.getInputArguments();
        for (String s : arguments) {
            if (!s.contains("-Xmx")) continue;
            currentXmx = s.substring(4);
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
            this.memTotal = 1L + Long.parseLong(attribute.toString()) / 0x40000000L;
            this.jSpinnerMemsize.setModel(new SpinnerNumberModel(1.0, 1.0, this.memTotal - 1L, 1.0));
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        StartupOptions stopts = new StartupOptions();
        this.xmx = stopts.getJvmParameter("-J-Xmx");
        if (this.xmx == null || this.xmx.isEmpty()) {
            this.xmx = currentXmx;
        }
        this.setLanguage(stopts.getJvmLocale());
        this.setOutputLanguage(TextOptions.getInstance().getOutputLocale(null));
        String value = AppOptions.getFontSize();
        if (value != null && !value.isEmpty()) {
            this.jSpinnerFontsize.setValue(Integer.valueOf(value));
        }
        this.jComboBoxAppearance.setSelectedItem(LookAndFeelProvider.getProviderFromName((String)stopts.getJvmParameter("--laf")));
        this.jCheckBoxWindow.setSelected(AppOptions.isRestoreViews());
        if (this.xmx != null) {
            Integer i;
            Integer c = 0;
            try {
                i = Integer.valueOf(this.xmx.replace('g', ' ').trim());
                c = Integer.valueOf(currentXmx.replace('g', ' ').trim());
            }
            catch (NumberFormatException e) {
                i = 1;
            }
            this.jSpinnerMemsize.setValue(i);
            this.jLabelcMemsize.setText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabelcMemsize.text", (Object)c));
        }
    }

    void store() {
        boolean needRestart = false;
        StartupOptions stopts = new StartupOptions();
        needRestart |= stopts.setJvmLocale(this.getLanguage());
        TextOptions.getInstance().setOutputLocale(this.getOutputLanguage());
        needRestart |= stopts.setJvmParameter("--laf", ((LookAndFeelProvider)this.jComboBoxAppearance.getSelectedItem()).getName());
        stopts.setJvmParameter("--cp:p", ((LookAndFeelProvider)this.jComboBoxAppearance.getSelectedItem()).getClassPath());
        needRestart |= !AppOptions.getFontSize().equals(this.jSpinnerFontsize.getValue().toString());
        AppOptions.setFontSize(this.jSpinnerFontsize.getValue().toString());
        stopts.applyChanges();
        AppOptions.setRestoreViews(this.jCheckBoxWindow.isSelected());
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionPanel.saved.statustext"));
        if (needRestart |= stopts.setJvmParameter("-J-Xmx", ((SpinnerNumberModel)this.jSpinnerMemsize.getModel()).getNumber().intValue() + "g")) {
            Lifecycle.askForStopAndStart(null, this.getLanguage());
        }
    }

    private String[] initLanguages(String defaultDesc) {
        ArrayList<String> langDescr = new ArrayList<String>(this.locales.length);
        langDescr.add(defaultDesc);
        for (Locale locale : this.locales) {
            if (locale.getDisplayName(locale).equals("espa\u00f1ol")) {
                langDescr.add("Castellano");
                continue;
            }
            langDescr.add(locale.getDisplayName(locale));
        }
        return langDescr.toArray(new String[0]);
    }

    private int findLanguageIndex(Locale locale) {
        int i;
        if (locale == null) {
            return -1;
        }
        for (i = 0; i < this.locales.length; ++i) {
            if (!locale.equals(this.locales[i])) continue;
            return i;
        }
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        for (i = 0; i < this.locales.length; ++i) {
            if (!locale.getLanguage().equals(this.locales[i].getLanguage())) continue;
            return i;
        }
        return -1;
    }

    void setLanguage(Locale locale) {
        int i = this.findLanguageIndex(locale);
        this.jcbLanguage.setSelectedIndex(++i);
    }

    Locale getLanguage() {
        int i = this.jcbLanguage.getSelectedIndex() - 1;
        if (i < 0 || i >= this.locales.length) {
            return null;
        }
        return this.locales[i];
    }

    void setOutputLanguage(Locale locale) {
        int i = this.findLanguageIndex(locale);
        this.jcbOutputLanguage.setSelectedIndex(++i);
    }

    Locale getOutputLanguage() {
        int i = this.jcbOutputLanguage.getSelectedIndex() - 1;
        if (i < 0 || i >= this.locales.length) {
            return null;
        }
        return this.locales[i];
    }
}

