/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.Utilities;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Indi;
import java.text.Normalizer;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;

public class IndiQuickSearch
implements SearchProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        String req = request.getText().trim();
        IndiQuickSearch indiQuickSearch = this;
        synchronized (indiQuickSearch) {
            for (Context context : GedcomDirectory.getDefault().getContexts()) {
                for (Indi indi : context.getGedcom().getIndis()) {
                    String str2;
                    String sosaStr = indi.getSosaString();
                    String indiName = indi.toString(true) + (sosaStr.isEmpty() ? "" : " [" + indi.getSosaString() + "]");
                    String str1 = Normalizer.normalize(this.getStringFromIndi(indi), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
                    if (!Utilities.wordsMatch((String)str1, (String)(str2 = Normalizer.normalize(req, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "")).toLowerCase()) || response.addResult(this.createAction((Entity)indi), indiName)) continue;
                    return;
                }
            }
        }
    }

    private Runnable createAction(final Entity entity) {
        return new Runnable(){

            @Override
            public void run() {
                SelectionDispatcher.fireSelection((Context)new Context(entity));
            }
        };
    }

    private String getStringFromIndi(Indi indi) {
        String[] firstnames;
        String[] names;
        String ret = "";
        for (String name : names = indi.getLastNames()) {
            ret = ret + name + " ";
        }
        for (String firstname : firstnames = indi.getFirstNames()) {
            ret = ret + firstname + " ";
        }
        ret = ret + indi.toString(true);
        String sosaStr = indi.getSosaString();
        if (!sosaStr.isEmpty()) {
            ret = ret + " [" + sosaStr + "]";
        }
        return ret.toLowerCase();
    }
}

