/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.familygroups;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.SubMenuAction;
import ancestris.gedcom.GedcomDirectory;
import ancestris.modules.familygroups.FamilyGroupsPlugin;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.io.Filter;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ActionMark
extends SubMenuAction {
    private static ImageIcon imgMark = new ImageIcon(ActionMark.class.getResource("MarkingIcon.png"));
    private static ImageIcon imgUnmark = new ImageIcon(ActionMark.class.getResource("Clean.png"));
    private static String TAG = "_FAMILY_GROUP";
    private Gedcom gedcom;
    private List<? extends Filter> filters;

    public ActionMark(Gedcom gedcom, List<? extends Filter> filters) {
        this.gedcom = gedcom;
        this.filters = filters;
        this.setImage(imgMark);
        this.setTip(NbBundle.getMessage(ActionMark.class, (String)"markgroup.tip"));
        this.addAction((Action)this.createMarkAction());
        this.addAction((Action)this.createUnmarkAction());
    }

    public void actionPerformed(ActionEvent event) {
        super.actionPerformed(event);
    }

    private AbstractAncestrisAction createMarkAction() {
        AbstractAncestrisAction action = new AbstractAncestrisAction(){

            public void actionPerformed(ActionEvent event) {
                ActionMark.commit(ActionMark.this.gedcom, new Runnable(){

                    @Override
                    public void run() {
                        for (Filter f : ActionMark.this.filters) {
                            ActionMark.markFilter(ActionMark.this.gedcom, (FamilyGroupsPlugin.FamilyGroupFilter)f);
                        }
                    }
                });
            }
        };
        action.setImage((Icon)imgMark);
        action.setText(NbBundle.getMessage(ActionMark.class, (String)"markgroup.mark"));
        return action;
    }

    private AbstractAncestrisAction createUnmarkAction() {
        AbstractAncestrisAction action = new AbstractAncestrisAction(){

            public void actionPerformed(ActionEvent event) {
                ActionMark.commit(ActionMark.this.gedcom, new Runnable(){

                    @Override
                    public void run() {
                        for (Filter f : ActionMark.this.filters) {
                            ActionMark.unmarkFilter(ActionMark.this.gedcom, (FamilyGroupsPlugin.FamilyGroupFilter)f);
                        }
                    }
                });
            }
        };
        action.setImage((Icon)imgUnmark);
        action.setText(NbBundle.getMessage(ActionMark.class, (String)"markgroup.unmark"));
        return action;
    }

    private static void commit(Gedcom gedcom, Runnable task) {
        block5: {
            try {
                if (gedcom.isWriteLocked()) {
                    task.run();
                    break block5;
                }
                gedcom.doUnitOfWork(localGedcom -> task.run());
            }
            catch (GedcomException ge) {
                Exceptions.printStackTrace((Throwable)ge);
            }
        }
    }

    public static void markFilter(Gedcom gedcom, FamilyGroupsPlugin.FamilyGroupFilter filter) {
        ActionMark.commit(gedcom, () -> {
            filter.getSubgroups().stream().filter(subgroup -> subgroup.isSelected()).forEachOrdered(subgroup -> subgroup.getIndis().forEach(indi -> {
                String value = filter.getTagValue((FamilyGroupsPlugin.SubgroupInfo)subgroup);
                Property prop = indi.getProperty(TAG);
                if (prop == null) {
                    prop = indi.addProperty(TAG, "");
                }
                prop.setValue(value);
            }));
            Context ctx = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
            GedcomDirectory.getDefault().activateTopComponent(ctx);
        });
    }

    public static void unmarkFilter(Gedcom gedcom, FamilyGroupsPlugin.FamilyGroupFilter filter) {
        ActionMark.commit(gedcom, () -> {
            filter.getSubgroups().stream().filter(subgroup -> subgroup.isSelected()).forEachOrdered(subgroup -> subgroup.getIndis().forEach(indi -> {
                for (Property prop : indi.getProperties(TAG)) {
                    indi.delProperty(prop);
                }
            }));
            Context ctx = (Context)Utilities.actionsGlobalContext().lookup(Context.class);
            GedcomDirectory.getDefault().activateTopComponent(ctx);
        });
    }
}

