/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.EventWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.Entity;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import org.openide.util.Exceptions;

public class AssoWrapper {
    public PropertyAssociation assoProp = null;
    public String assoTxt = "";
    public Indi assoIndi = null;
    public boolean assoIsNewIndi = false;
    public String assoLastname = "";
    public String assoFirstname = "";
    public int assoSex = 0;
    public String assoOccupation = "";
    public boolean assoOccuDateUpdate = false;
    private Entity targetEntity = null;
    public EventWrapper targetEvent = null;
    private String targetEventTag = "";
    public String targetEventDesc = "";

    public AssoWrapper(String text) {
        this.assoTxt = text;
    }

    public AssoWrapper(PropertyForeignXRef xrefProperty, EventWrapper event) {
        if (xrefProperty == null) {
            return;
        }
        Indi associatedIndi = (Indi)xrefProperty.getTargetEntity();
        PropertyAssociation assoProperty = (PropertyAssociation)xrefProperty.getTarget();
        this.setValues(associatedIndi, assoProperty, event);
    }

    public AssoWrapper(PropertyAssociation assoProperty) {
        if (assoProperty == null) {
            return;
        }
        Indi associatedIndi = (Indi)assoProperty.getEntity();
        Property eventProp = assoProperty.getTargetParent();
        EventWrapper event = new EventWrapper(eventProp, associatedIndi, null);
        this.setValues(associatedIndi, assoProperty, event);
    }

    private AssoWrapper(AssoWrapper asso) {
        this.assoProp = asso.assoProp;
        this.assoTxt = asso.assoTxt;
        this.assoIndi = asso.assoIndi;
        this.assoIsNewIndi = asso.assoIsNewIndi;
        this.assoLastname = asso.assoLastname;
        this.assoFirstname = asso.assoFirstname;
        this.assoSex = asso.assoSex;
        this.assoOccupation = asso.assoOccupation;
        this.assoOccuDateUpdate = asso.assoOccuDateUpdate;
        this.targetEntity = asso.targetEntity;
        this.targetEvent = asso.targetEvent;
        this.targetEventTag = asso.targetEventTag;
        this.targetEventDesc = asso.targetEventDesc;
    }

    public boolean equals(AssoWrapper object) {
        return this.assoProp != null && this.assoProp.equals(object.assoProp);
    }

    private void setValues(Indi associatedIndi, PropertyAssociation assoProperty, EventWrapper event) {
        this.assoProp = assoProperty;
        this.assoIndi = associatedIndi;
        this.targetEntity = event.eventProperty.getEntity();
        this.targetEvent = event;
        this.assoLastname = this.assoIndi.getLastName();
        this.assoFirstname = this.assoIndi.getFirstName();
        this.assoSex = this.assoIndi.getSex();
        this.assoOccupation = this.getOccupation(this.assoIndi, this.targetEvent);
        this.assoOccuDateUpdate = false;
        this.targetEventDesc = this.assoProp.getDisplayValue(false);
        PropertyRelationship relaP = (PropertyRelationship)this.assoProp.getProperty("RELA");
        this.assoTxt = relaP.getDisplayValue();
    }

    public String getOccupation(Indi indi, EventWrapper event) {
        Property occu = indi.getPropertyAtDate("OCCU", event != null ? event.date : null);
        return occu == null ? "" : occu.getDisplayValue();
    }

    public static AssoWrapper clone(AssoWrapper asso) {
        return new AssoWrapper(asso);
    }

    public String toString() {
        String name = (this.assoLastname + " " + this.assoFirstname).trim();
        return this.assoTxt + (!name.isEmpty() ? " | " + name : "");
    }

    public void update() {
        if (!this.isToBeUpdated()) {
            return;
        }
        if (this.targetEntity == null) {
            this.targetEntity = this.targetEvent.eventProperty.getEntity();
        }
        if (this.assoIndi == null || this.assoIndi.getGedcom() == null) {
            try {
                this.assoIndi = (Indi)this.targetEntity.getGedcom().createEntity("INDI");
                this.assoProp = null;
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.assoIndi.setName(this.assoFirstname, this.assoLastname);
        this.assoIndi.setSex(this.assoSex);
        this.updateProperty((Property)this.assoIndi, "OCCU", this.assoOccupation, this.assoOccuDateUpdate, this.targetEvent.eventProperty);
        if (this.assoProp == null || this.assoIsNewIndi) {
            PropertyXRef assoXref = (PropertyXRef)this.assoIndi.addProperty("ASSO", "@");
            this.assoProp = (PropertyAssociation)assoXref;
        } else {
            this.removeLink(this.assoProp);
        }
        Utils.setDistinctValue((Property)this.assoProp, '@' + this.targetEntity.getId() + '@');
        TagPath anchor = this.getAnchor(this.targetEvent.eventProperty);
        this.putProperty((Property)this.assoProp, "RELA", this.assoTxt + (anchor == null ? "" : '@' + anchor.toString()));
        try {
            this.assoProp.link();
        }
        catch (Exception ex) {
            this.removeAsso(this.assoIndi, this.assoProp);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private boolean isToBeUpdated() {
        TagPath oldAnchor;
        if (this.assoIsNewIndi || this.assoOccuDateUpdate) {
            return true;
        }
        if (!this.assoIndi.getFirstName().equals(this.assoFirstname)) {
            return true;
        }
        if (!this.assoIndi.getLastName().equals(this.assoLastname)) {
            return true;
        }
        if (this.assoIndi.getSex() != this.assoSex) {
            return true;
        }
        Property[] occuProps = this.assoIndi.getProperties("OCCU");
        boolean found = false;
        for (Property p : occuProps) {
            String occuStr = "";
            if (p != null) {
                occuStr = p.getDisplayValue().trim();
            }
            if (!occuStr.equals(this.assoOccupation.trim())) continue;
            found = true;
        }
        if (!found) {
            return true;
        }
        if (this.targetEntity == null || this.assoIndi == null || this.assoIndi.getGedcom() == null || this.assoProp == null) {
            return true;
        }
        String val = this.assoProp.getValue();
        if (!val.equals('@' + this.targetEntity.getId() + '@')) {
            return true;
        }
        TagPath newAnchor = this.getAnchor(this.targetEvent.eventProperty);
        PropertyRelationship p = (PropertyRelationship)this.assoProp.getProperty("RELA");
        TagPath tagPath = oldAnchor = p != null ? p.getAnchor() : null;
        return oldAnchor == null || !oldAnchor.equals((Object)newAnchor);
    }

    public void remove() {
        if (this.assoIndi != null && this.assoProp != null) {
            this.removeLink(this.assoProp);
            this.removeAsso(this.assoIndi, this.assoProp);
        }
    }

    private void putProperty(Property property, String tag, String value) {
        Property prop = property.getProperty(tag, true);
        if (prop != null) {
            Utils.setDistinctValue(prop, value);
        } else {
            property.addProperty(tag, value);
        }
    }

    private void removeLink(PropertyAssociation pa) {
        PropertyXRef target = pa.getTarget();
        if (target == null) {
            return;
        }
        Property targetParent = target.getParent();
        pa.unlink();
        targetParent.delProperty((Property)target);
    }

    private void removeAsso(Indi indi, PropertyAssociation pa) {
        indi.delProperty((Property)pa);
    }

    private TagPath getAnchor(Property property) {
        if (property == null) {
            return null;
        }
        TagPath result = property.getPath(false);
        return property.getEntity().getProperty(result) == property ? result : property.getPath(true);
    }

    private void updateProperty(Property property, String tag, String newValue, boolean updateDate, Property sourceEvent) {
        if (newValue.isEmpty()) {
            return;
        }
        PropertyDate sourceDate = sourceEvent != null ? (PropertyDate)sourceEvent.getProperty("DATE") : null;
        String newDate = sourceDate != null ? sourceDate.getValue() : "";
        Property foundProperty = property.getPropertyAtDate(tag, sourceDate);
        String oldValue = foundProperty != null ? foundProperty.getValue() : "";
        PropertyDate pDate = foundProperty != null ? (PropertyDate)foundProperty.getProperty("DATE") : null;
        boolean overlap = true;
        boolean propertyChange = !newValue.equals(oldValue);
        PointInTime pStart = null;
        PointInTime pEnd = null;
        PointInTime sourceStart = null;
        PointInTime sourceEnd = null;
        try {
            pStart = pDate.getStart();
            pEnd = pDate.getEnd();
            if (pEnd == null || pEnd.isEmpty()) {
                pEnd = pStart;
            }
            sourceStart = sourceDate.getStart();
            sourceEnd = sourceDate.getEnd();
            if (sourceEnd == null || sourceEnd.isEmpty()) {
                sourceEnd = sourceStart;
            }
            overlap = sourceStart.compareTo(pStart) >= 0 && sourceStart.compareTo(pEnd) <= 0 || sourceEnd.compareTo(pStart) >= 0 && sourceEnd.compareTo(pEnd) <= 0 || pStart.compareTo(sourceStart) >= 0 && pStart.compareTo(sourceEnd) <= 0 || pEnd.compareTo(sourceStart) >= 0 && pEnd.compareTo(sourceEnd) <= 0;
        }
        catch (Exception e) {
            overlap = true;
        }
        if (!overlap && propertyChange) {
            foundProperty = null;
        }
        if (foundProperty == null) {
            Property prop = property.addProperty(tag, newValue);
            if (updateDate && !newDate.isEmpty()) {
                prop.addProperty("DATE", newDate);
            }
        } else {
            if (propertyChange) {
                foundProperty.setValue(newValue);
            }
            if (updateDate && !newDate.isEmpty()) {
                if (pDate == null) {
                    foundProperty.addProperty("DATE", newDate);
                } else if (!overlap) {
                    if (sourceEnd.compareTo(pStart) < 0) {
                        pDate.setValue(PropertyDate.FROM_TO, sourceStart, pEnd, "");
                    } else {
                        pDate.setValue(PropertyDate.FROM_TO, pStart, sourceEnd, "");
                    }
                }
            }
        }
    }
}

