/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking.persistence;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import swingx.docking.Bridge;
import swingx.docking.Dock;
import swingx.docking.Dockable;
import swingx.docking.Docking;
import swingx.docking.DockingPane;
import swingx.docking.Persister;
import swingx.docking.Slice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPersister
extends Persister {
    private static String NONE = "";
    private static Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private String version;
    private Writer writer;
    private Reader reader;
    private List<Docking> dockings;

    public XMLPersister(DockingPane dockingPane, Reader reader, String version) {
        super(dockingPane);
        this.reader = reader;
        this.version = version;
    }

    public XMLPersister(DockingPane dockingPane, Writer writer, String version) {
        super(dockingPane);
        this.writer = writer;
        this.version = version;
    }

    @Override
    protected List<Docking> loadDockings() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("no reader");
        }
        try {
            InputSource source = new InputSource(this.reader);
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(source, (DefaultHandler)new SAXIn());
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        catch (SAXException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        return this.dockings;
    }

    @Override
    protected void saveDockings(List<Docking> dockings) throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("no writer");
        }
        this.dockings = dockings;
        try {
            SAXSource source = new SAXSource(new SAXOut(), new InputSource());
            StreamResult target = new StreamResult(this.writer);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, target);
        }
        catch (TransformerException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    protected String formatKey(Object key) throws SAXException {
        if (key instanceof String) {
            return (String)key;
        }
        throw new SAXException("String keys supported only");
    }

    protected Object parseKey(String key) throws SAXException {
        return key;
    }

    private class SAXIn
    extends DefaultHandler {
        private Stack<Object> stack = new Stack();

        private SAXIn() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if ("dockingPane".equals(qName)) {
                if (XMLPersister.this.version != null && !XMLPersister.this.version.equals(atts.getValue("version"))) {
                    throw new SAXException("invalid version " + atts.getValue("version") + " != " + XMLPersister.this.version);
                }
                XMLPersister.this.dockings = new ArrayList();
                this.stack.push(XMLPersister.this.dockings);
            } else if ("docking".equals(qName)) {
                Docking docking = XMLPersister.this.createDocking();
                Rectangle screenBounds = new Rectangle();
                screenBounds.x = Integer.parseInt(atts.getValue("x"));
                screenBounds.y = Integer.parseInt(atts.getValue("y"));
                screenBounds.width = Integer.parseInt(atts.getValue("width"));
                screenBounds.height = Integer.parseInt(atts.getValue("height"));
                docking.setScreenBounds(screenBounds);
                XMLPersister.this.dockings.add(docking);
                this.stack.push(docking);
            } else if ("slice".equals(qName)) {
                Slice slice = XMLPersister.this.createSlice();
                slice.setOrientation(Integer.parseInt(atts.getValue("orientation")));
                slice.setWeight(Float.parseFloat(atts.getValue("weight")));
                this.add(slice);
                this.stack.push(slice);
            } else if ("dock".equals(qName)) {
                Dock dock = XMLPersister.this.createDock();
                this.add(dock);
                this.stack.push(dock);
            } else if ("bridge".equals(qName)) {
                Object key = XMLPersister.this.parseKey(atts.getValue("key"));
                Bridge bridge = XMLPersister.this.createBridge();
                JComponent bridged = null;
                if (!new Boolean(atts.getValue("null")).booleanValue()) {
                    bridged = XMLPersister.this.resolveComponent(key);
                }
                bridge.setBridged(key, bridged);
                this.add(bridge);
                this.stack.push(bridge);
            } else if ("dockable".equals(qName)) {
                Object key = XMLPersister.this.parseKey(atts.getValue("key"));
                Dockable dockable = null;
                if (!new Boolean(atts.getValue("null")).booleanValue()) {
                    dockable = XMLPersister.this.resolveDockable(key);
                }
                Dock dock = (Dock)this.stack.peek();
                dock.putDockable(key, dockable);
                if (dockable != null && new Boolean(atts.getValue("selected")).booleanValue()) {
                    dock.setSelectedDockable(dockable);
                }
                this.stack.push(dockable);
            } else {
                throw new SAXException("unkown qName '" + qName + "'");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void add(JComponent component) throws SAXException {
            JComponent parent = (JComponent)this.stack.peek();
            if (parent instanceof Docking) {
                Docking docking = (Docking)parent;
                docking.setRoot(component);
                return;
            } else {
                if (!(parent instanceof Slice)) throw new SAXException("unexpected parent");
                Slice slice = (Slice)parent;
                if (slice.getMain() == null) {
                    slice.setMain(component);
                    return;
                } else {
                    if (slice.getRemainder() != null) throw new SAXException("unexpected additional child");
                    slice.setRemainder(component);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.stack.pop();
        }
    }

    private class SAXOut
    implements XMLReader {
        private ContentHandler handler;

        private SAXOut() {
        }

        public void parse(InputSource input) throws IOException, SAXException {
            this.handler.startDocument();
            AttributesImpl attributes = new AttributesImpl();
            if (XMLPersister.this.version != null) {
                attributes.addAttribute(NONE, NONE, "version", NONE, XMLPersister.this.version);
            }
            this.handler.startElement(NONE, NONE, "dockingPane", attributes);
            int d = 0;
            while (d < XMLPersister.this.dockings.size()) {
                this.write((JComponent)XMLPersister.this.dockings.get(d), this.handler);
                ++d;
            }
            this.handler.endElement(NONE, NONE, "dockingPane");
            this.handler.endDocument();
        }

        protected void write(JComponent component, ContentHandler handler) throws SAXException {
            if (component instanceof Docking) {
                Docking docking = (Docking)component;
                AttributesImpl attributes = new AttributesImpl();
                Rectangle screenBounds = docking.getScreenBounds();
                attributes.addAttribute(NONE, NONE, "x", NONE, Integer.toString(screenBounds.x));
                attributes.addAttribute(NONE, NONE, "y", NONE, Integer.toString(screenBounds.y));
                attributes.addAttribute(NONE, NONE, "width", NONE, Integer.toString(screenBounds.width));
                attributes.addAttribute(NONE, NONE, "height", NONE, Integer.toString(screenBounds.height));
                handler.startElement(NONE, NONE, "docking", attributes);
                this.write(docking.getRoot(), handler);
                handler.endElement(NONE, NONE, "docking");
            } else if (component instanceof Slice) {
                Slice slice = (Slice)component;
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(NONE, NONE, "orientation", NONE, Integer.toString(slice.getOrientation()));
                attributes.addAttribute(NONE, NONE, "weight", NONE, Double.toString(slice.getWeight()));
                handler.startElement(NONE, NONE, "slice", attributes);
                this.write(slice.getMain(), handler);
                this.write(slice.getRemainder(), handler);
                handler.endElement(NONE, NONE, "slice");
            } else if (component instanceof Dock) {
                Dock dock = (Dock)component;
                handler.startElement(NONE, NONE, "dock", EMPTY_ATTRIBUTES);
                List<Object> keys = dock.getDockableKeys();
                int k = keys.size() - 1;
                while (k >= 0) {
                    Object key = keys.get(k);
                    Dockable dockable = dock.getDockable(key);
                    AttributesImpl attributes = new AttributesImpl();
                    attributes = new AttributesImpl();
                    attributes.addAttribute(NONE, NONE, "key", NONE, XMLPersister.this.formatKey(key));
                    if (dockable == null) {
                        attributes.addAttribute(NONE, NONE, "null", NONE, "true");
                    }
                    if (dockable != null && dockable == dock.getSelectedDockable()) {
                        attributes.addAttribute(NONE, NONE, "selected", NONE, "true");
                    }
                    handler.startElement(NONE, NONE, "dockable", attributes);
                    handler.endElement(NONE, NONE, "dockable");
                    --k;
                }
                handler.endElement(NONE, NONE, "dock");
            } else if (component instanceof Bridge) {
                Bridge bridge = (Bridge)component;
                Object key = bridge.getKey();
                JComponent bridged = bridge.getBridged();
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(NONE, NONE, "key", NONE, XMLPersister.this.formatKey(key));
                if (bridged == null) {
                    attributes.addAttribute(NONE, NONE, "null", NONE, "true");
                }
                handler.startElement(NONE, NONE, "bridge", attributes);
                handler.endElement(NONE, NONE, "bridge");
            } else {
                throw new SAXException("unknown component " + component);
            }
        }

        public ContentHandler getContentHandler() {
            return this.handler;
        }

        public void setContentHandler(ContentHandler handler) {
            this.handler = handler;
        }

        public DTDHandler getDTDHandler() {
            return null;
        }

        public EntityResolver getEntityResolver() {
            return null;
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }

        public boolean getFeature(String name) {
            return false;
        }

        public Object getProperty(String name) {
            return null;
        }

        public void parse(String systemId) throws IOException, SAXException {
        }

        public void setDTDHandler(DTDHandler handler) {
        }

        public void setEntityResolver(EntityResolver resolver) {
        }

        public void setErrorHandler(ErrorHandler handler) {
        }

        public void setFeature(String name, boolean value) {
        }

        public void setProperty(String name, Object value) {
        }
    }
}

