/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.ui;

import ancestris.app.ActionOpen;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.resources.Images;
import ancestris.gedcom.RecentFiles;
import ancestris.welcome.content.ActionButton;
import ancestris.welcome.content.BundleSupport;
import ancestris.welcome.content.Constants;
import ancestris.welcome.ui.Bundle;
import genj.gedcom.Gedcom;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.WordUtils;
import org.openide.filesystems.FileObject;

public class RecentFilesPanel
extends JPanel
implements Constants {
    private static final int MAX_FILES = 5;
    private PropertyChangeListener changeListener = null;

    public RecentFilesPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeAll();
        this.add((Component)this.rebuildContent(), "Center");
        RecentFiles.getDefault().addPropertyChangeListener(this.getPropertyChangeListener());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        RecentFiles.getDefault().removePropertyChangeListener(this.getPropertyChangeListener());
    }

    private PropertyChangeListener getPropertyChangeListener() {
        if (null == this.changeListener) {
            this.changeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("RecentFiletInformation".equals(e.getPropertyName())) {
                        RecentFilesPanel.this.removeAll();
                        RecentFilesPanel.this.add((Component)RecentFilesPanel.this.rebuildContent(), "Center");
                        RecentFilesPanel.this.invalidate();
                        RecentFilesPanel.this.revalidate();
                        RecentFilesPanel.this.repaint();
                    }
                }
            };
        }
        return this.changeListener;
    }

    private JPanel rebuildContent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        List files = RecentFiles.getDefault().getAll();
        for (FileObject p : files) {
            this.addFile(panel, row++, p);
            if (row < 5) continue;
            break;
        }
        if (0 == row) {
            panel.add((Component)new JLabel(BundleSupport.getLabel("NoRecentFile")), new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0));
        } else {
            panel.add((Component)new JLabel(), new GridBagConstraints(0, row, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private void addFile(JPanel panel, int row, FileObject file) {
        ActionOpen action = new ActionOpen(file);
        action.setText(this.getDisplayName(file.getNameExt()));
        ActionButton b = new ActionButton((Action)action, file.toURL().toString(), false, "RecentFile");
        b.setFont(BUTTON_FONT);
        b.getAccessibleContext().setAccessibleName(b.getText());
        b.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("RecentFile", b.getText()));
        b.setIcon((Icon)Gedcom.getImage());
        panel.add((Component)b, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        b = new ActionButton((Action)((Object)new DelFile(file)), "", false, "DelRecentFile");
        panel.add((Component)b, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 22, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private String getDisplayName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        name = name.replace("_", " ");
        char[] delimiters = new char[]{' ', '-'};
        String ret = WordUtils.capitalize((String)name.substring(0, name.lastIndexOf(".") == -1 ? name.length() : name.lastIndexOf(".")), (char[])delimiters);
        if (ret.length() > 44) {
            ret = ret.substring(0, 44) + "...";
        }
        return ret;
    }

    private static class DelFile
    extends AbstractAncestrisAction {
        private final FileObject file;

        public DelFile(FileObject file) {
            this.file = file;
            this.setText("");
            this.setTip(Bundle.del_from_history(file.getNameExt()));
            this.setImage((Icon)Images.imgDel);
        }

        public void actionPerformed(ActionEvent e) {
            RecentFiles.getDefault().remove(this.file);
        }
    }
}

