/*
 * Decompiled with CFR 0.152.
 */
package ancestris.welcome.content;

import ancestris.welcome.content.ButtonBorder;
import ancestris.welcome.content.Constants;
import ancestris.welcome.content.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openide.util.NbBundle;

public abstract class LinkButton
extends JButton
implements Constants,
MouseListener,
ActionListener,
FocusListener {
    private boolean underline = false;
    private final boolean showBorder;
    private final Color defaultForeground;
    private static final Border regularBorder = ButtonBorder.createRegular();
    private static final Border mouseoverBorder = ButtonBorder.createMouseOver();
    private String usageTrackingId;

    public LinkButton(String label, String usageTrackingId) {
        this(label, false, usageTrackingId);
    }

    public LinkButton(String label, boolean showBorder, String usageTrackingId) {
        this(label, Utils.getColor("LinkColor"), showBorder, usageTrackingId);
    }

    public LinkButton(String label, Color foreground, String usageTrackingId) {
        this(label, foreground, false, usageTrackingId);
    }

    public LinkButton(String label, Color foreground, boolean showBorder, String usageTrackingId) {
        super(label);
        this.defaultForeground = foreground;
        this.showBorder = showBorder;
        this.setForeground(this.defaultForeground);
        this.setFont(BUTTON_FONT);
        this.usageTrackingId = usageTrackingId;
        if (showBorder) {
            this.setBorder(BorderFactory.createEmptyBorder(2, 11, 2, 11));
            this.setMargin(new Insets(11, 11, 11, 11));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.setMargin(new Insets(0, 0, 0, 0));
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = true;
            this.repaint();
            this.onMouseEntered(e);
            if (!this.showBorder) {
                this.setForeground(Utils.getColor("MouseOverLinkColor"));
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            this.underline = false;
            if (!this.showBorder) {
                this.setForeground(this.isVisited() ? Utils.getColor("VisitedLinkColor") : this.defaultForeground);
            }
            this.repaint();
            this.onMouseExited(e);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = Utils.prepareGraphics(g);
        if (this.showBorder) {
            Border b = this.underline ? mouseoverBorder : regularBorder;
            b.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g2);
        Dimension size = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            g2.setStroke(LINK_IN_FOCUS_STROKE);
            g2.setColor(Utils.getColor("LinkInFocusColor"));
            g2.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        Rectangle rect = this.getBounds();
        rect.grow(0, FONT_SIZE);
        this.scrollRectToVisible(rect);
    }

    protected void onMouseExited(MouseEvent e) {
    }

    protected void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline && this.isEnabled() && !this.showBorder) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            int iconHeight = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
                iconHeight = this.getIcon().getIconHeight();
            }
            int x1 = iconWidth;
            int y1 = iconHeight == 0 ? fm.getHeight() : fm.getHeight() + (iconHeight - fm.getHeight()) / 2;
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }

    public void setUsageTrackingId(String id) {
        this.usageTrackingId = id;
    }

    protected void logUsage() {
        LogRecord rec = new LogRecord(Level.INFO, "USG_START_PAGE_LINK");
        String id = this.usageTrackingId;
        if (null == id) {
            id = this.getText();
        }
        rec.setParameters(new Object[]{id});
        rec.setLoggerName(Constants.USAGE_LOGGER.getName());
        rec.setResourceBundle(NbBundle.getBundle((String)"ancestris.welcome.resources.Bundle"));
        rec.setResourceBundleName("ancestris.welcome.resources.Bundle");
        Constants.USAGE_LOGGER.log(rec);
    }
}

