.TH sane\-escl 5 "14 Dec 2019" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-escl
.SH NAME
sane\-escl \- SANE backend for eSCL scanners
.SH DESCRIPTION
The
.B sane\-escl
library implements a SANE (Scanner Access Now Easy) backend that provides access to
eSCL protocol scanners.
.PP
Currently, the following models work with this backend (This list is not exhaustive):
.PP
.RS
BROTHER DCP-L2530
.br
BROTHER HL-L2590DW
.br
CANON IR C3520
.br
CANON PIXMA MG5765
.br
CANON PIXMA TS3100, TS3150, TS3300, TS3151, TS3350, TS3351,
.br
CANON PIXMA TS3352, TS5351, TS6150, TS8050, TS9100, TR4540,
.br
CANON PIXMA TR8500, TR8520
.br
EPSON ET3740, ET4750
.br
HP DESKJET 2710, DESKJET 2723, DESKJET 3760, LASERJET MFP M28W,
.br
HP OFFICEJET 4630, OFFICEJET PRO 8610
.br
RICOH SP3710S
.br
XEROX VERSALINK C7220
.RE
.PP
The.
.B sane\-escl
backend for SANE supports AirScan/eSCL devices that announce
themselves on mDNS as _uscan._utcp or _uscans._utcp.
If the device is available, the
.B sane\-escl
backend recovers these capacities.
The user configures and starts scanning.
A list of devices that use the eSCL protocol can be found at
.IR https://support.apple.com/en-us/HT201311 .
While these devices are expected to work, your mileage may vary.

.SH FILES
.TP
.I @CONFIGDIR@/escl.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane\-escl.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-escl.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_DEBUG_ESCL
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.SH "SEE ALSO"
.BR sane (7)
.BR scanimage (1)
.BR xscanimage (1)
.BR xsane (1)

.SH AUTHORS
Touboul Nathane, Thierry HUCHARD
