##
## Copyright (C) 2011-2012 Andrew Atkinson
##
##-------------------------------------------------------------------
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program.  If not, see <http://www.gnu.org/licenses/>.
##-------------------------------------------------------------------


from distutils.core import setup
from Defaults import ProgramInfo as info
import py2exe
import os

outputname = info().name + info().version.replace('.', '_')
manualfolder = 'Manual' + info().manversion.replace('.', '_')

copyfiles = [('Images', ['Images/topparser.ico']),
                ('', ['COPYING']),
                ('', ['ChangeLog.txt'])]

for file in os.listdir('Manual'):
    if os.path.isfile('Manual/' + file):
        copyfiles.append([manualfolder, ['Manual/' + file]])
        print(copyfiles)

setup(
    name=info().name,
    version=info().version,
    url=info().website,
    author=info().developer,
    description=info().description,
    license=info().licence,
    windows=[{"script": 'TopParser.py',
              "icon_resourses": [(1, 'Images/topparser.ico')],
            "copyright": info().copyright}],
    data_files= copyfiles,
    options={"py2exe": {"dist_dir": outputname}}
)
