"use strict";

var fs = require( "fs" );

module.exports = function( grunt ) {
	grunt.registerTask( "dist", "Process files for distribution", function() {
		var files = grunt.file.expand( { filter: "isFile" }, "dist/*" );

		files.forEach( function( filename ) {
			var map,
				text = fs.readFileSync( filename, "utf8" );

			// Modify map/min so that it points to files in the same folder;
			// see https://github.com/mishoo/UglifyJS2/issues/47
			if ( /\.map$/.test( filename ) ) {
				text = text.replace( /"dist\//g, "\"" );
				fs.writeFileSync( filename, text, "utf-8" );
			} else if ( /\.min\.js$/.test( filename ) ) {

				// Wrap sourceMap directive in multiline comments (#13274)
				text = text.replace( /\n?(\/\/@\s*sourceMappingURL=)(.*)/,
					function( _, directive, path ) {
						map = "\n" + directive + path.replace( /^dist\//, "" );
						return "";
					} );
				if ( map ) {
					text = text.replace( /(^\/\*[\w\W]*?)\s*\*\/|$/,
						function( _, comment ) {
							return ( comment || "\n/*" ) + map + "\n*/";
						} );
				}
				fs.writeFileSync( filename, text, "utf-8" );
			}
		} );
	} );
};
