#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    src
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_SStm_AO_SStm
  require_relative 'ao'                                 # ao.rb
  require_relative 'se'                                 # se.rb
    include SiSU_Env
  require_relative 'ao_composite'                       # ao_composite.rb
  require_relative 'shared_metadata'                    # shared_metadata.rb
  require_relative 'src_po4a_share'                     # src_po4a_share.rb
  require_relative 'src_po4a_sst_ao_sst_set'            # src_po4a_sst_ao_sst_set.rb
  include SiSU_Param
  require_relative 'object_munge'                       # object_munge.rb
  require_relative 'utils_composite'                    # utils_composite.rb
  require_relative 'utils_response'                     # utils_response.rb
  class Source
    include SiSU_Object_Munge
    include SiSU_Languages_Selected
    include SiSU_Response
    @@md_src,@@md_master=
          nil,      nil
    @@auto_translation_ = :go
    def initialize(opt,fn=nil)
      @opt,@fn=opt,fn
      #unless @opt.fns =~/(.+?\.(?:-|ssm\.)?sst)$/
      #  puts "#{@opt.fns} not a processed file type"
      #end
      file_arr=SiSU_Info_Env::InfoEnv.new.
        source_file_processing_array(@opt.fno)
      SiSU_Param::Parameters::Instructions.new(file_arr,@opt).extract
      r=Px[:lng_lst_rgx].gsub(/\|#{language.source_language_selected_str}\|/,'|')
      @lang_regx=%r{(?:#{r})}
      @@todo=if source_language_selected_str == opt.f_pth[:lng]
        :same_file
      else :compare
      end
      if opt.f_pth[:lng]==@opt.lng_base \
      and opt.f_pth[:lng]==source_language_selected_str
        @@md_master=SiSU_Param::Parameters.new(opt).get
      end
    end
    def wrap_width_set(md,env)
      if defined? md.make.plaintext_wrap \
      and md.make.plaintext_wrap
        md.make.plaintext_wrap
      elsif defined? env.plaintext_wrap \
      and env.plaintext_wrap
        #env.plaintext_wrap # 78 use 75
        75
      else 75 #78
      end
    end
    def process_file(md,env,file,wrap_width,fn)
      if source_language_selected_str == @opt.f_pth[:lng]
        @@ao_arr_lang_trans=
          SiSU_AO::Source.new(
            @opt,
            fn,
            :po4a
          ).get # ao file drawn here
      end
      @ao_arr_lang_src=
        SiSU_AO::Source.new(
          @opt,
          fn,
          :po4a
        ).get # ao file drawn here
      SiSU_SStm_AO_SStm::Source::Scroll.new(
        fn,
        @ao_arr_lang_src,
        @@ao_arr_lang_trans,
        @@md_src,
        @@md_master,
        wrap_width
      ).songsheet
    end
    def read_process_src_files
      begin
        src={}
        src[:pth]=@opt.f_pth[:pth]
        src[:files]=if @opt.fns =~ /\.(?:(?:-|ssm\.)sst|ssm)$/
          @opt.fns=@opt.fns.gsub(/\.ssm\.sst$/,'.ssm')
          SiSU_Assemble::CompositeFileList.new(@opt).read
        else
          [@opt.fns]
        end
        md=SiSU_Param::Parameters.new(@opt).get
        env=SiSU_Env::InfoEnv.new(@opt.fns)
        file=SiSU_Env::FileOp.new(md)
        lng=/\/([^\/]+)$/.match(src[:pth])[1]
        if language.source_language_selected_str == lng
          SiSU_Po4a_Project::Po4aDistClean.new(@opt,file).song
        end
        wrap_width=wrap_width_set(md,env)
        lng = /\/([^\/]+)$/.match(src[:pth])[1]
        ans=response?('process files?')
        if ans
          src[:files].each do |fn|
            puts "[#{lng}] #{fn}"
            process_file(md,env,file,wrap_width,fn)
          end
        end
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    def read_setup
      begin
        md=SiSU_Param::Parameters.new(@opt).get
        file=SiSU_Env::FileOp.new(md)
        SiSU_Po4a_Project::Po4aCfg.new(@opt,file).song
        SiSU_Po4a_Project::Po4aProject.new(@opt,file).song
      rescue
        SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
          __LINE__.to_s + ':' + __FILE__
        end
      ensure
      end
    end
    private
    class Scroll <Source
      include SiSU_Po4aUtils
      @@endnotes={ para: [], end: [] }
      def initialize(fn,data_src,data_master,md_src,md_master,wrap_width)
        @fn,@data_src,@data_master,@md_src,@md_master,@wrap_width=
         fn, data_src, data_master, md_src, md_master, wrap_width
        @md=md_src
        @tab="\t"
        @@endnotes_=(@md.opt.selections.str =~/--endnote/) \
        ? true
        : false    # --footnote
        @pot={
          body: [],
          open: [],
          close: [],
          head: [],
          metadata: [],
          tail: []
        }
      end
      def br
        (@md.opt.selections.str =~/--dos/) ? "\r\n" : "\n"  # --unix
      end
      def songsheet
        fn=@fn
        pot=compare_structure_src_trn(@data_src,@data_master,@@todo)
        publish(fn,pot)
      end
      def pot_structure_wrap(orig,trans,indent=0,hang=0)
        SiSU_Po4aUtils::Wrap.new(
          @md,
          orig,
          trans,
          @wrap_width,
          indent,
          hang
        )
      end
      def wrap_endnotes(orig_notes='',trn_notes='')
        #nt=@@endnotes_ ? 'endnote' : 'footnote'
        @fn=0
        a_l=orig_notes.length
        0.upto(a_l-1) do |i|
          @fn=if orig_notes[i].to_s =~/^\^~([\d*+]+)/ # provides endnote number within paragraph
            @fn += 1
          else @fn
          end
          #mark="^~ "
          orig=(orig_notes[i].to_s =~/^\^~[\d*+]+/) \
          ? (orig_notes[i].to_s.gsub(/^\^~[\d*+]+/,'^~'))
          : orig_notes[i].to_s
          trans=if trn_notes.is_a?(Array) \
          and trn_notes.length==orig_notes.length
            (trn_notes[i].to_s =~/^\^~[\d*+]+/) \
            ? (trn_notes[i].to_s.gsub(/^\^~[\d*+]+/,'^~'))
            : trn_notes[i].to_s
          else ''
          end
          util=pot_structure_wrap(orig,trans)
          wrap=util.line_wrap
          wrap=if wrap =~ /^\s*\^~[\d*+]+\s+.+?\s*\Z/m
            wrap.gsub(/^\s*(\^~[\d*+]+)\s+(.+?)\s*\Z/m, <<GSUB
\\1 \\2
GSUB
                      )
          else
            wrap.gsub(/^(.+)\Z/m, <<GSUB
\\1
GSUB
                      )
          end
          @@endnotes[:para] << wrap
          @@endnotes[:end] << '' << wrap
        end
        @@endnotes[:para].each {|e| @pot[:body] << e << br}
        @@endnotes[:para]=[]
        @@endnotes
      end
      def pot_metadata_src
        @po4a_identify_type='type: SiSU doc' #'type: Plain text'
        meta_src=SiSU_Metadata::Summary.new(@md_src)
        w=[]
        w << [
          meta_src.metadata_tags.title.main,
          meta_src.metadata_tags.title.sub,
          meta_src.metadata_tags.title.edition,
          meta_src.metadata_tags.title.note,
          meta_src.metadata_tags.title.short,
          meta_src.metadata_tags.title.language,
          meta_src.metadata_tags.title.language_char,
        ]
        w << [
          meta_src.metadata_tags.creator.head,
          meta_src.metadata_tags.creator.author,
          meta_src.metadata_tags.creator.contributor,
          meta_src.metadata_tags.creator.illustrator,
          meta_src.metadata_tags.creator.photographer,
          meta_src.metadata_tags.creator.translator,
          meta_src.metadata_tags.creator.audio,
          meta_src.metadata_tags.creator.digitized_by,
          meta_src.metadata_tags.creator.prepared_by,
        ]
        w << [
          meta_src.metadata_tags.rights.head,
          meta_src.metadata_tags.rights.copyright.text,
          meta_src.metadata_tags.rights.copyright.translation,
          meta_src.metadata_tags.rights.copyright.illustrations,
          meta_src.metadata_tags.rights.copyright.photographs,
          meta_src.metadata_tags.rights.copyright.digitization,
          meta_src.metadata_tags.rights.copyright.audio,
          meta_src.metadata_tags.rights.license,
        ]
        w << [
          meta_src.metadata_tags.classify.head,
          meta_src.metadata_tags.classify.subject,
          meta_src.metadata_tags.classify.topic_register,
          meta_src.metadata_tags.classify.loc,
          meta_src.metadata_tags.classify.dewey,
        ]
        w << [
          meta_src.metadata_tags.date.head,
          meta_src.metadata_tags.date.added_to_site,
          meta_src.metadata_tags.date.available,
          meta_src.metadata_tags.date.created,
          meta_src.metadata_tags.date.issued,
          meta_src.metadata_tags.date.modified,
          meta_src.metadata_tags.date.published,
          meta_src.metadata_tags.date.valid,
        ]
        w << [
          meta_src.processing_tags.make.language,
          meta_src.processing_tags.make.headings,
          meta_src.processing_tags.make.num_top,
          meta_src.processing_tags.make.breaks,
          meta_src.processing_tags.make.emphasis,
          meta_src.processing_tags.make.bold,
          meta_src.processing_tags.make.italics,
          meta_src.processing_tags.make.texpdf_font,
        ]
        w.each do |y|
          z=''
          y.each do |x|
            if x
              z += x + "\n" if x =~/^#|^msg(?:id|str)/
              z += %{#{x}\n} if x =~/^@\S+?:(?: |$)/
              z += %{#{x}\n} if x =~/^\s+:\S+?: /
            end
          end
          @pot[:metadata] << z << br
          #puts z unless z.empty?
        end
      end
      def pot_metadata_src_trn
        #@po4a_identify_type='type: Plain text'
        meta_src=SiSU_Metadata::Summary.new(@md_src)
        w=[]
        w << [
          meta_src.metadata_tags.title.main,
          meta_src.metadata_tags.title.sub,
          meta_src.metadata_tags.title.edition,
          meta_src.metadata_tags.title.note,
          meta_src.metadata_tags.title.short,
          meta_src.metadata_tags.title.language,
          meta_src.metadata_tags.title.language_char,
        ]
        w << [
          meta_src.metadata_tags.creator.head,
          meta_src.metadata_tags.creator.author,
          meta_src.metadata_tags.creator.contributor,
          meta_src.metadata_tags.creator.illustrator,
          meta_src.metadata_tags.creator.photographer,
          meta_src.metadata_tags.creator.translator,
          meta_src.metadata_tags.creator.audio,
          meta_src.metadata_tags.creator.digitized_by,
          meta_src.metadata_tags.creator.prepared_by,
        ]
        w << [
          meta_src.metadata_tags.rights.head,
          meta_src.metadata_tags.rights.copyright.text,
          meta_src.metadata_tags.rights.copyright.translation,
          meta_src.metadata_tags.rights.copyright.illustrations,
          meta_src.metadata_tags.rights.copyright.photographs,
          meta_src.metadata_tags.rights.copyright.digitization,
          meta_src.metadata_tags.rights.copyright.audio,
          meta_src.metadata_tags.rights.license,
        ]
        w << [
          meta_src.metadata_tags.classify.head,
          meta_src.metadata_tags.classify.subject,
          meta_src.metadata_tags.classify.topic_register,
          meta_src.metadata_tags.classify.loc,
          meta_src.metadata_tags.classify.dewey,
        ]
        w << [
          meta_src.metadata_tags.date.head,
          meta_src.metadata_tags.date.added_to_site,
          meta_src.metadata_tags.date.available,
          meta_src.metadata_tags.date.created,
          meta_src.metadata_tags.date.issued,
          meta_src.metadata_tags.date.modified,
          meta_src.metadata_tags.date.published,
          meta_src.metadata_tags.date.valid,
        ]
        w << [
          meta_src.processing_tags.make.language,
          meta_src.processing_tags.make.headings,
          meta_src.processing_tags.make.num_top,
          meta_src.processing_tags.make.breaks,
          meta_src.processing_tags.make.emphasis,
          meta_src.processing_tags.make.bold,
          meta_src.processing_tags.make.italics,
          meta_src.processing_tags.make.texpdf_font,
        ]
        w.each do |y|
          z=''
          y.each do |x|
            if x
              z += x + "\n" if x =~/^#|^msg(?:id|str)/
              z += %{#{x}\n} if x =~/^@\S+?:(?: |$)/
              z += %{#{x}\n} if x =~/^\s+:\S+?: /
            end
          end
          @pot[:metadata] << z << br
          #puts z unless z.empty?
        end
      end
      def auto_translate?(set_to=nil)
        @@auto_translation_=
        if @md.opt.act[:po4a_lang_trans][:set]==:on
          set_to \
          ? set_to
          : @@auto_translation_
        else :skip
        end
      end
      def auto_translation(src_txt,markup=:src) # check for an appropriate request flag
        auto_translate?(:skip)
        begin
          src_txt_clean=clean_text(src_txt,markup)
          src_txt_clean=src_txt_clean.
            gsub(/\n/,' ').
            gsub(/"/,'\"').
            gsub(/([()])/,'\\\\\1')
          trans=''
          unless auto_translate? == :skip
            require 'timeout'
            Timeout::timeout(60) {
              trans=`trans -b -no-ansi en:#{@md.opt.f_pth[:lng_is]} #{src_txt_clean}`.strip
              unless trans.empty?
                trans + ' {[G.Tr]}http://translate.google.com'
              end
            }
          end
          trans
        rescue
          auto_translate?(:skip)
          p 'timeout issues with translation, skip remaining'
        end
      end
      def pot_structure
        def heading(dob_src='',notes_s='',dob_trn='',notes_t='')   #% used to extract the structure of a document
          lv=n=n3=nil
          lv=dob_src.ln
          n=lv - 1
          n3=lv + 2
          util=nil
          fn=(dob_src.name=~/[a-z\d]/i) ? dob_src.name : ''
          mark="#{dob_src.lv}~#{fn} "
          orig="#{mark}#{dob_src.obj}"
          trans=((dob_trn=='') \
          || (dob_src.obj == dob_trn.obj)) \
          ? ''
          : "#{mark}#{dob_trn.obj}"
          if @md.opt.f_pth[:lng_is] !=@md.opt.lng_base \
          and trans.empty? \
          and auto_translate?
            trans=auto_translation(dob_src.obj,:src)
          end
          util=pot_structure_wrap(orig,trans)
          wrapped=util.line_wrap
          @pot[:body] << wrapped << br # main text, contents, body KEEP
          if @@endnotes[:para] \
          and notes_s.length > 0 \
          and not @@endnotes_
            @pot[:body] << br
            wrap_endnotes(notes_s,notes_t)
          elsif @@endnotes[:para] \
          and @@endnotes_
            @pot[:body] << br*2
          end
        end
        def para(dob_src='',notes_s='',dob_trn='',notes_t='')      #% used to extract the structure of a document
          util=nil
          wrapped=if dob_src.indent =~/[1-9]/ \
          and dob_src.indent == dob_src.hang
            s_mark=desc=orig=trans=''
            mark=if dob_src.bullet_
              "_#{dob_src.indent}* "
            else
              "_#{dob_src.indent} "
            end
            orig="#{mark}#{dob_src.obj}"
            trans=((dob_trn=='') \
            || (dob_src.obj == dob_trn.obj)) \
            ? ''
            : "#{mark}#{dob_trn.obj}"
            if @md.opt.f_pth[:lng_is] !=@md.opt.lng_base \
            and trans.empty? \
            and auto_translate?
              trans=auto_translation(dob_src.obj,:src)
            end
            util=pot_structure_wrap(orig,trans)
          elsif dob_src.hang =~/[0-9]/ \
          and dob_src.indent != dob_src.hang
            s_mark=desc=orig=trans=''
            mark="_#{dob_src.hang}_#{dob_src.indent} "
            orig="#{mark}#{dob_src.obj}"
            trans=((dob_trn=='') \
            || (dob_src.obj == dob_trn.obj)) \
            ? ''
            : "#{mark}#{dob_trn.obj}"
            if @md.opt.f_pth[:lng_is] !=@md.opt.lng_base \
            and trans.empty? \
            and auto_translate?
              trans=auto_translation(dob_src.obj,:src)
            end
            util=pot_structure_wrap(orig,trans)
          else
            s_mark=desc=orig=trans=''
            if dob_src.bullet_
              mark='_* '
              orig="#{mark}#{dob_src.obj}"
              trans=((dob_trn=='') \
              || (dob_src.obj == dob_trn.obj)) \
              ? ''
              : "#{mark}#{dob_trn.obj}"
              if @md.opt.f_pth[:lng_is] !=@md.opt.lng_base \
              and trans.empty? \
              and auto_translate?
                trans=auto_translation(dob_src.obj,:src)
              end
            else
              mark=''
              orig=dob_src.obj
              trans=((dob_trn=='') \
              || (dob_src.obj == dob_trn.obj)) \
              ? ''
              : "#{mark}#{dob_trn.obj}"
              if @md.opt.f_pth[:lng_is] !=@md.opt.lng_base \
              and trans.empty? \
              and auto_translate?
                trans=auto_translation(dob_src.obj,:src)
              end
            end
            util=pot_structure_wrap(orig,trans)
          end
          wrapped=util.line_wrap
          @pot[:body] << wrapped << br # main text, contents, body KEEP
          if @@endnotes[:para] \
          and notes_s.length > 0 \
          and not @@endnotes_
            @pot[:body] << br
            wrap_endnotes(notes_s,notes_t)
          elsif @@endnotes[:para] \
          and @@endnotes_
            @pot[:body] << br*2
          end
        end
        def block(dob_src='',notes_s='',dob_trn='',notes_t='')     #% used to extract the structure of a document
          mark_o ="block{\n\n"
          mark_c ="\n\n}block"
          orig="#{mark_o}#{dob_src.obj}#{mark_c}"
          trans=((dob_trn=='') \
          || (dob_src.obj == dob_trn.obj)) \
          ? ''
          : "#{mark_o}#{dob_trn.obj}#{mark_c}"
          if @md.opt.f_pth[:lng_is] !=@md.opt.lng_base \
          and trans.empty? \
          and auto_translate?
            trans=auto_translation(dob_src.obj,:src)
          end
          util=pot_structure_wrap(orig,trans)
          unwrapped=util.no_line_wrap_block
          @pot[:body] << unwrapped << br
        end
        def group(dob_src='',notes_s='',dob_trn='',notes_t='')     #% used to extract the structure of a document
          mark_o ="group{\n\n"
          mark_c ="\n\n}group"
          orig="#{mark_o}#{dob_src.obj}#{mark_c}"
          trans=((dob_trn=='') \
          || (dob_src.obj == dob_trn.obj)) \
          ? ''
          : "#{mark_o}#{dob_trn.obj}#{mark_c}"
          if @md.opt.f_pth[:lng_is] !=@md.opt.lng_base \
          and trans.empty? \
          and auto_translate?
            trans=auto_translation(dob_src.obj,:src)
          end
          util=pot_structure_wrap(orig,trans)
          unwrapped=util.no_line_wrap_block
          @pot[:body] << unwrapped << br
        end
        def verse(dob_src='',notes_s='',dob_trn='',notes_t='')     #% used to extract the structure of a document
          mark="poem{\n\nverse\n\nverse\n\n...\n\n}poem"
          instruct=s_mark=''
          if @md.opt.act[:maintenance][:set]==:on
            instruct=%{\n# verse are part of the text block described as a poem, } \
            + %{the first verse is preceeded by an opening marker, } \
            + %{and the last verse by a closing marker, } \
            + %{the content of which should remain unwrapped}
            s_mark="\n# " + %{"\\n\\n#{mark}\\n\\n"}
          end
          orig=dob_src.obj
          trans=(dob_trn=='') \
          ? ''
          : dob_trn.obj
          util=pot_structure_wrap(orig,trans)
          unwrapped=util.no_line_wrap_block
          @pot[:body] << unwrapped << br
        end
        def code(dob_src='',notes_s='',dob_trn='',notes_t='')      #% used to extract the structure of a document
          mark_o ="code{\n\n"
          mark_c ="\n\n}code"
          orig="#{mark_o}#{dob_src.obj}#{mark_c}"
          trans=(dob_trn=='') \
          ? ''
          : "#{mark_o}#{dob_trn.obj}#{mark_c}"
          util=pot_structure_wrap(orig,trans)
          unwrapped=util.no_line_wrap_block
          @pot[:body] << unwrapped << br
        end
        def table(dob_src='',notes_s='',dob_trn='',notes_t='')     #% used to extract the structure of a document
          mark_o ="table{\n\n"
          mark_c ="\n\n}table"
          orig="#{mark_o}#{dob_src.obj}#{mark_c}"
          orig=orig.gsub(/#{Mx[:tc_c]}/m,"\n")
          trans=(dob_trn=='') \
          ? ''
          : "#{mark_o}#{dob_trn.obj}#{mark_c}"
          trans=trans.gsub(/#{Mx[:tc_c]}/m,"\n")
          util=pot_structure_wrap(orig,trans)
          unwrapped=util.no_line_wrap_block
          @pot[:body] << unwrapped << br
        end
        def idx_markup(idx)
          struct=['={' + "\n  "]
          idx.sort.each do |x|
            x.each_with_index do |y,i0|
              case y
              when String
                unless struct[-1] =~/=\{/
                  struct << ' ;' + "\n  "
                end
                struct << y
                if x[i0+1].class == Hash \
                and x[i0+1][:sub].length > 0
                  struct << ' :' + "\n    "
                end
              when Hash
                if y[:plus].to_i > 0
                  struct << '+' + y[:plus].to_s
                end
                if y[:sub].length > 0
                  y[:sub].each_with_index do |z,i1|
                    z.each_with_index do |a,i2|
                      if z.length > 0
                        struct << a[0]
                        if a[1][:plus].to_i > 0
                          struct << '+' + a[1][:plus].to_s
                        end
                        if (i1 + 1) < y[:sub].length
                          struct << '|'
                        end
                      end
                    end
                  end
                end
              end
            end
          end
          struct << "\n" + '}'
          #puts struct.join
          struct.join
        end
        def idx(dob_src='') #% used for book index but broken as original markup lost, already abstracted, fix
          orig=pot_structure.idx_markup(dob_src.idx) #'={' + dob_src.idx + '}'
          util=pot_structure_wrap(orig,'')
          unwrapped=util.no_line_wrap_block
          if @pot[:body][-1] == "\n"
            @pot[:body][-1] = unwrapped #<< br
            @pot[:body] << br
          else # expect to catch all above, problem if wraps, must =~/^=\{/
            @pot[:body] << unwrapped << br # places idx in separate object
          end
        end
        self
      end
      def compare_structure_src_trn(data_src,data_trn,todo)
        #@endnotes,@copen,@pot_contents_close=Array.new(3){[]}
        a_l= data_src.length
        s,t=0,0
        0.upto(a_l-1) do |i|
          if todo==:compare
            unless data_src[s] \
            and data_trn[t]
              break
            end
            if data_src[s].of == :comment \
            and data_trn[t].of == :comment \
            and (data_src[s].is == data_trn[t].is)
              s+=1;t+=1
              next
            end
            if ((data_src[s].is == :comment) \
            || (data_trn[t].is == :comment)) \
            and (data_src[s].is != data_trn[t].is)
              if data_src[s].is == :comment
                if @md.opt.act[:maintenance][:set]==:on
                  puts "src (comment):\n\t" \
                  + data_src[s].obj
                end
                s+=1
                #next if data_src[s].is == :comment
              elsif data_trn[t].is == :comment
                if @md.opt.act[:maintenance][:set]==:on
                  puts "trans (comment):\n\t" \
                  + data_trn[t].obj
                end
                t+=1
                #next if data_trn[t].is == :comment
              end
            end
            if ((defined? data_src[s].ocn) \
            && (data_src[s].ocn.is_a?(Fixnum))) \
            and ((defined? data_trn[t].ocn) \
            && (data_trn[t].ocn.is_a?(Fixnum))) \
            and (data_src[s].ocn == data_trn[t].ocn)
              @m_s,@m_t=s,t
            elsif ((defined? data_src[s].ocn) \
            && (data_src[s].ocn.is_a?(Fixnum))) \
            and ((defined? data_trn[t].ocn) \
            && (data_trn[t].ocn.is_a?(Fixnum))) \
            and (data_src[s].ocn != data_trn[t].ocn)
              p '--- OCN ---'
              p 'mis-match'
              p data_src[s].ocn if defined? data_src[s].ocn
              p data_src[s].obj if defined? data_src[s].obj
              p data_trn[t].ocn if defined? data_trn[t].ocn
              p data_trn[t].obj if defined? data_trn[t].obj
              p '---'
              p 'previous match'
              p data_src[@m_s].ocn if defined? data_src[@m_s].ocn
              p data_src[@m_s].obj if defined? data_src[@m_s].obj
              p data_trn[@m_t].ocn if defined? data_trn[@m_t].ocn
              p data_trn[@m_t].obj if defined? data_trn[@m_s].obj
              exit
            elsif (((defined? data_src[s].ocn) \
            && (defined? data_trn[t].ocn)) \
            and data_src[s].ocn.class != data_trn[t].ocn.class)
              p '--- OCN class ---'
              p 'mis-match'
              p data_src[s].ocn if defined? data_src[s].ocn
              p data_src[s].obj if defined? data_src[s].obj
              p data_trn[t].ocn if defined? data_trn[t].ocn
              p data_trn[t].obj if defined? data_trn[t].obj
              #p '---'
              #p 'previous match'
              #p data_src[@m_s].ocn
              #p data_src[@m_s].obj
              #p data_trn[@m_t].ocn
              #p data_trn[@m_t].obj
            #elsif (defined? data_src[s].ocn != defined? data_trn[t].ocn) \
            #and (data_src[s].ocn.nil? != data_trn[t].ocn.nil?)
            #  p '--- missing OCN? ---'
            #  p 'mis-match'
            #  p data_src[s].ocn if defined? data_src[s].ocn
            #  p data_src[s].obj
            #  p data_trn[t].ocn if defined? data_trn[t].ocn
            #  p data_trn[t].obj
            else
            end
          end
          notes_s=''
          data_src[s],notes_s=markup(data_src[s])
          data_src[s],nul=pot_data(data_src[s],notes_s)
          s+=1;t+=1
        end
        @pot #watch
      end
      def pot_data(dob_src='',notes_s)
        if dob_src.obj !~/(^#{Rx[:meta]}|#{Mx[:br_eof]}|#{Mx[:br_endnotes]})/
          if defined? dob_src.ocn \
          and dob_src.ocn.to_s =~/\d+/
            paranum=dob_src.ocn.to_s
            @p_num=SiSU_Po4aUtils::ParagraphNumber.new(paranum)
          end
          case dob_src.is
          when :heading
            pot_structure.heading(dob_src,notes_s)
          when :para
            pot_structure.para(dob_src,notes_s)
          when :group
            pot_structure.group(dob_src,notes_s)
          when :block
            pot_structure.block(dob_src,notes_s)
          when :verse
            pot_structure.verse(dob_src,notes_s)
          when :code
            pot_structure.code(dob_src,notes_s)
          when :table
            pot_structure.table(dob_src,notes_s)
          end
          if defined? dob_src.idx \
          and not dob_src.idx.nil? \
          and not dob_src.idx.empty?
            pot_structure.idx(dob_src)
          end
          #if dob_src ## Clean Prepared Text
          #  dob_src.obj=dob_src.obj.gsub(/<!.+!>/,' ').
          #    gsub(/<:\S+>/,' ') if dob_src ## Clean Prepared Text
          #end
        end
        #[dob_src,dob_trn]
      end
      def markup(dob)
        dob,notes=objects.textface_marks_po4a(dob,:separate)
        [dob,notes]
      end
      def publish(fn,pot)
        content=[]
        content << pot[:open]
        content << pot[:head]
        content << pot[:metadata]
        content << pot[:body]
        content << @@endnotes[:end] if @@endnotes_
        Output.new(fn,content,@md,@process).po4a
        @@endnotes={ para: [], end: [] }
      end
    end
    class Output <Source
      include SiSU_Param
      include SiSU_Env
      def initialize(fn,content,md,process=:complete)
        @fn,@content,@md,@process=fn,content,md,process
        @file=SiSU_Env::FileOp.new(md,fn)
      end
      def po4a                                                                 #%pot output
        file_pot=@file.write_file.po4a_sst
        #file_pot=(@md.opt.f_pth[:lng] == @md.opt.lng_base) \
        #? @file.write_file.pot
        #: @file.write_file.po
        @sisu=[]
        emptyline=0
        @content.each do |para|                                                # this is a hack
          if para.is_a?(Array) \
          and para.length > 0
            para.each do |line|
              if line
                line=line.gsub(/\s+$/m,'').
                  gsub(/^\A[ ]*\Z/m,'')
                if line=~/^\A[ ]*\Z/m
                  emptyline+=1
                else emptyline=0
                end
                file_pot.puts line if emptyline < 2                     #remove extra line spaces (fix upstream)
              end
            end
          else file_pot.puts para          #unix plaintext # /^([*=-]|\.){5}/
          end
        end
        file_pot.close
        SiSU_Po4aUtils::PotNumber.new.reset
        #po4a_git
      end
      def po4a_git
        unless @md.opt.act[:maintenance][:set]==:on
          require_relative 'git'                           # git.rb
          git=SiSU_Git::Source.new(@md.opt,@process)
          unless FileTest.directory?(@file.output_path.pot_git.dir)
            git.create_file_structure_git
          end
          if @md.opt.f_pth[:lng] == @md.opt.lng_base
            FileUtils::cp(
              @file.place_file.pot.dir,
              @file.output_path.pot_git.dir
            )
          else # naive, work on -->
            FileUtils::cp(
              @file.place_file.po.dir,
              @file.output_path.po_git.dir
            ) #unless FileTest.file?(@file.place_file.po_git.dir)
          end
          git.read
        end
      end
    end
  end
end
__END__
REMOVE
&#033;\|&#035;\|&&#042;\|&#045;\|&#047;\|&#095;\|&#123;\|&#125;\|&#126;\|&#

tables are problematic, difficult to reconstitute instruction, check

metadata, move to top? and work on

footnotes, different types, asterisk, also do you want to have separate
paragraphs, or breaks within one block?

where no ocn appropriately use ~# or -# or indeed 1~name-

comments in document, what to do about them, not sure they are currently
retained in dal, could be quite valuable to keep

Translate Shell
http://www.soimort.org/translate-shell/
translate.google.com
