
2021-01-20 Triage Log

A busy week with more performance gains than regressions. These changes included one very large [perf gain](https://github.com/rust-lang/rust/issues/79670) and one very large [perf regression](https://github.com/rust-lang/rust/issues/78407) in stress test benchmarks that seem to only produce mild perf changes in real world use cases. 

Triage done by **@rylev**.
Revision range: [b6b461652a9bebfb4ddabcae896ee7237cf0962a..e05409a02c6e73a3dea6da98798468db2910ca59](https://perf.rust-lang.org/?start=b6b461652a9bebfb4ddabcae896ee7237cf0962a&end=e05409a02c6e73a3dea6da98798468db2910ca59&absolute=false&stat=instructions%3Au)

3 Regressions, 5 Improvements, 4 Mixed
2 of them in rollups

#### Regressions

Use tcx.symbol_name when determining clashing extern declarations. [#80009](https://github.com/rust-lang/rust/issues/80009)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=704e47f78b4c8801a3c76f235a5a152e1b60b300&end=7a9b552cb1621c9c57898d147228aab32b65a7c3&stat=instructions:u) (up to 1.3% on `incr-full` builds of `externs-check`)
- Fix for [overeager warning in clashing extern declarations](https://github.com/rust-lang/rust/issues/79581).
- Unsure how much performance can be gained back but an allocation is occuring that isn't strictly necessary. Perhaps removing it will help.
- PR author was pinged about the regression [here](https://github.com/rust-lang/rust/pull/80009#issuecomment-763526902)

Update cargo [#80974](https://github.com/rust-lang/rust/issues/80974)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=18ec4a9a74731ddc6a453ca29c0836f61dbcb8d4&end=e48eb37b9470a26748c916f7153569906f3c67bf&stat=instructions:u) (up to 5.2% on `incr-unchanged` builds of `token-stream-stress-opt`)
- Purely an update of Cargo. Not sure why this is causing issues.

implement ptr::write without dedicated intrinsic [#80290](https://github.com/rust-lang/rust/issues/80290)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=63a83c5f55801b17b77adf690db397d17c706c48&end=492b83c6971c390af7a42932869502224ef55ef7&stat=instructions:u) (up to 1.2% on `full` builds of `regex-debug`)
- Small regex-debug full builds regression specifically in the `LLVM_module_codegen_emit_obj` query. This largely affects debug builds due to this previously being an instrinsic but now requiring LLVM to optimize it to its previously efficient form.
- An idea for gaining the performance back can be found [here](https://github.com/rust-lang/rust/pull/80290#issuecomment-763583590)

#### Improvements

Turn type inhabitedness into a query to fix `exhaustive_patterns` perf [#79670](https://github.com/rust-lang/rust/issues/79670)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7a9b552cb1621c9c57898d147228aab32b65a7c3&end=058a71016553f267ae80b90276ef79956457d51a&stat=instructions:u) (up to -22.6% on `full` builds of `match-stress-exhaustive_patterns-check`)
- Large wins in the match stress test. Up to 22% and nearly 86% in the `check_match` query.

Reintroduce hir::ExprKind::If [#79328](https://github.com/rust-lang/rust/issues/79328)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7bb163095d8c751787f1449f3f3c245077f484e3&end=d03fe84169d50a4b96cdef7b2f862217ab634055&stat=instructions:u) (up to -3.1% on `incr-full` builds of `clap-rs-check`)

Use probe-stack=inline-asm in LLVM 11+ [#77885](https://github.com/rust-lang/rust/issues/77885)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6c869d34ae2d87d21db9892d4dc088639bcbe041&end=635ccfe01c0be19d9fb0a99facbd9e06290f0ab1&stat=instructions:u) (up to -2.1% on `incr-unchanged` builds of `cargo-check`)

Try to avoid locals when cloning into Box/Rc/Arc [#80824](https://github.com/rust-lang/rust/issues/80824)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=9f3998b4aa9d0eea3249fdd48b8b719185673d16&end=116d1a7056830ccf649f74f823de4333ed329392&stat=instructions:u) (up to -1.3% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo-debug`)

BTreeMap: convert search functions to methods [#81159](https://github.com/rust-lang/rust/issues/81159)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5e91c4ecc09312d8b63d250a432b0f3ef83f1df7&end=73f233b3ad68b54f854c0aea918fc496a35502cf&stat=instructions:u) (up to -1.6% on `full` builds of `ripgrep-opt`)

#### Mixed

Make CTFE able to check for UB... [#78407](https://github.com/rust-lang/rust/issues/78407)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=497c9a256b1c2961e91565ccc6e0dd3a87a031ed&end=704e47f78b4c8801a3c76f235a5a152e1b60b300&stat=instructions:u) (up to 191.2% on `full` builds of `ctfe-stress-4-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=497c9a256b1c2961e91565ccc6e0dd3a87a031ed&end=704e47f78b4c8801a3c76f235a5a152e1b60b300&stat=instructions:u) (up to -4.4% on `full` builds of `many-assoc-items-check`)
- Unfortunately, the regressions outweigh the improvements considerably though the regressions are in the stress test for const eval which this change directly impacts, particularly the `eval_to_allocation_raw` query.
- These regressions were determined necessary and seem to only dramatically impact stress benchmarks while sometimes leading to perf gains in real world use cases.

Rollup of 10 pull requests [#80960](https://github.com/rust-lang/rust/issues/80960)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=150d1fee04856ff158e34e8d687a7fe59e97ef33&end=fc93e4719c2ced744d75f0c281bb7ba29844bedd&stat=instructions:u) (up to 87.7% on `incr-patched: sparse set` builds of `regex-debug`)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=150d1fee04856ff158e34e8d687a7fe59e97ef33&end=fc93e4719c2ced744d75f0c281bb7ba29844bedd&stat=instructions:u) (up to -5.8% on `incr-patched: u8 3072` builds of `issue-46449-debug`)
- Perf losses seem to be coming from LLVM codegen which leads me to believe that [#80796](https://github.com/rust-lang/rust/pull/80796) is possibly to blame. A perf test has been [kicked off](https://github.com/rust-lang/rust/pull/81207).

Rollup of 13 pull requests [#81113](https://github.com/rust-lang/rust/issues/81113)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7d3818152d8ab5649d2e5cc6d7851ed7c03055fe&end=edeb631ad0cd6fdf31e2e31ec90e105d1768be28&stat=instructions:u) (up to -6.1% on `incr-unchanged` builds of `webrender-check`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=7d3818152d8ab5649d2e5cc6d7851ed7c03055fe&end=edeb631ad0cd6fdf31e2e31ec90e105d1768be28&stat=instructions:u) (up to 5.8% on `incr-unchanged` builds of `deep-vector-check`)
- Hard to tell which PR is responsible though it seems like the regressions are largely coming in the `expand_crate` query. Best guesss might be [#80031](https://github.com/rust-lang/rust/pull/80031).

Remove PredicateKind and instead only use Binder<PredicateAtom> [#80679](https://github.com/rust-lang/rust/issues/80679)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1f0fc02cc8ab4e0d9dd3e06a6d46fcb72b2a026f&end=4253153db205251f72ea4493687a31e04a2a8ca0&stat=instructions:u) (up to 3.3% on `full` builds of `deeply-nested-async-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1f0fc02cc8ab4e0d9dd3e06a6d46fcb72b2a026f&end=4253153db205251f72ea4493687a31e04a2a8ca0&stat=instructions:u) (up to -2.0% on `incr-full` builds of `deeply-nested-async-debug`)
- Largely reverts the performance changes (both regressions and gains) from [#73503](https://github.com/rust-lang/rust/pull/73503).

#### Nags requiring follow up

* Still need a follow up to one of last weeks [perf regressions](https://github.com/rust-lang/rust/pull/80441).
