# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from DataPushService.idl.

use strict;

package Raritan::RPC::event::DataPushService;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "event.DataPushService:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::event::DataPushService::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant ERR_NO_SUCH_ID => 1;

use constant ERR_INVALID_PARAMS => 2;

use constant ERR_MAX_ENTRIES_REACHED => 3;

use Raritan::RPC::event::DataPushService::EntrySettings;

sub addEntry($$$) {
    my ($self, $entryId, $entrySettings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'entrySettings'} = Raritan::RPC::event::DataPushService::EntrySettings::encode($entrySettings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'addEntry', $args);
    $$entryId = $rsp->{'entryId'};
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::DataPushService::EntrySettings;

sub modifyEntry($$$) {
    my ($self, $entryId, $entrySettings) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'entryId'} = 1 * $entryId;
    $args->{'entrySettings'} = Raritan::RPC::event::DataPushService::EntrySettings::encode($entrySettings);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'modifyEntry', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub deleteEntry($$) {
    my ($self, $entryId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'entryId'} = 1 * $entryId;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'deleteEntry', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::DataPushService::EntrySettings;

sub getEntry($$$) {
    my ($self, $entrySettings, $entryId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'entryId'} = 1 * $entryId;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getEntry', $args);
    $$entrySettings = Raritan::RPC::event::DataPushService::EntrySettings::decode($agent, $rsp->{'entrySettings'});
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::event::DataPushService::EntrySettings;

sub listEntries($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'listEntries', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = Raritan::RPC::event::DataPushService::EntrySettings::decode($agent, $rsp->{'_ret_'}->[$i0]->{'value'});
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}

sub pushData($$) {
    my ($self, $entryId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'entryId'} = 1 * $entryId;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'pushData', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('event.DataPushService', 1, 0, 0, 'Raritan::RPC::event::DataPushService');
1;
