% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{new_app}
\alias{new_app}
\title{Create a local web application}
\usage{
new_app(name, handler, open = interactive(), ports = 4321 + 1:10)
}
\arguments{
\item{name}{The app name (a character string, and each app should have a
unique name).}

\item{handler}{A function that takes the HTTP request information (the first
argument is the requested path) and returns a response.}

\item{open}{Whether to open the app, or a function to open the app URL.}

\item{ports}{A vector of ports to try for starting the server.}
}
\value{
The app URL of the form \verb{http://127.0.0.1:port/custom/name/}.
}
\description{
An experimental function to create a local web application based on R's
internal \code{httpd} server (which is primarily for running R's dynamic help
system).
}
\note{
This function is not based on base R's public API, and is possible to
break in the future, which is also why the documentation here is terse.
Please avoid creating public-facing web apps with it. You may consider
packages like \pkg{httpuv} and \pkg{Rserve} for production web apps.
}
