% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple.R
\name{testing.hov}
\alias{testing.hov}
\title{Testing for Homogeneity of Variance}
\usage{
testing.hov(x, wf, J, min.coef = 128, debug = FALSE)
}
\arguments{
\item{x}{Sequence of observations from a (long memory) time series.}

\item{wf}{Name of the wavelet filter to use in the decomposition.}

\item{J}{Specifies the depth of the decomposition.  This must be a number
less than or equal to \eqn{\log(\mbox{length}(x),2)}{log(length(x),2)}.}

\item{min.coef}{Minimum number of wavelet coefficients for testing purposes.
Empirical results suggest that 128 is a reasonable number in order to apply
asymptotic critical values.}

\item{debug}{Boolean variable: if set to \code{TRUE}, actions taken by the
algorithm are printed to the screen.}
}
\value{
Matrix whose columns include (1) the level of the wavelet transform
where the variance change occurs, (2) the value of the test statistic, (3)
the DWT coefficient where the change point is located, (4) the MODWT
coefficient where the change point is located.  Note, there is currently no
checking that the MODWT is contained within the associated support of the
DWT coefficient.  This could lead to incorrect estimates of the location of
the variance change.
}
\description{
A recursive algorithm for detecting and locating multiple variance change
points in a sequence of random variables with long-range dependence.
}
\details{
For details see Section 9.6 of Percival and Walden (2000) or Section 7.3 in
Gencay, Selcuk and Whitcher (2001).
}
\references{
Gencay, R., F. Selcuk and B. Whitcher (2001) \emph{An
Introduction to Wavelets and Other Filtering Methods in Finance and
Economics}, Academic Press.

Percival, D. B. and A. T. Walden (2000) \emph{Wavelet Methods for Time
Series Analysis}, Cambridge University Press.
}
\seealso{
\code{\link{dwt}}, \code{\link{modwt}}, \code{\link{rotcumvar}},
\code{\link{mult.loc}}.
}
\author{
B. Whitcher
}
\keyword{ts}
