% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{PolyVtx}
\alias{PolyVtx}
\title{Polygon Vertices}
\usage{
PolyVtx(n, r = 1L, xc = 0L, yc = 0L, t1 = 0)
}
\arguments{
\item{n}{Number of sides of the polygon}

\item{r}{Radius of the polygon}

\item{xc, yc}{X/Y coordinates for the center of the polygon}

\item{t1}{Angle of the first vertex in degrees}
}
\value{
A \code{\link[base]{data.frame}} with \code{n} rows and two columns:
\describe{
 \item{\code{x}}{X positions of each coordinate}
 \item{\code{y}}{Y positions of each coordinate}
}
}
\description{
Calculate the vertices of a regular polygon given the number of sides and
its radius (distance from center to vertex). Also permits transforming the
resulting coordinates by moving the origin and altering the initial angle
}
\examples{
coords <- PolyVtx(5, t1 = 90)
coords
if (requireNamespace("ggplot2", quietly = TRUE)) {
  ggplot2::ggplot(coords, ggplot2::aes(x = x, y = y)) + ggplot2::geom_polygon()
}

}
\references{
\url{https://stackoverflow.com/questions/3436453/calculate-coordinates-of-a-regular-polygons-vertices}
}
\keyword{internal}
