% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fov.R
\docType{class}
\name{FOV-class}
\alias{FOV-class}
\alias{FOV}
\title{The Field of View Object}
\description{
A modern container for storing coordinates of spatially-resolved single
cells. Capable of storing multiple cell segmentation boundary masks.
Supports coordinates for spatially-resolved molecule (FISH) data.
Compatible with \code{\link{SpatialImage}}
}
\section{Slots}{

\describe{
\item{\code{molecules}}{(\code{\link[base]{list}}) A named list of
\code{\link[SeuratObject:Molecules-class]{Molecules}} objects defining
spatially-resolved molecular coordinates}

\item{\code{boundaries}}{(\code{[named]\link[base]{list}}
\{\code{\link[SeuratObject:Segmentation-class]{Segmentation}},
\code{\link[SeuratObject:Centroids-class]{Centroids}}\}) A named list of
\code{\link[SeuratObject:Segmentation-class]{Segmentation}} and
\code{\link[SeuratObject:Centroids-class]{Centroids}} objects defining
spatially-resolved boundaries}

\item{\code{assay}}{(\code{\link[base:character]{character [1L]}}) A character
naming the associated assay of the spatial coordinates}

\item{\code{key}}{(\code{\link[base:character]{character [1L]}}) The key
for the spatial coordinates}
}}

\seealso{
\code{\link{FOV-methods}}
}
