% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{CreateAssayObject}
\alias{CreateAssayObject}
\title{Create an Assay object}
\usage{
CreateAssayObject(counts, data, min.cells = 0, min.features = 0)
}
\arguments{
\item{counts}{Unnormalized data such as raw counts or TPMs}

\item{data}{Prenormalized data; if provided, do not pass \code{counts}}

\item{min.cells}{Include features detected in at least this many cells. Will
subset the counts matrix as well. To reintroduce excluded features, create a
new object with a lower cutoff.}

\item{min.features}{Include cells where at least this many features are
detected.}
}
\value{
A \code{\link{Assay}} object
}
\description{
Create an Assay object from a feature (e.g. gene) expression matrix. The
expected format of the input matrix is features x cells.
}
\details{
Non-unique cell or feature names are not allowed. Please make unique before
calling this function.
}
\examples{
\dontrun{
pbmc_raw <- read.table(
  file = system.file('extdata', 'pbmc_raw.txt', package = 'Seurat'),
  as.is = TRUE
)
pbmc_rna <- CreateAssayObject(counts = pbmc_raw)
pbmc_rna
}

}
\concept{assay}
