% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{fn_env}
\alias{fn_env}
\alias{fn_env<-}
\title{Return the closure environment of a function}
\usage{
fn_env(fn)

fn_env(x) <- value
}
\arguments{
\item{fn, x}{A function.}

\item{value}{A new closure environment for the function.}
}
\description{
Closure environments define the scope of functions (see \code{\link[=env]{env()}}).
When a function call is evaluated, R creates an evaluation frame
that inherits from the closure environment. This makes all objects
defined in the closure environment and all its parents available to
code executed within the function.
}
\details{
\code{fn_env()} returns the closure environment of \code{fn}. There is also
an assignment method to set a new closure environment.
}
\examples{
env <- child_env("base")
fn <- with_env(env, function() NULL)
identical(fn_env(fn), env)

other_env <- child_env("base")
fn_env(fn) <- other_env
identical(fn_env(fn), other_env)
}
