% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-plots.R
\name{gg_tensor}
\alias{gg_tensor}
\title{Plot tensor product effects}
\usage{
gg_tensor(x, ci = FALSE, ...)
}
\arguments{
\item{x}{ a fitted \code{gam} object as produced by \code{gam()}.}

\item{ci}{A logical value indicating whether confidence intervals should be
calculated and returned. Defaults to \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link[mgcv]{plot.gam}}}
}
\description{
Given a gam model this convenience function returns a \code{ggplot2} object
depicting 2d smooth terms specified in the model as heat/contour plots. If
more than one 2d smooth term is present individual terms are faceted.
}
\examples{
g <- mgcv::gam(Sepal.Length ~ te(Sepal.Width, Petal.Length), data=iris)
gg_tensor(g)
gg_tensor(g, ci=TRUE)
gg_tensor(update(g, .~. + te(Petal.Width, Petal.Length)))
}
\seealso{
\code{\link{tidy_smooth2d}}
}
