% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-auth.R
\name{req_auth_bearer_token}
\alias{req_auth_bearer_token}
\title{Authenticate request with bearer token}
\usage{
req_auth_bearer_token(req, token)
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{token}{A bearer token}
}
\value{
A modified HTTP \link{request}.
}
\description{
A bearer token gives the bearer access to confidential resources
(so you should keep them secure like you would with a user name and
password). They are usually produced by some large authentication scheme
(like the various OAuth 2.0 flows), but you are sometimes given then
directly.
}
\examples{
req <- request("http://example.com") |> req_auth_bearer_token("sdaljsdf093lkfs")
req

# httr2 does its best to redact the Authorization header so that you don't
# accidentally reveal confidential data. Use `redact_headers` to reveal it:
print(req, redact_headers = FALSE)
}
\seealso{
See \href{https://datatracker.ietf.org/doc/html/rfc6750}{RFC 6750} for more details about bearer token usage
with OAuth 2.0.
}
