% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-quasirandom.R
\name{geom_quasirandom}
\alias{geom_quasirandom}
\title{Points, jittered to reduce overplotting using the vipor package}
\usage{
geom_quasirandom(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  ...,
  method = "quasirandom",
  width = NULL,
  varwidth = FALSE,
  bandwidth = 0.5,
  nbins = NULL,
  dodge.width = 0,
  groupOnX = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{method}{the method used for distributing points
(quasirandom, pseudorandom, smiley, maxout, frowney, minout, tukey, tukeyDense).
See \code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}} for the details of each method.}

\item{width}{the maximum amount of spread (default: 0.4)}

\item{varwidth}{vary the width by the relative size of each group}

\item{bandwidth}{the bandwidth adjustment to use when calculating density
Smaller numbers (< 1) produce a tighter "fit". (default: 0.5)}

\item{nbins}{the number of bins used when calculating density
(has little effect with quasirandom/random distribution)}

\item{dodge.width}{Amount by which points from different aesthetic groups
will be dodged. This requires that one of the aesthetics is a factor.}

\item{groupOnX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} No longer needed.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
The quasirandom geom is a convenient means to offset points within categories
to reduce overplotting. Uses the vipor package
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "point")}
}

\examples{
  ggplot2::qplot(class, hwy, data = ggplot2::mpg, geom='quasirandom')
  # Generate fake data
  distro <- data.frame(
    'variable'=rep(c('runif','rnorm'),each=100),
    'value'=c(runif(100, min=-3, max=3), rnorm(100))
  )
  ggplot2::qplot(variable, value, data = distro, geom = 'quasirandom')
  ggplot2::ggplot(distro,aes(variable, value)) + geom_quasirandom(width=0.1)
}
\seealso{
\code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}} how spacing is determined,
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} for regular, unjittered points,
\code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}} for jittered points,
\code{\link[=geom_boxplot]{geom_boxplot()}} for another way of looking at the conditional
distribution of a variable
}
