% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_error.R
\name{residuals.brmsfit}
\alias{residuals.brmsfit}
\title{Posterior Draws of Residuals/Predictive Errors}
\usage{
\method{residuals}{brmsfit}(
  object,
  newdata = NULL,
  re_formula = NULL,
  method = "posterior_epred",
  type = c("ordinary", "pearson"),
  resp = NULL,
  ndraws = NULL,
  draw_ids = NULL,
  sort = FALSE,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used.
\code{NA} values within factors are interpreted as if all dummy
variables of this factor are zero. This allows, for instance, to make
predictions of the grand mean when using sum coding.}

\item{re_formula}{formula containing group-level effects to be considered in
the prediction. If \code{NULL} (default), include all group-level effects;
if \code{NA}, include no group-level effects.}

\item{method}{Method use to obtain predictions. Either
\code{"posterior_epred"} (the default) or \code{"posterior_predict"}.
Using \code{"posterior_predict"} is recommended
but \code{"posterior_epred"} is the current default for
reasons of backwards compatibility.}

\item{type}{The type of the residuals,
either \code{"ordinary"} or \code{"pearson"}.
More information is provided under 'Details'.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{ndraws}{Positive integer indicating how many posterior draws should
be used. If \code{NULL} (the default) all draws are used. Ignored if
\code{draw_ids} is not \code{NULL}.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{sort}{Logical. Only relevant for time series models.
Indicating whether to return predicted values in the original
order (\code{FALSE}; default) or in the order of the
time series (\code{TRUE}).}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}..}

\item{robust}{If \code{FALSE} (the default) the mean is used as
the measure of central tendency and the standard deviation as
the measure of variability. If \code{TRUE}, the median and the
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\value{
An \code{array} of predictive error/residual draws. If
  \code{summary = FALSE} the output resembles those of
  \code{\link{predictive_error.brmsfit}}. If \code{summary = TRUE} the output
  is an N x E matrix, where N is the number of observations and E denotes
  the summary statistics computed from the draws.
}
\description{
This method is an alias of \code{\link{predictive_error.brmsfit}}
with additional arguments for obtaining summaries of the computed draws.
}
\details{
Residuals of type \code{'ordinary'} are of the form \eqn{R = Y -
  Yrep}, where \eqn{Y} is the observed and \eqn{Yrep} is the predicted response.
  Residuals of type \code{pearson} are of the form \eqn{R = (Y - Yrep) /
  SD(Yrep)}, where \eqn{SD(Yrep)} is an estimate of the standard deviation of
  \eqn{Yrep}.
}
\examples{
\dontrun{
## fit a model
fit <- brm(rating ~ treat + period + carry + (1|subject),
           data = inhaler, cores = 2)

## extract residuals/predictive errors
res <- residuals(fit)
head(res)
}

}
