% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer64.R
\name{as.character.integer64}
\alias{as.character.integer64}
\alias{as.bitstring}
\alias{as.double.integer64}
\alias{as.integer.integer64}
\alias{as.logical.integer64}
\alias{as.bitstring.integer64}
\alias{print.bitstring}
\alias{as.list.integer64}
\title{Coerce from integer64}
\usage{
as.bitstring(x, ...)

\method{as.double}{integer64}(x, keep.names = FALSE, ...)

\method{as.integer}{integer64}(x, ...)

\method{as.logical}{integer64}(x, ...)

\method{as.character}{integer64}(x, ...)

\method{as.bitstring}{integer64}(x, ...)

\method{print}{bitstring}(x, ...)

\method{as.list}{integer64}(x, ...)
}
\arguments{
\item{x}{an integer64 vector}

\item{...}{further arguments to the \code{\link[=NextMethod]{NextMethod()}}}

\item{keep.names}{FALSE, set to TRUE to keep a names vector}
}
\value{
\code{as.bitstring} returns a string of class 'bitstring'.

The other methods return atomic vectors of the expected types
}
\description{
Methods to coerce integer64 to other atomic types. 'as.bitstring' coerces
to a human-readable bit representation (strings of zeroes and ones).
The methods \code{\link[=format]{format()}}, \code{\link[=as.character]{as.character()}}, \code{\link[=as.double]{as.double()}},
\code{\link[=as.logical]{as.logical()}}, \code{\link[=as.integer]{as.integer()}} do what you would expect.
}
\examples{
  as.character(lim.integer64())
  as.bitstring(lim.integer64())
  as.bitstring(as.integer64(c(
   -2,-1,NA,0:2
  )))
}
\seealso{
\code{\link[=as.integer64.character]{as.integer64.character()}} \code{\link[=integer64]{integer64()}}
}
\keyword{classes}
\keyword{manip}
