% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwlProcess.R
\name{cwlProcess}
\alias{cwlProcess}
\title{Parameters for CWL}
\usage{
cwlProcess(
  cwlVersion = "v1.0",
  cwlClass = "CommandLineTool",
  baseCommand = character(),
  requirements = list(),
  hints = list(),
  arguments = list(),
  id = character(),
  label = character(),
  doc = character(),
  inputs = InputParamList(),
  outputs = OutputParamList(),
  stdout = character(),
  stdin = character(),
  expression = character(),
  extensions = list(),
  intent = list()
)
}
\arguments{
\item{cwlVersion}{CWL version}

\item{cwlClass}{"CommandLineTool"}

\item{baseCommand}{Specifies the program or R function to execute}

\item{requirements}{A list of requirements that apply to either the
runtime environment or the workflow engine that must be met in
order to execute this process.}

\item{hints}{Any or a list for the workflow engine.}

\item{arguments}{Command line bindings which are not directly
associated with input parameters.}

\item{id}{The unique identifier for this process object.}

\item{label}{A short, human-readable label of this process object.}

\item{doc}{A documentation string for this object, or an array of
strings which should be concatenated.}

\item{inputs}{A object of `InputParamList`.}

\item{outputs}{A object of `OutputParamList`.}

\item{stdout}{Capture the command's standard output stream to a
file written to the designated output directory.}

\item{stdin}{A path to a file whose contents must be piped into the
command's standard input stream.}

\item{expression}{Javascripts for ExpressionTool class.}

\item{extensions}{A list of extensions and metadata}

\item{intent}{An identifier for the type of computational
operation, of this Process.}
}
\value{
A `cwlProcess` class object.
}
\description{
The main CWL parameter class and constructor for command
tools. More details:
https://www.commonwl.org/v1.0/CommandLineTool.html
}
\details{
https://www.commonwl.org/v1.0/CommandLineTool.html
}
\examples{
input1 <- InputParam(id = "sth")
echo <- cwlProcess(baseCommand = "echo", inputs = InputParamList(input1))
}
