% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_summaryStats.R
\name{channelActivityPlot}
\alias{channelActivityPlot}
\title{Visualise a specified metric over all channels over time.}
\usage{
channelActivityPlot(summaryData, zScale = NULL, zAverage = TRUE)
}
\arguments{
\item{summaryData}{Object of class \linkS4class{Fast5Summary}.}

\item{zScale}{A data.frame containg two columns.  The first must be labelled
'id' and correspond to id field present in all slots in summaryData.  The 
second column should contain data pertaining to that reads that you wish to
be represented on the coloured z-axis.}

\item{zAverage}{Logical indicating if a bar showing the mean across all 
channel for the choosen zScale should be shown on the plot. Defaults to
TRUE.}
}
\value{
Returns an object of class \code{gg} representing the plot.
}
\description{
Plots a line for each fast 5 file, arranged by channel and experiment time 
when the signal was being recorded.  The colour of each line can be 
specified by the user to reflect any metric they wish.  The intention of the
plot is to investigate trends that may appear at specific time points, or 
influence a subset of channels.
}
\examples{
if( require(minionSummaryData) ) {
   require(dplyr)
   data(s.typhi.rep3, package = 'minionSummaryData')
   ## we will plot the median event signal for each read on z-axis
   z_scale = select(eventData(s.typhi.rep3), id, median_signal)
   channelActivityPlot( s.typhi.rep3, zScale = z_scale )
}
}
