# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor.aio import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementLogProfilesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_log_profiles_delete(self, resource_group):
        response = await self.client.log_profiles.delete(
            log_profile_name="str",
            api_version="2016-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_log_profiles_get(self, resource_group):
        response = await self.client.log_profiles.get(
            log_profile_name="str",
            api_version="2016-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_log_profiles_create_or_update(self, resource_group):
        response = await self.client.log_profiles.create_or_update(
            log_profile_name="str",
            parameters={
                "categories": ["str"],
                "location": "str",
                "locations": ["str"],
                "retentionPolicy": {"days": 0, "enabled": bool},
                "id": "str",
                "name": "str",
                "serviceBusRuleId": "str",
                "storageAccountId": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2016-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_log_profiles_update(self, resource_group):
        response = await self.client.log_profiles.update(
            log_profile_name="str",
            log_profiles_resource={
                "categories": ["str"],
                "locations": ["str"],
                "retentionPolicy": {"days": 0, "enabled": bool},
                "serviceBusRuleId": "str",
                "storageAccountId": "str",
                "tags": {"str": "str"},
            },
            api_version="2016-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_log_profiles_list(self, resource_group):
        response = self.client.log_profiles.list(
            api_version="2016-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
