# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Config(msrest.serialization.Model):
    """Config.

    :param is_hive_enabled:
    :type is_hive_enabled: bool
    """

    _attribute_map = {
        'is_hive_enabled': {'key': 'isHiveEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Config, self).__init__(**kwargs)
        self.is_hive_enabled = kwargs.get('is_hive_enabled', None)


class Data(msrest.serialization.Model):
    """Data.

    :param handler_path:
    :type handler_path: str
    :param inputs:
    :type inputs: list[str]
    :param outputs:
    :type outputs: list[str]
    :param tables:
    :type tables: ~azure.synapse.models.Tables
    :param config:
    :type config: ~azure.synapse.models.Config
    """

    _attribute_map = {
        'handler_path': {'key': 'handlerPath', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[str]'},
        'outputs': {'key': 'outputs', 'type': '[str]'},
        'tables': {'key': 'tables', 'type': 'Tables'},
        'config': {'key': 'config', 'type': 'Config'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Data, self).__init__(**kwargs)
        self.handler_path = kwargs.get('handler_path', None)
        self.inputs = kwargs.get('inputs', None)
        self.outputs = kwargs.get('outputs', None)
        self.tables = kwargs.get('tables', None)
        self.config = kwargs.get('config', None)


class Edge(msrest.serialization.Model):
    """Edge.

    :param id:
    :type id: int
    :param child_id:
    :type child_id: int
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'child_id': {'key': 'childId', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Edge, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.child_id = kwargs.get('child_id', None)


class ErrorDetail(msrest.serialization.Model):
    """ErrorDetail.

    All required parameters must be populated in order to send to Azure.

    :param code: Required.
    :type code: str
    :param message: Required.
    :type message: str
    :param target:
    :type target: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)


class ErrorInformation(msrest.serialization.Model):
    """ErrorInformation.

    :param message:
    :type message: str
    :param error_code:
    :type error_code: str
    :param source:  Possible values include: 'System', 'User', 'Unknown', 'Dependency'.
    :type source: str or ~azure.synapse.models.ErrorSource
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorInformation, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.error_code = kwargs.get('error_code', None)
        self.source = kwargs.get('source', None)


class ErrorResponseException(HttpResponseError):
    """Server responded with exception of type: 'ErrorResponse'.

    :param response: Server response to be deserialized.
    :param error_model: A deserialized model of the response body as model.
    """

    def __init__(self, response, error_model):
        self.error = error_model
        super(ErrorResponseException, self).__init__(response=response, error_model=error_model)

    @classmethod
    def from_response(cls, response, deserialize):
        """Deserialize this response as this exception, or a subclass of this exception.

        :param response: Server response to be deserialized.
        :param deserialize: A deserializer
        """
        model_name = 'ErrorResponse'
        error = deserialize(model_name, response)
        if error is None:
            error = deserialize.dependencies[model_name]()
        return error._EXCEPTION_TYPE(response, error)


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :param code: Required.
    :type code: str
    :param message: Required.
    :type message: str
    :param target:
    :type target: str
    :param details:
    :type details: list[~azure.synapse.models.ErrorDetail]
    """
    _EXCEPTION_TYPE = ErrorResponseException

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class Executors(msrest.serialization.Model):
    """Executors.

    :param is_dynamic_allocation_on:
    :type is_dynamic_allocation_on: bool
    :param executor_instances:
    :type executor_instances: int
    :param start_time:
    :type start_time: int
    :param end_time:
    :type end_time: int
    :param events:
    :type events: list[int]
    :param executor_cores:
    :type executor_cores: str
    :param executor_memory:
    :type executor_memory: str
    """

    _attribute_map = {
        'is_dynamic_allocation_on': {'key': 'isDynamicAllocationOn', 'type': 'bool'},
        'executor_instances': {'key': 'executorInstances', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'int'},
        'end_time': {'key': 'endTime', 'type': 'int'},
        'events': {'key': 'events', 'type': '[int]'},
        'executor_cores': {'key': 'executorCores', 'type': 'str'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Executors, self).__init__(**kwargs)
        self.is_dynamic_allocation_on = kwargs.get('is_dynamic_allocation_on', None)
        self.executor_instances = kwargs.get('executor_instances', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.events = kwargs.get('events', None)
        self.executor_cores = kwargs.get('executor_cores', None)
        self.executor_memory = kwargs.get('executor_memory', None)


class ExtendedLivyBatchRequest(msrest.serialization.Model):
    """ExtendedLivyBatchRequest.

    :param tags: A set of tags. Dictionary of :code:`<string>`.
    :type tags: dict[str, str]
    :param artifact_id:
    :type artifact_id: str
    :param name:
    :type name: str
    :param file:
    :type file: str
    :param class_name:
    :type class_name: str
    :param args:
    :type args: list[str]
    :param jars:
    :type jars: list[str]
    :param files:
    :type files: list[str]
    :param archives:
    :type archives: list[str]
    :param conf: Dictionary of :code:`<string>`.
    :type conf: dict[str, str]
    :param driver_memory:
    :type driver_memory: str
    :param driver_cores:
    :type driver_cores: int
    :param executor_memory:
    :type executor_memory: str
    :param executor_cores:
    :type executor_cores: int
    :param num_executors:
    :type num_executors: int
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'class_name': {'key': 'className', 'type': 'str'},
        'args': {'key': 'args', 'type': '[str]'},
        'jars': {'key': 'jars', 'type': '[str]'},
        'files': {'key': 'files', 'type': '[str]'},
        'archives': {'key': 'archives', 'type': '[str]'},
        'conf': {'key': 'conf', 'type': '{str}'},
        'driver_memory': {'key': 'driverMemory', 'type': 'str'},
        'driver_cores': {'key': 'driverCores', 'type': 'int'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
        'executor_cores': {'key': 'executorCores', 'type': 'int'},
        'num_executors': {'key': 'numExecutors', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLivyBatchRequest, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.artifact_id = kwargs.get('artifact_id', None)
        self.name = kwargs.get('name', None)
        self.file = kwargs.get('file', None)
        self.class_name = kwargs.get('class_name', None)
        self.args = kwargs.get('args', None)
        self.jars = kwargs.get('jars', None)
        self.files = kwargs.get('files', None)
        self.archives = kwargs.get('archives', None)
        self.conf = kwargs.get('conf', None)
        self.driver_memory = kwargs.get('driver_memory', None)
        self.driver_cores = kwargs.get('driver_cores', None)
        self.executor_memory = kwargs.get('executor_memory', None)
        self.executor_cores = kwargs.get('executor_cores', None)
        self.num_executors = kwargs.get('num_executors', None)


class ExtendedLivyBatchResponse(msrest.serialization.Model):
    """ExtendedLivyBatchResponse.

    :param livy_info:
    :type livy_info: ~azure.synapse.models.LivyBatchStateInformation
    :param name:
    :type name: str
    :param workspace_name:
    :type workspace_name: str
    :param spark_pool_name:
    :type spark_pool_name: str
    :param submitter_name:
    :type submitter_name: str
    :param submitter_id:
    :type submitter_id: str
    :param artifact_id:
    :type artifact_id: str
    :param job_type:  Possible values include: 'SparkBatch', 'SparkSession'.
    :type job_type: str or ~azure.synapse.models.JobType
    :param result:  Possible values include: 'Uncertain', 'Succeeded', 'Failed', 'Cancelled'.
    :type result: str or ~azure.synapse.models.JobResult
    :param scheduler_info:
    :type scheduler_info: ~azure.synapse.models.SchedulerInformation
    :param plugin_info:
    :type plugin_info: ~azure.synapse.models.SparkServicePluginInformation
    :param error_info:
    :type error_info: list[~azure.synapse.models.ErrorInformation]
    :param tags: A set of tags. Dictionary of :code:`<string>`.
    :type tags: dict[str, str]
    :param id:
    :type id: int
    :param app_id:
    :type app_id: str
    :param app_info: Dictionary of :code:`<string>`.
    :type app_info: dict[str, str]
    :param state:
    :type state: str
    :param log:
    :type log: list[str]
    """

    _attribute_map = {
        'livy_info': {'key': 'livyInfo', 'type': 'LivyBatchStateInformation'},
        'name': {'key': 'name', 'type': 'str'},
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'spark_pool_name': {'key': 'sparkPoolName', 'type': 'str'},
        'submitter_name': {'key': 'submitterName', 'type': 'str'},
        'submitter_id': {'key': 'submitterId', 'type': 'str'},
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'result': {'key': 'result', 'type': 'str'},
        'scheduler_info': {'key': 'schedulerInfo', 'type': 'SchedulerInformation'},
        'plugin_info': {'key': 'pluginInfo', 'type': 'SparkServicePluginInformation'},
        'error_info': {'key': 'errorInfo', 'type': '[ErrorInformation]'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'int'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_info': {'key': 'appInfo', 'type': '{str}'},
        'state': {'key': 'state', 'type': 'str'},
        'log': {'key': 'log', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLivyBatchResponse, self).__init__(**kwargs)
        self.livy_info = kwargs.get('livy_info', None)
        self.name = kwargs.get('name', None)
        self.workspace_name = kwargs.get('workspace_name', None)
        self.spark_pool_name = kwargs.get('spark_pool_name', None)
        self.submitter_name = kwargs.get('submitter_name', None)
        self.submitter_id = kwargs.get('submitter_id', None)
        self.artifact_id = kwargs.get('artifact_id', None)
        self.job_type = kwargs.get('job_type', None)
        self.result = kwargs.get('result', None)
        self.scheduler_info = kwargs.get('scheduler_info', None)
        self.plugin_info = kwargs.get('plugin_info', None)
        self.error_info = kwargs.get('error_info', None)
        self.tags = kwargs.get('tags', None)
        self.id = kwargs.get('id', None)
        self.app_id = kwargs.get('app_id', None)
        self.app_info = kwargs.get('app_info', None)
        self.state = kwargs.get('state', None)
        self.log = kwargs.get('log', None)


class ExtendedLivyListBatchResponse(msrest.serialization.Model):
    """ExtendedLivyListBatchResponse.

    :param from_property:
    :type from_property: int
    :param total:
    :type total: int
    :param sessions:
    :type sessions: list[~azure.synapse.models.ExtendedLivyBatchResponse]
    """

    _attribute_map = {
        'from_property': {'key': 'from', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
        'sessions': {'key': 'sessions', 'type': '[ExtendedLivyBatchResponse]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLivyListBatchResponse, self).__init__(**kwargs)
        self.from_property = kwargs.get('from_property', None)
        self.total = kwargs.get('total', None)
        self.sessions = kwargs.get('sessions', None)


class ExtendedLivyListSessionResponse(msrest.serialization.Model):
    """ExtendedLivyListSessionResponse.

    :param from_property:
    :type from_property: int
    :param total:
    :type total: int
    :param sessions:
    :type sessions: list[~azure.synapse.models.ExtendedLivySessionResponse]
    """

    _attribute_map = {
        'from_property': {'key': 'from', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
        'sessions': {'key': 'sessions', 'type': '[ExtendedLivySessionResponse]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLivyListSessionResponse, self).__init__(**kwargs)
        self.from_property = kwargs.get('from_property', None)
        self.total = kwargs.get('total', None)
        self.sessions = kwargs.get('sessions', None)


class ExtendedLivySessionRequest(msrest.serialization.Model):
    """ExtendedLivySessionRequest.

    :param tags: A set of tags. Dictionary of :code:`<string>`.
    :type tags: dict[str, str]
    :param artifact_id:
    :type artifact_id: str
    :param name:
    :type name: str
    :param file:
    :type file: str
    :param class_name:
    :type class_name: str
    :param args:
    :type args: list[str]
    :param jars:
    :type jars: list[str]
    :param files:
    :type files: list[str]
    :param archives:
    :type archives: list[str]
    :param conf: Dictionary of :code:`<string>`.
    :type conf: dict[str, str]
    :param driver_memory:
    :type driver_memory: str
    :param driver_cores:
    :type driver_cores: int
    :param executor_memory:
    :type executor_memory: str
    :param executor_cores:
    :type executor_cores: int
    :param num_executors:
    :type num_executors: int
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'class_name': {'key': 'className', 'type': 'str'},
        'args': {'key': 'args', 'type': '[str]'},
        'jars': {'key': 'jars', 'type': '[str]'},
        'files': {'key': 'files', 'type': '[str]'},
        'archives': {'key': 'archives', 'type': '[str]'},
        'conf': {'key': 'conf', 'type': '{str}'},
        'driver_memory': {'key': 'driverMemory', 'type': 'str'},
        'driver_cores': {'key': 'driverCores', 'type': 'int'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
        'executor_cores': {'key': 'executorCores', 'type': 'int'},
        'num_executors': {'key': 'numExecutors', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLivySessionRequest, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.artifact_id = kwargs.get('artifact_id', None)
        self.name = kwargs.get('name', None)
        self.file = kwargs.get('file', None)
        self.class_name = kwargs.get('class_name', None)
        self.args = kwargs.get('args', None)
        self.jars = kwargs.get('jars', None)
        self.files = kwargs.get('files', None)
        self.archives = kwargs.get('archives', None)
        self.conf = kwargs.get('conf', None)
        self.driver_memory = kwargs.get('driver_memory', None)
        self.driver_cores = kwargs.get('driver_cores', None)
        self.executor_memory = kwargs.get('executor_memory', None)
        self.executor_cores = kwargs.get('executor_cores', None)
        self.num_executors = kwargs.get('num_executors', None)


class ExtendedLivySessionResponse(msrest.serialization.Model):
    """ExtendedLivySessionResponse.

    :param livy_info:
    :type livy_info: ~azure.synapse.models.LivySessionStateInformation
    :param name:
    :type name: str
    :param workspace_name:
    :type workspace_name: str
    :param spark_pool_name:
    :type spark_pool_name: str
    :param submitter_name:
    :type submitter_name: str
    :param submitter_id:
    :type submitter_id: str
    :param artifact_id:
    :type artifact_id: str
    :param job_type:  Possible values include: 'SparkBatch', 'SparkSession'.
    :type job_type: str or ~azure.synapse.models.JobType
    :param result:  Possible values include: 'Uncertain', 'Succeeded', 'Failed', 'Cancelled'.
    :type result: str or ~azure.synapse.models.JobResult
    :param scheduler_info:
    :type scheduler_info: ~azure.synapse.models.SchedulerInformation
    :param plugin_info:
    :type plugin_info: ~azure.synapse.models.SparkServicePluginInformation
    :param error_info:
    :type error_info: list[~azure.synapse.models.ErrorInformation]
    :param tags: A set of tags. Dictionary of :code:`<string>`.
    :type tags: dict[str, str]
    :param id:
    :type id: int
    :param app_id:
    :type app_id: str
    :param app_info: Dictionary of :code:`<string>`.
    :type app_info: dict[str, str]
    :param state:
    :type state: str
    :param log:
    :type log: list[str]
    """

    _attribute_map = {
        'livy_info': {'key': 'livyInfo', 'type': 'LivySessionStateInformation'},
        'name': {'key': 'name', 'type': 'str'},
        'workspace_name': {'key': 'workspaceName', 'type': 'str'},
        'spark_pool_name': {'key': 'sparkPoolName', 'type': 'str'},
        'submitter_name': {'key': 'submitterName', 'type': 'str'},
        'submitter_id': {'key': 'submitterId', 'type': 'str'},
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'result': {'key': 'result', 'type': 'str'},
        'scheduler_info': {'key': 'schedulerInfo', 'type': 'SchedulerInformation'},
        'plugin_info': {'key': 'pluginInfo', 'type': 'SparkServicePluginInformation'},
        'error_info': {'key': 'errorInfo', 'type': '[ErrorInformation]'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'int'},
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_info': {'key': 'appInfo', 'type': '{str}'},
        'state': {'key': 'state', 'type': 'str'},
        'log': {'key': 'log', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLivySessionResponse, self).__init__(**kwargs)
        self.livy_info = kwargs.get('livy_info', None)
        self.name = kwargs.get('name', None)
        self.workspace_name = kwargs.get('workspace_name', None)
        self.spark_pool_name = kwargs.get('spark_pool_name', None)
        self.submitter_name = kwargs.get('submitter_name', None)
        self.submitter_id = kwargs.get('submitter_id', None)
        self.artifact_id = kwargs.get('artifact_id', None)
        self.job_type = kwargs.get('job_type', None)
        self.result = kwargs.get('result', None)
        self.scheduler_info = kwargs.get('scheduler_info', None)
        self.plugin_info = kwargs.get('plugin_info', None)
        self.error_info = kwargs.get('error_info', None)
        self.tags = kwargs.get('tags', None)
        self.id = kwargs.get('id', None)
        self.app_id = kwargs.get('app_id', None)
        self.app_info = kwargs.get('app_info', None)
        self.state = kwargs.get('state', None)
        self.log = kwargs.get('log', None)


class GetAccessControlInfoRequest(msrest.serialization.Model):
    """GetAccessControlInfoRequest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar artifact_type:  Default value: "Workspace".
    :vartype artifact_type: str
    :param artifact_name:
    :type artifact_name: str
    """

    _validation = {
        'artifact_type': {'constant': True},
    }

    _attribute_map = {
        'artifact_type': {'key': 'artifactType', 'type': 'str'},
        'artifact_name': {'key': 'artifactName', 'type': 'str'},
    }

    artifact_type = "Workspace"

    def __init__(
        self,
        **kwargs
    ):
        super(GetAccessControlInfoRequest, self).__init__(**kwargs)
        self.artifact_name = kwargs.get('artifact_name', None)


class HistoryServerDataResponse(msrest.serialization.Model):
    """HistoryServerDataResponse.

    :param data:
    :type data: ~azure.synapse.models.Data
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'Data'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HistoryServerDataResponse, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)


class HistoryServerDiagnosticResponse(msrest.serialization.Model):
    """HistoryServerDiagnosticResponse.

    :param data:
    :type data: ~azure.synapse.models.HistoryServerDiagnosticResponseData
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'HistoryServerDiagnosticResponseData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HistoryServerDiagnosticResponse, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)


class HistoryServerDiagnosticResponseData(msrest.serialization.Model):
    """HistoryServerDiagnosticResponseData.

    :param stages:
    :type stages: ~azure.synapse.models.Stages
    :param executors:
    :type executors: ~azure.synapse.models.Executors
    """

    _attribute_map = {
        'stages': {'key': 'stages', 'type': 'Stages'},
        'executors': {'key': 'executors', 'type': 'Executors'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HistoryServerDiagnosticResponseData, self).__init__(**kwargs)
        self.stages = kwargs.get('stages', None)
        self.executors = kwargs.get('executors', None)


class HistoryServerGraphResponse(msrest.serialization.Model):
    """HistoryServerGraphResponse.

    :param data:
    :type data: ~azure.synapse.models.HistoryServerGraphResponseData
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'HistoryServerGraphResponseData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HistoryServerGraphResponse, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)


class HistoryServerGraphResponseData(msrest.serialization.Model):
    """HistoryServerGraphResponseData.

    :param is_app_finished:
    :type is_app_finished: bool
    :param jobs:
    :type jobs: ~azure.synapse.models.Jobs
    :param stages:
    :type stages: ~azure.synapse.models.Stages
    """

    _attribute_map = {
        'is_app_finished': {'key': 'isAppFinished', 'type': 'bool'},
        'jobs': {'key': 'jobs', 'type': 'Jobs'},
        'stages': {'key': 'stages', 'type': 'Stages'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HistoryServerGraphResponseData, self).__init__(**kwargs)
        self.is_app_finished = kwargs.get('is_app_finished', None)
        self.jobs = kwargs.get('jobs', None)
        self.stages = kwargs.get('stages', None)


class HistoryServerPropertiesResponse(msrest.serialization.Model):
    """HistoryServerPropertiesResponse.

    :param web_proxy_endpoint:
    :type web_proxy_endpoint: str
    """

    _attribute_map = {
        'web_proxy_endpoint': {'key': 'webProxyEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HistoryServerPropertiesResponse, self).__init__(**kwargs)
        self.web_proxy_endpoint = kwargs.get('web_proxy_endpoint', None)


class Jobs(msrest.serialization.Model):
    """Jobs.

    :param time:
    :type time: int
    :param start_time:
    :type start_time: int
    :param id:
    :type id: int
    :param edges:
    :type edges: list[~azure.synapse.models.Edge]
    :param nodes:
    :type nodes: list[int]
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'int'},
        'id': {'key': 'id', 'type': 'int'},
        'edges': {'key': 'edges', 'type': '[Edge]'},
        'nodes': {'key': 'nodes', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Jobs, self).__init__(**kwargs)
        self.time = kwargs.get('time', None)
        self.start_time = kwargs.get('start_time', None)
        self.id = kwargs.get('id', None)
        self.edges = kwargs.get('edges', None)
        self.nodes = kwargs.get('nodes', None)


class LivyBatchStateInformation(msrest.serialization.Model):
    """LivyBatchStateInformation.

    :param not_started_at:
    :type not_started_at: ~datetime.datetime
    :param starting_at:
    :type starting_at: ~datetime.datetime
    :param running_at:
    :type running_at: ~datetime.datetime
    :param dead_at:
    :type dead_at: ~datetime.datetime
    :param success_at:
    :type success_at: ~datetime.datetime
    :param killed_at:
    :type killed_at: ~datetime.datetime
    :param recovering_at:
    :type recovering_at: ~datetime.datetime
    :param current_state:
    :type current_state: str
    :param job_creation_request:
    :type job_creation_request: ~azure.synapse.models.LivyRequestBase
    """

    _attribute_map = {
        'not_started_at': {'key': 'notStartedAt', 'type': 'iso-8601'},
        'starting_at': {'key': 'startingAt', 'type': 'iso-8601'},
        'running_at': {'key': 'runningAt', 'type': 'iso-8601'},
        'dead_at': {'key': 'deadAt', 'type': 'iso-8601'},
        'success_at': {'key': 'successAt', 'type': 'iso-8601'},
        'killed_at': {'key': 'killedAt', 'type': 'iso-8601'},
        'recovering_at': {'key': 'recoveringAt', 'type': 'iso-8601'},
        'current_state': {'key': 'currentState', 'type': 'str'},
        'job_creation_request': {'key': 'jobCreationRequest', 'type': 'LivyRequestBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivyBatchStateInformation, self).__init__(**kwargs)
        self.not_started_at = kwargs.get('not_started_at', None)
        self.starting_at = kwargs.get('starting_at', None)
        self.running_at = kwargs.get('running_at', None)
        self.dead_at = kwargs.get('dead_at', None)
        self.success_at = kwargs.get('success_at', None)
        self.killed_at = kwargs.get('killed_at', None)
        self.recovering_at = kwargs.get('recovering_at', None)
        self.current_state = kwargs.get('current_state', None)
        self.job_creation_request = kwargs.get('job_creation_request', None)


class LivyRequestBase(msrest.serialization.Model):
    """LivyRequestBase.

    :param name:
    :type name: str
    :param file:
    :type file: str
    :param class_name:
    :type class_name: str
    :param args:
    :type args: list[str]
    :param jars:
    :type jars: list[str]
    :param files:
    :type files: list[str]
    :param archives:
    :type archives: list[str]
    :param conf: Dictionary of :code:`<string>`.
    :type conf: dict[str, str]
    :param driver_memory:
    :type driver_memory: str
    :param driver_cores:
    :type driver_cores: int
    :param executor_memory:
    :type executor_memory: str
    :param executor_cores:
    :type executor_cores: int
    :param num_executors:
    :type num_executors: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'file': {'key': 'file', 'type': 'str'},
        'class_name': {'key': 'className', 'type': 'str'},
        'args': {'key': 'args', 'type': '[str]'},
        'jars': {'key': 'jars', 'type': '[str]'},
        'files': {'key': 'files', 'type': '[str]'},
        'archives': {'key': 'archives', 'type': '[str]'},
        'conf': {'key': 'conf', 'type': '{str}'},
        'driver_memory': {'key': 'driverMemory', 'type': 'str'},
        'driver_cores': {'key': 'driverCores', 'type': 'int'},
        'executor_memory': {'key': 'executorMemory', 'type': 'str'},
        'executor_cores': {'key': 'executorCores', 'type': 'int'},
        'num_executors': {'key': 'numExecutors', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivyRequestBase, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.file = kwargs.get('file', None)
        self.class_name = kwargs.get('class_name', None)
        self.args = kwargs.get('args', None)
        self.jars = kwargs.get('jars', None)
        self.files = kwargs.get('files', None)
        self.archives = kwargs.get('archives', None)
        self.conf = kwargs.get('conf', None)
        self.driver_memory = kwargs.get('driver_memory', None)
        self.driver_cores = kwargs.get('driver_cores', None)
        self.executor_memory = kwargs.get('executor_memory', None)
        self.executor_cores = kwargs.get('executor_cores', None)
        self.num_executors = kwargs.get('num_executors', None)


class LivySessionStateInformation(msrest.serialization.Model):
    """LivySessionStateInformation.

    :param not_started_at:
    :type not_started_at: ~datetime.datetime
    :param starting_at:
    :type starting_at: ~datetime.datetime
    :param idle_at:
    :type idle_at: ~datetime.datetime
    :param dead_at:
    :type dead_at: ~datetime.datetime
    :param shutting_down_at:
    :type shutting_down_at: ~datetime.datetime
    :param killed_at:
    :type killed_at: ~datetime.datetime
    :param recovering_at:
    :type recovering_at: ~datetime.datetime
    :param busy_at:
    :type busy_at: ~datetime.datetime
    :param error_at:
    :type error_at: ~datetime.datetime
    :param current_state:
    :type current_state: str
    :param job_creation_request:
    :type job_creation_request: ~azure.synapse.models.LivyRequestBase
    """

    _attribute_map = {
        'not_started_at': {'key': 'notStartedAt', 'type': 'iso-8601'},
        'starting_at': {'key': 'startingAt', 'type': 'iso-8601'},
        'idle_at': {'key': 'idleAt', 'type': 'iso-8601'},
        'dead_at': {'key': 'deadAt', 'type': 'iso-8601'},
        'shutting_down_at': {'key': 'shuttingDownAt', 'type': 'iso-8601'},
        'killed_at': {'key': 'killedAt', 'type': 'iso-8601'},
        'recovering_at': {'key': 'recoveringAt', 'type': 'iso-8601'},
        'busy_at': {'key': 'busyAt', 'type': 'iso-8601'},
        'error_at': {'key': 'errorAt', 'type': 'iso-8601'},
        'current_state': {'key': 'currentState', 'type': 'str'},
        'job_creation_request': {'key': 'jobCreationRequest', 'type': 'LivyRequestBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivySessionStateInformation, self).__init__(**kwargs)
        self.not_started_at = kwargs.get('not_started_at', None)
        self.starting_at = kwargs.get('starting_at', None)
        self.idle_at = kwargs.get('idle_at', None)
        self.dead_at = kwargs.get('dead_at', None)
        self.shutting_down_at = kwargs.get('shutting_down_at', None)
        self.killed_at = kwargs.get('killed_at', None)
        self.recovering_at = kwargs.get('recovering_at', None)
        self.busy_at = kwargs.get('busy_at', None)
        self.error_at = kwargs.get('error_at', None)
        self.current_state = kwargs.get('current_state', None)
        self.job_creation_request = kwargs.get('job_creation_request', None)


class LivyStatementCancellationResponse(msrest.serialization.Model):
    """LivyStatementCancellationResponse.

    :param msg:
    :type msg: str
    """

    _attribute_map = {
        'msg': {'key': 'msg', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivyStatementCancellationResponse, self).__init__(**kwargs)
        self.msg = kwargs.get('msg', None)


class LivyStatementOutput(msrest.serialization.Model):
    """LivyStatementOutput.

    :param status:
    :type status: str
    :param execution_count:
    :type execution_count: int
    :param data:
    :type data: object
    :param ename:
    :type ename: str
    :param evalue:
    :type evalue: str
    :param traceback:
    :type traceback: list[str]
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'execution_count': {'key': 'execution_count', 'type': 'int'},
        'data': {'key': 'data', 'type': 'object'},
        'ename': {'key': 'ename', 'type': 'str'},
        'evalue': {'key': 'evalue', 'type': 'str'},
        'traceback': {'key': 'traceback', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivyStatementOutput, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.execution_count = kwargs.get('execution_count', None)
        self.data = kwargs.get('data', None)
        self.ename = kwargs.get('ename', None)
        self.evalue = kwargs.get('evalue', None)
        self.traceback = kwargs.get('traceback', None)


class LivyStatementRequestBody(msrest.serialization.Model):
    """LivyStatementRequestBody.

    :param code:
    :type code: str
    :param kind:
    :type kind: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivyStatementRequestBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.kind = kwargs.get('kind', None)


class LivyStatementResponseBody(msrest.serialization.Model):
    """LivyStatementResponseBody.

    :param id:
    :type id: int
    :param code:
    :type code: str
    :param state:
    :type state: str
    :param output:
    :type output: ~azure.synapse.models.LivyStatementOutput
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'code': {'key': 'code', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'output': {'key': 'output', 'type': 'LivyStatementOutput'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivyStatementResponseBody, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.code = kwargs.get('code', None)
        self.state = kwargs.get('state', None)
        self.output = kwargs.get('output', None)


class LivyStatementsResponseBody(msrest.serialization.Model):
    """LivyStatementsResponseBody.

    :param total_statements:
    :type total_statements: int
    :param statements:
    :type statements: list[~azure.synapse.models.LivyStatementResponseBody]
    """

    _attribute_map = {
        'total_statements': {'key': 'total_statements', 'type': 'int'},
        'statements': {'key': 'statements', 'type': '[LivyStatementResponseBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LivyStatementsResponseBody, self).__init__(**kwargs)
        self.total_statements = kwargs.get('total_statements', None)
        self.statements = kwargs.get('statements', None)


class Option(msrest.serialization.Model):
    """Option.

    :param additional_prop1:
    :type additional_prop1: str
    :param additional_prop2:
    :type additional_prop2: str
    :param additional_prop3:
    :type additional_prop3: str
    """

    _attribute_map = {
        'additional_prop1': {'key': 'additionalProp1', 'type': 'str'},
        'additional_prop2': {'key': 'additionalProp2', 'type': 'str'},
        'additional_prop3': {'key': 'additionalProp3', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Option, self).__init__(**kwargs)
        self.additional_prop1 = kwargs.get('additional_prop1', None)
        self.additional_prop2 = kwargs.get('additional_prop2', None)
        self.additional_prop3 = kwargs.get('additional_prop3', None)


class SchedulerInformation(msrest.serialization.Model):
    """SchedulerInformation.

    :param submitted_at:
    :type submitted_at: ~datetime.datetime
    :param scheduled_at:
    :type scheduled_at: ~datetime.datetime
    :param ended_at:
    :type ended_at: ~datetime.datetime
    :param cancellation_requested_at:
    :type cancellation_requested_at: ~datetime.datetime
    :param current_state:  Possible values include: 'Queued', 'Scheduled', 'Ended'.
    :type current_state: str or ~azure.synapse.models.SchedulerCurrentState
    """

    _attribute_map = {
        'submitted_at': {'key': 'submittedAt', 'type': 'iso-8601'},
        'scheduled_at': {'key': 'scheduledAt', 'type': 'iso-8601'},
        'ended_at': {'key': 'endedAt', 'type': 'iso-8601'},
        'cancellation_requested_at': {'key': 'cancellationRequestedAt', 'type': 'iso-8601'},
        'current_state': {'key': 'currentState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SchedulerInformation, self).__init__(**kwargs)
        self.submitted_at = kwargs.get('submitted_at', None)
        self.scheduled_at = kwargs.get('scheduled_at', None)
        self.ended_at = kwargs.get('ended_at', None)
        self.cancellation_requested_at = kwargs.get('cancellation_requested_at', None)
        self.current_state = kwargs.get('current_state', None)


class SetWorkspaceAdministratorsRequest(msrest.serialization.Model):
    """SetWorkspaceAdministratorsRequest.

    :param administrators:
    :type administrators: list[str]
    """

    _attribute_map = {
        'administrators': {'key': 'administrators', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SetWorkspaceAdministratorsRequest, self).__init__(**kwargs)
        self.administrators = kwargs.get('administrators', None)


class SparkJob(msrest.serialization.Model):
    """SparkJob.

    :param state:
    :type state: str
    :param name:
    :type name: str
    :param submitter:
    :type submitter: str
    :param compute:
    :type compute: str
    :param spark_application_id:
    :type spark_application_id: str
    :param livy_id:
    :type livy_id: str
    :param timing:
    :type timing: list[str]
    :param spark_job_definition:
    :type spark_job_definition: str
    :param pipeline:
    :type pipeline: list[~azure.synapse.models.SparkJob]
    :param job_type:
    :type job_type: str
    :param submit_time:
    :type submit_time: ~datetime.datetime
    :param end_time:
    :type end_time: ~datetime.datetime
    :param queued_duration:
    :type queued_duration: str
    :param running_duration:
    :type running_duration: str
    :param total_duration:
    :type total_duration: str
    """

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'submitter': {'key': 'submitter', 'type': 'str'},
        'compute': {'key': 'compute', 'type': 'str'},
        'spark_application_id': {'key': 'sparkApplicationId', 'type': 'str'},
        'livy_id': {'key': 'livyId', 'type': 'str'},
        'timing': {'key': 'timing', 'type': '[str]'},
        'spark_job_definition': {'key': 'sparkJobDefinition', 'type': 'str'},
        'pipeline': {'key': 'pipeline', 'type': '[SparkJob]'},
        'job_type': {'key': 'jobType', 'type': 'str'},
        'submit_time': {'key': 'submitTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'queued_duration': {'key': 'queuedDuration', 'type': 'str'},
        'running_duration': {'key': 'runningDuration', 'type': 'str'},
        'total_duration': {'key': 'totalDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SparkJob, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.name = kwargs.get('name', None)
        self.submitter = kwargs.get('submitter', None)
        self.compute = kwargs.get('compute', None)
        self.spark_application_id = kwargs.get('spark_application_id', None)
        self.livy_id = kwargs.get('livy_id', None)
        self.timing = kwargs.get('timing', None)
        self.spark_job_definition = kwargs.get('spark_job_definition', None)
        self.pipeline = kwargs.get('pipeline', None)
        self.job_type = kwargs.get('job_type', None)
        self.submit_time = kwargs.get('submit_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.queued_duration = kwargs.get('queued_duration', None)
        self.running_duration = kwargs.get('running_duration', None)
        self.total_duration = kwargs.get('total_duration', None)


class SparkJobListViewResponse(msrest.serialization.Model):
    """SparkJobListViewResponse.

    :param n_jobs:
    :type n_jobs: int
    :param spark_jobs:
    :type spark_jobs: list[~azure.synapse.models.SparkJob]
    """

    _attribute_map = {
        'n_jobs': {'key': 'nJobs', 'type': 'int'},
        'spark_jobs': {'key': 'sparkJobs', 'type': '[SparkJob]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SparkJobListViewResponse, self).__init__(**kwargs)
        self.n_jobs = kwargs.get('n_jobs', None)
        self.spark_jobs = kwargs.get('spark_jobs', None)


class SparkServicePluginInformation(msrest.serialization.Model):
    """SparkServicePluginInformation.

    :param preparation_started_at:
    :type preparation_started_at: ~datetime.datetime
    :param resource_acquisition_started_at:
    :type resource_acquisition_started_at: ~datetime.datetime
    :param submission_started_at:
    :type submission_started_at: ~datetime.datetime
    :param monitoring_started_at:
    :type monitoring_started_at: ~datetime.datetime
    :param cleanup_started_at:
    :type cleanup_started_at: ~datetime.datetime
    :param current_state:  Possible values include: 'Preparation', 'ResourceAcquisition', 'Queued',
     'Submission', 'Monitoring', 'Cleanup', 'Ended'.
    :type current_state: str or ~azure.synapse.models.PluginCurrentState
    """

    _attribute_map = {
        'preparation_started_at': {'key': 'preparationStartedAt', 'type': 'iso-8601'},
        'resource_acquisition_started_at': {'key': 'resourceAcquisitionStartedAt', 'type': 'iso-8601'},
        'submission_started_at': {'key': 'submissionStartedAt', 'type': 'iso-8601'},
        'monitoring_started_at': {'key': 'monitoringStartedAt', 'type': 'iso-8601'},
        'cleanup_started_at': {'key': 'cleanupStartedAt', 'type': 'iso-8601'},
        'current_state': {'key': 'currentState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SparkServicePluginInformation, self).__init__(**kwargs)
        self.preparation_started_at = kwargs.get('preparation_started_at', None)
        self.resource_acquisition_started_at = kwargs.get('resource_acquisition_started_at', None)
        self.submission_started_at = kwargs.get('submission_started_at', None)
        self.monitoring_started_at = kwargs.get('monitoring_started_at', None)
        self.cleanup_started_at = kwargs.get('cleanup_started_at', None)
        self.current_state = kwargs.get('current_state', None)


class Stages(msrest.serialization.Model):
    """Stages.

    :param data_avg:
    :type data_avg: int
    :param time_avg:
    :type time_avg: int
    :param id:
    :type id: int
    :param attempt_id:
    :type attempt_id: int
    :param name:
    :type name: str
    :param data_skew_task:
    :type data_skew_task: list[int]
    :param time_skew_task:
    :type time_skew_task: list[int]
    :param tasks:
    :type tasks: list[int]
    """

    _attribute_map = {
        'data_avg': {'key': 'dataAvg', 'type': 'int'},
        'time_avg': {'key': 'timeAvg', 'type': 'int'},
        'id': {'key': 'id', 'type': 'int'},
        'attempt_id': {'key': 'attemptId', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'data_skew_task': {'key': 'dataSkewTask', 'type': '[int]'},
        'time_skew_task': {'key': 'timeSkewTask', 'type': '[int]'},
        'tasks': {'key': 'tasks', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Stages, self).__init__(**kwargs)
        self.data_avg = kwargs.get('data_avg', None)
        self.time_avg = kwargs.get('time_avg', None)
        self.id = kwargs.get('id', None)
        self.attempt_id = kwargs.get('attempt_id', None)
        self.name = kwargs.get('name', None)
        self.data_skew_task = kwargs.get('data_skew_task', None)
        self.time_skew_task = kwargs.get('time_skew_task', None)
        self.tasks = kwargs.get('tasks', None)


class Tables(msrest.serialization.Model):
    """Tables.

    :param operation:
    :type operation: str
    :param options:
    :type options: list[~azure.synapse.models.Option]
    """

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'options': {'key': 'options', 'type': '[Option]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Tables, self).__init__(**kwargs)
        self.operation = kwargs.get('operation', None)
        self.options = kwargs.get('options', None)


class WorkspaceAccessControlResponse(msrest.serialization.Model):
    """WorkspaceAccessControlResponse.

    :param administrators:
    :type administrators: list[str]
    :param etag:
    :type etag: str
    :param access_control_list: Dictionary of
     <components·k2t8p9·schemas·workspaceaccesscontrolresponse·properties·accesscontrollist·additionalproperties>.
    :type access_control_list: dict[str, list[str]]
    """

    _attribute_map = {
        'administrators': {'key': 'administrators', 'type': '[str]'},
        'etag': {'key': 'etag', 'type': 'str'},
        'access_control_list': {'key': 'accessControlList', 'type': '{[str]}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceAccessControlResponse, self).__init__(**kwargs)
        self.administrators = kwargs.get('administrators', None)
        self.etag = kwargs.get('etag', None)
        self.access_control_list = kwargs.get('access_control_list', None)
