# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ApplicationType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of application being monitored.
    """

    WEB = "web"
    OTHER = "other"

class CategoryType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    WORKBOOK = "workbook"
    TSG = "TSG"
    PERFORMANCE = "performance"
    RETENTION = "retention"

class FavoriteSourceType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    RETENTION = "retention"
    NOTEBOOK = "notebook"
    SESSIONS = "sessions"
    EVENTS = "events"
    USERFLOWS = "userflows"
    FUNNEL = "funnel"
    IMPACT = "impact"
    SEGMENTATION = "segmentation"

class FavoriteType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum indicating if this favorite definition is owned by a specific user or is shared between
    all users with access to the Application Insights component.
    """

    SHARED = "shared"
    USER = "user"

class FlowType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Used by the Application Insights system to determine what kind of flow this component was
    created by. This is to be set to 'Bluefield' when creating/updating a component via the REST
    API.
    """

    BLUEFIELD = "Bluefield"

class IngestionMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the flow of the ingestion.
    """

    APPLICATION_INSIGHTS = "ApplicationInsights"
    APPLICATION_INSIGHTS_WITH_DIAGNOSTIC_SETTINGS = "ApplicationInsightsWithDiagnosticSettings"
    LOG_ANALYTICS = "LogAnalytics"

class ItemScope(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum indicating if this item definition is owned by a specific user or is shared between all
    users with access to the Application Insights component.
    """

    SHARED = "shared"
    USER = "user"

class ItemScopePath(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    ANALYTICS_ITEMS = "analyticsItems"
    MYANALYTICS_ITEMS = "myanalyticsItems"

class ItemType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum indicating the type of the Analytics item.
    """

    NONE = "none"
    QUERY = "query"
    RECENT = "recent"
    FUNCTION = "function"

class ItemTypeParameter(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    NONE = "none"
    QUERY = "query"
    FUNCTION = "function"
    FOLDER = "folder"
    RECENT = "recent"

class PurgeState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the operation represented by the requested Id.
    """

    PENDING = "pending"
    COMPLETED = "completed"

class RequestSource(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Describes what tool created this Application Insights component. Customers using this API
    should set this to the default 'rest'.
    """

    REST = "rest"

class SharedTypeKind(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of workbook. Choices are user and shared.
    """

    USER = "user"
    SHARED = "shared"

class WebTestKind(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of web test that this web test watches. Choices are ping and multistep.
    """

    PING = "ping"
    MULTISTEP = "multistep"
