# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum

class AvroCompressionCodec(str, Enum):

    none = "none"
    deflate = "deflate"
    snappy = "snappy"
    xz = "xz"
    bzip2 = "bzip2"

class AzureFunctionActivityMethod(str, Enum):
    """The list of HTTP methods supported by a AzureFunctionActivity.
    """

    get = "GET"
    post = "POST"
    put = "PUT"
    delete = "DELETE"
    options = "OPTIONS"
    head = "HEAD"
    trace = "TRACE"

class CellOutputType(str, Enum):
    """Execution, display, or stream outputs.
    """

    execute_result = "execute_result"
    display_data = "display_data"
    stream = "stream"
    error = "error"

class DataFlowComputeType(str, Enum):
    """Compute type of the cluster which will execute data flow job.
    """

    general = "General"
    memory_optimized = "MemoryOptimized"
    compute_optimized = "ComputeOptimized"

class DatasetCompressionLevel(str, Enum):
    """All available compression levels.
    """

    optimal = "Optimal"
    fastest = "Fastest"

class DelimitedTextCompressionCodec(str, Enum):

    bzip2 = "bzip2"
    gzip = "gzip"
    deflate = "deflate"
    zip_deflate = "zipDeflate"
    snappy = "snappy"
    lz4 = "lz4"

class DependencyCondition(str, Enum):

    succeeded = "Succeeded"
    failed = "Failed"
    skipped = "Skipped"
    completed = "Completed"

class DynamicsAuthenticationType(str, Enum):
    """The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd'
    for on-premises with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in
    online scenario. Type: string (or Expression with resultType string).
    """

    office365 = "Office365"
    ifd = "Ifd"
    aad_service_principal = "AADServicePrincipal"

class DynamicsDeploymentType(str, Enum):
    """The deployment type of the Dynamics instance. 'Online' for Dynamics Online and
    'OnPremisesWithIfd' for Dynamics on-premises with Ifd. Type: string (or Expression with
    resultType string).
    """

    online = "Online"
    on_premises_with_ifd = "OnPremisesWithIfd"

class DynamicsServicePrincipalCredentialType(str, Enum):
    """The service principal credential type to use in Server-To-Server authentication.
    'ServicePrincipalKey' for key/secret, 'ServicePrincipalCert' for certificate. Type: string (or
    Expression with resultType string).
    """

    service_principal_key = "ServicePrincipalKey"
    service_principal_cert = "ServicePrincipalCert"

class EventSubscriptionStatus(str, Enum):
    """Event Subscription Status.
    """

    enabled = "Enabled"
    provisioning = "Provisioning"
    deprovisioning = "Deprovisioning"
    disabled = "Disabled"
    unknown = "Unknown"

class FtpAuthenticationType(str, Enum):
    """The authentication type to be used to connect to the FTP server.
    """

    basic = "Basic"
    anonymous = "Anonymous"

class GoogleAdWordsAuthenticationType(str, Enum):
    """The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only
    be used on self-hosted IR.
    """

    service_authentication = "ServiceAuthentication"
    user_authentication = "UserAuthentication"

class GoogleBigQueryAuthenticationType(str, Enum):
    """The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only
    be used on self-hosted IR.
    """

    service_authentication = "ServiceAuthentication"
    user_authentication = "UserAuthentication"

class HBaseAuthenticationType(str, Enum):
    """The authentication mechanism to use to connect to the HBase server.
    """

    anonymous = "Anonymous"
    basic = "Basic"

class HdiNodeTypes(str, Enum):
    """The node types on which the script action should be executed.
    """

    headnode = "Headnode"
    workernode = "Workernode"
    zookeeper = "Zookeeper"

class HDInsightActivityDebugInfoOption(str, Enum):
    """The HDInsightActivityDebugInfoOption settings to use.
    """

    none = "None"
    always = "Always"
    failure = "Failure"

class HiveAuthenticationType(str, Enum):
    """The authentication method used to access the Hive server.
    """

    anonymous = "Anonymous"
    username = "Username"
    username_and_password = "UsernameAndPassword"
    windows_azure_hd_insight_service = "WindowsAzureHDInsightService"

class HiveServerType(str, Enum):
    """The type of Hive server.
    """

    hive_server1 = "HiveServer1"
    hive_server2 = "HiveServer2"
    hive_thrift_server = "HiveThriftServer"

class HiveThriftTransportProtocol(str, Enum):
    """The transport protocol to use in the Thrift layer.
    """

    binary = "Binary"
    sasl = "SASL"
    http = "HTTP "

class HttpAuthenticationType(str, Enum):
    """The authentication type to be used to connect to the HTTP server.
    """

    basic = "Basic"
    anonymous = "Anonymous"
    digest = "Digest"
    windows = "Windows"
    client_certificate = "ClientCertificate"

class ImpalaAuthenticationType(str, Enum):
    """The authentication type to use.
    """

    anonymous = "Anonymous"
    sasl_username = "SASLUsername"
    username_and_password = "UsernameAndPassword"

class MongoDbAuthenticationType(str, Enum):
    """The authentication type to be used to connect to the MongoDB database.
    """

    basic = "Basic"
    anonymous = "Anonymous"

class ODataAadServicePrincipalCredentialType(str, Enum):
    """Specify the credential type (key or cert) is used for service principal.
    """

    service_principal_key = "ServicePrincipalKey"
    service_principal_cert = "ServicePrincipalCert"

class ODataAuthenticationType(str, Enum):
    """Type of authentication used to connect to the OData service.
    """

    basic = "Basic"
    anonymous = "Anonymous"
    windows = "Windows"
    aad_service_principal = "AadServicePrincipal"
    managed_service_identity = "ManagedServiceIdentity"

class OrcCompressionCodec(str, Enum):

    none = "none"
    zlib = "zlib"
    snappy = "snappy"

class ParameterType(str, Enum):
    """Parameter type.
    """

    object = "Object"
    string = "String"
    int = "Int"
    float = "Float"
    bool = "Bool"
    array = "Array"
    secure_string = "SecureString"

class ParquetCompressionCodec(str, Enum):

    none = "none"
    gzip = "gzip"
    snappy = "snappy"
    lzo = "lzo"

class PhoenixAuthenticationType(str, Enum):
    """The authentication mechanism used to connect to the Phoenix server.
    """

    anonymous = "Anonymous"
    username_and_password = "UsernameAndPassword"
    windows_azure_hd_insight_service = "WindowsAzureHDInsightService"

class PluginCurrentState(str, Enum):

    preparation = "Preparation"
    resource_acquisition = "ResourceAcquisition"
    queued = "Queued"
    submission = "Submission"
    monitoring = "Monitoring"
    cleanup = "Cleanup"
    ended = "Ended"

class PrestoAuthenticationType(str, Enum):
    """The authentication mechanism used to connect to the Presto server.
    """

    anonymous = "Anonymous"
    ldap = "LDAP"

class RestServiceAuthenticationType(str, Enum):
    """Type of authentication used to connect to the REST service.
    """

    anonymous = "Anonymous"
    basic = "Basic"
    aad_service_principal = "AadServicePrincipal"
    managed_service_identity = "ManagedServiceIdentity"

class RunQueryFilterOperand(str, Enum):
    """Parameter name to be used for filter. The allowed operands to query pipeline runs are
    PipelineName, RunStart, RunEnd and Status; to query activity runs are ActivityName,
    ActivityRunStart, ActivityRunEnd, ActivityType and Status, and to query trigger runs are
    TriggerName, TriggerRunTimestamp and Status.
    """

    pipeline_name = "PipelineName"
    status = "Status"
    run_start = "RunStart"
    run_end = "RunEnd"
    activity_name = "ActivityName"
    activity_run_start = "ActivityRunStart"
    activity_run_end = "ActivityRunEnd"
    activity_type = "ActivityType"
    trigger_name = "TriggerName"
    trigger_run_timestamp = "TriggerRunTimestamp"
    run_group_id = "RunGroupId"
    latest_only = "LatestOnly"

class RunQueryFilterOperator(str, Enum):
    """Operator to be used for filter.
    """

    equals = "Equals"
    not_equals = "NotEquals"
    in_enum = "In"
    not_in = "NotIn"

class RunQueryOrder(str, Enum):
    """Sorting order of the parameter.
    """

    asc = "ASC"
    desc = "DESC"

class RunQueryOrderByField(str, Enum):
    """Parameter name to be used for order by. The allowed parameters to order by for pipeline runs
    are PipelineName, RunStart, RunEnd and Status; for activity runs are ActivityName,
    ActivityRunStart, ActivityRunEnd and Status; for trigger runs are TriggerName,
    TriggerRunTimestamp and Status.
    """

    run_start = "RunStart"
    run_end = "RunEnd"
    pipeline_name = "PipelineName"
    status = "Status"
    activity_name = "ActivityName"
    activity_run_start = "ActivityRunStart"
    activity_run_end = "ActivityRunEnd"
    trigger_name = "TriggerName"
    trigger_run_timestamp = "TriggerRunTimestamp"

class SapHanaAuthenticationType(str, Enum):
    """The authentication type to be used to connect to the SAP HANA server.
    """

    basic = "Basic"
    windows = "Windows"

class SchedulerCurrentState(str, Enum):

    queued = "Queued"
    scheduled = "Scheduled"
    ended = "Ended"

class ServiceNowAuthenticationType(str, Enum):
    """The authentication type to use.
    """

    basic = "Basic"
    o_auth2 = "OAuth2"

class SftpAuthenticationType(str, Enum):
    """The authentication type to be used to connect to the FTP server.
    """

    basic = "Basic"
    ssh_public_key = "SshPublicKey"

class SparkAuthenticationType(str, Enum):
    """The authentication method used to access the Spark server.
    """

    anonymous = "Anonymous"
    username = "Username"
    username_and_password = "UsernameAndPassword"
    windows_azure_hd_insight_service = "WindowsAzureHDInsightService"

class SparkBatchJobResultType(str, Enum):
    """The Spark batch job result.
    """

    uncertain = "Uncertain"
    succeeded = "Succeeded"
    failed = "Failed"
    cancelled = "Cancelled"

class SparkErrorSource(str, Enum):

    system = "System"
    user = "User"
    unknown = "Unknown"
    dependency = "Dependency"

class SparkJobType(str, Enum):
    """The job type.
    """

    spark_batch = "SparkBatch"
    spark_session = "SparkSession"

class SparkServerType(str, Enum):
    """The type of Spark server.
    """

    shark_server = "SharkServer"
    shark_server2 = "SharkServer2"
    spark_thrift_server = "SparkThriftServer"

class SparkThriftTransportProtocol(str, Enum):
    """The transport protocol to use in the Thrift layer.
    """

    binary = "Binary"
    sasl = "SASL"
    http = "HTTP "

class SqlConnectionType(str, Enum):
    """The type of the connection.
    """

    sql_on_demand = "SqlOnDemand"
    sql_pool = "SqlPool"

class SsisPackageLocationType(str, Enum):
    """The type of SSIS package location.
    """

    ssisdb = "SSISDB"
    file = "File"
    inline_package = "InlinePackage"

class StoredProcedureParameterType(str, Enum):
    """Stored procedure parameter type.
    """

    string = "String"
    int = "Int"
    int64 = "Int64"
    decimal = "Decimal"
    guid = "Guid"
    boolean = "Boolean"
    date = "Date"

class SybaseAuthenticationType(str, Enum):
    """AuthenticationType to be used for connection.
    """

    basic = "Basic"
    windows = "Windows"

class TeradataAuthenticationType(str, Enum):
    """AuthenticationType to be used for connection.
    """

    basic = "Basic"
    windows = "Windows"

class TriggerRunStatus(str, Enum):
    """Trigger run status.
    """

    succeeded = "Succeeded"
    failed = "Failed"
    inprogress = "Inprogress"

class TriggerRuntimeState(str, Enum):
    """Enumerates possible state of Triggers.
    """

    started = "Started"
    stopped = "Stopped"
    disabled = "Disabled"

class VariableType(str, Enum):
    """Variable type.
    """

    string = "String"
    bool = "Bool"
    boolean = "Boolean"
    array = "Array"

class WebActivityMethod(str, Enum):
    """The list of HTTP methods supported by a WebActivity.
    """

    get = "GET"
    post = "POST"
    put = "PUT"
    delete = "DELETE"

class WebAuthenticationType(str, Enum):
    """Type of authentication used to connect to the web table source.
    """

    basic = "Basic"
    anonymous = "Anonymous"
    client_certificate = "ClientCertificate"
