#!/usr/bin/env python
# @generated by pegen from python-in-rpython.gram

# Special RPython version

import sys


from pypy.interpreter.pyparser.baserpypeg import *

# Keywords and soft keywords are listed at the end of the parser definition.
class PythonParser(Parser):

    def start(self): # type Optional[Any]
        # start: file
        mark = self._index
        if self._verbose: log_start(self, 'start')
        file = self.file()
        if file:
            return file
        self._index = mark
        return None

    def file(self): # type Optional[ast . Module]
        # file: statements? $
        mark = self._index
        if self._verbose: log_start(self, 'file')
        a = self.statements()
        _endmarker = self.expect_type(0)
        if _endmarker:
            return ast . Module ( body = a , type_ignores = self . make_type_ignores ( ) )
        self._index = mark
        return None

    def interactive(self): # type Optional[ast . Interactive]
        # interactive: statement_newline
        mark = self._index
        if self._verbose: log_start(self, 'interactive')
        a = self.statement_newline()
        if a:
            return ast . Interactive ( body = a )
        self._index = mark
        return None

    def eval(self): # type Optional[ast . Expression]
        # eval: expressions NEWLINE* $
        mark = self._index
        if self._verbose: log_start(self, 'eval')
        a = self.expressions()
        if a:
            _loop0_1 = self._loop0_1()
            _endmarker = self.expect_type(0)
            if _endmarker:
                return ast . Expression ( body = a )
        self._index = mark
        return None

    def func_type(self): # type Optional[ast . FunctionType]
        # func_type: '(' type_expressions? ')' '->' expression NEWLINE* $
        mark = self._index
        if self._verbose: log_start(self, 'func_type')
        literal = self.expect_type(7)
        if literal:
            a = self.type_expressions()
            literal_1 = self.expect_type(8)
            if literal_1:
                literal_2 = self.expect_type(52)
                if literal_2:
                    b = self.expression()
                    if b:
                        _loop0_2 = self._loop0_2()
                        _endmarker = self.expect_type(0)
                        if _endmarker:
                            return ast . FunctionType ( argtypes = a , returns = b )
        self._index = mark
        return None

    def fstring(self): # type Optional[ast . Expr]
        # fstring: star_expressions
        mark = self._index
        if self._verbose: log_start(self, 'fstring')
        star_expressions = self.star_expressions()
        if star_expressions:
            return star_expressions
        self._index = mark
        return None

    def type_expressions(self): # type Optional[list]
        # type_expressions: ','.expression+ ',' '*' expression ',' '**' expression | ','.expression+ ',' '*' expression | ','.expression+ ',' '**' expression | '*' expression ',' '**' expression | '*' expression | '**' expression | ','.expression+
        mark = self._index
        if self._verbose: log_start(self, 'type_expressions')
        a = self._gather_3()
        if a:
            literal = self.expect_type(12)
            if literal:
                literal_1 = self.expect_type(16)
                if literal_1:
                    b = self.expression()
                    if b:
                        literal_2 = self.expect_type(12)
                        if literal_2:
                            literal_3 = self.expect_type(36)
                            if literal_3:
                                c = self.expression()
                                if c:
                                    return a + [b , c]
        self._index = mark
        a = self._gather_5()
        if a:
            literal = self.expect_type(12)
            if literal:
                literal_1 = self.expect_type(16)
                if literal_1:
                    b = self.expression()
                    if b:
                        return a + [b]
        self._index = mark
        a = self._gather_7()
        if a:
            literal = self.expect_type(12)
            if literal:
                literal_1 = self.expect_type(36)
                if literal_1:
                    b = self.expression()
                    if b:
                        return a + [b]
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            a = self.expression()
            if a:
                literal_1 = self.expect_type(12)
                if literal_1:
                    literal_2 = self.expect_type(36)
                    if literal_2:
                        b = self.expression()
                        if b:
                            return [a , b]
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            a = self.expression()
            if a:
                return [a]
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            a = self.expression()
            if a:
                return [a]
        self._index = mark
        a = self._gather_9()
        if a:
            return a
        self._index = mark
        return None

    def statements(self): # type Optional[list]
        # statements: statement+
        mark = self._index
        if self._verbose: log_start(self, 'statements')
        a = self._loop1_11()
        if a:
            return [x for l in a for x in l]
        self._index = mark
        return None

    def statement(self): # type Optional[list]
        # statement: compound_stmt | simple_stmts
        mark = self._index
        if self._verbose: log_start(self, 'statement')
        a = self.compound_stmt()
        if a:
            return [a]
        self._index = mark
        a = self.simple_stmts()
        if a:
            return a
        self._index = mark
        return None

    def statement_newline(self): # type Optional[list]
        # statement_newline: compound_stmt NEWLINE? $ | simple_stmts $ | NEWLINE $ | $
        mark = self._index
        if self._verbose: log_start(self, 'statement_newline')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.compound_stmt()
        if a:
            opt = self.expect_type(4)
            _endmarker = self.expect_type(0)
            if _endmarker:
                return [a]
        self._index = mark
        a = self.simple_stmts()
        if a:
            _endmarker = self.expect_type(0)
            if _endmarker:
                return a
        self._index = mark
        _newline = self.expect_type(4)
        if _newline:
            _endmarker = self.expect_type(0)
            if _endmarker:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return [ast . Pass ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._index = mark
        _endmarker = self.expect_type(0)
        if _endmarker:
            return None
        self._index = mark
        return None

    def simple_stmts(self): # type Optional[list]
        # simple_stmts: simple_stmt !';' NEWLINE | ';'.simple_stmt+ ';'? NEWLINE
        mark = self._index
        if self._verbose: log_start(self, 'simple_stmts')
        a = self.simple_stmt()
        if a:
            if self.negative_lookahead(PythonParser.expect_type, 13):
                _newline = self.expect_type(4)
                if _newline:
                    return [a]
        self._index = mark
        a = self._gather_12()
        if a:
            opt = self.expect_type(13)
            _newline = self.expect_type(4)
            if _newline:
                return a
        self._index = mark
        return None

    @memoize
    def simple_stmt(self): # type Optional[Any]
        # simple_stmt: assignment | star_expressions | &'return' return_stmt | &('import' | 'from') import_stmt | &'raise' raise_stmt | 'pass' | &'del' del_stmt | &'yield' yield_stmt | &'assert' assert_stmt | 'break' | 'continue' | &'global' global_stmt | &'nonlocal' nonlocal_stmt
        mark = self._index
        if self._verbose: log_start(self, 'simple_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        assignment = self.assignment()
        if assignment:
            return assignment
        self._index = mark
        e = self.star_expressions()
        if e:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Expr ( value = e , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 499):
            return_stmt = self.return_stmt()
            if return_stmt:
                return return_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser._tmp_14, ):
            import_stmt = self.import_stmt()
            if import_stmt:
                return import_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 500):
            raise_stmt = self.raise_stmt()
            if raise_stmt:
                return raise_stmt
        self._index = mark
        literal = self.expect_type(501)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Pass ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 502):
            del_stmt = self.del_stmt()
            if del_stmt:
                return del_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 503):
            yield_stmt = self.yield_stmt()
            if yield_stmt:
                return yield_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 504):
            assert_stmt = self.assert_stmt()
            if assert_stmt:
                return assert_stmt
        self._index = mark
        literal = self.expect_type(505)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Break ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(506)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Continue ( lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 507):
            global_stmt = self.global_stmt()
            if global_stmt:
                return global_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 508):
            nonlocal_stmt = self.nonlocal_stmt()
            if nonlocal_stmt:
                return nonlocal_stmt
        self._index = mark
        return None

    def compound_stmt(self): # type Optional[Any]
        # compound_stmt: &('def' | '@' | ASYNC) function_def | &'if' if_stmt | &('class' | '@') class_def | &('with' | ASYNC) with_stmt | &('for' | ASYNC) for_stmt | &'try' try_stmt | &'while' while_stmt | match_stmt
        mark = self._index
        if self._verbose: log_start(self, 'compound_stmt')
        if self.positive_lookahead(PythonParser._tmp_15, ):
            function_def = self.function_def()
            if function_def:
                return function_def
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 509):
            if_stmt = self.if_stmt()
            if if_stmt:
                return if_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser._tmp_16, ):
            class_def = self.class_def()
            if class_def:
                return class_def
        self._index = mark
        if self.positive_lookahead(PythonParser._tmp_17, ):
            with_stmt = self.with_stmt()
            if with_stmt:
                return with_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser._tmp_18, ):
            for_stmt = self.for_stmt()
            if for_stmt:
                return for_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 510):
            try_stmt = self.try_stmt()
            if try_stmt:
                return try_stmt
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 511):
            while_stmt = self.while_stmt()
            if while_stmt:
                return while_stmt
        self._index = mark
        match_stmt = self.match_stmt()
        if match_stmt:
            return match_stmt
        self._index = mark
        return None

    def assignment(self): # type Optional[Any]
        # assignment: NAME ':' expression ['=' annotated_rhs] | ('(' single_target ')' | single_subscript_attribute_target) ':' expression ['=' annotated_rhs] | ((star_targets '='))+ (yield_expr | star_expressions) !'=' TYPE_COMMENT? | single_target augassign ~ (yield_expr | star_expressions) | invalid_assignment
        mark = self._index
        if self._verbose: log_start(self, 'assignment')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.name()
        if a:
            literal = self.expect_type(11)
            if literal:
                b = self.expression()
                if b:
                    c = self._tmp_19()
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return self . check_version ( ( 3 , 6 ) , "Variable annotation syntax is" , ast . AnnAssign ( target = self . set_expr_context ( a , Store ) , annotation = b , value = c , simple = 1 , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._index = mark
        a = self._tmp_20()
        if a:
            literal = self.expect_type(11)
            if literal:
                b = self.expression()
                if b:
                    c = self._tmp_21()
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return self . check_version ( ( 3 , 6 ) , "Variable annotation syntax is" , ast . AnnAssign ( target = a , annotation = b , value = c , simple = 0 , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._index = mark
        a = self._loop1_22()
        if a:
            b = self._tmp_23()
            if b:
                if self.negative_lookahead(PythonParser.expect_type, 22):
                    tc = self.type_comment()
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Assign ( targets = a , value = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        cut = False
        a = self.single_target()
        if a:
            b = self.augassign()
            if b:
                cut = True
                c = self._tmp_24()
                if c:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . AugAssign ( target = a , op = b [0] , value = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if cut: return None
        if self.call_invalid_rules:
            invalid_assignment = self.invalid_assignment()
            if invalid_assignment:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def annotated_rhs(self): # type Optional[Any]
        # annotated_rhs: yield_expr | star_expressions
        mark = self._index
        if self._verbose: log_start(self, 'annotated_rhs')
        yield_expr = self.yield_expr()
        if yield_expr:
            return yield_expr
        self._index = mark
        star_expressions = self.star_expressions()
        if star_expressions:
            return star_expressions
        self._index = mark
        return None

    def augassign(self): # type Optional[Any]
        # augassign: '+=' | '-=' | '*=' | '@=' | '/=' | '%=' | '&=' | '|=' | '^=' | '<<=' | '>>=' | '**=' | '//='
        mark = self._index
        if self._verbose: log_start(self, 'augassign')
        literal = self.expect_type(37)
        if literal:
            return [ast . Add]
        self._index = mark
        literal = self.expect_type(38)
        if literal:
            return [ast . Sub]
        self._index = mark
        literal = self.expect_type(39)
        if literal:
            return [ast . Mult]
        self._index = mark
        literal = self.expect_type(51)
        if literal:
            return self . check_version ( ( 3 , 5 ) , "The '@' operator is" , [ast . MatMult] )
        self._index = mark
        literal = self.expect_type(40)
        if literal:
            return [ast . Div]
        self._index = mark
        literal = self.expect_type(41)
        if literal:
            return [ast . Mod]
        self._index = mark
        literal = self.expect_type(42)
        if literal:
            return [ast . BitAnd]
        self._index = mark
        literal = self.expect_type(43)
        if literal:
            return [ast . BitOr]
        self._index = mark
        literal = self.expect_type(44)
        if literal:
            return [ast . BitXor]
        self._index = mark
        literal = self.expect_type(45)
        if literal:
            return [ast . LShift]
        self._index = mark
        literal = self.expect_type(46)
        if literal:
            return [ast . RShift]
        self._index = mark
        literal = self.expect_type(47)
        if literal:
            return [ast . Pow]
        self._index = mark
        literal = self.expect_type(49)
        if literal:
            return [ast . FloorDiv]
        self._index = mark
        return None

    def return_stmt(self): # type Optional[ast . Return]
        # return_stmt: 'return' star_expressions?
        mark = self._index
        if self._verbose: log_start(self, 'return_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(499)
        if literal:
            a = self.star_expressions()
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Return ( value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def raise_stmt(self): # type Optional[ast . Raise]
        # raise_stmt: 'raise' expression ['from' expression] | 'raise'
        mark = self._index
        if self._verbose: log_start(self, 'raise_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(500)
        if literal:
            a = self.expression()
            if a:
                b = self._tmp_25()
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Raise ( exc = a , cause = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(500)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Raise ( exc = None , cause = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def global_stmt(self): # type Optional[ast . Global]
        # global_stmt: 'global' ','.NAME+
        mark = self._index
        if self._verbose: log_start(self, 'global_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(507)
        if literal:
            a = self._gather_26()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Global ( names = [n . id for n in a] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def nonlocal_stmt(self): # type Optional[ast . Nonlocal]
        # nonlocal_stmt: 'nonlocal' ','.NAME+
        mark = self._index
        if self._verbose: log_start(self, 'nonlocal_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(508)
        if literal:
            a = self._gather_28()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Nonlocal ( names = [n . id for n in a] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def del_stmt(self): # type Optional[ast . Delete]
        # del_stmt: 'del' del_targets &(';' | NEWLINE) | invalid_del_stmt
        mark = self._index
        if self._verbose: log_start(self, 'del_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(502)
        if literal:
            a = self.del_targets()
            if a:
                if self.positive_lookahead(PythonParser._tmp_30, ):
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Delete ( targets = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_del_stmt = self.invalid_del_stmt()
            if invalid_del_stmt:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def yield_stmt(self): # type Optional[ast . Expr]
        # yield_stmt: yield_expr
        mark = self._index
        if self._verbose: log_start(self, 'yield_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        y = self.yield_expr()
        if y:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Expr ( value = y , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def assert_stmt(self): # type Optional[ast . Assert]
        # assert_stmt: 'assert' expression [',' expression]
        mark = self._index
        if self._verbose: log_start(self, 'assert_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(504)
        if literal:
            a = self.expression()
            if a:
                b = self._tmp_31()
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Assert ( test = a , msg = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def import_stmt(self): # type Optional[ast . Import]
        # import_stmt: import_name | import_from
        mark = self._index
        if self._verbose: log_start(self, 'import_stmt')
        import_name = self.import_name()
        if import_name:
            return import_name
        self._index = mark
        import_from = self.import_from()
        if import_from:
            return import_from
        self._index = mark
        return None

    def import_name(self): # type Optional[ast . Import]
        # import_name: 'import' dotted_as_names
        mark = self._index
        if self._verbose: log_start(self, 'import_name')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(512)
        if literal:
            a = self.dotted_as_names()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Import ( names = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def import_from(self): # type Optional[ast . ImportFrom]
        # import_from: 'from' (('.' | '...'))* dotted_name 'import' import_from_targets | 'from' (('.' | '...'))+ 'import' import_from_targets
        mark = self._index
        if self._verbose: log_start(self, 'import_from')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(513)
        if literal:
            a = self._loop0_32()
            b = self.dotted_name()
            if b:
                literal_1 = self.expect_type(512)
                if literal_1:
                    c = self.import_from_targets()
                    if c:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . ImportFrom ( module = b , names = c , level = self . extract_import_level ( a ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(513)
        if literal:
            a = self._loop1_33()
            if a:
                literal_1 = self.expect_type(512)
                if literal_1:
                    b = self.import_from_targets()
                    if b:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . ImportFrom ( module = None , names = b , level = self . extract_import_level ( a ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def import_from_targets(self): # type Optional[List [ast . alias]]
        # import_from_targets: '(' import_from_as_names ','? ')' | import_from_as_names !',' | '*' | invalid_import_from_targets
        mark = self._index
        if self._verbose: log_start(self, 'import_from_targets')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(7)
        if literal:
            a = self.import_from_as_names()
            if a:
                opt = self.expect_type(12)
                literal_1 = self.expect_type(8)
                if literal_1:
                    return a
        self._index = mark
        import_from_as_names = self.import_from_as_names()
        if import_from_as_names:
            if self.negative_lookahead(PythonParser.expect_type, 12):
                return import_from_as_names
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return [ast . alias ( name = "*" , asname = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._index = mark
        if self.call_invalid_rules:
            invalid_import_from_targets = self.invalid_import_from_targets()
            if invalid_import_from_targets:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def import_from_as_names(self): # type Optional[List [ast . alias]]
        # import_from_as_names: ','.import_from_as_name+
        mark = self._index
        if self._verbose: log_start(self, 'import_from_as_names')
        a = self._gather_34()
        if a:
            return a
        self._index = mark
        return None

    def import_from_as_name(self): # type Optional[ast . alias]
        # import_from_as_name: NAME ['as' NAME]
        mark = self._index
        if self._verbose: log_start(self, 'import_from_as_name')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.name()
        if a:
            b = self._tmp_36()
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . alias ( name = self . extract_id ( a ) , asname = self . extract_id ( b ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def dotted_as_names(self): # type Optional[List [ast . alias]]
        # dotted_as_names: ','.dotted_as_name+
        mark = self._index
        if self._verbose: log_start(self, 'dotted_as_names')
        a = self._gather_37()
        if a:
            return a
        self._index = mark
        return None

    def dotted_as_name(self): # type Optional[ast . alias]
        # dotted_as_name: dotted_name ['as' NAME]
        mark = self._index
        if self._verbose: log_start(self, 'dotted_as_name')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.dotted_name()
        if a:
            b = self._tmp_39()
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . alias ( name = a , asname = self . extract_id ( b ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    @memoize_left_rec
    def dotted_name(self): # type Optional[str]
        # dotted_name: NAME !'.' | dotted_name '.' NAME | NAME
        mark = self._index
        if self._verbose: log_start(self, 'dotted_name')
        a = self.name()
        if a:
            if self.negative_lookahead(PythonParser.expect_type, 23):
                return self . extract_id ( a )
        self._index = mark
        a = self.dotted_name()
        if a:
            literal = self.expect_type(23)
            if literal:
                b = self.name()
                if b:
                    return a + "." + b . id
        self._index = mark
        a = self.name()
        if a:
            return a . id
        self._index = mark
        return None

    @memoize
    def block(self): # type Optional[list]
        # block: NEWLINE INDENT statements DEDENT | simple_stmts | invalid_block
        mark = self._index
        if self._verbose: log_start(self, 'block')
        _newline = self.expect_type(4)
        if _newline:
            _indent = self.expect_type(5)
            if _indent:
                a = self.statements()
                if a:
                    _dedent = self.expect_type(6)
                    if _dedent:
                        return a
        self._index = mark
        simple_stmts = self.simple_stmts()
        if simple_stmts:
            return simple_stmts
        self._index = mark
        if self.call_invalid_rules:
            invalid_block = self.invalid_block()
            if invalid_block:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def decorators(self): # type Optional[Any]
        # decorators: decorator+
        mark = self._index
        if self._verbose: log_start(self, 'decorators')
        _loop1_40 = self._loop1_40()
        if _loop1_40:
            return _loop1_40
        self._index = mark
        return None

    def decorator(self): # type Optional[Any]
        # decorator: ('@' dec_maybe_call NEWLINE) | ('@' named_expression NEWLINE)
        mark = self._index
        if self._verbose: log_start(self, 'decorator')
        a = self._tmp_41()
        if a:
            return a
        self._index = mark
        a = self._tmp_42()
        if a:
            return self . check_version ( ( 3 , 9 ) , "Generic decorator are" , a )
        self._index = mark
        return None

    def dec_maybe_call(self): # type Optional[Any]
        # dec_maybe_call: dec_primary '(' arguments? ')' | dec_primary
        mark = self._index
        if self._verbose: log_start(self, 'dec_maybe_call')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        dn = self.dec_primary()
        if dn:
            literal = self.expect_type(7)
            if literal:
                z = self.arguments()
                literal_1 = self.expect_type(8)
                if literal_1:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Call ( func = dn , args = z . args if z and z . args else None , keywords = z . keywords if z and z . keywords else None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        dec_primary = self.dec_primary()
        if dec_primary:
            return dec_primary
        self._index = mark
        return None

    @memoize_left_rec
    def dec_primary(self): # type Optional[Any]
        # dec_primary: dec_primary '.' NAME | NAME
        mark = self._index
        if self._verbose: log_start(self, 'dec_primary')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.dec_primary()
        if a:
            literal = self.expect_type(23)
            if literal:
                b = self.name()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Attribute ( value = a , attr = b . id , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.name()
        if a:
            return a
        self._index = mark
        return None

    def class_def(self): # type Optional[ast . ClassDef]
        # class_def: decorators class_def_raw | class_def_raw
        mark = self._index
        if self._verbose: log_start(self, 'class_def')
        a = self.decorators()
        if a:
            b = self.class_def_raw()
            if b:
                return self . set_decorators ( b , a )
        self._index = mark
        class_def_raw = self.class_def_raw()
        if class_def_raw:
            return class_def_raw
        self._index = mark
        return None

    def class_def_raw(self): # type Optional[ast . ClassDef]
        # class_def_raw: invalid_class_def_raw | 'class' NAME ['(' arguments? ')'] ':' block
        mark = self._index
        if self._verbose: log_start(self, 'class_def_raw')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_class_def_raw = self.invalid_class_def_raw()
            if invalid_class_def_raw:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(514)
        if literal:
            a = self.name()
            if a:
                b = self._tmp_43()
                literal_1 = self.expect_type(11)
                if literal_1:
                    c = self.block()
                    if c:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . ClassDef ( self . extract_id ( a ) , bases = b . args if b else None , keywords = b . keywords if b else None , body = c , decorator_list = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        return None

    def function_def(self): # type Optional[Union [ast . FunctionDef , ast . AsyncFunctionDef]]
        # function_def: decorators function_def_raw | function_def_raw
        mark = self._index
        if self._verbose: log_start(self, 'function_def')
        d = self.decorators()
        if d:
            f = self.function_def_raw()
            if f:
                return self . set_decorators ( f , d )
        self._index = mark
        f = self.function_def_raw()
        if f:
            return self . set_decorators ( f , None )
        self._index = mark
        return None

    def function_def_raw(self): # type Optional[Union [ast . FunctionDef , ast . AsyncFunctionDef]]
        # function_def_raw: invalid_def_raw | 'def' NAME &&'(' params? ')' ['->' expression] &&':' func_type_comment? block | ASYNC 'def' NAME &&'(' params? ')' ['->' expression] &&':' func_type_comment? block
        mark = self._index
        if self._verbose: log_start(self, 'function_def_raw')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_def_raw = self.invalid_def_raw()
            if invalid_def_raw:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(515)
        if literal:
            n = self.name()
            if n:
                literal_1 = self.expect_forced(self.expect_type(7), "'('")
                if literal_1:
                    params = self.params()
                    literal_2 = self.expect_type(8)
                    if literal_2:
                        a = self._tmp_44()
                        literal_3 = self.expect_forced(self.expect_type(11), "':'")
                        if literal_3:
                            tc = self.func_type_comment()
                            b = self.block()
                            if b:
                                tok = self.get_last_non_whitespace_token()
                                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                return ast . FunctionDef ( name = self . extract_id ( n ) , args = params or self . make_arguments ( None , None , None , [] , None ) , returns = a , body = b , decorator_list = None , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        _async = self.expect_type(58)
        if _async:
            literal = self.expect_type(515)
            if literal:
                n = self.name()
                if n:
                    literal_1 = self.expect_forced(self.expect_type(7), "'('")
                    if literal_1:
                        params = self.params()
                        literal_2 = self.expect_type(8)
                        if literal_2:
                            a = self._tmp_45()
                            literal_3 = self.expect_forced(self.expect_type(11), "':'")
                            if literal_3:
                                tc = self.func_type_comment()
                                b = self.block()
                                if b:
                                    tok = self.get_last_non_whitespace_token()
                                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                    return self . check_version ( ( 3 , 5 ) , "Async functions are" , ast . AsyncFunctionDef ( name = self . extract_id ( n ) , args = params or self . make_arguments ( None , None , None , [] , None ) , returns = a , body = b , decorator_list = None , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._index = mark
        return None

    def func_type_comment(self): # type Optional[Any]
        # func_type_comment: NEWLINE TYPE_COMMENT &(NEWLINE INDENT) | invalid_double_type_comments | TYPE_COMMENT
        mark = self._index
        if self._verbose: log_start(self, 'func_type_comment')
        _newline = self.expect_type(4)
        if _newline:
            t = self.type_comment()
            if t:
                if self.positive_lookahead(PythonParser._tmp_46, ):
                    return t
        self._index = mark
        if self.call_invalid_rules:
            invalid_double_type_comments = self.invalid_double_type_comments()
            if invalid_double_type_comments:
                assert 0, 'unreachable'
            self._index = mark
        type_comment = self.type_comment()
        if type_comment:
            return type_comment
        self._index = mark
        return None

    def params(self): # type Optional[Any]
        # params: invalid_parameters | parameters
        mark = self._index
        if self._verbose: log_start(self, 'params')
        if self.call_invalid_rules:
            invalid_parameters = self.invalid_parameters()
            if invalid_parameters:
                assert 0, 'unreachable'
            self._index = mark
        parameters = self.parameters()
        if parameters:
            return parameters
        self._index = mark
        return None

    def parameters(self): # type Optional[ast . arguments]
        # parameters: slash_no_default param_no_default* param_with_default* star_etc? | slash_with_default param_with_default* star_etc? | param_no_default+ param_with_default* star_etc? | param_with_default+ star_etc? | star_etc
        mark = self._index
        if self._verbose: log_start(self, 'parameters')
        a = self.slash_no_default()
        if a:
            b = self._loop0_47()
            c = self._loop0_48()
            d = self.star_etc()
            return self . make_arguments ( a . plain_names , None , b , c , d )
        self._index = mark
        a = self.slash_with_default()
        if a:
            b = self._loop0_49()
            c = self.star_etc()
            return self . make_arguments ( None , a , None , b , c )
        self._index = mark
        a = self._loop1_50()
        if a:
            b = self._loop0_51()
            c = self.star_etc()
            return self . make_arguments ( None , None , a , b , c )
        self._index = mark
        a = self._loop1_52()
        if a:
            b = self.star_etc()
            return self . make_arguments ( None , None , None , a , b )
        self._index = mark
        a = self.star_etc()
        if a:
            return self . make_arguments ( None , None , None , None , a )
        self._index = mark
        return None

    def slash_no_default(self): # type Optional[List [ast . arg]]
        # slash_no_default: param_no_default+ '/' ',' | param_no_default+ '/' &')'
        mark = self._index
        if self._verbose: log_start(self, 'slash_no_default')
        a = self._loop1_53()
        if a:
            literal = self.expect_type(17)
            if literal:
                literal_1 = self.expect_type(12)
                if literal_1:
                    return self . make_slash_with_default ( a , None )
        self._index = mark
        a = self._loop1_54()
        if a:
            literal = self.expect_type(17)
            if literal:
                if self.positive_lookahead(PythonParser.expect_type, 8):
                    return self . make_slash_with_default ( a , None )
        self._index = mark
        return None

    def slash_with_default(self): # type Optional[SlashWithDefault]
        # slash_with_default: param_no_default* param_with_default+ '/' ',' | param_no_default* param_with_default+ '/' &')'
        mark = self._index
        if self._verbose: log_start(self, 'slash_with_default')
        a = self._loop0_55()
        b = self._loop1_56()
        if b:
            literal = self.expect_type(17)
            if literal:
                literal_1 = self.expect_type(12)
                if literal_1:
                    return self . make_slash_with_default ( a , b )
        self._index = mark
        a = self._loop0_57()
        b = self._loop1_58()
        if b:
            literal = self.expect_type(17)
            if literal:
                if self.positive_lookahead(PythonParser.expect_type, 8):
                    return self . make_slash_with_default ( a , b )
        self._index = mark
        return None

    def star_etc(self): # type Optional[StarEtc]
        # star_etc: invalid_star_etc | '*' param_no_default param_maybe_default* kwds? | '*' param_no_default_star_annotation param_maybe_default* kwds? | '*' ',' param_maybe_default+ kwds? | kwds
        mark = self._index
        if self._verbose: log_start(self, 'star_etc')
        if self.call_invalid_rules:
            invalid_star_etc = self.invalid_star_etc()
            if invalid_star_etc:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(16)
        if literal:
            a = self.param_no_default()
            if a:
                b = self._loop0_59()
                c = self.kwds()
                return self . make_star_etc ( a , b , c )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            a = self.param_no_default_star_annotation()
            if a:
                b = self._loop0_60()
                c = self.kwds()
                return self . make_star_etc ( a , b , c )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            literal_1 = self.expect_type(12)
            if literal_1:
                b = self._loop1_61()
                if b:
                    c = self.kwds()
                    return self . make_star_etc ( None , b , c )
        self._index = mark
        a = self.kwds()
        if a:
            return self . make_star_etc ( None , [] , a )
        self._index = mark
        return None

    def kwds(self): # type Optional[arg_ty]
        # kwds: invalid_kwds | '**' param_no_default
        mark = self._index
        if self._verbose: log_start(self, 'kwds')
        if self.call_invalid_rules:
            invalid_kwds = self.invalid_kwds()
            if invalid_kwds:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(36)
        if literal:
            a = self.param_no_default()
            if a:
                return a
        self._index = mark
        return None

    def param_no_default(self): # type Optional[ast . arg]
        # param_no_default: param ',' TYPE_COMMENT? | param TYPE_COMMENT? &')'
        mark = self._index
        if self._verbose: log_start(self, 'param_no_default')
        a = self.param()
        if a:
            literal = self.expect_type(12)
            if literal:
                tc = self.type_comment()
                return self . set_arg_type_comment ( a , tc )
        self._index = mark
        a = self.param()
        if a:
            tc = self.type_comment()
            if self.positive_lookahead(PythonParser.expect_type, 8):
                return self . set_arg_type_comment ( a , tc )
        self._index = mark
        return None

    def param_no_default_star_annotation(self): # type Optional[ast . arg]
        # param_no_default_star_annotation: param_star_annotation ',' TYPE_COMMENT? | param_star_annotation TYPE_COMMENT? &')'
        mark = self._index
        if self._verbose: log_start(self, 'param_no_default_star_annotation')
        a = self.param_star_annotation()
        if a:
            literal = self.expect_type(12)
            if literal:
                tc = self.type_comment()
                return self . set_arg_type_comment ( a , tc )
        self._index = mark
        a = self.param_star_annotation()
        if a:
            tc = self.type_comment()
            if self.positive_lookahead(PythonParser.expect_type, 8):
                return self . set_arg_type_comment ( a , tc )
        self._index = mark
        return None

    def param_with_default(self): # type Optional[NameDefaultPair]
        # param_with_default: param default ',' TYPE_COMMENT? | param default TYPE_COMMENT? &')'
        mark = self._index
        if self._verbose: log_start(self, 'param_with_default')
        a = self.param()
        if a:
            c = self.default()
            if c:
                literal = self.expect_type(12)
                if literal:
                    tc = self.type_comment()
                    return self . name_default_pair ( a , c , tc )
        self._index = mark
        a = self.param()
        if a:
            c = self.default()
            if c:
                tc = self.type_comment()
                if self.positive_lookahead(PythonParser.expect_type, 8):
                    return self . name_default_pair ( a , c , tc )
        self._index = mark
        return None

    def param_maybe_default(self): # type Optional[NameDefaultPair]
        # param_maybe_default: param default? ',' TYPE_COMMENT? | param default? TYPE_COMMENT? &')'
        mark = self._index
        if self._verbose: log_start(self, 'param_maybe_default')
        a = self.param()
        if a:
            c = self.default()
            literal = self.expect_type(12)
            if literal:
                tc = self.type_comment()
                return self . name_default_pair ( a , c , tc )
        self._index = mark
        a = self.param()
        if a:
            c = self.default()
            tc = self.type_comment()
            if self.positive_lookahead(PythonParser.expect_type, 8):
                return self . name_default_pair ( a , c , tc )
        self._index = mark
        return None

    def param(self): # type Optional[ast . arg]
        # param: NAME annotation?
        mark = self._index
        if self._verbose: log_start(self, 'param')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.name()
        if a:
            b = self.annotation()
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . arg ( arg = self . extract_id ( a ) , annotation = b , type_comment = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def param_star_annotation(self): # type Optional[ast . arg]
        # param_star_annotation: NAME star_annotation
        mark = self._index
        if self._verbose: log_start(self, 'param_star_annotation')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.name()
        if a:
            b = self.star_annotation()
            if b:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . arg ( arg = self . extract_id ( a ) , annotation = b , type_comment = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def annotation(self): # type Optional[Any]
        # annotation: ':' expression
        mark = self._index
        if self._verbose: log_start(self, 'annotation')
        literal = self.expect_type(11)
        if literal:
            a = self.expression()
            if a:
                return a
        self._index = mark
        return None

    def star_annotation(self): # type Optional[Any]
        # star_annotation: ':' star_expression
        mark = self._index
        if self._verbose: log_start(self, 'star_annotation')
        literal = self.expect_type(11)
        if literal:
            a = self.star_expression()
            if a:
                return a
        self._index = mark
        return None

    def default(self): # type Optional[Any]
        # default: '=' expression
        mark = self._index
        if self._verbose: log_start(self, 'default')
        literal = self.expect_type(22)
        if literal:
            a = self.expression()
            if a:
                return a
        self._index = mark
        return None

    def if_stmt(self): # type Optional[ast . If]
        # if_stmt: invalid_if_stmt | 'if' named_expression ':' block elif_stmt | 'if' named_expression ':' block else_block?
        mark = self._index
        if self._verbose: log_start(self, 'if_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_if_stmt = self.invalid_if_stmt()
            if invalid_if_stmt:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(509)
        if literal:
            a = self.named_expression()
            if a:
                literal_1 = self.expect_type(11)
                if literal_1:
                    b = self.block()
                    if b:
                        c = self.elif_stmt()
                        if c:
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . If ( test = a , body = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(509)
        if literal:
            a = self.named_expression()
            if a:
                literal_1 = self.expect_type(11)
                if literal_1:
                    b = self.block()
                    if b:
                        c = self.else_block()
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . If ( test = a , body = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def elif_stmt(self): # type Optional[List [ast . If]]
        # elif_stmt: invalid_elif_stmt | 'elif' named_expression ':' block elif_stmt | 'elif' named_expression ':' block else_block?
        mark = self._index
        if self._verbose: log_start(self, 'elif_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_elif_stmt = self.invalid_elif_stmt()
            if invalid_elif_stmt:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(516)
        if literal:
            a = self.named_expression()
            if a:
                literal_1 = self.expect_type(11)
                if literal_1:
                    b = self.block()
                    if b:
                        c = self.elif_stmt()
                        if c:
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return [ast . If ( test = a , body = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._index = mark
        literal = self.expect_type(516)
        if literal:
            a = self.named_expression()
            if a:
                literal_1 = self.expect_type(11)
                if literal_1:
                    b = self.block()
                    if b:
                        c = self.else_block()
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return [ast . If ( test = a , body = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )]
        self._index = mark
        return None

    def else_block(self): # type Optional[list]
        # else_block: invalid_else_stmt | 'else' &&':' block
        mark = self._index
        if self._verbose: log_start(self, 'else_block')
        if self.call_invalid_rules:
            invalid_else_stmt = self.invalid_else_stmt()
            if invalid_else_stmt:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(517)
        if literal:
            literal_1 = self.expect_forced(self.expect_type(11), "':'")
            if literal_1:
                b = self.block()
                if b:
                    return b
        self._index = mark
        return None

    def while_stmt(self): # type Optional[ast . While]
        # while_stmt: invalid_while_stmt | 'while' named_expression ':' block else_block?
        mark = self._index
        if self._verbose: log_start(self, 'while_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_while_stmt = self.invalid_while_stmt()
            if invalid_while_stmt:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(511)
        if literal:
            a = self.named_expression()
            if a:
                literal_1 = self.expect_type(11)
                if literal_1:
                    b = self.block()
                    if b:
                        c = self.else_block()
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . While ( test = a , body = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def for_stmt(self): # type Optional[Union [ast . For , ast . AsyncFor]]
        # for_stmt: invalid_for_stmt | 'for' star_targets 'in' ~ star_expressions ':' TYPE_COMMENT? block else_block? | ASYNC 'for' star_targets 'in' ~ star_expressions ':' TYPE_COMMENT? block else_block? | invalid_for_target
        mark = self._index
        if self._verbose: log_start(self, 'for_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_for_stmt = self.invalid_for_stmt()
            if invalid_for_stmt:
                assert 0, 'unreachable'
            self._index = mark
        cut = False
        literal = self.expect_type(518)
        if literal:
            t = self.star_targets()
            if t:
                literal_1 = self.expect_type(519)
                if literal_1:
                    cut = True
                    ex = self.star_expressions()
                    if ex:
                        literal_2 = self.expect_type(11)
                        if literal_2:
                            tc = self.type_comment()
                            b = self.block()
                            if b:
                                el = self.else_block()
                                tok = self.get_last_non_whitespace_token()
                                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                return ast . For ( target = t , iter = ex , body = b , orelse = el , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if cut: return None
        cut = False
        _async = self.expect_type(58)
        if _async:
            literal = self.expect_type(518)
            if literal:
                t = self.star_targets()
                if t:
                    literal_1 = self.expect_type(519)
                    if literal_1:
                        cut = True
                        ex = self.star_expressions()
                        if ex:
                            literal_2 = self.expect_type(11)
                            if literal_2:
                                tc = self.type_comment()
                                b = self.block()
                                if b:
                                    el = self.else_block()
                                    tok = self.get_last_non_whitespace_token()
                                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                    return self . check_version ( ( 3 , 5 ) , "Async for loops are" , ast . AsyncFor ( target = t , iter = ex , body = b , orelse = el , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        if cut: return None
        if self.call_invalid_rules:
            invalid_for_target = self.invalid_for_target()
            if invalid_for_target:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def with_stmt(self): # type Optional[Union [ast . With , ast . AsyncWith]]
        # with_stmt: invalid_with_stmt_indent | 'with' '(' ','.with_item+ ','? ')' ':' block | 'with' ','.with_item+ ':' TYPE_COMMENT? block | ASYNC 'with' '(' ','.with_item+ ','? ')' ':' block | ASYNC 'with' ','.with_item+ ':' TYPE_COMMENT? block | invalid_with_stmt
        mark = self._index
        if self._verbose: log_start(self, 'with_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_with_stmt_indent = self.invalid_with_stmt_indent()
            if invalid_with_stmt_indent:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(520)
        if literal:
            literal_1 = self.expect_type(7)
            if literal_1:
                a = self._gather_62()
                if a:
                    opt = self.expect_type(12)
                    literal_2 = self.expect_type(8)
                    if literal_2:
                        literal_3 = self.expect_type(11)
                        if literal_3:
                            b = self.block()
                            if b:
                                tok = self.get_last_non_whitespace_token()
                                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                return self . check_version ( ( 3 , 9 ) , "Parenthesized with items" , ast . With ( items = a , body = b , type_comment = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        literal = self.expect_type(520)
        if literal:
            a = self._gather_64()
            if a:
                literal_1 = self.expect_type(11)
                if literal_1:
                    tc = self.type_comment()
                    b = self.block()
                    if b:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . With ( items = a , body = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        _async = self.expect_type(58)
        if _async:
            literal = self.expect_type(520)
            if literal:
                literal_1 = self.expect_type(7)
                if literal_1:
                    a = self._gather_66()
                    if a:
                        opt = self.expect_type(12)
                        literal_2 = self.expect_type(8)
                        if literal_2:
                            literal_3 = self.expect_type(11)
                            if literal_3:
                                b = self.block()
                                if b:
                                    tok = self.get_last_non_whitespace_token()
                                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                    return self . check_version ( ( 3 , 9 ) , "Parenthesized with items" , ast . AsyncWith ( items = a , body = b , type_comment = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        _async = self.expect_type(58)
        if _async:
            literal = self.expect_type(520)
            if literal:
                a = self._gather_68()
                if a:
                    literal_1 = self.expect_type(11)
                    if literal_1:
                        tc = self.type_comment()
                        b = self.block()
                        if b:
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return self . check_version ( ( 3 , 5 ) , "Async with statements are" , ast . AsyncWith ( items = a , body = b , type_comment = tc , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        if self.call_invalid_rules:
            invalid_with_stmt = self.invalid_with_stmt()
            if invalid_with_stmt:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def with_item(self): # type Optional[ast . withitem]
        # with_item: expression 'as' star_target &(',' | ')' | ':') | invalid_with_item | expression
        mark = self._index
        if self._verbose: log_start(self, 'with_item')
        e = self.expression()
        if e:
            literal = self.expect_type(521)
            if literal:
                t = self.star_target()
                if t:
                    if self.positive_lookahead(PythonParser._tmp_70, ):
                        return ast . withitem ( context_expr = e , optional_vars = t )
        self._index = mark
        if self.call_invalid_rules:
            invalid_with_item = self.invalid_with_item()
            if invalid_with_item:
                assert 0, 'unreachable'
            self._index = mark
        e = self.expression()
        if e:
            return ast . withitem ( context_expr = e , optional_vars = None )
        self._index = mark
        return None

    def try_stmt(self): # type Optional[ast . Try]
        # try_stmt: invalid_try_stmt | 'try' &&':' block finally_block | 'try' &&':' block except_block+ else_block? finally_block? | 'try' &&':' block except_star_block+ else_block? finally_block?
        mark = self._index
        if self._verbose: log_start(self, 'try_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_try_stmt = self.invalid_try_stmt()
            if invalid_try_stmt:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(510)
        if literal:
            literal_1 = self.expect_forced(self.expect_type(11), "':'")
            if literal_1:
                b = self.block()
                if b:
                    f = self.finally_block()
                    if f:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Try ( body = b , handlers = [] , orelse = None , finalbody = f , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(510)
        if literal:
            literal_1 = self.expect_forced(self.expect_type(11), "':'")
            if literal_1:
                b = self.block()
                if b:
                    ex = self._loop1_71()
                    if ex:
                        el = self.else_block()
                        f = self.finally_block()
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Try ( body = b , handlers = ex , orelse = el , finalbody = f , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(510)
        if literal:
            literal_1 = self.expect_forced(self.expect_type(11), "':'")
            if literal_1:
                b = self.block()
                if b:
                    ex = self._loop1_72()
                    if ex:
                        el = self.else_block()
                        f = self.finally_block()
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return self . check_version ( ( 3 , 11 ) , "Exception groups are" , ast . TryStar ( b , ex , el , f , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        return None

    def except_block(self): # type Optional[ast . ExceptHandler]
        # except_block: invalid_except_stmt_indent | 'except' expression ['as' NAME] ':' block | 'except' ':' block | invalid_except_stmt
        mark = self._index
        if self._verbose: log_start(self, 'except_block')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_except_stmt_indent = self.invalid_except_stmt_indent()
            if invalid_except_stmt_indent:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(522)
        if literal:
            e = self.expression()
            if e:
                t = self._tmp_73()
                literal_1 = self.expect_type(11)
                if literal_1:
                    b = self.block()
                    if b:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . ExceptHandler ( type = e , name = self . extract_id ( t ) , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(522)
        if literal:
            literal_1 = self.expect_type(11)
            if literal_1:
                b = self.block()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . ExceptHandler ( type = None , name = None , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_except_stmt = self.invalid_except_stmt()
            if invalid_except_stmt:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def except_star_block(self): # type Optional[excepthandler_ty]
        # except_star_block: invalid_except_star_stmt_indent | 'except' '*' expression ['as' NAME] ':' block | invalid_except_stmt
        mark = self._index
        if self._verbose: log_start(self, 'except_star_block')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_except_star_stmt_indent = self.invalid_except_star_stmt_indent()
            if invalid_except_star_stmt_indent:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(522)
        if literal:
            literal_1 = self.expect_type(16)
            if literal_1:
                e = self.expression()
                if e:
                    t = self._tmp_74()
                    literal_2 = self.expect_type(11)
                    if literal_2:
                        b = self.block()
                        if b:
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . ExceptHandler ( e , self . extract_id ( t ) , b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_except_stmt = self.invalid_except_stmt()
            if invalid_except_stmt:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def finally_block(self): # type Optional[list]
        # finally_block: invalid_finally_stmt | 'finally' &&':' block
        mark = self._index
        if self._verbose: log_start(self, 'finally_block')
        if self.call_invalid_rules:
            invalid_finally_stmt = self.invalid_finally_stmt()
            if invalid_finally_stmt:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(523)
        if literal:
            literal_1 = self.expect_forced(self.expect_type(11), "':'")
            if literal_1:
                a = self.block()
                if a:
                    return a
        self._index = mark
        return None

    def match_stmt(self): # type Optional["ast.Match"]
        # match_stmt: "match" subject_expr ':' NEWLINE INDENT case_block+ DEDENT | invalid_match_stmt
        mark = self._index
        if self._verbose: log_start(self, 'match_stmt')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect("match")
        if literal:
            subject = self.subject_expr()
            if subject:
                literal_1 = self.expect_type(11)
                if literal_1:
                    _newline = self.expect_type(4)
                    if _newline:
                        _indent = self.expect_type(5)
                        if _indent:
                            cases = self._loop1_75()
                            if cases:
                                _dedent = self.expect_type(6)
                                if _dedent:
                                    tok = self.get_last_non_whitespace_token()
                                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                    return ast . Match ( subject = subject , cases = cases , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_match_stmt = self.invalid_match_stmt()
            if invalid_match_stmt:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def subject_expr(self): # type Optional[Any]
        # subject_expr: star_named_expression ',' star_named_expressions? | named_expression
        mark = self._index
        if self._verbose: log_start(self, 'subject_expr')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        value = self.star_named_expression()
        if value:
            literal = self.expect_type(12)
            if literal:
                values = self.star_named_expressions()
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , ast . Tuple ( elts = [value] + ( values or [] ) , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        e = self.named_expression()
        if e:
            return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , e )
        self._index = mark
        return None

    def case_block(self): # type Optional["ast.match_case"]
        # case_block: invalid_case_block | "case" patterns guard? ':' block
        mark = self._index
        if self._verbose: log_start(self, 'case_block')
        if self.call_invalid_rules:
            invalid_case_block = self.invalid_case_block()
            if invalid_case_block:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect("case")
        if literal:
            pattern = self.patterns()
            if pattern:
                guard = self.guard()
                literal_1 = self.expect_type(11)
                if literal_1:
                    body = self.block()
                    if body:
                        return ast . match_case ( pattern = pattern , guard = guard , body = body )
        self._index = mark
        return None

    def guard(self): # type Optional[Any]
        # guard: 'if' named_expression
        mark = self._index
        if self._verbose: log_start(self, 'guard')
        literal = self.expect_type(509)
        if literal:
            guard = self.named_expression()
            if guard:
                return guard
        self._index = mark
        return None

    def patterns(self): # type Optional[Any]
        # patterns: open_sequence_pattern | pattern
        mark = self._index
        if self._verbose: log_start(self, 'patterns')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        patterns = self.open_sequence_pattern()
        if patterns:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchSequence ( patterns = patterns , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        pattern = self.pattern()
        if pattern:
            return pattern
        self._index = mark
        return None

    def pattern(self): # type Optional[Any]
        # pattern: as_pattern | or_pattern
        mark = self._index
        if self._verbose: log_start(self, 'pattern')
        as_pattern = self.as_pattern()
        if as_pattern:
            return as_pattern
        self._index = mark
        or_pattern = self.or_pattern()
        if or_pattern:
            return or_pattern
        self._index = mark
        return None

    def as_pattern(self): # type Optional["ast.MatchAs"]
        # as_pattern: or_pattern 'as' pattern_capture_target | invalid_as_pattern
        mark = self._index
        if self._verbose: log_start(self, 'as_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        pattern = self.or_pattern()
        if pattern:
            literal = self.expect_type(521)
            if literal:
                target = self.pattern_capture_target()
                if target:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . MatchAs ( pattern = pattern , name = target , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_as_pattern = self.invalid_as_pattern()
            if invalid_as_pattern:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def or_pattern(self): # type Optional["ast.MatchOr"]
        # or_pattern: '|'.closed_pattern+
        mark = self._index
        if self._verbose: log_start(self, 'or_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        patterns = self._gather_76()
        if patterns:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchOr ( patterns = patterns , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) if len ( patterns ) > 1 else patterns [0]
        self._index = mark
        return None

    @memoize
    def closed_pattern(self): # type Optional[Any]
        # closed_pattern: literal_pattern | capture_pattern | wildcard_pattern | value_pattern | group_pattern | sequence_pattern | mapping_pattern | class_pattern
        mark = self._index
        if self._verbose: log_start(self, 'closed_pattern')
        literal_pattern = self.literal_pattern()
        if literal_pattern:
            return literal_pattern
        self._index = mark
        capture_pattern = self.capture_pattern()
        if capture_pattern:
            return capture_pattern
        self._index = mark
        wildcard_pattern = self.wildcard_pattern()
        if wildcard_pattern:
            return wildcard_pattern
        self._index = mark
        value_pattern = self.value_pattern()
        if value_pattern:
            return value_pattern
        self._index = mark
        group_pattern = self.group_pattern()
        if group_pattern:
            return group_pattern
        self._index = mark
        sequence_pattern = self.sequence_pattern()
        if sequence_pattern:
            return sequence_pattern
        self._index = mark
        mapping_pattern = self.mapping_pattern()
        if mapping_pattern:
            return mapping_pattern
        self._index = mark
        class_pattern = self.class_pattern()
        if class_pattern:
            return class_pattern
        self._index = mark
        return None

    def literal_pattern(self): # type Optional[Any]
        # literal_pattern: signed_number !('+' | '-') | complex_number | strings | 'None' | 'True' | 'False'
        mark = self._index
        if self._verbose: log_start(self, 'literal_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        value = self.signed_number()
        if value:
            if self.negative_lookahead(PythonParser._tmp_78, ):
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . MatchValue ( value = value , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        value = self.complex_number()
        if value:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchValue ( value = value , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        value = self.strings()
        if value:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchValue ( value = value , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(524)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchSingleton ( value = self . space . w_None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(525)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchSingleton ( value = self . space . w_True , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(526)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchSingleton ( value = self . space . w_False , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def literal_expr(self): # type Optional[Any]
        # literal_expr: signed_number !('+' | '-') | complex_number | strings | 'None' | 'True' | 'False'
        mark = self._index
        if self._verbose: log_start(self, 'literal_expr')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        signed_number = self.signed_number()
        if signed_number:
            if self.negative_lookahead(PythonParser._tmp_79, ):
                return signed_number
        self._index = mark
        complex_number = self.complex_number()
        if complex_number:
            return complex_number
        self._index = mark
        strings = self.strings()
        if strings:
            return strings
        self._index = mark
        literal = self.expect_type(524)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( self . space . w_None , None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(525)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( self . space . w_True , None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(526)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( self . space . w_False , None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def complex_number(self): # type Optional[Any]
        # complex_number: signed_real_number '+' imaginary_number | signed_real_number '-' imaginary_number
        mark = self._index
        if self._verbose: log_start(self, 'complex_number')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        real = self.signed_real_number()
        if real:
            literal = self.expect_type(14)
            if literal:
                imag = self.imaginary_number()
                if imag:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = real , op = ast . Add , right = imag , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        real = self.signed_real_number()
        if real:
            literal = self.expect_type(15)
            if literal:
                imag = self.imaginary_number()
                if imag:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = real , op = ast . Sub , right = imag , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def signed_number(self): # type Optional[Any]
        # signed_number: NUMBER | '-' NUMBER
        mark = self._index
        if self._verbose: log_start(self, 'signed_number')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.number()
        if a:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . parse_number ( a ) , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(15)
        if literal:
            a = self.number()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . UnaryOp ( op = ast . USub , operand = ast . Constant ( value = self . parse_number ( a ) , kind = None , lineno = a . lineno , col_offset = a . column , end_lineno = a . end_lineno , end_col_offset = a . end_column ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        return None

    def signed_real_number(self): # type Optional[Any]
        # signed_real_number: real_number | '-' real_number
        mark = self._index
        if self._verbose: log_start(self, 'signed_real_number')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        real_number = self.real_number()
        if real_number:
            return real_number
        self._index = mark
        literal = self.expect_type(15)
        if literal:
            real = self.real_number()
            if real:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . UnaryOp ( op = ast . USub , operand = real , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def real_number(self): # type Optional[ast . Constant]
        # real_number: NUMBER
        mark = self._index
        if self._verbose: log_start(self, 'real_number')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        real = self.number()
        if real:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . ensure_real ( real ) , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def imaginary_number(self): # type Optional[ast . Constant]
        # imaginary_number: NUMBER
        mark = self._index
        if self._verbose: log_start(self, 'imaginary_number')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        imag = self.number()
        if imag:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . ensure_imaginary ( imag ) , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def capture_pattern(self): # type Optional[Any]
        # capture_pattern: pattern_capture_target
        mark = self._index
        if self._verbose: log_start(self, 'capture_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        target = self.pattern_capture_target()
        if target:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchAs ( pattern = None , name = target , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def pattern_capture_target(self): # type Optional[str]
        # pattern_capture_target: !"_" NAME !('.' | '(' | '=')
        mark = self._index
        if self._verbose: log_start(self, 'pattern_capture_target')
        if self.negative_lookahead(PythonParser.expect, "_"):
            name = self.name()
            if name:
                if self.negative_lookahead(PythonParser._tmp_80, ):
                    return name . id
        self._index = mark
        return None

    def wildcard_pattern(self): # type Optional["ast.MatchAs"]
        # wildcard_pattern: "_"
        mark = self._index
        if self._verbose: log_start(self, 'wildcard_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect("_")
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . MatchAs ( pattern = None , name = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def value_pattern(self): # type Optional["ast.MatchValue"]
        # value_pattern: attr !('.' | '(' | '=')
        mark = self._index
        if self._verbose: log_start(self, 'value_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        attr = self.attr()
        if attr:
            if self.negative_lookahead(PythonParser._tmp_81, ):
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . MatchValue ( value = attr , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    @memoize_left_rec
    def attr(self): # type Optional[ast . Attribute]
        # attr: name_or_attr '.' NAME
        mark = self._index
        if self._verbose: log_start(self, 'attr')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        value = self.name_or_attr()
        if value:
            literal = self.expect_type(23)
            if literal:
                attr = self.name()
                if attr:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Attribute ( value = value , attr = attr . id , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def name_or_attr(self): # type Optional[Any]
        # name_or_attr: attr | NAME
        mark = self._index
        if self._verbose: log_start(self, 'name_or_attr')
        attr = self.attr()
        if attr:
            return attr
        self._index = mark
        name = self.name()
        if name:
            return name
        self._index = mark
        return None

    def group_pattern(self): # type Optional[Any]
        # group_pattern: '(' pattern ')'
        mark = self._index
        if self._verbose: log_start(self, 'group_pattern')
        literal = self.expect_type(7)
        if literal:
            pattern = self.pattern()
            if pattern:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return pattern
        self._index = mark
        return None

    def sequence_pattern(self): # type Optional["ast.MatchSequence"]
        # sequence_pattern: '[' maybe_sequence_pattern? ']' | '(' open_sequence_pattern? ')'
        mark = self._index
        if self._verbose: log_start(self, 'sequence_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(9)
        if literal:
            patterns = self.maybe_sequence_pattern()
            literal_1 = self.expect_type(10)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . MatchSequence ( patterns = patterns , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            patterns = self.open_sequence_pattern()
            literal_1 = self.expect_type(8)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . MatchSequence ( patterns = patterns , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def open_sequence_pattern(self): # type Optional[Any]
        # open_sequence_pattern: maybe_star_pattern ',' maybe_sequence_pattern?
        mark = self._index
        if self._verbose: log_start(self, 'open_sequence_pattern')
        pattern = self.maybe_star_pattern()
        if pattern:
            literal = self.expect_type(12)
            if literal:
                patterns = self.maybe_sequence_pattern()
                return [pattern] + ( patterns or [] )
        self._index = mark
        return None

    def maybe_sequence_pattern(self): # type Optional[Any]
        # maybe_sequence_pattern: ','.maybe_star_pattern+ ','?
        mark = self._index
        if self._verbose: log_start(self, 'maybe_sequence_pattern')
        patterns = self._gather_82()
        if patterns:
            opt = self.expect_type(12)
            return patterns
        self._index = mark
        return None

    def maybe_star_pattern(self): # type Optional[Any]
        # maybe_star_pattern: star_pattern | pattern
        mark = self._index
        if self._verbose: log_start(self, 'maybe_star_pattern')
        star_pattern = self.star_pattern()
        if star_pattern:
            return star_pattern
        self._index = mark
        pattern = self.pattern()
        if pattern:
            return pattern
        self._index = mark
        return None

    @memoize
    def star_pattern(self): # type Optional[Any]
        # star_pattern: '*' pattern_capture_target | '*' wildcard_pattern
        mark = self._index
        if self._verbose: log_start(self, 'star_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(16)
        if literal:
            target = self.pattern_capture_target()
            if target:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . MatchStar ( name = target , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            wildcard_pattern = self.wildcard_pattern()
            if wildcard_pattern:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . MatchStar ( name = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def mapping_pattern(self): # type Optional[Any]
        # mapping_pattern: '{' '}' | '{' double_star_pattern ','? '}' | '{' items_pattern ',' double_star_pattern ','? '}' | '{' items_pattern ','? '}'
        mark = self._index
        if self._verbose: log_start(self, 'mapping_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(26)
        if literal:
            literal_1 = self.expect_type(27)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . MatchMapping ( keys = None , patterns = None , rest = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(26)
        if literal:
            rest = self.double_star_pattern()
            if rest:
                opt = self.expect_type(12)
                literal_1 = self.expect_type(27)
                if literal_1:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . MatchMapping ( keys = None , patterns = None , rest = rest , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(26)
        if literal:
            items = self.items_pattern()
            if items:
                literal_1 = self.expect_type(12)
                if literal_1:
                    rest = self.double_star_pattern()
                    if rest:
                        opt = self.expect_type(12)
                        literal_2 = self.expect_type(27)
                        if literal_2:
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . MatchMapping ( keys = self . get_pattern_keys ( items ) , patterns = self . get_patterns ( items ) , rest = rest , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        literal = self.expect_type(26)
        if literal:
            items = self.items_pattern()
            if items:
                opt = self.expect_type(12)
                literal_1 = self.expect_type(27)
                if literal_1:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . MatchMapping ( keys = self . get_pattern_keys ( items ) , patterns = self . get_patterns ( items ) , rest = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        return None

    def items_pattern(self): # type Optional[Any]
        # items_pattern: ','.key_value_pattern+
        mark = self._index
        if self._verbose: log_start(self, 'items_pattern')
        _gather_84 = self._gather_84()
        if _gather_84:
            return _gather_84
        self._index = mark
        return None

    def key_value_pattern(self): # type Optional[Any]
        # key_value_pattern: (literal_expr | attr) ':' pattern
        mark = self._index
        if self._verbose: log_start(self, 'key_value_pattern')
        key = self._tmp_86()
        if key:
            literal = self.expect_type(11)
            if literal:
                pattern = self.pattern()
                if pattern:
                    return self . key_pattern_pair ( key , pattern )
        self._index = mark
        return None

    def double_star_pattern(self): # type Optional[Any]
        # double_star_pattern: '**' pattern_capture_target
        mark = self._index
        if self._verbose: log_start(self, 'double_star_pattern')
        literal = self.expect_type(36)
        if literal:
            target = self.pattern_capture_target()
            if target:
                return target
        self._index = mark
        return None

    def class_pattern(self): # type Optional["ast.MatchClass"]
        # class_pattern: name_or_attr '(' ')' | name_or_attr '(' positional_patterns ','? ')' | name_or_attr '(' keyword_patterns ','? ')' | name_or_attr '(' positional_patterns ',' keyword_patterns ','? ')' | invalid_class_pattern
        mark = self._index
        if self._verbose: log_start(self, 'class_pattern')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        cls = self.name_or_attr()
        if cls:
            literal = self.expect_type(7)
            if literal:
                literal_1 = self.expect_type(8)
                if literal_1:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . MatchClass ( cls = cls , patterns = None , kwd_attrs = None , kwd_patterns = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        cls = self.name_or_attr()
        if cls:
            literal = self.expect_type(7)
            if literal:
                patterns = self.positional_patterns()
                if patterns:
                    opt = self.expect_type(12)
                    literal_1 = self.expect_type(8)
                    if literal_1:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . MatchClass ( cls = cls , patterns = patterns , kwd_attrs = None , kwd_patterns = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        cls = self.name_or_attr()
        if cls:
            literal = self.expect_type(7)
            if literal:
                keywords = self.keyword_patterns()
                if keywords:
                    opt = self.expect_type(12)
                    literal_1 = self.expect_type(8)
                    if literal_1:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . MatchClass ( cls = cls , patterns = None , kwd_attrs = self . get_pattern_names ( keywords ) , kwd_patterns = self . get_patterns ( keywords ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        cls = self.name_or_attr()
        if cls:
            literal = self.expect_type(7)
            if literal:
                patterns = self.positional_patterns()
                if patterns:
                    literal_1 = self.expect_type(12)
                    if literal_1:
                        keywords = self.keyword_patterns()
                        if keywords:
                            opt = self.expect_type(12)
                            literal_2 = self.expect_type(8)
                            if literal_2:
                                tok = self.get_last_non_whitespace_token()
                                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                                return ast . MatchClass ( cls = cls , patterns = patterns , kwd_attrs = self . get_pattern_names ( keywords ) , kwd_patterns = self . get_patterns ( keywords ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        if self.call_invalid_rules:
            invalid_class_pattern = self.invalid_class_pattern()
            if invalid_class_pattern:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def positional_patterns(self): # type Optional[Any]
        # positional_patterns: ','.pattern+
        mark = self._index
        if self._verbose: log_start(self, 'positional_patterns')
        args = self._gather_87()
        if args:
            return args
        self._index = mark
        return None

    def keyword_patterns(self): # type Optional[Any]
        # keyword_patterns: ','.keyword_pattern+
        mark = self._index
        if self._verbose: log_start(self, 'keyword_patterns')
        _gather_89 = self._gather_89()
        if _gather_89:
            return _gather_89
        self._index = mark
        return None

    def keyword_pattern(self): # type Optional[Any]
        # keyword_pattern: NAME '=' pattern
        mark = self._index
        if self._verbose: log_start(self, 'keyword_pattern')
        arg = self.name()
        if arg:
            literal = self.expect_type(22)
            if literal:
                value = self.pattern()
                if value:
                    return self . key_pattern_pair ( arg , value )
        self._index = mark
        return None

    def star_expressions(self): # type Optional[Any]
        # star_expressions: star_expression ((',' star_expression))+ ','? | star_expression ',' | star_expression
        mark = self._index
        if self._verbose: log_start(self, 'star_expressions')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.star_expression()
        if a:
            b = self._loop1_91()
            if b:
                opt = self.expect_type(12)
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Tuple ( elts = [a] + b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.star_expression()
        if a:
            literal = self.expect_type(12)
            if literal:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Tuple ( elts = [a] , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        star_expression = self.star_expression()
        if star_expression:
            return star_expression
        self._index = mark
        return None

    @memoize
    def star_expression(self): # type Optional[Any]
        # star_expression: '*' bitwise_or | expression
        mark = self._index
        if self._verbose: log_start(self, 'star_expression')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(16)
        if literal:
            a = self.bitwise_or()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Starred ( value = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        expression = self.expression()
        if expression:
            return expression
        self._index = mark
        return None

    def star_named_expressions(self): # type Optional[Any]
        # star_named_expressions: ','.star_named_expression+ ','?
        mark = self._index
        if self._verbose: log_start(self, 'star_named_expressions')
        a = self._gather_92()
        if a:
            opt = self.expect_type(12)
            return a
        self._index = mark
        return None

    def star_named_expression(self): # type Optional[Any]
        # star_named_expression: '*' bitwise_or | named_expression
        mark = self._index
        if self._verbose: log_start(self, 'star_named_expression')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(16)
        if literal:
            a = self.bitwise_or()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Starred ( value = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        named_expression = self.named_expression()
        if named_expression:
            return named_expression
        self._index = mark
        return None

    def assignment_expression(self): # type Optional[Any]
        # assignment_expression: NAME ':=' ~ expression
        mark = self._index
        if self._verbose: log_start(self, 'assignment_expression')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        cut = False
        a = self.name()
        if a:
            literal = self.expect_type(54)
            if literal:
                cut = True
                b = self.expression()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return self . check_version ( ( 3 , 8 ) , "The ':=' operator is" , ast . NamedExpr ( target = self . set_expr_context ( a , Store ) , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , ) )
        self._index = mark
        if cut: return None
        return None

    def named_expression(self): # type Optional[Any]
        # named_expression: assignment_expression | invalid_named_expression | expression !':='
        mark = self._index
        if self._verbose: log_start(self, 'named_expression')
        assignment_expression = self.assignment_expression()
        if assignment_expression:
            return assignment_expression
        self._index = mark
        if self.call_invalid_rules:
            invalid_named_expression = self.invalid_named_expression()
            if invalid_named_expression:
                assert 0, 'unreachable'
            self._index = mark
        a = self.expression()
        if a:
            if self.negative_lookahead(PythonParser.expect_type, 54):
                return a
        self._index = mark
        return None

    def expressions(self): # type Optional[Any]
        # expressions: expression ((',' expression))+ ','? | expression ',' | expression
        mark = self._index
        if self._verbose: log_start(self, 'expressions')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.expression()
        if a:
            b = self._loop1_94()
            if b:
                opt = self.expect_type(12)
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Tuple ( elts = [a] + b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.expression()
        if a:
            literal = self.expect_type(12)
            if literal:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Tuple ( elts = [a] , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        expression = self.expression()
        if expression:
            return expression
        self._index = mark
        return None

    @memoize
    def expression(self): # type Optional[Any]
        # expression: invalid_expression | invalid_legacy_expression | disjunction 'if' disjunction 'else' expression | disjunction | lambdef
        mark = self._index
        if self._verbose: log_start(self, 'expression')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_expression = self.invalid_expression()
            if invalid_expression:
                assert 0, 'unreachable'
            self._index = mark
        if self.call_invalid_rules:
            invalid_legacy_expression = self.invalid_legacy_expression()
            if invalid_legacy_expression:
                assert 0, 'unreachable'
            self._index = mark
        a = self.disjunction()
        if a:
            literal = self.expect_type(509)
            if literal:
                b = self.disjunction()
                if b:
                    literal_1 = self.expect_type(517)
                    if literal_1:
                        c = self.expression()
                        if c:
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . IfExp ( body = a , test = b , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        disjunction = self.disjunction()
        if disjunction:
            return disjunction
        self._index = mark
        lambdef = self.lambdef()
        if lambdef:
            return lambdef
        self._index = mark
        return None

    def yield_expr(self): # type Optional[Any]
        # yield_expr: 'yield' 'from' expression | 'yield' star_expressions?
        mark = self._index
        if self._verbose: log_start(self, 'yield_expr')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(503)
        if literal:
            literal_1 = self.expect_type(513)
            if literal_1:
                a = self.expression()
                if a:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . YieldFrom ( value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(503)
        if literal:
            a = self.star_expressions()
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Yield ( value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    @memoize
    def disjunction(self): # type Optional[Any]
        # disjunction: conjunction (('or' conjunction))+ | conjunction
        mark = self._index
        if self._verbose: log_start(self, 'disjunction')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.conjunction()
        if a:
            b = self._loop1_95()
            if b:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . BoolOp ( op = ast . Or , values = [a] + b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        conjunction = self.conjunction()
        if conjunction:
            return conjunction
        self._index = mark
        return None

    @memoize
    def conjunction(self): # type Optional[Any]
        # conjunction: inversion (('and' inversion))+ | inversion
        mark = self._index
        if self._verbose: log_start(self, 'conjunction')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.inversion()
        if a:
            b = self._loop1_96()
            if b:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . BoolOp ( op = ast . And , values = [a] + b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        inversion = self.inversion()
        if inversion:
            return inversion
        self._index = mark
        return None

    @memoize
    def inversion(self): # type Optional[Any]
        # inversion: 'not' inversion | comparison
        mark = self._index
        if self._verbose: log_start(self, 'inversion')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(527)
        if literal:
            a = self.inversion()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . UnaryOp ( op = ast . Not , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        comparison = self.comparison()
        if comparison:
            return comparison
        self._index = mark
        return None

    def comparison(self): # type Optional[Any]
        # comparison: bitwise_or compare_op_bitwise_or_pair+ | bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'comparison')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.bitwise_or()
        if a:
            b = self._loop1_97()
            if b:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Compare ( left = a , ops = self . get_comparison_ops ( b ) , comparators = self . get_comparators ( b ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        bitwise_or = self.bitwise_or()
        if bitwise_or:
            return bitwise_or
        self._index = mark
        return None

    def compare_op_bitwise_or_pair(self): # type Optional[Any]
        # compare_op_bitwise_or_pair: eq_bitwise_or | noteq_bitwise_or | lte_bitwise_or | lt_bitwise_or | gte_bitwise_or | gt_bitwise_or | notin_bitwise_or | in_bitwise_or | isnot_bitwise_or | is_bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'compare_op_bitwise_or_pair')
        eq_bitwise_or = self.eq_bitwise_or()
        if eq_bitwise_or:
            return eq_bitwise_or
        self._index = mark
        noteq_bitwise_or = self.noteq_bitwise_or()
        if noteq_bitwise_or:
            return noteq_bitwise_or
        self._index = mark
        lte_bitwise_or = self.lte_bitwise_or()
        if lte_bitwise_or:
            return lte_bitwise_or
        self._index = mark
        lt_bitwise_or = self.lt_bitwise_or()
        if lt_bitwise_or:
            return lt_bitwise_or
        self._index = mark
        gte_bitwise_or = self.gte_bitwise_or()
        if gte_bitwise_or:
            return gte_bitwise_or
        self._index = mark
        gt_bitwise_or = self.gt_bitwise_or()
        if gt_bitwise_or:
            return gt_bitwise_or
        self._index = mark
        notin_bitwise_or = self.notin_bitwise_or()
        if notin_bitwise_or:
            return notin_bitwise_or
        self._index = mark
        in_bitwise_or = self.in_bitwise_or()
        if in_bitwise_or:
            return in_bitwise_or
        self._index = mark
        isnot_bitwise_or = self.isnot_bitwise_or()
        if isnot_bitwise_or:
            return isnot_bitwise_or
        self._index = mark
        is_bitwise_or = self.is_bitwise_or()
        if is_bitwise_or:
            return is_bitwise_or
        self._index = mark
        return None

    def eq_bitwise_or(self): # type Optional[Any]
        # eq_bitwise_or: '==' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'eq_bitwise_or')
        literal = self.expect_type(28)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . cmpop_expr_pair ( ast . Eq , a )
        self._index = mark
        return None

    def noteq_bitwise_or(self): # type Optional[Any]
        # noteq_bitwise_or: '!=' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'noteq_bitwise_or')
        tok = self.expect_type(29)
        if tok:
            a = self.bitwise_or()
            if a:
                return self . check_barry ( tok ) and self . cmpop_expr_pair ( ast . NotEq , a )
        self._index = mark
        return None

    def lte_bitwise_or(self): # type Optional[Any]
        # lte_bitwise_or: '<=' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'lte_bitwise_or')
        literal = self.expect_type(30)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . cmpop_expr_pair ( ast . LtE , a )
        self._index = mark
        return None

    def lt_bitwise_or(self): # type Optional[Any]
        # lt_bitwise_or: '<' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'lt_bitwise_or')
        literal = self.expect_type(20)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . cmpop_expr_pair ( ast . Lt , a )
        self._index = mark
        return None

    def gte_bitwise_or(self): # type Optional[Any]
        # gte_bitwise_or: '>=' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'gte_bitwise_or')
        literal = self.expect_type(31)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . cmpop_expr_pair ( ast . GtE , a )
        self._index = mark
        return None

    def gt_bitwise_or(self): # type Optional[Any]
        # gt_bitwise_or: '>' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'gt_bitwise_or')
        literal = self.expect_type(21)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . cmpop_expr_pair ( ast . Gt , a )
        self._index = mark
        return None

    def notin_bitwise_or(self): # type Optional[Any]
        # notin_bitwise_or: 'not' 'in' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'notin_bitwise_or')
        literal = self.expect_type(527)
        if literal:
            literal_1 = self.expect_type(519)
            if literal_1:
                a = self.bitwise_or()
                if a:
                    return self . cmpop_expr_pair ( ast . NotIn , a )
        self._index = mark
        return None

    def in_bitwise_or(self): # type Optional[Any]
        # in_bitwise_or: 'in' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'in_bitwise_or')
        literal = self.expect_type(519)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . cmpop_expr_pair ( ast . In , a )
        self._index = mark
        return None

    def isnot_bitwise_or(self): # type Optional[Any]
        # isnot_bitwise_or: 'is' 'not' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'isnot_bitwise_or')
        literal = self.expect_type(528)
        if literal:
            literal_1 = self.expect_type(527)
            if literal_1:
                a = self.bitwise_or()
                if a:
                    return self . cmpop_expr_pair ( ast . IsNot , a )
        self._index = mark
        return None

    def is_bitwise_or(self): # type Optional[Any]
        # is_bitwise_or: 'is' bitwise_or
        mark = self._index
        if self._verbose: log_start(self, 'is_bitwise_or')
        literal = self.expect_type(528)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . cmpop_expr_pair ( ast . Is , a )
        self._index = mark
        return None

    @memoize_left_rec
    def bitwise_or(self): # type Optional[Any]
        # bitwise_or: bitwise_or '|' bitwise_xor | bitwise_xor
        mark = self._index
        if self._verbose: log_start(self, 'bitwise_or')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.bitwise_or()
        if a:
            literal = self.expect_type(18)
            if literal:
                b = self.bitwise_xor()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . BitOr , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        bitwise_xor = self.bitwise_xor()
        if bitwise_xor:
            return bitwise_xor
        self._index = mark
        return None

    @memoize_left_rec
    def bitwise_xor(self): # type Optional[Any]
        # bitwise_xor: bitwise_xor '^' bitwise_and | bitwise_and
        mark = self._index
        if self._verbose: log_start(self, 'bitwise_xor')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.bitwise_xor()
        if a:
            literal = self.expect_type(33)
            if literal:
                b = self.bitwise_and()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . BitXor , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        bitwise_and = self.bitwise_and()
        if bitwise_and:
            return bitwise_and
        self._index = mark
        return None

    @memoize_left_rec
    def bitwise_and(self): # type Optional[Any]
        # bitwise_and: bitwise_and '&' shift_expr | shift_expr
        mark = self._index
        if self._verbose: log_start(self, 'bitwise_and')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.bitwise_and()
        if a:
            literal = self.expect_type(19)
            if literal:
                b = self.shift_expr()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . BitAnd , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        shift_expr = self.shift_expr()
        if shift_expr:
            return shift_expr
        self._index = mark
        return None

    @memoize_left_rec
    def shift_expr(self): # type Optional[Any]
        # shift_expr: shift_expr '<<' sum | shift_expr '>>' sum | sum
        mark = self._index
        if self._verbose: log_start(self, 'shift_expr')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.shift_expr()
        if a:
            literal = self.expect_type(34)
            if literal:
                b = self.sum()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . LShift , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.shift_expr()
        if a:
            literal = self.expect_type(35)
            if literal:
                b = self.sum()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . RShift , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        sum = self.sum()
        if sum:
            return sum
        self._index = mark
        return None

    @memoize_left_rec
    def sum(self): # type Optional[Any]
        # sum: sum '+' term | sum '-' term | term
        mark = self._index
        if self._verbose: log_start(self, 'sum')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.sum()
        if a:
            literal = self.expect_type(14)
            if literal:
                b = self.term()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . Add , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.sum()
        if a:
            literal = self.expect_type(15)
            if literal:
                b = self.term()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . Sub , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        term = self.term()
        if term:
            return term
        self._index = mark
        return None

    @memoize_left_rec
    def term(self): # type Optional[Any]
        # term: term '*' factor | term '/' factor | term '//' factor | term '%' factor | term '@' factor | factor
        mark = self._index
        if self._verbose: log_start(self, 'term')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.term()
        if a:
            literal = self.expect_type(16)
            if literal:
                b = self.factor()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . Mult , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.term()
        if a:
            literal = self.expect_type(17)
            if literal:
                b = self.factor()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . Div , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.term()
        if a:
            literal = self.expect_type(48)
            if literal:
                b = self.factor()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . FloorDiv , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.term()
        if a:
            literal = self.expect_type(24)
            if literal:
                b = self.factor()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . Mod , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.term()
        if a:
            literal = self.expect_type(50)
            if literal:
                b = self.factor()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return self . check_version ( ( 3 , 5 ) , "The '@' operator is" , ast . BinOp ( left = a , op = ast . MatMult , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        factor = self.factor()
        if factor:
            return factor
        self._index = mark
        return None

    @memoize
    def factor(self): # type Optional[Any]
        # factor: '+' factor | '-' factor | '~' factor | power
        mark = self._index
        if self._verbose: log_start(self, 'factor')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(14)
        if literal:
            a = self.factor()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . UnaryOp ( op = ast . UAdd , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(15)
        if literal:
            a = self.factor()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . UnaryOp ( op = ast . USub , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(32)
        if literal:
            a = self.factor()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . UnaryOp ( op = ast . Invert , operand = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        power = self.power()
        if power:
            return power
        self._index = mark
        return None

    def power(self): # type Optional[Any]
        # power: await_primary '**' factor | await_primary
        mark = self._index
        if self._verbose: log_start(self, 'power')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.await_primary()
        if a:
            literal = self.expect_type(36)
            if literal:
                b = self.factor()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . BinOp ( left = a , op = ast . Pow , right = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        await_primary = self.await_primary()
        if await_primary:
            return await_primary
        self._index = mark
        return None

    @memoize
    def await_primary(self): # type Optional[Any]
        # await_primary: AWAIT primary | primary
        mark = self._index
        if self._verbose: log_start(self, 'await_primary')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        _await = self.expect_type(59)
        if _await:
            a = self.primary()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return self . check_version ( ( 3 , 5 ) , "Await expressions are" , ast . Await ( a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset ) )
        self._index = mark
        primary = self.primary()
        if primary:
            return primary
        self._index = mark
        return None

    @memoize_left_rec
    def primary(self): # type Optional[Any]
        # primary: primary '.' NAME | primary genexp | primary '(' arguments? ')' | primary '[' slices ']' | atom
        mark = self._index
        if self._verbose: log_start(self, 'primary')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.primary()
        if a:
            literal = self.expect_type(23)
            if literal:
                b = self.name()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Attribute ( value = a , attr = b . id , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.primary()
        if a:
            b = self.genexp()
            if b:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Call ( func = a , args = [b] , keywords = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.primary()
        if a:
            literal = self.expect_type(7)
            if literal:
                b = self.arguments()
                literal_1 = self.expect_type(8)
                if literal_1:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Call ( func = a , args = b . args if b and b . args else None , keywords = b . keywords if b and b . keywords else None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        a = self.primary()
        if a:
            literal = self.expect_type(9)
            if literal:
                b = self.slices()
                if b:
                    literal_1 = self.expect_type(10)
                    if literal_1:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Subscript ( value = a , slice = b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        atom = self.atom()
        if atom:
            return atom
        self._index = mark
        return None

    def slices(self): # type Optional[Any]
        # slices: slice !',' | ','.(slice | starred_expression)+ ','?
        mark = self._index
        if self._verbose: log_start(self, 'slices')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.slice()
        if a:
            if self.negative_lookahead(PythonParser.expect_type, 12):
                return a
        self._index = mark
        a = self._gather_98()
        if a:
            opt = self.expect_type(12)
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Tuple ( elts = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def slice(self): # type Optional[Any]
        # slice: expression? ':' expression? [':' expression?] | named_expression
        mark = self._index
        if self._verbose: log_start(self, 'slice')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.expression()
        literal = self.expect_type(11)
        if literal:
            b = self.expression()
            c = self._tmp_100()
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Slice ( lower = a , upper = b , step = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.named_expression()
        if a:
            return a
        self._index = mark
        return None

    def atom(self): # type Optional[Any]
        # atom: NAME | 'True' | 'False' | 'None' | &STRING strings | NUMBER | '$NUM' | &'(' (tuple | group | genexp) | &'[' (list | listcomp) | &'{' (dict | set | dictcomp | setcomp) | '...'
        mark = self._index
        if self._verbose: log_start(self, 'atom')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        name = self.name()
        if name:
            return name
        self._index = mark
        literal = self.expect_type(525)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . space . w_True , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(526)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . space . w_False , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(524)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . space . w_None , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.positive_lookahead(PythonParser.string, ):
            strings = self.strings()
            if strings:
                return strings
        self._index = mark
        a = self.number()
        if a:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . parse_number ( a ) , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.expect_type(65)
        if a:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return self . revdbmetavar ( int ( tok . value [1 :] ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 7):
            _tmp_101 = self._tmp_101()
            if _tmp_101:
                return _tmp_101
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 9):
            _tmp_102 = self._tmp_102()
            if _tmp_102:
                return _tmp_102
        self._index = mark
        if self.positive_lookahead(PythonParser.expect_type, 26):
            _tmp_103 = self._tmp_103()
            if _tmp_103:
                return _tmp_103
        self._index = mark
        literal = self.expect_type(53)
        if literal:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Constant ( value = self . space . w_Ellipsis , kind = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def group(self): # type Optional[Any]
        # group: '(' (yield_expr | named_expression) ')' | invalid_group
        mark = self._index
        if self._verbose: log_start(self, 'group')
        literal = self.expect_type(7)
        if literal:
            a = self._tmp_104()
            if a:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return a
        self._index = mark
        if self.call_invalid_rules:
            invalid_group = self.invalid_group()
            if invalid_group:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def lambdef(self): # type Optional[Any]
        # lambdef: 'lambda' lambda_params? ':' expression
        mark = self._index
        if self._verbose: log_start(self, 'lambdef')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(529)
        if literal:
            a = self.lambda_params()
            literal_1 = self.expect_type(11)
            if literal_1:
                b = self.expression()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Lambda ( args = a or self . make_arguments ( None , None , None , [] , None ) , body = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def lambda_params(self): # type Optional[Any]
        # lambda_params: invalid_lambda_parameters | lambda_parameters
        mark = self._index
        if self._verbose: log_start(self, 'lambda_params')
        if self.call_invalid_rules:
            invalid_lambda_parameters = self.invalid_lambda_parameters()
            if invalid_lambda_parameters:
                assert 0, 'unreachable'
            self._index = mark
        lambda_parameters = self.lambda_parameters()
        if lambda_parameters:
            return lambda_parameters
        self._index = mark
        return None

    def lambda_parameters(self): # type Optional[ast . arguments]
        # lambda_parameters: lambda_slash_no_default lambda_param_no_default* lambda_param_with_default* lambda_star_etc? | lambda_slash_with_default lambda_param_with_default* lambda_star_etc? | lambda_param_no_default+ lambda_param_with_default* lambda_star_etc? | lambda_param_with_default+ lambda_star_etc? | lambda_star_etc
        mark = self._index
        if self._verbose: log_start(self, 'lambda_parameters')
        a = self.lambda_slash_no_default()
        if a:
            b = self._loop0_105()
            c = self._loop0_106()
            d = self.lambda_star_etc()
            return self . make_arguments ( a . plain_names , None , b , c , d )
        self._index = mark
        a = self.lambda_slash_with_default()
        if a:
            b = self._loop0_107()
            c = self.lambda_star_etc()
            return self . make_arguments ( None , a , None , b , c )
        self._index = mark
        a = self._loop1_108()
        if a:
            b = self._loop0_109()
            c = self.lambda_star_etc()
            return self . make_arguments ( None , None , a , b , c )
        self._index = mark
        a = self._loop1_110()
        if a:
            b = self.lambda_star_etc()
            return self . make_arguments ( None , None , None , a , b )
        self._index = mark
        a = self.lambda_star_etc()
        if a:
            return self . make_arguments ( None , None , None , [] , a )
        self._index = mark
        return None

    def lambda_slash_no_default(self): # type Optional[Any]
        # lambda_slash_no_default: lambda_param_no_default+ '/' ',' | lambda_param_no_default+ '/' &':'
        mark = self._index
        if self._verbose: log_start(self, 'lambda_slash_no_default')
        a = self._loop1_111()
        if a:
            literal = self.expect_type(17)
            if literal:
                literal_1 = self.expect_type(12)
                if literal_1:
                    return self . make_slash_with_default ( a , None )
        self._index = mark
        a = self._loop1_112()
        if a:
            literal = self.expect_type(17)
            if literal:
                if self.positive_lookahead(PythonParser.expect_type, 11):
                    return self . make_slash_with_default ( a , None )
        self._index = mark
        return None

    def lambda_slash_with_default(self): # type Optional[Any]
        # lambda_slash_with_default: lambda_param_no_default* lambda_param_with_default+ '/' ',' | lambda_param_no_default* lambda_param_with_default+ '/' &':'
        mark = self._index
        if self._verbose: log_start(self, 'lambda_slash_with_default')
        a = self._loop0_113()
        b = self._loop1_114()
        if b:
            literal = self.expect_type(17)
            if literal:
                literal_1 = self.expect_type(12)
                if literal_1:
                    return self . make_slash_with_default ( a , b )
        self._index = mark
        a = self._loop0_115()
        b = self._loop1_116()
        if b:
            literal = self.expect_type(17)
            if literal:
                if self.positive_lookahead(PythonParser.expect_type, 11):
                    return self . make_slash_with_default ( a , b )
        self._index = mark
        return None

    def lambda_star_etc(self): # type Optional[StarEtc]
        # lambda_star_etc: '*' lambda_param_no_default lambda_param_maybe_default* lambda_kwds? | '*' ',' lambda_param_maybe_default+ lambda_kwds? | lambda_kwds | invalid_lambda_star_etc
        mark = self._index
        if self._verbose: log_start(self, 'lambda_star_etc')
        literal = self.expect_type(16)
        if literal:
            a = self.lambda_param_no_default()
            if a:
                b = self._loop0_117()
                c = self.lambda_kwds()
                return self . make_star_etc ( a , b , c )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            literal_1 = self.expect_type(12)
            if literal_1:
                b = self._loop1_118()
                if b:
                    c = self.lambda_kwds()
                    return self . make_star_etc ( None , b , c )
        self._index = mark
        a = self.lambda_kwds()
        if a:
            return self . make_star_etc ( None , None , a )
        self._index = mark
        if self.call_invalid_rules:
            invalid_lambda_star_etc = self.invalid_lambda_star_etc()
            if invalid_lambda_star_etc:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def lambda_kwds(self): # type Optional[ast . arg]
        # lambda_kwds: invalid_lambda_kwds | '**' lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, 'lambda_kwds')
        if self.call_invalid_rules:
            invalid_lambda_kwds = self.invalid_lambda_kwds()
            if invalid_lambda_kwds:
                assert 0, 'unreachable'
            self._index = mark
        literal = self.expect_type(36)
        if literal:
            a = self.lambda_param_no_default()
            if a:
                return a
        self._index = mark
        return None

    def lambda_param_no_default(self): # type Optional[ast . arg]
        # lambda_param_no_default: lambda_param ',' | lambda_param &':'
        mark = self._index
        if self._verbose: log_start(self, 'lambda_param_no_default')
        a = self.lambda_param()
        if a:
            literal = self.expect_type(12)
            if literal:
                return a
        self._index = mark
        a = self.lambda_param()
        if a:
            if self.positive_lookahead(PythonParser.expect_type, 11):
                return a
        self._index = mark
        return None

    def lambda_param_with_default(self): # type Optional[NameDefaultPair]
        # lambda_param_with_default: lambda_param default ',' | lambda_param default &':'
        mark = self._index
        if self._verbose: log_start(self, 'lambda_param_with_default')
        a = self.lambda_param()
        if a:
            c = self.default()
            if c:
                literal = self.expect_type(12)
                if literal:
                    return self . name_default_pair ( a , c , None )
        self._index = mark
        a = self.lambda_param()
        if a:
            c = self.default()
            if c:
                if self.positive_lookahead(PythonParser.expect_type, 11):
                    return self . name_default_pair ( a , c , None )
        self._index = mark
        return None

    def lambda_param_maybe_default(self): # type Optional[NameDefaultPair]
        # lambda_param_maybe_default: lambda_param default? ',' | lambda_param default? &':'
        mark = self._index
        if self._verbose: log_start(self, 'lambda_param_maybe_default')
        a = self.lambda_param()
        if a:
            c = self.default()
            literal = self.expect_type(12)
            if literal:
                return self . name_default_pair ( a , c , None )
        self._index = mark
        a = self.lambda_param()
        if a:
            c = self.default()
            if self.positive_lookahead(PythonParser.expect_type, 11):
                return self . name_default_pair ( a , c , None )
        self._index = mark
        return None

    def lambda_param(self): # type Optional[ast . arg]
        # lambda_param: NAME
        mark = self._index
        if self._verbose: log_start(self, 'lambda_param')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.name()
        if a:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . arg ( arg = self . extract_id ( a ) , annotation = None , type_comment = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    @memoize
    def strings(self): # type Optional[ast . Str]
        # strings: STRING+
        mark = self._index
        if self._verbose: log_start(self, 'strings')
        a = self._loop1_119()
        if a:
            return self . generate_ast_for_string ( a )
        self._index = mark
        return None

    def list(self): # type Optional[ast . List]
        # list: '[' star_named_expressions? ']'
        mark = self._index
        if self._verbose: log_start(self, 'list')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(9)
        if literal:
            a = self.star_named_expressions()
            literal_1 = self.expect_type(10)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . List ( elts = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def tuple(self): # type Optional[ast . Tuple]
        # tuple: '(' [star_named_expression ',' star_named_expressions?] ')'
        mark = self._index
        if self._verbose: log_start(self, 'tuple')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(7)
        if literal:
            a = self._tmp_120()
            literal_1 = self.expect_type(8)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Tuple ( elts = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def set(self): # type Optional[ast . Set]
        # set: '{' star_named_expressions '}'
        mark = self._index
        if self._verbose: log_start(self, 'set')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(26)
        if literal:
            a = self.star_named_expressions()
            if a:
                literal_1 = self.expect_type(27)
                if literal_1:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Set ( elts = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def dict(self): # type Optional[ast . Dict]
        # dict: '{' double_starred_kvpairs? '}' | '{' invalid_double_starred_kvpairs '}'
        mark = self._index
        if self._verbose: log_start(self, 'dict')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(26)
        if literal:
            a = self.double_starred_kvpairs()
            literal_1 = self.expect_type(27)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Dict ( keys = [kv . key for kv in a] if a else None , values = [kv . value for kv in a] if a else None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(26)
        if literal:
            invalid_double_starred_kvpairs = self.invalid_double_starred_kvpairs()
            if invalid_double_starred_kvpairs:
                literal_1 = self.expect_type(27)
                if literal_1:
                    assert 0, 'unreachable'
        self._index = mark
        return None

    def double_starred_kvpairs(self): # type Optional[list]
        # double_starred_kvpairs: ','.double_starred_kvpair+ ','?
        mark = self._index
        if self._verbose: log_start(self, 'double_starred_kvpairs')
        a = self._gather_121()
        if a:
            opt = self.expect_type(12)
            return a
        self._index = mark
        return None

    def double_starred_kvpair(self): # type Optional[Any]
        # double_starred_kvpair: '**' bitwise_or | kvpair
        mark = self._index
        if self._verbose: log_start(self, 'double_starred_kvpair')
        literal = self.expect_type(36)
        if literal:
            a = self.bitwise_or()
            if a:
                return self . dict_display_entry ( None , a )
        self._index = mark
        kvpair = self.kvpair()
        if kvpair:
            return kvpair
        self._index = mark
        return None

    def kvpair(self): # type Optional[Any]
        # kvpair: expression ':' expression
        mark = self._index
        if self._verbose: log_start(self, 'kvpair')
        a = self.expression()
        if a:
            literal = self.expect_type(11)
            if literal:
                b = self.expression()
                if b:
                    return self . dict_display_entry ( a , b )
        self._index = mark
        return None

    def for_if_clauses(self): # type Optional[List [ast . comprehension]]
        # for_if_clauses: for_if_clause+
        mark = self._index
        if self._verbose: log_start(self, 'for_if_clauses')
        a = self._loop1_123()
        if a:
            return a
        self._index = mark
        return None

    def for_if_clause(self): # type Optional[ast . comprehension]
        # for_if_clause: ASYNC 'for' star_targets 'in' ~ disjunction (('if' disjunction))* | 'for' star_targets 'in' ~ disjunction (('if' disjunction))* | invalid_for_target
        mark = self._index
        if self._verbose: log_start(self, 'for_if_clause')
        cut = False
        x = self.expect_type(58)
        if x:
            literal = self.expect_type(518)
            if literal:
                a = self.star_targets()
                if a:
                    literal_1 = self.expect_type(519)
                    if literal_1:
                        cut = True
                        b = self.disjunction()
                        if b:
                            c = self._loop0_124()
                            return self . check_version ( ( 3 , 6 ) , "Async comprehensions are" , x ) and ast . comprehension ( target = a , iter = b , ifs = c if c else None , is_async = True )
        self._index = mark
        if cut: return None
        cut = False
        literal = self.expect_type(518)
        if literal:
            a = self.star_targets()
            if a:
                literal_1 = self.expect_type(519)
                if literal_1:
                    cut = True
                    b = self.disjunction()
                    if b:
                        c = self._loop0_125()
                        return ast . comprehension ( target = a , iter = b , ifs = c if c else None , is_async = False )
        self._index = mark
        if cut: return None
        if self.call_invalid_rules:
            invalid_for_target = self.invalid_for_target()
            if invalid_for_target:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def listcomp(self): # type Optional[ast . ListComp]
        # listcomp: '[' named_expression for_if_clauses ']' | invalid_comprehension
        mark = self._index
        if self._verbose: log_start(self, 'listcomp')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(9)
        if literal:
            a = self.named_expression()
            if a:
                b = self.for_if_clauses()
                if b:
                    literal_1 = self.expect_type(10)
                    if literal_1:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . ListComp ( elt = a , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_comprehension = self.invalid_comprehension()
            if invalid_comprehension:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def setcomp(self): # type Optional[ast . SetComp]
        # setcomp: '{' named_expression for_if_clauses '}' | invalid_comprehension
        mark = self._index
        if self._verbose: log_start(self, 'setcomp')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(26)
        if literal:
            a = self.named_expression()
            if a:
                b = self.for_if_clauses()
                if b:
                    literal_1 = self.expect_type(27)
                    if literal_1:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . SetComp ( elt = a , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_comprehension = self.invalid_comprehension()
            if invalid_comprehension:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def genexp(self): # type Optional[ast . GeneratorExp]
        # genexp: '(' (assignment_expression | expression !':=') for_if_clauses ')' | invalid_comprehension
        mark = self._index
        if self._verbose: log_start(self, 'genexp')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(7)
        if literal:
            a = self._tmp_126()
            if a:
                b = self.for_if_clauses()
                if b:
                    literal_1 = self.expect_type(8)
                    if literal_1:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . GeneratorExp ( elt = a , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_comprehension = self.invalid_comprehension()
            if invalid_comprehension:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def dictcomp(self): # type Optional[ast . DictComp]
        # dictcomp: '{' kvpair for_if_clauses '}' | invalid_dict_comprehension
        mark = self._index
        if self._verbose: log_start(self, 'dictcomp')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(26)
        if literal:
            a = self.kvpair()
            if a:
                b = self.for_if_clauses()
                if b:
                    literal_1 = self.expect_type(27)
                    if literal_1:
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . DictComp ( key = a . key , value = a . value , generators = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        if self.call_invalid_rules:
            invalid_dict_comprehension = self.invalid_dict_comprehension()
            if invalid_dict_comprehension:
                assert 0, 'unreachable'
            self._index = mark
        return None

    @memoize
    def arguments(self): # type Optional[ast . Call]
        # arguments: args ','? &')' | invalid_arguments
        mark = self._index
        if self._verbose: log_start(self, 'arguments')
        a = self.args()
        if a:
            opt = self.expect_type(12)
            if self.positive_lookahead(PythonParser.expect_type, 8):
                return a
        self._index = mark
        if self.call_invalid_rules:
            invalid_arguments = self.invalid_arguments()
            if invalid_arguments:
                assert 0, 'unreachable'
            self._index = mark
        return None

    def args(self): # type Optional[ast . Call]
        # args: ','.(starred_expression | (assignment_expression | expression !':=') !'=')+ [',' kwargs] | kwargs
        mark = self._index
        if self._verbose: log_start(self, 'args')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self._gather_127()
        if a:
            b = self._tmp_129()
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Call ( func = self . dummy_name ( ) , args = a + ( [e for e in b if isinstance ( e , ast . Starred )] if b else [] ) , keywords = ( [e for e in b if isinstance ( e , ast . keyword )] if b else [] ) , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.kwargs()
        if a:
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Call ( func = self . dummy_name ( ) , args = [e for e in a if isinstance ( e , ast . Starred )] , keywords = [e for e in a if isinstance ( e , ast . keyword )] , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def kwargs(self): # type Optional[list]
        # kwargs: ','.kwarg_or_starred+ ',' ','.kwarg_or_double_starred+ | ','.kwarg_or_starred+ | ','.kwarg_or_double_starred+
        mark = self._index
        if self._verbose: log_start(self, 'kwargs')
        a = self._gather_130()
        if a:
            literal = self.expect_type(12)
            if literal:
                b = self._gather_132()
                if b:
                    return a + b
        self._index = mark
        _gather_134 = self._gather_134()
        if _gather_134:
            return _gather_134
        self._index = mark
        _gather_136 = self._gather_136()
        if _gather_136:
            return _gather_136
        self._index = mark
        return None

    def starred_expression(self): # type Optional[Any]
        # starred_expression: '*' expression | '*'
        mark = self._index
        if self._verbose: log_start(self, 'starred_expression')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(16)
        if literal:
            a = self.expression()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Starred ( value = a , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            return self . raise_syntax_error ( "Invalid star expression" )
        self._index = mark
        return None

    def kwarg_or_starred(self): # type Optional[Any]
        # kwarg_or_starred: invalid_kwarg | NAME '=' expression | starred_expression
        mark = self._index
        if self._verbose: log_start(self, 'kwarg_or_starred')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_kwarg = self.invalid_kwarg()
            if invalid_kwarg:
                assert 0, 'unreachable'
            self._index = mark
        a = self.name()
        if a:
            literal = self.expect_type(22)
            if literal:
                b = self.expression()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . keyword ( arg = self . extract_id ( a ) , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.starred_expression()
        if a:
            return a
        self._index = mark
        return None

    def kwarg_or_double_starred(self): # type Optional[Any]
        # kwarg_or_double_starred: invalid_kwarg | NAME '=' expression | '**' expression
        mark = self._index
        if self._verbose: log_start(self, 'kwarg_or_double_starred')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        if self.call_invalid_rules:
            invalid_kwarg = self.invalid_kwarg()
            if invalid_kwarg:
                assert 0, 'unreachable'
            self._index = mark
        a = self.name()
        if a:
            literal = self.expect_type(22)
            if literal:
                b = self.expression()
                if b:
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . keyword ( arg = self . extract_id ( a ) , value = b , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            a = self.expression()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . keyword ( arg = None , value = a , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def star_targets(self): # type Optional[Any]
        # star_targets: star_target !',' | star_target ((',' star_target))* ','?
        mark = self._index
        if self._verbose: log_start(self, 'star_targets')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.star_target()
        if a:
            if self.negative_lookahead(PythonParser.expect_type, 12):
                return a
        self._index = mark
        a = self.star_target()
        if a:
            b = self._loop0_138()
            opt = self.expect_type(12)
            tok = self.get_last_non_whitespace_token()
            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
            return ast . Tuple ( elts = [a] + b , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def star_targets_list_seq(self): # type Optional[list]
        # star_targets_list_seq: ','.star_target+ ','?
        mark = self._index
        if self._verbose: log_start(self, 'star_targets_list_seq')
        a = self._gather_139()
        if a:
            opt = self.expect_type(12)
            return a
        self._index = mark
        return None

    def star_targets_tuple_seq(self): # type Optional[list]
        # star_targets_tuple_seq: star_target ((',' star_target))+ ','? | star_target ','
        mark = self._index
        if self._verbose: log_start(self, 'star_targets_tuple_seq')
        a = self.star_target()
        if a:
            b = self._loop1_141()
            if b:
                opt = self.expect_type(12)
                return [a] + b
        self._index = mark
        a = self.star_target()
        if a:
            literal = self.expect_type(12)
            if literal:
                return [a]
        self._index = mark
        return None

    @memoize
    def star_target(self): # type Optional[Any]
        # star_target: '*' (!'*' star_target) | target_with_star_atom
        mark = self._index
        if self._verbose: log_start(self, 'star_target')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        literal = self.expect_type(16)
        if literal:
            a = self._tmp_142()
            if a:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Starred ( value = self . set_expr_context ( a , Store ) , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        target_with_star_atom = self.target_with_star_atom()
        if target_with_star_atom:
            return target_with_star_atom
        self._index = mark
        return None

    @memoize
    def target_with_star_atom(self): # type Optional[Any]
        # target_with_star_atom: t_primary '.' NAME !t_lookahead | t_primary '[' slices ']' !t_lookahead | star_atom
        mark = self._index
        if self._verbose: log_start(self, 'target_with_star_atom')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.t_primary()
        if a:
            literal = self.expect_type(23)
            if literal:
                b = self.name()
                if b:
                    if self.negative_lookahead(PythonParser.t_lookahead, ):
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Attribute ( value = a , attr = b . id , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.t_primary()
        if a:
            literal = self.expect_type(9)
            if literal:
                b = self.slices()
                if b:
                    literal_1 = self.expect_type(10)
                    if literal_1:
                        if self.negative_lookahead(PythonParser.t_lookahead, ):
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . Subscript ( value = a , slice = b , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        star_atom = self.star_atom()
        if star_atom:
            return star_atom
        self._index = mark
        return None

    def star_atom(self): # type Optional[Any]
        # star_atom: NAME | '(' target_with_star_atom ')' | '(' star_targets_tuple_seq? ')' | '[' star_targets_list_seq? ']'
        mark = self._index
        if self._verbose: log_start(self, 'star_atom')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.name()
        if a:
            return self . set_expr_context ( a , Store )
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            a = self.target_with_star_atom()
            if a:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return self . set_expr_context ( a , Store )
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            a = self.star_targets_tuple_seq()
            literal_1 = self.expect_type(8)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Tuple ( elts = a , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(9)
        if literal:
            a = self.star_targets_list_seq()
            literal_1 = self.expect_type(10)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . List ( elts = a , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def single_target(self): # type Optional[Any]
        # single_target: single_subscript_attribute_target | NAME | '(' single_target ')'
        mark = self._index
        if self._verbose: log_start(self, 'single_target')
        single_subscript_attribute_target = self.single_subscript_attribute_target()
        if single_subscript_attribute_target:
            return single_subscript_attribute_target
        self._index = mark
        a = self.name()
        if a:
            return self . set_expr_context ( a , Store )
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            a = self.single_target()
            if a:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return a
        self._index = mark
        return None

    def single_subscript_attribute_target(self): # type Optional[Any]
        # single_subscript_attribute_target: t_primary '.' NAME !t_lookahead | t_primary '[' slices ']' !t_lookahead
        mark = self._index
        if self._verbose: log_start(self, 'single_subscript_attribute_target')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.t_primary()
        if a:
            literal = self.expect_type(23)
            if literal:
                b = self.name()
                if b:
                    if self.negative_lookahead(PythonParser.t_lookahead, ):
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Attribute ( value = a , attr = b . id , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.t_primary()
        if a:
            literal = self.expect_type(9)
            if literal:
                b = self.slices()
                if b:
                    literal_1 = self.expect_type(10)
                    if literal_1:
                        if self.negative_lookahead(PythonParser.t_lookahead, ):
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . Subscript ( value = a , slice = b , ctx = Store , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    @memoize_left_rec
    def t_primary(self): # type Optional[Any]
        # t_primary: t_primary '.' NAME &t_lookahead | t_primary '[' slices ']' &t_lookahead | t_primary genexp &t_lookahead | t_primary '(' arguments? ')' &t_lookahead | atom &t_lookahead
        mark = self._index
        if self._verbose: log_start(self, 't_primary')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.t_primary()
        if a:
            literal = self.expect_type(23)
            if literal:
                b = self.name()
                if b:
                    if self.positive_lookahead(PythonParser.t_lookahead, ):
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Attribute ( value = a , attr = b . id , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.t_primary()
        if a:
            literal = self.expect_type(9)
            if literal:
                b = self.slices()
                if b:
                    literal_1 = self.expect_type(10)
                    if literal_1:
                        if self.positive_lookahead(PythonParser.t_lookahead, ):
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . Subscript ( value = a , slice = b , ctx = Load , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.t_primary()
        if a:
            b = self.genexp()
            if b:
                if self.positive_lookahead(PythonParser.t_lookahead, ):
                    tok = self.get_last_non_whitespace_token()
                    end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                    return ast . Call ( func = a , args = [b] , keywords = None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.t_primary()
        if a:
            literal = self.expect_type(7)
            if literal:
                b = self.arguments()
                literal_1 = self.expect_type(8)
                if literal_1:
                    if self.positive_lookahead(PythonParser.t_lookahead, ):
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Call ( func = a , args = b . args if b else None , keywords = b . keywords if b and b . keywords else None , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset , )
        self._index = mark
        a = self.atom()
        if a:
            if self.positive_lookahead(PythonParser.t_lookahead, ):
                return a
        self._index = mark
        return None

    def t_lookahead(self): # type Optional[Any]
        # t_lookahead: '(' | '[' | '.'
        mark = self._index
        if self._verbose: log_start(self, 't_lookahead')
        literal = self.expect_type(7)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(9)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(23)
        if literal:
            return literal
        self._index = mark
        return None

    def del_targets(self): # type Optional[Any]
        # del_targets: ','.del_target+ ','?
        mark = self._index
        if self._verbose: log_start(self, 'del_targets')
        a = self._gather_143()
        if a:
            opt = self.expect_type(12)
            return a
        self._index = mark
        return None

    @memoize
    def del_target(self): # type Optional[Any]
        # del_target: t_primary '.' NAME !t_lookahead | t_primary '[' slices ']' !t_lookahead | del_t_atom
        mark = self._index
        if self._verbose: log_start(self, 'del_target')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.t_primary()
        if a:
            literal = self.expect_type(23)
            if literal:
                b = self.name()
                if b:
                    if self.negative_lookahead(PythonParser.t_lookahead, ):
                        tok = self.get_last_non_whitespace_token()
                        end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                        return ast . Attribute ( value = a , attr = b . id , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        a = self.t_primary()
        if a:
            literal = self.expect_type(9)
            if literal:
                b = self.slices()
                if b:
                    literal_1 = self.expect_type(10)
                    if literal_1:
                        if self.negative_lookahead(PythonParser.t_lookahead, ):
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . Subscript ( value = a , slice = b , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        del_t_atom = self.del_t_atom()
        if del_t_atom:
            return del_t_atom
        self._index = mark
        return None

    def del_t_atom(self): # type Optional[Any]
        # del_t_atom: NAME | '(' del_target ')' | '(' del_targets? ')' | '[' del_targets? ']'
        mark = self._index
        if self._verbose: log_start(self, 'del_t_atom')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.name()
        if a:
            return self . set_expr_context ( a , Del )
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            a = self.del_target()
            if a:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return self . set_expr_context ( a , Del )
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            a = self.del_targets()
            literal_1 = self.expect_type(8)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . Tuple ( elts = a , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        literal = self.expect_type(9)
        if literal:
            a = self.del_targets()
            literal_1 = self.expect_type(10)
            if literal_1:
                tok = self.get_last_non_whitespace_token()
                end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                return ast . List ( elts = a , ctx = Del , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        return None

    def invalid_arguments(self): # type Optional[NoReturn]
        # invalid_arguments: args ',' '*' | expression for_if_clauses ',' [args | expression for_if_clauses] | NAME '=' expression for_if_clauses | args for_if_clauses | args ',' expression for_if_clauses | args ',' args
        mark = self._index
        if self._verbose: log_start(self, 'invalid_arguments')
        a = self.args()
        if a:
            literal = self.expect_type(12)
            if literal:
                literal_1 = self.expect_type(16)
                if literal_1:
                    return self . raise_syntax_error_known_location ( "iterable argument unpacking follows keyword argument unpacking" , a . keywords [- 1] if a . keywords else a . args [- 1] , )
        self._index = mark
        a = self.expression()
        if a:
            b = self.for_if_clauses()
            if b:
                literal = self.expect_type(12)
                if literal:
                    opt = self._tmp_145()
                    return self . raise_syntax_error_known_range ( "Generator expression must be parenthesized" , a , self . get_last_comprehension_item ( self . get_last ( b ) ) )
        self._index = mark
        a = self.name()
        if a:
            b = self.expect_type(22)
            if b:
                expression = self.expression()
                if expression:
                    for_if_clauses = self.for_if_clauses()
                    if for_if_clauses:
                        return self . raise_syntax_error_known_range ( "invalid syntax. Maybe you meant '==' or ':=' instead of '='?" , a , b )
        self._index = mark
        a = self.args()
        if a:
            b = self.for_if_clauses()
            if b:
                return self . check_nonparen_genexp_in_call ( "Generator expression must be parenthesized" , a , b )
        self._index = mark
        args = self.args()
        if args:
            literal = self.expect_type(12)
            if literal:
                a = self.expression()
                if a:
                    b = self.for_if_clauses()
                    if b:
                        return self . raise_syntax_error_known_range ( "Generator expression must be parenthesized" , a , self . get_last_comprehension_item ( self . get_last ( b ) ) , )
        self._index = mark
        a = self.args()
        if a:
            literal = self.expect_type(12)
            if literal:
                args = self.args()
                if args:
                    return self . raise_syntax_error ( "positional argument follows keyword argument unpacking" if self . check_last_keyword_no_arg ( a ) else "positional argument follows keyword argument" , )
        self._index = mark
        return None

    def invalid_kwarg(self): # type Optional[NoReturn]
        # invalid_kwarg: NAME '=' expression for_if_clauses | !(NAME '=') expression '='
        mark = self._index
        if self._verbose: log_start(self, 'invalid_kwarg')
        a = self.name()
        if a:
            b = self.expect_type(22)
            if b:
                expression = self.expression()
                if expression:
                    for_if_clauses = self.for_if_clauses()
                    if for_if_clauses:
                        return self . raise_syntax_error_known_range ( "invalid syntax. Maybe you meant '==' or ':=' instead of '='?" , a , b )
        self._index = mark
        if self.negative_lookahead(PythonParser._tmp_146, ):
            a = self.expression()
            if a:
                b = self.expect_type(22)
                if b:
                    return self . kwarg_illegal_assignment ( a , b )
        self._index = mark
        return None

    @without_invalid
    def expression_without_invalid(self): # type Optional[ast . AST]
        # expression_without_invalid: disjunction 'if' disjunction 'else' expression | disjunction | lambdef
        mark = self._index
        if self._verbose: log_start(self, 'expression_without_invalid')
        tok = self.peek()
        start_lineno, start_col_offset = tok.lineno, tok.column
        a = self.disjunction()
        if a:
            literal = self.expect_type(509)
            if literal:
                b = self.disjunction()
                if b:
                    literal_1 = self.expect_type(517)
                    if literal_1:
                        c = self.expression()
                        if c:
                            tok = self.get_last_non_whitespace_token()
                            end_lineno, end_col_offset = tok.end_lineno, tok.end_column
                            return ast . IfExp ( body = b , test = a , orelse = c , lineno=start_lineno, col_offset=start_col_offset, end_lineno=end_lineno, end_col_offset=end_col_offset )
        self._index = mark
        disjunction = self.disjunction()
        if disjunction:
            return disjunction
        self._index = mark
        lambdef = self.lambdef()
        if lambdef:
            return lambdef
        self._index = mark
        return None

    def invalid_legacy_expression(self): # type Optional[Any]
        # invalid_legacy_expression: NAME !'(' star_expressions
        mark = self._index
        if self._verbose: log_start(self, 'invalid_legacy_expression')
        a = self.name()
        if a:
            if self.negative_lookahead(PythonParser.expect_type, 7):
                b = self.star_expressions()
                if b:
                    return self . raise_syntax_error_known_range ( "Missing parentheses in call to '%s'. Did you mean %s(...)?" % ( a . id , a . id ) , a , b , ) if self . check_legacy_stmt ( a ) else None
        self._index = mark
        return None

    def invalid_expression(self): # type Optional[NoReturn]
        # invalid_expression: !(NAME STRING | SOFT_KEYWORD) disjunction expression_without_invalid | disjunction 'if' disjunction !('else' | ':')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_expression')
        if self.negative_lookahead(PythonParser._tmp_147, ):
            a = self.disjunction()
            if a:
                b = self.expression_without_invalid()
                if b:
                    return ( None if self . check_legacy_stmt ( a ) or self . _tokens [mark - 1] . level == 0 else self . raise_syntax_error_known_range ( "invalid syntax. Perhaps you forgot a comma?" , a , b ) )
        self._index = mark
        a = self.disjunction()
        if a:
            literal = self.expect_type(509)
            if literal:
                b = self.disjunction()
                if b:
                    if self.negative_lookahead(PythonParser._tmp_148, ):
                        return self . raise_syntax_error_known_range ( "expected 'else' after 'if' expression" , a , b )
        self._index = mark
        return None

    def invalid_named_expression(self): # type Optional[NoReturn]
        # invalid_named_expression: expression ':=' expression | NAME '=' bitwise_or !('=' | ':=') | !(list | tuple | genexp | 'True' | 'None' | 'False') bitwise_or '=' bitwise_or !('=' | ':=')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_named_expression')
        a = self.expression()
        if a:
            literal = self.expect_type(54)
            if literal:
                expression = self.expression()
                if expression:
                    return self . raise_syntax_error_known_location ( "cannot use assignment expressions with %s" % ( self . get_expr_name ( a ) , ) , a )
        self._index = mark
        a = self.name()
        if a:
            literal = self.expect_type(22)
            if literal:
                b = self.bitwise_or()
                if b:
                    if self.negative_lookahead(PythonParser._tmp_149, ):
                        return ( None if self . in_recursive_rule else self . raise_syntax_error_known_range ( "invalid syntax. Maybe you meant '==' or ':=' instead of '='?" , a , b ) )
        self._index = mark
        if self.negative_lookahead(PythonParser._tmp_150, ):
            a = self.bitwise_or()
            if a:
                b = self.expect_type(22)
                if b:
                    bitwise_or = self.bitwise_or()
                    if bitwise_or:
                        if self.negative_lookahead(PythonParser._tmp_151, ):
                            return ( None if self . in_recursive_rule else self . raise_syntax_error_known_location ( "cannot assign to %s here. Maybe you meant '==' instead of '='?" % ( self . get_expr_name ( a ) , ) , a ) )
        self._index = mark
        return None

    def invalid_assignment(self): # type Optional[NoReturn]
        # invalid_assignment: invalid_ann_assign_target ':' expression | star_named_expression ',' star_named_expressions* ':' expression | expression ':' expression | ((star_targets '='))* star_expressions '=' | ((star_targets '='))* yield_expr '=' | star_expressions augassign (yield_expr | star_expressions)
        mark = self._index
        if self._verbose: log_start(self, 'invalid_assignment')
        a = self.invalid_ann_assign_target()
        if a:
            literal = self.expect_type(11)
            if literal:
                expression = self.expression()
                if expression:
                    return self . raise_syntax_error_known_location ( "only single target (not %s) can be annotated" % ( self . get_expr_name ( a ) , ) , a )
        self._index = mark
        a = self.star_named_expression()
        if a:
            literal = self.expect_type(12)
            if literal:
                _loop0_152 = self._loop0_152()
                literal_1 = self.expect_type(11)
                if literal_1:
                    expression = self.expression()
                    if expression:
                        return self . raise_syntax_error_known_location ( "only single target (not tuple) can be annotated" , a )
        self._index = mark
        a = self.expression()
        if a:
            literal = self.expect_type(11)
            if literal:
                expression = self.expression()
                if expression:
                    return self . raise_syntax_error_known_location ( "illegal target for annotation" , a )
        self._index = mark
        _loop0_153 = self._loop0_153()
        a = self.star_expressions()
        if a:
            literal = self.expect_type(22)
            if literal:
                return self . raise_syntax_error_if_invalid_target ( a , "assign" )
        self._index = mark
        _loop0_154 = self._loop0_154()
        a = self.yield_expr()
        if a:
            literal = self.expect_type(22)
            if literal:
                return self . raise_syntax_error_known_location ( "assignment to yield expression not possible" , a )
        self._index = mark
        a = self.star_expressions()
        if a:
            augassign = self.augassign()
            if augassign:
                _tmp_155 = self._tmp_155()
                if _tmp_155:
                    return self . raise_syntax_error_known_location ( "'%s' is an illegal expression for augmented assignment" % ( self . get_expr_name ( a ) , ) , a )
        self._index = mark
        return None

    def invalid_ann_assign_target(self): # type Optional[ast . AST]
        # invalid_ann_assign_target: list | tuple | '(' invalid_ann_assign_target ')'
        mark = self._index
        if self._verbose: log_start(self, 'invalid_ann_assign_target')
        a = self.list()
        if a:
            return a
        self._index = mark
        a = self.tuple()
        if a:
            return a
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            a = self.invalid_ann_assign_target()
            if a:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return a
        self._index = mark
        return None

    def invalid_del_stmt(self): # type Optional[NoReturn]
        # invalid_del_stmt: 'del' star_expressions
        mark = self._index
        if self._verbose: log_start(self, 'invalid_del_stmt')
        literal = self.expect_type(502)
        if literal:
            a = self.star_expressions()
            if a:
                return self . raise_syntax_error_if_invalid_target ( a , "delete" )
        self._index = mark
        return None

    def invalid_block(self): # type Optional[NoReturn]
        # invalid_block: NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_block')
        _newline = self.expect_type(4)
        if _newline:
            if self.negative_lookahead(PythonParser.expect_type, 5):
                return self . raise_indentation_error ( "expected an indented block" )
        self._index = mark
        return None

    def invalid_comprehension(self): # type Optional[NoReturn]
        # invalid_comprehension: ('[' | '(' | '{') starred_expression for_if_clauses | ('[' | '{') star_named_expression ',' star_named_expressions for_if_clauses | ('[' | '{') star_named_expression ',' for_if_clauses
        mark = self._index
        if self._verbose: log_start(self, 'invalid_comprehension')
        _tmp_156 = self._tmp_156()
        if _tmp_156:
            a = self.starred_expression()
            if a:
                for_if_clauses = self.for_if_clauses()
                if for_if_clauses:
                    return self . raise_syntax_error_known_location ( "iterable unpacking cannot be used in comprehension" , a )
        self._index = mark
        _tmp_157 = self._tmp_157()
        if _tmp_157:
            a = self.star_named_expression()
            if a:
                literal = self.expect_type(12)
                if literal:
                    b = self.star_named_expressions()
                    if b:
                        for_if_clauses = self.for_if_clauses()
                        if for_if_clauses:
                            return self . raise_syntax_error_known_range ( "did you forget parentheses around the comprehension target?" , a , b [- 1] )
        self._index = mark
        _tmp_158 = self._tmp_158()
        if _tmp_158:
            a = self.star_named_expression()
            if a:
                b = self.expect_type(12)
                if b:
                    for_if_clauses = self.for_if_clauses()
                    if for_if_clauses:
                        return self . raise_syntax_error_known_range ( "did you forget parentheses around the comprehension target?" , a , b )
        self._index = mark
        return None

    def invalid_dict_comprehension(self): # type Optional[NoReturn]
        # invalid_dict_comprehension: '{' '**' bitwise_or for_if_clauses '}'
        mark = self._index
        if self._verbose: log_start(self, 'invalid_dict_comprehension')
        literal = self.expect_type(26)
        if literal:
            a = self.expect_type(36)
            if a:
                bitwise_or = self.bitwise_or()
                if bitwise_or:
                    for_if_clauses = self.for_if_clauses()
                    if for_if_clauses:
                        literal_1 = self.expect_type(27)
                        if literal_1:
                            return self . raise_syntax_error_known_location ( "dict unpacking cannot be used in dict comprehension" , a )
        self._index = mark
        return None

    def invalid_parameters(self): # type Optional[NoReturn]
        # invalid_parameters: param_no_default* invalid_parameters_helper param_no_default | param_no_default* '(' param_no_default+ ','? ')' | "/" ',' | (slash_no_default | slash_with_default) param_maybe_default* '/' | [(slash_no_default | slash_with_default)] param_maybe_default* '*' (',' | param_no_default) param_maybe_default* '/' | param_maybe_default+ '/' '*'
        mark = self._index
        if self._verbose: log_start(self, 'invalid_parameters')
        _loop0_159 = self._loop0_159()
        invalid_parameters_helper = self.invalid_parameters_helper()
        if invalid_parameters_helper:
            a = self.param_no_default()
            if a:
                return self . raise_syntax_error_known_location ( "non-default argument follows default argument" , a )
        self._index = mark
        _loop0_160 = self._loop0_160()
        a = self.expect_type(7)
        if a:
            _loop1_161 = self._loop1_161()
            if _loop1_161:
                opt = self.expect_type(12)
                b = self.expect_type(8)
                if b:
                    return self . raise_syntax_error_known_range ( "Function parameters cannot be parenthesized" , a , b )
        self._index = mark
        a = self.expect("/")
        if a:
            literal = self.expect_type(12)
            if literal:
                return self . raise_syntax_error_known_location ( "at least one argument must precede /" , a )
        self._index = mark
        _tmp_162 = self._tmp_162()
        if _tmp_162:
            _loop0_163 = self._loop0_163()
            a = self.expect_type(17)
            if a:
                return self . raise_syntax_error_known_location ( "/ may appear only once" , a )
        self._index = mark
        opt = self._tmp_164()
        _loop0_165 = self._loop0_165()
        literal = self.expect_type(16)
        if literal:
            _tmp_166 = self._tmp_166()
            if _tmp_166:
                _loop0_167 = self._loop0_167()
                a = self.expect_type(17)
                if a:
                    return self . raise_syntax_error_known_location ( "/ must be ahead of *" , a )
        self._index = mark
        _loop1_168 = self._loop1_168()
        if _loop1_168:
            literal = self.expect_type(17)
            if literal:
                a = self.expect_type(16)
                if a:
                    return self . raise_syntax_error_known_location ( "expected comma between / and *" , a )
        self._index = mark
        return None

    def invalid_default(self): # type Optional[Any]
        # invalid_default: '=' &(')' | ',')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_default')
        a = self.expect_type(22)
        if a:
            if self.positive_lookahead(PythonParser._tmp_169, ):
                return self . raise_syntax_error_known_location ( "expected default value expression" , a )
        self._index = mark
        return None

    def invalid_star_etc(self): # type Optional[Any]
        # invalid_star_etc: '*' (')' | ',' (')' | '**')) | '*' ',' TYPE_COMMENT | '*' param '=' | '*' (param_no_default | ',') param_maybe_default* '*' (param_no_default | ',')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_star_etc')
        a = self.expect_type(16)
        if a:
            _tmp_170 = self._tmp_170()
            if _tmp_170:
                return self . raise_syntax_error_known_location ( "named arguments must follow bare *" , a )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            literal_1 = self.expect_type(12)
            if literal_1:
                type_comment = self.type_comment()
                if type_comment:
                    return self . raise_indentation_error ( "bare * has associated type comment" )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            param = self.param()
            if param:
                a = self.expect_type(22)
                if a:
                    return self . raise_syntax_error_known_location ( "var-positional argument cannot have default value" , a )
        self._index = mark
        literal = self.expect_type(16)
        if literal:
            _tmp_171 = self._tmp_171()
            if _tmp_171:
                _loop0_172 = self._loop0_172()
                a = self.expect_type(16)
                if a:
                    _tmp_173 = self._tmp_173()
                    if _tmp_173:
                        return self . raise_syntax_error_known_location ( "* argument may appear only once" , a )
        self._index = mark
        return None

    def invalid_kwds(self): # type Optional[Any]
        # invalid_kwds: '**' param '=' | '**' param ',' param | '**' param ',' ('*' | '**' | '/')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_kwds')
        literal = self.expect_type(36)
        if literal:
            param = self.param()
            if param:
                a = self.expect_type(22)
                if a:
                    return self . raise_syntax_error_known_location ( "var-keyword argument cannot have default value" , a )
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            param = self.param()
            if param:
                literal_1 = self.expect_type(12)
                if literal_1:
                    a = self.param()
                    if a:
                        return self . raise_syntax_error_known_location ( "arguments cannot follow var-keyword argument" , a )
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            param = self.param()
            if param:
                literal_1 = self.expect_type(12)
                if literal_1:
                    a = self._tmp_174()
                    if a:
                        return self . raise_syntax_error_known_location ( "arguments cannot follow var-keyword argument" , a )
        self._index = mark
        return None

    def invalid_parameters_helper(self): # type Optional[Any]
        # invalid_parameters_helper: slash_with_default | param_with_default+
        mark = self._index
        if self._verbose: log_start(self, 'invalid_parameters_helper')
        a = self.slash_with_default()
        if a:
            return self . dummy_name ( )
        self._index = mark
        a = self._loop1_175()
        if a:
            return self . dummy_name ( )
        self._index = mark
        return None

    def invalid_lambda_parameters(self): # type Optional[NoReturn]
        # invalid_lambda_parameters: lambda_param_no_default* invalid_lambda_parameters_helper lambda_param_no_default | lambda_param_no_default* '(' ','.lambda_param+ ','? ')' | "/" ',' | (lambda_slash_no_default | lambda_slash_with_default) lambda_param_maybe_default* '/' | [(lambda_slash_no_default | lambda_slash_with_default)] lambda_param_maybe_default* '*' (',' | lambda_param_no_default) lambda_param_maybe_default* '/' | lambda_param_maybe_default+ '/' '*'
        mark = self._index
        if self._verbose: log_start(self, 'invalid_lambda_parameters')
        _loop0_176 = self._loop0_176()
        invalid_lambda_parameters_helper = self.invalid_lambda_parameters_helper()
        if invalid_lambda_parameters_helper:
            a = self.lambda_param_no_default()
            if a:
                return self . raise_syntax_error_known_location ( "non-default argument follows default argument" , a )
        self._index = mark
        _loop0_177 = self._loop0_177()
        a = self.expect_type(7)
        if a:
            _gather_178 = self._gather_178()
            if _gather_178:
                opt = self.expect_type(12)
                b = self.expect_type(8)
                if b:
                    return self . raise_syntax_error_known_range ( "Lambda expression parameters cannot be parenthesized" , a , b )
        self._index = mark
        a = self.expect("/")
        if a:
            literal = self.expect_type(12)
            if literal:
                return self . raise_syntax_error_known_location ( "at least one argument must precede /" , a )
        self._index = mark
        _tmp_180 = self._tmp_180()
        if _tmp_180:
            _loop0_181 = self._loop0_181()
            a = self.expect_type(17)
            if a:
                return self . raise_syntax_error_known_location ( "/ may appear only once" , a )
        self._index = mark
        opt = self._tmp_182()
        _loop0_183 = self._loop0_183()
        literal = self.expect_type(16)
        if literal:
            _tmp_184 = self._tmp_184()
            if _tmp_184:
                _loop0_185 = self._loop0_185()
                a = self.expect_type(17)
                if a:
                    return self . raise_syntax_error_known_location ( "/ must be ahead of *" , a )
        self._index = mark
        _loop1_186 = self._loop1_186()
        if _loop1_186:
            literal = self.expect_type(17)
            if literal:
                a = self.expect_type(16)
                if a:
                    return self . raise_syntax_error_known_location ( "expected comma between / and *" , a )
        self._index = mark
        return None

    def invalid_lambda_parameters_helper(self): # type Optional[Any]
        # invalid_lambda_parameters_helper: lambda_slash_with_default | lambda_param_with_default+
        mark = self._index
        if self._verbose: log_start(self, 'invalid_lambda_parameters_helper')
        a = self.lambda_slash_with_default()
        if a:
            return self . dummy_name ( )
        self._index = mark
        a = self._loop1_187()
        if a:
            return self . dummy_name ( )
        self._index = mark
        return None

    def invalid_lambda_star_etc(self): # type Optional[NoReturn]
        # invalid_lambda_star_etc: '*' (':' | ',' (':' | '**'))
        mark = self._index
        if self._verbose: log_start(self, 'invalid_lambda_star_etc')
        literal = self.expect_type(16)
        if literal:
            _tmp_188 = self._tmp_188()
            if _tmp_188:
                return self . raise_syntax_error ( "named arguments must follow bare *" )
        self._index = mark
        return None

    def invalid_lambda_kwds(self): # type Optional[Any]
        # invalid_lambda_kwds: '**' lambda_param '=' | '**' lambda_param ',' lambda_param | '**' lambda_param ',' ('*' | '**' | '/')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_lambda_kwds')
        literal = self.expect_type(36)
        if literal:
            lambda_param = self.lambda_param()
            if lambda_param:
                a = self.expect_type(22)
                if a:
                    return self . raise_syntax_error_known_location ( "var-keyword argument cannot have default value" , a )
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            lambda_param = self.lambda_param()
            if lambda_param:
                literal_1 = self.expect_type(12)
                if literal_1:
                    a = self.lambda_param()
                    if a:
                        return self . raise_syntax_error_known_location ( "arguments cannot follow var-keyword argument" , a )
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            lambda_param = self.lambda_param()
            if lambda_param:
                literal_1 = self.expect_type(12)
                if literal_1:
                    a = self._tmp_189()
                    if a:
                        return self . raise_syntax_error_known_location ( "arguments cannot follow var-keyword argument" , a )
        self._index = mark
        return None

    def invalid_double_type_comments(self): # type Optional[NoReturn]
        # invalid_double_type_comments: TYPE_COMMENT NEWLINE TYPE_COMMENT NEWLINE INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_double_type_comments')
        type_comment = self.type_comment()
        if type_comment:
            _newline = self.expect_type(4)
            if _newline:
                type_comment_1 = self.type_comment()
                if type_comment_1:
                    _newline_1 = self.expect_type(4)
                    if _newline_1:
                        _indent = self.expect_type(5)
                        if _indent:
                            return self . raise_syntax_error ( "Cannot have two type comments on def" )
        self._index = mark
        return None

    def invalid_with_item(self): # type Optional[NoReturn]
        # invalid_with_item: expression 'as' expression &(',' | ')' | ':')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_with_item')
        expression = self.expression()
        if expression:
            literal = self.expect_type(521)
            if literal:
                a = self.expression()
                if a:
                    if self.positive_lookahead(PythonParser._tmp_190, ):
                        return self . raise_syntax_error_if_invalid_target ( a , "assign" )
        self._index = mark
        return None

    def invalid_for_target(self): # type Optional[NoReturn]
        # invalid_for_target: ASYNC? 'for' star_expressions
        mark = self._index
        if self._verbose: log_start(self, 'invalid_for_target')
        opt = self.expect_type(58)
        literal = self.expect_type(518)
        if literal:
            a = self.star_expressions()
            if a:
                return self . raise_syntax_error_if_invalid_target ( a , "for" )
        self._index = mark
        return None

    def invalid_group(self): # type Optional[NoReturn]
        # invalid_group: '(' starred_expression ')' | '(' '**' expression ')'
        mark = self._index
        if self._verbose: log_start(self, 'invalid_group')
        literal = self.expect_type(7)
        if literal:
            a = self.starred_expression()
            if a:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return self . raise_syntax_error_known_location ( "cannot use starred expression here" , a )
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            a = self.expect_type(36)
            if a:
                expression = self.expression()
                if expression:
                    literal_1 = self.expect_type(8)
                    if literal_1:
                        return self . raise_syntax_error_known_location ( "cannot use double starred expression here" , a )
        self._index = mark
        return None

    def invalid_import_from_targets(self): # type Optional[NoReturn]
        # invalid_import_from_targets: import_from_as_names ',' NEWLINE
        mark = self._index
        if self._verbose: log_start(self, 'invalid_import_from_targets')
        import_from_as_names = self.import_from_as_names()
        if import_from_as_names:
            a = self.expect_type(12)
            if a:
                _newline = self.expect_type(4)
                if _newline:
                    return self . raise_syntax_error_known_location ( "trailing comma not allowed without surrounding parentheses" , a )
        self._index = mark
        return None

    def invalid_with_stmt(self): # type Optional[None]
        # invalid_with_stmt: ASYNC? 'with' ','.(expression ['as' star_target])+ NEWLINE | ASYNC? 'with' '(' ','.(expressions ['as' star_target])+ ','? ')' NEWLINE
        mark = self._index
        if self._verbose: log_start(self, 'invalid_with_stmt')
        opt = self.expect_type(58)
        literal = self.expect_type(520)
        if literal:
            _gather_191 = self._gather_191()
            if _gather_191:
                n = self.expect_type(4)
                if n:
                    return self . raise_syntax_error_known_location ( "expected ':'" , n )
        self._index = mark
        opt = self.expect_type(58)
        literal = self.expect_type(520)
        if literal:
            literal_1 = self.expect_type(7)
            if literal_1:
                _gather_193 = self._gather_193()
                if _gather_193:
                    opt_1 = self.expect_type(12)
                    literal_2 = self.expect_type(8)
                    if literal_2:
                        n = self.expect_type(4)
                        if n:
                            return self . raise_syntax_error_known_location ( "expected ':'" , n )
        self._index = mark
        return None

    def invalid_with_stmt_indent(self): # type Optional[NoReturn]
        # invalid_with_stmt_indent: ASYNC? 'with' ','.(expression ['as' star_target])+ ':' NEWLINE !INDENT | ASYNC? 'with' '(' ','.(expressions ['as' star_target])+ ','? ')' ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_with_stmt_indent')
        opt = self.expect_type(58)
        a = self.expect_type(520)
        if a:
            _gather_195 = self._gather_195()
            if _gather_195:
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . raise_indentation_error ( "expected an indented block after 'with' statement on line %s" % a . lineno )
        self._index = mark
        opt = self.expect_type(58)
        a = self.expect_type(520)
        if a:
            literal = self.expect_type(7)
            if literal:
                _gather_197 = self._gather_197()
                if _gather_197:
                    opt_1 = self.expect_type(12)
                    literal_1 = self.expect_type(8)
                    if literal_1:
                        literal_2 = self.expect_type(11)
                        if literal_2:
                            _newline = self.expect_type(4)
                            if _newline:
                                if self.negative_lookahead(PythonParser.expect_type, 5):
                                    return self . raise_indentation_error ( "expected an indented block after 'with' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_try_stmt(self): # type Optional[Any]
        # invalid_try_stmt: 'try' ':' NEWLINE !INDENT | 'try' ':' block !('except' | 'finally') | 'try' ':' block* except_block+ 'except' '*' expression ['as' NAME] ':' | 'try' ':' block* except_star_block+ 'except' [expression ['as' NAME]] ':'
        mark = self._index
        if self._verbose: log_start(self, 'invalid_try_stmt')
        a = self.expect_type(510)
        if a:
            literal = self.expect_type(11)
            if literal:
                _newline = self.expect_type(4)
                if _newline:
                    if self.negative_lookahead(PythonParser.expect_type, 5):
                        return self . raise_indentation_error ( "expected an indented block after 'try' statement on line %s" % a . lineno )
        self._index = mark
        literal = self.expect_type(510)
        if literal:
            literal_1 = self.expect_type(11)
            if literal_1:
                block = self.block()
                if block:
                    if self.negative_lookahead(PythonParser._tmp_199, ):
                        return self . raise_syntax_error ( "expected 'except' or 'finally' block" )
        self._index = mark
        literal = self.expect_type(510)
        if literal:
            literal_1 = self.expect_type(11)
            if literal_1:
                _loop0_200 = self._loop0_200()
                _loop1_201 = self._loop1_201()
                if _loop1_201:
                    a = self.expect_type(522)
                    if a:
                        b = self.expect_type(16)
                        if b:
                            expression = self.expression()
                            if expression:
                                opt = self._tmp_202()
                                literal_2 = self.expect_type(11)
                                if literal_2:
                                    return self . raise_syntax_error_known_range ( "cannot have both 'except' and 'except*' on the same 'try'" , a , b )
        self._index = mark
        literal = self.expect_type(510)
        if literal:
            literal_1 = self.expect_type(11)
            if literal_1:
                _loop0_203 = self._loop0_203()
                _loop1_204 = self._loop1_204()
                if _loop1_204:
                    a = self.expect_type(522)
                    if a:
                        opt = self._tmp_205()
                        literal_2 = self.expect_type(11)
                        if literal_2:
                            return self . raise_syntax_error_known_location ( "cannot have both 'except' and 'except*' on the same 'try'" , a )
        self._index = mark
        return None

    def invalid_except_stmt(self): # type Optional[None]
        # invalid_except_stmt: 'except' expression ',' expressions ['as' NAME] ':' | 'except' expression ['as' NAME] NEWLINE | 'except' NEWLINE | 'except' '*' (NEWLINE | ':')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_except_stmt')
        literal = self.expect_type(522)
        if literal:
            a = self.expression()
            if a:
                literal_1 = self.expect_type(12)
                if literal_1:
                    expressions = self.expressions()
                    if expressions:
                        opt = self._tmp_206()
                        literal_2 = self.expect_type(11)
                        if literal_2:
                            return self . raise_syntax_error_starting_from ( "multiple exception types must be parenthesized" , a )
        self._index = mark
        a = self.expect_type(522)
        if a:
            expression = self.expression()
            if expression:
                opt = self._tmp_207()
                n = self.expect_type(4)
                if n:
                    return self . raise_syntax_error_known_location ( "expected ':'" , n )
        self._index = mark
        a = self.expect_type(522)
        if a:
            n = self.expect_type(4)
            if n:
                return self . raise_syntax_error_known_location ( "expected ':'" , n )
        self._index = mark
        a = self.expect_type(522)
        if a:
            literal = self.expect_type(16)
            if literal:
                _tmp_208 = self._tmp_208()
                if _tmp_208:
                    return self . raise_syntax_error ( "expected one or more exception types" )
        self._index = mark
        return None

    def invalid_finally_stmt(self): # type Optional[NoReturn]
        # invalid_finally_stmt: 'finally' ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_finally_stmt')
        a = self.expect_type(523)
        if a:
            literal = self.expect_type(11)
            if literal:
                _newline = self.expect_type(4)
                if _newline:
                    if self.negative_lookahead(PythonParser.expect_type, 5):
                        return self . raise_indentation_error ( "expected an indented block after 'finally' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_except_stmt_indent(self): # type Optional[NoReturn]
        # invalid_except_stmt_indent: 'except' expression ['as' NAME] ':' NEWLINE !INDENT | 'except' ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_except_stmt_indent')
        a = self.expect_type(522)
        if a:
            expression = self.expression()
            if expression:
                opt = self._tmp_209()
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . raise_indentation_error ( "expected an indented block after 'except' statement on line %s" % a . lineno )
        self._index = mark
        a = self.expect_type(522)
        if a:
            literal = self.expect_type(11)
            if literal:
                _newline = self.expect_type(4)
                if _newline:
                    if self.negative_lookahead(PythonParser.expect_type, 5):
                        return self . raise_indentation_error ( "expected an indented block after 'except' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_except_star_stmt_indent(self): # type Optional[Any]
        # invalid_except_star_stmt_indent: 'except' '*' expression ['as' NAME] ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_except_star_stmt_indent')
        a = self.expect_type(522)
        if a:
            literal = self.expect_type(16)
            if literal:
                expression = self.expression()
                if expression:
                    opt = self._tmp_210()
                    literal_1 = self.expect_type(11)
                    if literal_1:
                        _newline = self.expect_type(4)
                        if _newline:
                            if self.negative_lookahead(PythonParser.expect_type, 5):
                                return self . raise_indentation_error ( "expected an indented block after 'except*' statement on line %d" % a . lineno )
        self._index = mark
        return None

    def invalid_match_stmt(self): # type Optional[NoReturn]
        # invalid_match_stmt: "match" subject_expr !':' | "match" subject_expr ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_match_stmt')
        literal = self.expect("match")
        if literal:
            subject_expr = self.subject_expr()
            if subject_expr:
                if self.negative_lookahead(PythonParser.expect_type, 11):
                    return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , self . raise_syntax_error ( "expected ':'" ) )
        self._index = mark
        a = self.expect("match")
        if a:
            subject = self.subject_expr()
            if subject:
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . check_version ( ( 3 , 10 ) , "Pattern matching is" , self . raise_indentation_error ( "expected an indented block after 'match' statement on line %s" % a . lineno ) )
        self._index = mark
        return None

    def invalid_case_block(self): # type Optional[NoReturn]
        # invalid_case_block: "case" patterns guard? !':' | "case" patterns guard? ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_case_block')
        literal = self.expect("case")
        if literal:
            patterns = self.patterns()
            if patterns:
                opt = self.guard()
                if self.negative_lookahead(PythonParser.expect_type, 11):
                    return self . raise_syntax_error ( "expected ':'" )
        self._index = mark
        a = self.expect("case")
        if a:
            patterns = self.patterns()
            if patterns:
                opt = self.guard()
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . raise_indentation_error ( "expected an indented block after 'case' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_as_pattern(self): # type Optional[NoReturn]
        # invalid_as_pattern: or_pattern 'as' "_" | or_pattern 'as' !NAME expression
        mark = self._index
        if self._verbose: log_start(self, 'invalid_as_pattern')
        or_pattern = self.or_pattern()
        if or_pattern:
            literal = self.expect_type(521)
            if literal:
                a = self.expect("_")
                if a:
                    return self . raise_syntax_error_known_location ( "cannot use '_' as a target" , a )
        self._index = mark
        or_pattern = self.or_pattern()
        if or_pattern:
            literal = self.expect_type(521)
            if literal:
                if self.negative_lookahead(PythonParser.name, ):
                    a = self.expression()
                    if a:
                        return self . raise_syntax_error_known_location ( "invalid pattern target" , a )
        self._index = mark
        return None

    def invalid_class_pattern(self): # type Optional[NoReturn]
        # invalid_class_pattern: name_or_attr '(' invalid_class_argument_pattern
        mark = self._index
        if self._verbose: log_start(self, 'invalid_class_pattern')
        name_or_attr = self.name_or_attr()
        if name_or_attr:
            literal = self.expect_type(7)
            if literal:
                a = self.invalid_class_argument_pattern()
                if a:
                    return self . raise_syntax_error_known_range ( "positional patterns follow keyword patterns" , a [0] , a [- 1] )
        self._index = mark
        return None

    def invalid_class_argument_pattern(self): # type Optional[list]
        # invalid_class_argument_pattern: [positional_patterns ','] keyword_patterns ',' positional_patterns
        mark = self._index
        if self._verbose: log_start(self, 'invalid_class_argument_pattern')
        opt = self._tmp_211()
        keyword_patterns = self.keyword_patterns()
        if keyword_patterns:
            literal = self.expect_type(12)
            if literal:
                a = self.positional_patterns()
                if a:
                    return a
        self._index = mark
        return None

    def invalid_if_stmt(self): # type Optional[NoReturn]
        # invalid_if_stmt: 'if' named_expression NEWLINE | 'if' named_expression ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_if_stmt')
        literal = self.expect_type(509)
        if literal:
            named_expression = self.named_expression()
            if named_expression:
                n = self.expect_type(4)
                if n:
                    return self . raise_syntax_error_known_location ( "expected ':'" , n )
        self._index = mark
        a = self.expect_type(509)
        if a:
            a_1 = self.named_expression()
            if a_1:
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . raise_indentation_error ( "expected an indented block after 'if' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_elif_stmt(self): # type Optional[NoReturn]
        # invalid_elif_stmt: 'elif' named_expression NEWLINE | 'elif' named_expression ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_elif_stmt')
        literal = self.expect_type(516)
        if literal:
            named_expression = self.named_expression()
            if named_expression:
                _newline = self.expect_type(4)
                if _newline:
                    return self . raise_syntax_error ( "expected ':'" )
        self._index = mark
        a = self.expect_type(516)
        if a:
            named_expression = self.named_expression()
            if named_expression:
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . raise_indentation_error ( "expected an indented block after 'elif' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_else_stmt(self): # type Optional[NoReturn]
        # invalid_else_stmt: 'else' ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_else_stmt')
        a = self.expect_type(517)
        if a:
            literal = self.expect_type(11)
            if literal:
                _newline = self.expect_type(4)
                if _newline:
                    if self.negative_lookahead(PythonParser.expect_type, 5):
                        return self . raise_indentation_error ( "expected an indented block after 'else' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_while_stmt(self): # type Optional[NoReturn]
        # invalid_while_stmt: 'while' named_expression NEWLINE | 'while' named_expression ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_while_stmt')
        literal = self.expect_type(511)
        if literal:
            named_expression = self.named_expression()
            if named_expression:
                _newline = self.expect_type(4)
                if _newline:
                    return self . raise_syntax_error ( "expected ':'" )
        self._index = mark
        a = self.expect_type(511)
        if a:
            named_expression = self.named_expression()
            if named_expression:
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . raise_indentation_error ( "expected an indented block after 'while' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_for_stmt(self): # type Optional[NoReturn]
        # invalid_for_stmt: ASYNC? 'for' star_targets 'in' star_expressions NEWLINE | ASYNC? 'for' star_targets 'in' star_expressions ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_for_stmt')
        opt = self.expect_type(58)
        literal = self.expect_type(518)
        if literal:
            star_targets = self.star_targets()
            if star_targets:
                literal_1 = self.expect_type(519)
                if literal_1:
                    star_expressions = self.star_expressions()
                    if star_expressions:
                        n = self.expect_type(4)
                        if n:
                            return self . raise_syntax_error_known_location ( "expected ':'" , n )
        self._index = mark
        opt = self.expect_type(58)
        a = self.expect_type(518)
        if a:
            star_targets = self.star_targets()
            if star_targets:
                literal = self.expect_type(519)
                if literal:
                    star_expressions = self.star_expressions()
                    if star_expressions:
                        literal_1 = self.expect_type(11)
                        if literal_1:
                            _newline = self.expect_type(4)
                            if _newline:
                                if self.negative_lookahead(PythonParser.expect_type, 5):
                                    return self . raise_indentation_error ( "expected an indented block after 'for' statement on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_def_raw(self): # type Optional[NoReturn]
        # invalid_def_raw: ASYNC? 'def' NAME '(' params? ')' ['->' expression] ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_def_raw')
        opt = self.expect_type(58)
        a = self.expect_type(515)
        if a:
            name = self.name()
            if name:
                literal = self.expect_type(7)
                if literal:
                    opt_1 = self.params()
                    literal_1 = self.expect_type(8)
                    if literal_1:
                        opt_2 = self._tmp_212()
                        literal_2 = self.expect_type(11)
                        if literal_2:
                            _newline = self.expect_type(4)
                            if _newline:
                                if self.negative_lookahead(PythonParser.expect_type, 5):
                                    return self . raise_indentation_error ( "expected an indented block after function definition on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_class_def_raw(self): # type Optional[NoReturn]
        # invalid_class_def_raw: 'class' NAME ['(' arguments? ')'] NEWLINE | 'class' NAME ['(' arguments? ')'] ':' NEWLINE !INDENT
        mark = self._index
        if self._verbose: log_start(self, 'invalid_class_def_raw')
        literal = self.expect_type(514)
        if literal:
            name = self.name()
            if name:
                opt = self._tmp_213()
                n = self.expect_type(4)
                if n:
                    return self . raise_syntax_error_known_location ( "expected ':'" , n )
        self._index = mark
        a = self.expect_type(514)
        if a:
            name = self.name()
            if name:
                opt = self._tmp_214()
                literal = self.expect_type(11)
                if literal:
                    _newline = self.expect_type(4)
                    if _newline:
                        if self.negative_lookahead(PythonParser.expect_type, 5):
                            return self . raise_indentation_error ( "expected an indented block after class definition on line %s" % a . lineno )
        self._index = mark
        return None

    def invalid_double_starred_kvpairs(self): # type Optional[None]
        # invalid_double_starred_kvpairs: ','.double_starred_kvpair+ ',' invalid_kvpair | expression ':' '*' bitwise_or | expression ':' &('}' | ',')
        mark = self._index
        if self._verbose: log_start(self, 'invalid_double_starred_kvpairs')
        _gather_215 = self._gather_215()
        if _gather_215:
            literal = self.expect_type(12)
            if literal:
                invalid_kvpair = self.invalid_kvpair()
                if invalid_kvpair:
                    assert 0, 'unreachable'
        self._index = mark
        expression = self.expression()
        if expression:
            literal = self.expect_type(11)
            if literal:
                a = self.expect_type(16)
                if a:
                    bitwise_or = self.bitwise_or()
                    if bitwise_or:
                        return self . raise_syntax_error_starting_from ( "cannot use a starred expression in a dictionary value" , a )
        self._index = mark
        expression = self.expression()
        if expression:
            a = self.expect_type(11)
            if a:
                if self.positive_lookahead(PythonParser._tmp_217, ):
                    return self . raise_syntax_error_known_location ( "expression expected after dictionary key and ':'" , a )
        self._index = mark
        return None

    def invalid_kvpair(self): # type Optional[None]
        # invalid_kvpair: expression !(':') | expression ':' '*' bitwise_or | expression ':'
        mark = self._index
        if self._verbose: log_start(self, 'invalid_kvpair')
        a = self.expression()
        if a:
            if self.negative_lookahead(PythonParser.expect_type, 11):
                return self . _raise_syntax_error ( "':' expected after dictionary key" , a . lineno , a . col_offset - 1 , a . end_lineno , a . end_col_offset - 1 , )
        self._index = mark
        expression = self.expression()
        if expression:
            literal = self.expect_type(11)
            if literal:
                a = self.expect_type(16)
                if a:
                    bitwise_or = self.bitwise_or()
                    if bitwise_or:
                        return self . raise_syntax_error_starting_from ( "cannot use a starred expression in a dictionary value" , a )
        self._index = mark
        expression = self.expression()
        if expression:
            a = self.expect_type(11)
            if a:
                return self . raise_syntax_error_known_location ( "expression expected after dictionary key and ':'" , a )
        self._index = mark
        return None

    def _loop0_1(self): # type Optional[Any]
        # _loop0_1: NEWLINE
        mark = self._index
        if self._verbose: log_start(self, '_loop0_1')
        children = []
        while True:
            _newline = self.expect_type(4)
            if not _newline:
                break
            children.append(_newline)
            mark = self._index
        self._index = mark
        return children

    def _loop0_2(self): # type Optional[Any]
        # _loop0_2: NEWLINE
        mark = self._index
        if self._verbose: log_start(self, '_loop0_2')
        children = []
        while True:
            _newline = self.expect_type(4)
            if not _newline:
                break
            children.append(_newline)
            mark = self._index
        self._index = mark
        return children

    def _loop0_4(self): # type Optional[Any]
        # _loop0_4: ',' expression
        mark = self._index
        if self._verbose: log_start(self, '_loop0_4')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.expression()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_3(self): # type Optional[Any]
        # _gather_3: expression _loop0_4
        mark = self._index
        if self._verbose: log_start(self, '_gather_3')
        elem = self.expression()
        if elem is not None:
            seq = self._loop0_4()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_6(self): # type Optional[Any]
        # _loop0_6: ',' expression
        mark = self._index
        if self._verbose: log_start(self, '_loop0_6')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.expression()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_5(self): # type Optional[Any]
        # _gather_5: expression _loop0_6
        mark = self._index
        if self._verbose: log_start(self, '_gather_5')
        elem = self.expression()
        if elem is not None:
            seq = self._loop0_6()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_8(self): # type Optional[Any]
        # _loop0_8: ',' expression
        mark = self._index
        if self._verbose: log_start(self, '_loop0_8')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.expression()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_7(self): # type Optional[Any]
        # _gather_7: expression _loop0_8
        mark = self._index
        if self._verbose: log_start(self, '_gather_7')
        elem = self.expression()
        if elem is not None:
            seq = self._loop0_8()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_10(self): # type Optional[Any]
        # _loop0_10: ',' expression
        mark = self._index
        if self._verbose: log_start(self, '_loop0_10')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.expression()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_9(self): # type Optional[Any]
        # _gather_9: expression _loop0_10
        mark = self._index
        if self._verbose: log_start(self, '_gather_9')
        elem = self.expression()
        if elem is not None:
            seq = self._loop0_10()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop1_11(self): # type Optional[Any]
        # _loop1_11: statement
        mark = self._index
        if self._verbose: log_start(self, '_loop1_11')
        children = []
        while True:
            statement = self.statement()
            if not statement:
                break
            children.append(statement)
            mark = self._index
        self._index = mark
        return children

    def _loop0_13(self): # type Optional[Any]
        # _loop0_13: ';' simple_stmt
        mark = self._index
        if self._verbose: log_start(self, '_loop0_13')
        children = []
        while True:
            literal = self.expect_type(13)
            if not literal:
                break
            elem = self.simple_stmt()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_12(self): # type Optional[Any]
        # _gather_12: simple_stmt _loop0_13
        mark = self._index
        if self._verbose: log_start(self, '_gather_12')
        elem = self.simple_stmt()
        if elem is not None:
            seq = self._loop0_13()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_14(self): # type Optional[Any]
        # _tmp_14: 'import' | 'from'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_14')
        literal = self.expect_type(512)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(513)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_15(self): # type Optional[Any]
        # _tmp_15: 'def' | '@' | ASYNC
        mark = self._index
        if self._verbose: log_start(self, '_tmp_15')
        literal = self.expect_type(515)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(50)
        if literal:
            return literal
        self._index = mark
        _async = self.expect_type(58)
        if _async:
            return _async
        self._index = mark
        return None

    def _tmp_16(self): # type Optional[Any]
        # _tmp_16: 'class' | '@'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_16')
        literal = self.expect_type(514)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(50)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_17(self): # type Optional[Any]
        # _tmp_17: 'with' | ASYNC
        mark = self._index
        if self._verbose: log_start(self, '_tmp_17')
        literal = self.expect_type(520)
        if literal:
            return literal
        self._index = mark
        _async = self.expect_type(58)
        if _async:
            return _async
        self._index = mark
        return None

    def _tmp_18(self): # type Optional[Any]
        # _tmp_18: 'for' | ASYNC
        mark = self._index
        if self._verbose: log_start(self, '_tmp_18')
        literal = self.expect_type(518)
        if literal:
            return literal
        self._index = mark
        _async = self.expect_type(58)
        if _async:
            return _async
        self._index = mark
        return None

    def _tmp_19(self): # type Optional[Any]
        # _tmp_19: '=' annotated_rhs
        mark = self._index
        if self._verbose: log_start(self, '_tmp_19')
        literal = self.expect_type(22)
        if literal:
            d = self.annotated_rhs()
            if d:
                return d
        self._index = mark
        return None

    def _tmp_20(self): # type Optional[Any]
        # _tmp_20: '(' single_target ')' | single_subscript_attribute_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_20')
        literal = self.expect_type(7)
        if literal:
            b = self.single_target()
            if b:
                literal_1 = self.expect_type(8)
                if literal_1:
                    return b
        self._index = mark
        single_subscript_attribute_target = self.single_subscript_attribute_target()
        if single_subscript_attribute_target:
            return single_subscript_attribute_target
        self._index = mark
        return None

    def _tmp_21(self): # type Optional[Any]
        # _tmp_21: '=' annotated_rhs
        mark = self._index
        if self._verbose: log_start(self, '_tmp_21')
        literal = self.expect_type(22)
        if literal:
            d = self.annotated_rhs()
            if d:
                return d
        self._index = mark
        return None

    def _loop1_22(self): # type Optional[Any]
        # _loop1_22: (star_targets '=')
        mark = self._index
        if self._verbose: log_start(self, '_loop1_22')
        children = []
        while True:
            _tmp_218 = self._tmp_218()
            if not _tmp_218:
                break
            children.append(_tmp_218)
            mark = self._index
        self._index = mark
        return children

    def _tmp_23(self): # type Optional[Any]
        # _tmp_23: yield_expr | star_expressions
        mark = self._index
        if self._verbose: log_start(self, '_tmp_23')
        yield_expr = self.yield_expr()
        if yield_expr:
            return yield_expr
        self._index = mark
        star_expressions = self.star_expressions()
        if star_expressions:
            return star_expressions
        self._index = mark
        return None

    def _tmp_24(self): # type Optional[Any]
        # _tmp_24: yield_expr | star_expressions
        mark = self._index
        if self._verbose: log_start(self, '_tmp_24')
        yield_expr = self.yield_expr()
        if yield_expr:
            return yield_expr
        self._index = mark
        star_expressions = self.star_expressions()
        if star_expressions:
            return star_expressions
        self._index = mark
        return None

    def _tmp_25(self): # type Optional[Any]
        # _tmp_25: 'from' expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_25')
        literal = self.expect_type(513)
        if literal:
            z = self.expression()
            if z:
                return z
        self._index = mark
        return None

    def _loop0_27(self): # type Optional[Any]
        # _loop0_27: ',' NAME
        mark = self._index
        if self._verbose: log_start(self, '_loop0_27')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.name()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_26(self): # type Optional[Any]
        # _gather_26: NAME _loop0_27
        mark = self._index
        if self._verbose: log_start(self, '_gather_26')
        elem = self.name()
        if elem is not None:
            seq = self._loop0_27()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_29(self): # type Optional[Any]
        # _loop0_29: ',' NAME
        mark = self._index
        if self._verbose: log_start(self, '_loop0_29')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.name()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_28(self): # type Optional[Any]
        # _gather_28: NAME _loop0_29
        mark = self._index
        if self._verbose: log_start(self, '_gather_28')
        elem = self.name()
        if elem is not None:
            seq = self._loop0_29()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_30(self): # type Optional[Any]
        # _tmp_30: ';' | NEWLINE
        mark = self._index
        if self._verbose: log_start(self, '_tmp_30')
        literal = self.expect_type(13)
        if literal:
            return literal
        self._index = mark
        _newline = self.expect_type(4)
        if _newline:
            return _newline
        self._index = mark
        return None

    def _tmp_31(self): # type Optional[Any]
        # _tmp_31: ',' expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_31')
        literal = self.expect_type(12)
        if literal:
            z = self.expression()
            if z:
                return z
        self._index = mark
        return None

    def _loop0_32(self): # type Optional[Any]
        # _loop0_32: ('.' | '...')
        mark = self._index
        if self._verbose: log_start(self, '_loop0_32')
        children = []
        while True:
            _tmp_219 = self._tmp_219()
            if not _tmp_219:
                break
            children.append(_tmp_219)
            mark = self._index
        self._index = mark
        return children

    def _loop1_33(self): # type Optional[Any]
        # _loop1_33: ('.' | '...')
        mark = self._index
        if self._verbose: log_start(self, '_loop1_33')
        children = []
        while True:
            _tmp_220 = self._tmp_220()
            if not _tmp_220:
                break
            children.append(_tmp_220)
            mark = self._index
        self._index = mark
        return children

    def _loop0_35(self): # type Optional[Any]
        # _loop0_35: ',' import_from_as_name
        mark = self._index
        if self._verbose: log_start(self, '_loop0_35')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.import_from_as_name()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_34(self): # type Optional[Any]
        # _gather_34: import_from_as_name _loop0_35
        mark = self._index
        if self._verbose: log_start(self, '_gather_34')
        elem = self.import_from_as_name()
        if elem is not None:
            seq = self._loop0_35()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_36(self): # type Optional[Any]
        # _tmp_36: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_36')
        literal = self.expect_type(521)
        if literal:
            z = self.name()
            if z:
                return z
        self._index = mark
        return None

    def _loop0_38(self): # type Optional[Any]
        # _loop0_38: ',' dotted_as_name
        mark = self._index
        if self._verbose: log_start(self, '_loop0_38')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.dotted_as_name()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_37(self): # type Optional[Any]
        # _gather_37: dotted_as_name _loop0_38
        mark = self._index
        if self._verbose: log_start(self, '_gather_37')
        elem = self.dotted_as_name()
        if elem is not None:
            seq = self._loop0_38()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_39(self): # type Optional[Any]
        # _tmp_39: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_39')
        literal = self.expect_type(521)
        if literal:
            z = self.name()
            if z:
                return z
        self._index = mark
        return None

    def _loop1_40(self): # type Optional[Any]
        # _loop1_40: decorator
        mark = self._index
        if self._verbose: log_start(self, '_loop1_40')
        children = []
        while True:
            decorator = self.decorator()
            if not decorator:
                break
            children.append(decorator)
            mark = self._index
        self._index = mark
        return children

    def _tmp_41(self): # type Optional[Any]
        # _tmp_41: '@' dec_maybe_call NEWLINE
        mark = self._index
        if self._verbose: log_start(self, '_tmp_41')
        literal = self.expect_type(50)
        if literal:
            f = self.dec_maybe_call()
            if f:
                _newline = self.expect_type(4)
                if _newline:
                    return f
        self._index = mark
        return None

    def _tmp_42(self): # type Optional[Any]
        # _tmp_42: '@' named_expression NEWLINE
        mark = self._index
        if self._verbose: log_start(self, '_tmp_42')
        literal = self.expect_type(50)
        if literal:
            f = self.named_expression()
            if f:
                _newline = self.expect_type(4)
                if _newline:
                    return f
        self._index = mark
        return None

    def _tmp_43(self): # type Optional[Any]
        # _tmp_43: '(' arguments? ')'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_43')
        literal = self.expect_type(7)
        if literal:
            z = self.arguments()
            literal_1 = self.expect_type(8)
            if literal_1:
                return z
        self._index = mark
        return None

    def _tmp_44(self): # type Optional[Any]
        # _tmp_44: '->' expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_44')
        literal = self.expect_type(52)
        if literal:
            z = self.expression()
            if z:
                return z
        self._index = mark
        return None

    def _tmp_45(self): # type Optional[Any]
        # _tmp_45: '->' expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_45')
        literal = self.expect_type(52)
        if literal:
            z = self.expression()
            if z:
                return z
        self._index = mark
        return None

    def _tmp_46(self): # type Optional[Any]
        # _tmp_46: NEWLINE INDENT
        mark = self._index
        if self._verbose: log_start(self, '_tmp_46')
        _newline = self.expect_type(4)
        if _newline:
            _indent = self.expect_type(5)
            if _indent:
                return self.dummy_name()
        self._index = mark
        return None

    def _loop0_47(self): # type Optional[Any]
        # _loop0_47: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_47')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_48(self): # type Optional[Any]
        # _loop0_48: param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_48')
        children = []
        while True:
            param_with_default = self.param_with_default()
            if not param_with_default:
                break
            children.append(param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_49(self): # type Optional[Any]
        # _loop0_49: param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_49')
        children = []
        while True:
            param_with_default = self.param_with_default()
            if not param_with_default:
                break
            children.append(param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_50(self): # type Optional[Any]
        # _loop1_50: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_50')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_51(self): # type Optional[Any]
        # _loop0_51: param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_51')
        children = []
        while True:
            param_with_default = self.param_with_default()
            if not param_with_default:
                break
            children.append(param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_52(self): # type Optional[Any]
        # _loop1_52: param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_52')
        children = []
        while True:
            param_with_default = self.param_with_default()
            if not param_with_default:
                break
            children.append(param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_53(self): # type Optional[Any]
        # _loop1_53: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_53')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_54(self): # type Optional[Any]
        # _loop1_54: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_54')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_55(self): # type Optional[Any]
        # _loop0_55: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_55')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_56(self): # type Optional[Any]
        # _loop1_56: param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_56')
        children = []
        while True:
            param_with_default = self.param_with_default()
            if not param_with_default:
                break
            children.append(param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_57(self): # type Optional[Any]
        # _loop0_57: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_57')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_58(self): # type Optional[Any]
        # _loop1_58: param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_58')
        children = []
        while True:
            param_with_default = self.param_with_default()
            if not param_with_default:
                break
            children.append(param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_59(self): # type Optional[Any]
        # _loop0_59: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_59')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_60(self): # type Optional[Any]
        # _loop0_60: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_60')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_61(self): # type Optional[Any]
        # _loop1_61: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_61')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_63(self): # type Optional[Any]
        # _loop0_63: ',' with_item
        mark = self._index
        if self._verbose: log_start(self, '_loop0_63')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.with_item()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_62(self): # type Optional[Any]
        # _gather_62: with_item _loop0_63
        mark = self._index
        if self._verbose: log_start(self, '_gather_62')
        elem = self.with_item()
        if elem is not None:
            seq = self._loop0_63()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_65(self): # type Optional[Any]
        # _loop0_65: ',' with_item
        mark = self._index
        if self._verbose: log_start(self, '_loop0_65')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.with_item()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_64(self): # type Optional[Any]
        # _gather_64: with_item _loop0_65
        mark = self._index
        if self._verbose: log_start(self, '_gather_64')
        elem = self.with_item()
        if elem is not None:
            seq = self._loop0_65()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_67(self): # type Optional[Any]
        # _loop0_67: ',' with_item
        mark = self._index
        if self._verbose: log_start(self, '_loop0_67')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.with_item()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_66(self): # type Optional[Any]
        # _gather_66: with_item _loop0_67
        mark = self._index
        if self._verbose: log_start(self, '_gather_66')
        elem = self.with_item()
        if elem is not None:
            seq = self._loop0_67()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_69(self): # type Optional[Any]
        # _loop0_69: ',' with_item
        mark = self._index
        if self._verbose: log_start(self, '_loop0_69')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.with_item()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_68(self): # type Optional[Any]
        # _gather_68: with_item _loop0_69
        mark = self._index
        if self._verbose: log_start(self, '_gather_68')
        elem = self.with_item()
        if elem is not None:
            seq = self._loop0_69()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_70(self): # type Optional[Any]
        # _tmp_70: ',' | ')' | ':'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_70')
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(8)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(11)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop1_71(self): # type Optional[Any]
        # _loop1_71: except_block
        mark = self._index
        if self._verbose: log_start(self, '_loop1_71')
        children = []
        while True:
            except_block = self.except_block()
            if not except_block:
                break
            children.append(except_block)
            mark = self._index
        self._index = mark
        return children

    def _loop1_72(self): # type Optional[Any]
        # _loop1_72: except_star_block
        mark = self._index
        if self._verbose: log_start(self, '_loop1_72')
        children = []
        while True:
            except_star_block = self.except_star_block()
            if not except_star_block:
                break
            children.append(except_star_block)
            mark = self._index
        self._index = mark
        return children

    def _tmp_73(self): # type Optional[Any]
        # _tmp_73: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_73')
        literal = self.expect_type(521)
        if literal:
            z = self.name()
            if z:
                return z
        self._index = mark
        return None

    def _tmp_74(self): # type Optional[Any]
        # _tmp_74: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_74')
        literal = self.expect_type(521)
        if literal:
            z = self.name()
            if z:
                return z
        self._index = mark
        return None

    def _loop1_75(self): # type Optional[Any]
        # _loop1_75: case_block
        mark = self._index
        if self._verbose: log_start(self, '_loop1_75')
        children = []
        while True:
            case_block = self.case_block()
            if not case_block:
                break
            children.append(case_block)
            mark = self._index
        self._index = mark
        return children

    def _loop0_77(self): # type Optional[Any]
        # _loop0_77: '|' closed_pattern
        mark = self._index
        if self._verbose: log_start(self, '_loop0_77')
        children = []
        while True:
            literal = self.expect_type(18)
            if not literal:
                break
            elem = self.closed_pattern()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_76(self): # type Optional[Any]
        # _gather_76: closed_pattern _loop0_77
        mark = self._index
        if self._verbose: log_start(self, '_gather_76')
        elem = self.closed_pattern()
        if elem is not None:
            seq = self._loop0_77()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_78(self): # type Optional[Any]
        # _tmp_78: '+' | '-'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_78')
        literal = self.expect_type(14)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(15)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_79(self): # type Optional[Any]
        # _tmp_79: '+' | '-'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_79')
        literal = self.expect_type(14)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(15)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_80(self): # type Optional[Any]
        # _tmp_80: '.' | '(' | '='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_80')
        literal = self.expect_type(23)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(22)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_81(self): # type Optional[Any]
        # _tmp_81: '.' | '(' | '='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_81')
        literal = self.expect_type(23)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(22)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop0_83(self): # type Optional[Any]
        # _loop0_83: ',' maybe_star_pattern
        mark = self._index
        if self._verbose: log_start(self, '_loop0_83')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.maybe_star_pattern()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_82(self): # type Optional[Any]
        # _gather_82: maybe_star_pattern _loop0_83
        mark = self._index
        if self._verbose: log_start(self, '_gather_82')
        elem = self.maybe_star_pattern()
        if elem is not None:
            seq = self._loop0_83()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_85(self): # type Optional[Any]
        # _loop0_85: ',' key_value_pattern
        mark = self._index
        if self._verbose: log_start(self, '_loop0_85')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.key_value_pattern()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_84(self): # type Optional[Any]
        # _gather_84: key_value_pattern _loop0_85
        mark = self._index
        if self._verbose: log_start(self, '_gather_84')
        elem = self.key_value_pattern()
        if elem is not None:
            seq = self._loop0_85()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_86(self): # type Optional[Any]
        # _tmp_86: literal_expr | attr
        mark = self._index
        if self._verbose: log_start(self, '_tmp_86')
        literal_expr = self.literal_expr()
        if literal_expr:
            return literal_expr
        self._index = mark
        attr = self.attr()
        if attr:
            return attr
        self._index = mark
        return None

    def _loop0_88(self): # type Optional[Any]
        # _loop0_88: ',' pattern
        mark = self._index
        if self._verbose: log_start(self, '_loop0_88')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.pattern()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_87(self): # type Optional[Any]
        # _gather_87: pattern _loop0_88
        mark = self._index
        if self._verbose: log_start(self, '_gather_87')
        elem = self.pattern()
        if elem is not None:
            seq = self._loop0_88()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_90(self): # type Optional[Any]
        # _loop0_90: ',' keyword_pattern
        mark = self._index
        if self._verbose: log_start(self, '_loop0_90')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.keyword_pattern()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_89(self): # type Optional[Any]
        # _gather_89: keyword_pattern _loop0_90
        mark = self._index
        if self._verbose: log_start(self, '_gather_89')
        elem = self.keyword_pattern()
        if elem is not None:
            seq = self._loop0_90()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop1_91(self): # type Optional[Any]
        # _loop1_91: (',' star_expression)
        mark = self._index
        if self._verbose: log_start(self, '_loop1_91')
        children = []
        while True:
            _tmp_221 = self._tmp_221()
            if not _tmp_221:
                break
            children.append(_tmp_221)
            mark = self._index
        self._index = mark
        return children

    def _loop0_93(self): # type Optional[Any]
        # _loop0_93: ',' star_named_expression
        mark = self._index
        if self._verbose: log_start(self, '_loop0_93')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.star_named_expression()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_92(self): # type Optional[Any]
        # _gather_92: star_named_expression _loop0_93
        mark = self._index
        if self._verbose: log_start(self, '_gather_92')
        elem = self.star_named_expression()
        if elem is not None:
            seq = self._loop0_93()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop1_94(self): # type Optional[Any]
        # _loop1_94: (',' expression)
        mark = self._index
        if self._verbose: log_start(self, '_loop1_94')
        children = []
        while True:
            _tmp_222 = self._tmp_222()
            if not _tmp_222:
                break
            children.append(_tmp_222)
            mark = self._index
        self._index = mark
        return children

    def _loop1_95(self): # type Optional[Any]
        # _loop1_95: ('or' conjunction)
        mark = self._index
        if self._verbose: log_start(self, '_loop1_95')
        children = []
        while True:
            _tmp_223 = self._tmp_223()
            if not _tmp_223:
                break
            children.append(_tmp_223)
            mark = self._index
        self._index = mark
        return children

    def _loop1_96(self): # type Optional[Any]
        # _loop1_96: ('and' inversion)
        mark = self._index
        if self._verbose: log_start(self, '_loop1_96')
        children = []
        while True:
            _tmp_224 = self._tmp_224()
            if not _tmp_224:
                break
            children.append(_tmp_224)
            mark = self._index
        self._index = mark
        return children

    def _loop1_97(self): # type Optional[Any]
        # _loop1_97: compare_op_bitwise_or_pair
        mark = self._index
        if self._verbose: log_start(self, '_loop1_97')
        children = []
        while True:
            compare_op_bitwise_or_pair = self.compare_op_bitwise_or_pair()
            if not compare_op_bitwise_or_pair:
                break
            children.append(compare_op_bitwise_or_pair)
            mark = self._index
        self._index = mark
        return children

    def _loop0_99(self): # type Optional[Any]
        # _loop0_99: ',' (slice | starred_expression)
        mark = self._index
        if self._verbose: log_start(self, '_loop0_99')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self._tmp_225()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_98(self): # type Optional[Any]
        # _gather_98: (slice | starred_expression) _loop0_99
        mark = self._index
        if self._verbose: log_start(self, '_gather_98')
        elem = self._tmp_225()
        if elem is not None:
            seq = self._loop0_99()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_100(self): # type Optional[Any]
        # _tmp_100: ':' expression?
        mark = self._index
        if self._verbose: log_start(self, '_tmp_100')
        literal = self.expect_type(11)
        if literal:
            d = self.expression()
            return d
        self._index = mark
        return None

    def _tmp_101(self): # type Optional[Any]
        # _tmp_101: tuple | group | genexp
        mark = self._index
        if self._verbose: log_start(self, '_tmp_101')
        tuple = self.tuple()
        if tuple:
            return tuple
        self._index = mark
        group = self.group()
        if group:
            return group
        self._index = mark
        genexp = self.genexp()
        if genexp:
            return genexp
        self._index = mark
        return None

    def _tmp_102(self): # type Optional[Any]
        # _tmp_102: list | listcomp
        mark = self._index
        if self._verbose: log_start(self, '_tmp_102')
        list = self.list()
        if list:
            return list
        self._index = mark
        listcomp = self.listcomp()
        if listcomp:
            return listcomp
        self._index = mark
        return None

    def _tmp_103(self): # type Optional[Any]
        # _tmp_103: dict | set | dictcomp | setcomp
        mark = self._index
        if self._verbose: log_start(self, '_tmp_103')
        dict = self.dict()
        if dict:
            return dict
        self._index = mark
        set = self.set()
        if set:
            return set
        self._index = mark
        dictcomp = self.dictcomp()
        if dictcomp:
            return dictcomp
        self._index = mark
        setcomp = self.setcomp()
        if setcomp:
            return setcomp
        self._index = mark
        return None

    def _tmp_104(self): # type Optional[Any]
        # _tmp_104: yield_expr | named_expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_104')
        yield_expr = self.yield_expr()
        if yield_expr:
            return yield_expr
        self._index = mark
        named_expression = self.named_expression()
        if named_expression:
            return named_expression
        self._index = mark
        return None

    def _loop0_105(self): # type Optional[Any]
        # _loop0_105: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_105')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_106(self): # type Optional[Any]
        # _loop0_106: lambda_param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_106')
        children = []
        while True:
            lambda_param_with_default = self.lambda_param_with_default()
            if not lambda_param_with_default:
                break
            children.append(lambda_param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_107(self): # type Optional[Any]
        # _loop0_107: lambda_param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_107')
        children = []
        while True:
            lambda_param_with_default = self.lambda_param_with_default()
            if not lambda_param_with_default:
                break
            children.append(lambda_param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_108(self): # type Optional[Any]
        # _loop1_108: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_108')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_109(self): # type Optional[Any]
        # _loop0_109: lambda_param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_109')
        children = []
        while True:
            lambda_param_with_default = self.lambda_param_with_default()
            if not lambda_param_with_default:
                break
            children.append(lambda_param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_110(self): # type Optional[Any]
        # _loop1_110: lambda_param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_110')
        children = []
        while True:
            lambda_param_with_default = self.lambda_param_with_default()
            if not lambda_param_with_default:
                break
            children.append(lambda_param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_111(self): # type Optional[Any]
        # _loop1_111: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_111')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_112(self): # type Optional[Any]
        # _loop1_112: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_112')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_113(self): # type Optional[Any]
        # _loop0_113: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_113')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_114(self): # type Optional[Any]
        # _loop1_114: lambda_param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_114')
        children = []
        while True:
            lambda_param_with_default = self.lambda_param_with_default()
            if not lambda_param_with_default:
                break
            children.append(lambda_param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_115(self): # type Optional[Any]
        # _loop0_115: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_115')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_116(self): # type Optional[Any]
        # _loop1_116: lambda_param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_116')
        children = []
        while True:
            lambda_param_with_default = self.lambda_param_with_default()
            if not lambda_param_with_default:
                break
            children.append(lambda_param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_117(self): # type Optional[Any]
        # _loop0_117: lambda_param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_117')
        children = []
        while True:
            lambda_param_maybe_default = self.lambda_param_maybe_default()
            if not lambda_param_maybe_default:
                break
            children.append(lambda_param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_118(self): # type Optional[Any]
        # _loop1_118: lambda_param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_118')
        children = []
        while True:
            lambda_param_maybe_default = self.lambda_param_maybe_default()
            if not lambda_param_maybe_default:
                break
            children.append(lambda_param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_119(self): # type Optional[Any]
        # _loop1_119: STRING
        mark = self._index
        if self._verbose: log_start(self, '_loop1_119')
        children = []
        while True:
            string = self.string()
            if not string:
                break
            children.append(string)
            mark = self._index
        self._index = mark
        return children

    def _tmp_120(self): # type Optional[Any]
        # _tmp_120: star_named_expression ',' star_named_expressions?
        mark = self._index
        if self._verbose: log_start(self, '_tmp_120')
        y = self.star_named_expression()
        if y:
            literal = self.expect_type(12)
            if literal:
                z = self.star_named_expressions()
                return [y] + ( z or [] )
        self._index = mark
        return None

    def _loop0_122(self): # type Optional[Any]
        # _loop0_122: ',' double_starred_kvpair
        mark = self._index
        if self._verbose: log_start(self, '_loop0_122')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.double_starred_kvpair()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_121(self): # type Optional[Any]
        # _gather_121: double_starred_kvpair _loop0_122
        mark = self._index
        if self._verbose: log_start(self, '_gather_121')
        elem = self.double_starred_kvpair()
        if elem is not None:
            seq = self._loop0_122()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop1_123(self): # type Optional[Any]
        # _loop1_123: for_if_clause
        mark = self._index
        if self._verbose: log_start(self, '_loop1_123')
        children = []
        while True:
            for_if_clause = self.for_if_clause()
            if not for_if_clause:
                break
            children.append(for_if_clause)
            mark = self._index
        self._index = mark
        return children

    def _loop0_124(self): # type Optional[Any]
        # _loop0_124: ('if' disjunction)
        mark = self._index
        if self._verbose: log_start(self, '_loop0_124')
        children = []
        while True:
            _tmp_226 = self._tmp_226()
            if not _tmp_226:
                break
            children.append(_tmp_226)
            mark = self._index
        self._index = mark
        return children

    def _loop0_125(self): # type Optional[Any]
        # _loop0_125: ('if' disjunction)
        mark = self._index
        if self._verbose: log_start(self, '_loop0_125')
        children = []
        while True:
            _tmp_227 = self._tmp_227()
            if not _tmp_227:
                break
            children.append(_tmp_227)
            mark = self._index
        self._index = mark
        return children

    def _tmp_126(self): # type Optional[Any]
        # _tmp_126: assignment_expression | expression !':='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_126')
        assignment_expression = self.assignment_expression()
        if assignment_expression:
            return assignment_expression
        self._index = mark
        expression = self.expression()
        if expression:
            if self.negative_lookahead(PythonParser.expect_type, 54):
                return expression
        self._index = mark
        return None

    def _loop0_128(self): # type Optional[Any]
        # _loop0_128: ',' (starred_expression | (assignment_expression | expression !':=') !'=')
        mark = self._index
        if self._verbose: log_start(self, '_loop0_128')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self._tmp_228()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_127(self): # type Optional[Any]
        # _gather_127: (starred_expression | (assignment_expression | expression !':=') !'=') _loop0_128
        mark = self._index
        if self._verbose: log_start(self, '_gather_127')
        elem = self._tmp_228()
        if elem is not None:
            seq = self._loop0_128()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_129(self): # type Optional[Any]
        # _tmp_129: ',' kwargs
        mark = self._index
        if self._verbose: log_start(self, '_tmp_129')
        literal = self.expect_type(12)
        if literal:
            k = self.kwargs()
            if k:
                return k
        self._index = mark
        return None

    def _loop0_131(self): # type Optional[Any]
        # _loop0_131: ',' kwarg_or_starred
        mark = self._index
        if self._verbose: log_start(self, '_loop0_131')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.kwarg_or_starred()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_130(self): # type Optional[Any]
        # _gather_130: kwarg_or_starred _loop0_131
        mark = self._index
        if self._verbose: log_start(self, '_gather_130')
        elem = self.kwarg_or_starred()
        if elem is not None:
            seq = self._loop0_131()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_133(self): # type Optional[Any]
        # _loop0_133: ',' kwarg_or_double_starred
        mark = self._index
        if self._verbose: log_start(self, '_loop0_133')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.kwarg_or_double_starred()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_132(self): # type Optional[Any]
        # _gather_132: kwarg_or_double_starred _loop0_133
        mark = self._index
        if self._verbose: log_start(self, '_gather_132')
        elem = self.kwarg_or_double_starred()
        if elem is not None:
            seq = self._loop0_133()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_135(self): # type Optional[Any]
        # _loop0_135: ',' kwarg_or_starred
        mark = self._index
        if self._verbose: log_start(self, '_loop0_135')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.kwarg_or_starred()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_134(self): # type Optional[Any]
        # _gather_134: kwarg_or_starred _loop0_135
        mark = self._index
        if self._verbose: log_start(self, '_gather_134')
        elem = self.kwarg_or_starred()
        if elem is not None:
            seq = self._loop0_135()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_137(self): # type Optional[Any]
        # _loop0_137: ',' kwarg_or_double_starred
        mark = self._index
        if self._verbose: log_start(self, '_loop0_137')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.kwarg_or_double_starred()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_136(self): # type Optional[Any]
        # _gather_136: kwarg_or_double_starred _loop0_137
        mark = self._index
        if self._verbose: log_start(self, '_gather_136')
        elem = self.kwarg_or_double_starred()
        if elem is not None:
            seq = self._loop0_137()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_138(self): # type Optional[Any]
        # _loop0_138: (',' star_target)
        mark = self._index
        if self._verbose: log_start(self, '_loop0_138')
        children = []
        while True:
            _tmp_229 = self._tmp_229()
            if not _tmp_229:
                break
            children.append(_tmp_229)
            mark = self._index
        self._index = mark
        return children

    def _loop0_140(self): # type Optional[Any]
        # _loop0_140: ',' star_target
        mark = self._index
        if self._verbose: log_start(self, '_loop0_140')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.star_target()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_139(self): # type Optional[Any]
        # _gather_139: star_target _loop0_140
        mark = self._index
        if self._verbose: log_start(self, '_gather_139')
        elem = self.star_target()
        if elem is not None:
            seq = self._loop0_140()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop1_141(self): # type Optional[Any]
        # _loop1_141: (',' star_target)
        mark = self._index
        if self._verbose: log_start(self, '_loop1_141')
        children = []
        while True:
            _tmp_230 = self._tmp_230()
            if not _tmp_230:
                break
            children.append(_tmp_230)
            mark = self._index
        self._index = mark
        return children

    def _tmp_142(self): # type Optional[Any]
        # _tmp_142: !'*' star_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_142')
        if self.negative_lookahead(PythonParser.expect_type, 16):
            star_target = self.star_target()
            if star_target:
                return star_target
        self._index = mark
        return None

    def _loop0_144(self): # type Optional[Any]
        # _loop0_144: ',' del_target
        mark = self._index
        if self._verbose: log_start(self, '_loop0_144')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.del_target()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_143(self): # type Optional[Any]
        # _gather_143: del_target _loop0_144
        mark = self._index
        if self._verbose: log_start(self, '_gather_143')
        elem = self.del_target()
        if elem is not None:
            seq = self._loop0_144()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_145(self): # type Optional[Any]
        # _tmp_145: args | expression for_if_clauses
        mark = self._index
        if self._verbose: log_start(self, '_tmp_145')
        args = self.args()
        if args:
            return args
        self._index = mark
        expression = self.expression()
        if expression:
            for_if_clauses = self.for_if_clauses()
            if for_if_clauses:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_146(self): # type Optional[Any]
        # _tmp_146: NAME '='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_146')
        name = self.name()
        if name:
            literal = self.expect_type(22)
            if literal:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_147(self): # type Optional[Any]
        # _tmp_147: NAME STRING | SOFT_KEYWORD
        mark = self._index
        if self._verbose: log_start(self, '_tmp_147')
        name = self.name()
        if name:
            string = self.string()
            if string:
                return self.dummy_name()
        self._index = mark
        soft_keyword = self.soft_keyword()
        if soft_keyword:
            return soft_keyword
        self._index = mark
        return None

    def _tmp_148(self): # type Optional[Any]
        # _tmp_148: 'else' | ':'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_148')
        literal = self.expect_type(517)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(11)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_149(self): # type Optional[Any]
        # _tmp_149: '=' | ':='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_149')
        literal = self.expect_type(22)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(54)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_150(self): # type Optional[Any]
        # _tmp_150: list | tuple | genexp | 'True' | 'None' | 'False'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_150')
        list = self.list()
        if list:
            return list
        self._index = mark
        tuple = self.tuple()
        if tuple:
            return tuple
        self._index = mark
        genexp = self.genexp()
        if genexp:
            return genexp
        self._index = mark
        literal = self.expect_type(525)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(524)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(526)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_151(self): # type Optional[Any]
        # _tmp_151: '=' | ':='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_151')
        literal = self.expect_type(22)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(54)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop0_152(self): # type Optional[Any]
        # _loop0_152: star_named_expressions
        mark = self._index
        if self._verbose: log_start(self, '_loop0_152')
        children = []
        while True:
            star_named_expressions = self.star_named_expressions()
            if not star_named_expressions:
                break
            children.append(star_named_expressions)
            mark = self._index
        self._index = mark
        return children

    def _loop0_153(self): # type Optional[Any]
        # _loop0_153: (star_targets '=')
        mark = self._index
        if self._verbose: log_start(self, '_loop0_153')
        children = []
        while True:
            _tmp_231 = self._tmp_231()
            if not _tmp_231:
                break
            children.append(_tmp_231)
            mark = self._index
        self._index = mark
        return children

    def _loop0_154(self): # type Optional[Any]
        # _loop0_154: (star_targets '=')
        mark = self._index
        if self._verbose: log_start(self, '_loop0_154')
        children = []
        while True:
            _tmp_232 = self._tmp_232()
            if not _tmp_232:
                break
            children.append(_tmp_232)
            mark = self._index
        self._index = mark
        return children

    def _tmp_155(self): # type Optional[Any]
        # _tmp_155: yield_expr | star_expressions
        mark = self._index
        if self._verbose: log_start(self, '_tmp_155')
        yield_expr = self.yield_expr()
        if yield_expr:
            return yield_expr
        self._index = mark
        star_expressions = self.star_expressions()
        if star_expressions:
            return star_expressions
        self._index = mark
        return None

    def _tmp_156(self): # type Optional[Any]
        # _tmp_156: '[' | '(' | '{'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_156')
        literal = self.expect_type(9)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(7)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(26)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_157(self): # type Optional[Any]
        # _tmp_157: '[' | '{'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_157')
        literal = self.expect_type(9)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(26)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_158(self): # type Optional[Any]
        # _tmp_158: '[' | '{'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_158')
        literal = self.expect_type(9)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(26)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop0_159(self): # type Optional[Any]
        # _loop0_159: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_159')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_160(self): # type Optional[Any]
        # _loop0_160: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_160')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_161(self): # type Optional[Any]
        # _loop1_161: param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_161')
        children = []
        while True:
            param_no_default = self.param_no_default()
            if not param_no_default:
                break
            children.append(param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_162(self): # type Optional[Any]
        # _tmp_162: slash_no_default | slash_with_default
        mark = self._index
        if self._verbose: log_start(self, '_tmp_162')
        slash_no_default = self.slash_no_default()
        if slash_no_default:
            return slash_no_default
        self._index = mark
        slash_with_default = self.slash_with_default()
        if slash_with_default:
            return slash_with_default
        self._index = mark
        return None

    def _loop0_163(self): # type Optional[Any]
        # _loop0_163: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_163')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_164(self): # type Optional[Any]
        # _tmp_164: slash_no_default | slash_with_default
        mark = self._index
        if self._verbose: log_start(self, '_tmp_164')
        slash_no_default = self.slash_no_default()
        if slash_no_default:
            return slash_no_default
        self._index = mark
        slash_with_default = self.slash_with_default()
        if slash_with_default:
            return slash_with_default
        self._index = mark
        return None

    def _loop0_165(self): # type Optional[Any]
        # _loop0_165: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_165')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_166(self): # type Optional[Any]
        # _tmp_166: ',' | param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_tmp_166')
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        param_no_default = self.param_no_default()
        if param_no_default:
            return param_no_default
        self._index = mark
        return None

    def _loop0_167(self): # type Optional[Any]
        # _loop0_167: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_167')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_168(self): # type Optional[Any]
        # _loop1_168: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_168')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_169(self): # type Optional[Any]
        # _tmp_169: ')' | ','
        mark = self._index
        if self._verbose: log_start(self, '_tmp_169')
        literal = self.expect_type(8)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_170(self): # type Optional[Any]
        # _tmp_170: ')' | ',' (')' | '**')
        mark = self._index
        if self._verbose: log_start(self, '_tmp_170')
        literal = self.expect_type(8)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(12)
        if literal:
            _tmp_233 = self._tmp_233()
            if _tmp_233:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_171(self): # type Optional[Any]
        # _tmp_171: param_no_default | ','
        mark = self._index
        if self._verbose: log_start(self, '_tmp_171')
        param_no_default = self.param_no_default()
        if param_no_default:
            return param_no_default
        self._index = mark
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop0_172(self): # type Optional[Any]
        # _loop0_172: param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_172')
        children = []
        while True:
            param_maybe_default = self.param_maybe_default()
            if not param_maybe_default:
                break
            children.append(param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_173(self): # type Optional[Any]
        # _tmp_173: param_no_default | ','
        mark = self._index
        if self._verbose: log_start(self, '_tmp_173')
        param_no_default = self.param_no_default()
        if param_no_default:
            return param_no_default
        self._index = mark
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_174(self): # type Optional[Any]
        # _tmp_174: '*' | '**' | '/'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_174')
        literal = self.expect_type(16)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(17)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop1_175(self): # type Optional[Any]
        # _loop1_175: param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_175')
        children = []
        while True:
            param_with_default = self.param_with_default()
            if not param_with_default:
                break
            children.append(param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_176(self): # type Optional[Any]
        # _loop0_176: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_176')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_177(self): # type Optional[Any]
        # _loop0_177: lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_177')
        children = []
        while True:
            lambda_param_no_default = self.lambda_param_no_default()
            if not lambda_param_no_default:
                break
            children.append(lambda_param_no_default)
            mark = self._index
        self._index = mark
        return children

    def _loop0_179(self): # type Optional[Any]
        # _loop0_179: ',' lambda_param
        mark = self._index
        if self._verbose: log_start(self, '_loop0_179')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.lambda_param()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_178(self): # type Optional[Any]
        # _gather_178: lambda_param _loop0_179
        mark = self._index
        if self._verbose: log_start(self, '_gather_178')
        elem = self.lambda_param()
        if elem is not None:
            seq = self._loop0_179()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_180(self): # type Optional[Any]
        # _tmp_180: lambda_slash_no_default | lambda_slash_with_default
        mark = self._index
        if self._verbose: log_start(self, '_tmp_180')
        lambda_slash_no_default = self.lambda_slash_no_default()
        if lambda_slash_no_default:
            return lambda_slash_no_default
        self._index = mark
        lambda_slash_with_default = self.lambda_slash_with_default()
        if lambda_slash_with_default:
            return lambda_slash_with_default
        self._index = mark
        return None

    def _loop0_181(self): # type Optional[Any]
        # _loop0_181: lambda_param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_181')
        children = []
        while True:
            lambda_param_maybe_default = self.lambda_param_maybe_default()
            if not lambda_param_maybe_default:
                break
            children.append(lambda_param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_182(self): # type Optional[Any]
        # _tmp_182: lambda_slash_no_default | lambda_slash_with_default
        mark = self._index
        if self._verbose: log_start(self, '_tmp_182')
        lambda_slash_no_default = self.lambda_slash_no_default()
        if lambda_slash_no_default:
            return lambda_slash_no_default
        self._index = mark
        lambda_slash_with_default = self.lambda_slash_with_default()
        if lambda_slash_with_default:
            return lambda_slash_with_default
        self._index = mark
        return None

    def _loop0_183(self): # type Optional[Any]
        # _loop0_183: lambda_param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_183')
        children = []
        while True:
            lambda_param_maybe_default = self.lambda_param_maybe_default()
            if not lambda_param_maybe_default:
                break
            children.append(lambda_param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_184(self): # type Optional[Any]
        # _tmp_184: ',' | lambda_param_no_default
        mark = self._index
        if self._verbose: log_start(self, '_tmp_184')
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        lambda_param_no_default = self.lambda_param_no_default()
        if lambda_param_no_default:
            return lambda_param_no_default
        self._index = mark
        return None

    def _loop0_185(self): # type Optional[Any]
        # _loop0_185: lambda_param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop0_185')
        children = []
        while True:
            lambda_param_maybe_default = self.lambda_param_maybe_default()
            if not lambda_param_maybe_default:
                break
            children.append(lambda_param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_186(self): # type Optional[Any]
        # _loop1_186: lambda_param_maybe_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_186')
        children = []
        while True:
            lambda_param_maybe_default = self.lambda_param_maybe_default()
            if not lambda_param_maybe_default:
                break
            children.append(lambda_param_maybe_default)
            mark = self._index
        self._index = mark
        return children

    def _loop1_187(self): # type Optional[Any]
        # _loop1_187: lambda_param_with_default
        mark = self._index
        if self._verbose: log_start(self, '_loop1_187')
        children = []
        while True:
            lambda_param_with_default = self.lambda_param_with_default()
            if not lambda_param_with_default:
                break
            children.append(lambda_param_with_default)
            mark = self._index
        self._index = mark
        return children

    def _tmp_188(self): # type Optional[Any]
        # _tmp_188: ':' | ',' (':' | '**')
        mark = self._index
        if self._verbose: log_start(self, '_tmp_188')
        literal = self.expect_type(11)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(12)
        if literal:
            _tmp_234 = self._tmp_234()
            if _tmp_234:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_189(self): # type Optional[Any]
        # _tmp_189: '*' | '**' | '/'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_189')
        literal = self.expect_type(16)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(17)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_190(self): # type Optional[Any]
        # _tmp_190: ',' | ')' | ':'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_190')
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(8)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(11)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop0_192(self): # type Optional[Any]
        # _loop0_192: ',' (expression ['as' star_target])
        mark = self._index
        if self._verbose: log_start(self, '_loop0_192')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self._tmp_235()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_191(self): # type Optional[Any]
        # _gather_191: (expression ['as' star_target]) _loop0_192
        mark = self._index
        if self._verbose: log_start(self, '_gather_191')
        elem = self._tmp_235()
        if elem is not None:
            seq = self._loop0_192()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_194(self): # type Optional[Any]
        # _loop0_194: ',' (expressions ['as' star_target])
        mark = self._index
        if self._verbose: log_start(self, '_loop0_194')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self._tmp_236()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_193(self): # type Optional[Any]
        # _gather_193: (expressions ['as' star_target]) _loop0_194
        mark = self._index
        if self._verbose: log_start(self, '_gather_193')
        elem = self._tmp_236()
        if elem is not None:
            seq = self._loop0_194()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_196(self): # type Optional[Any]
        # _loop0_196: ',' (expression ['as' star_target])
        mark = self._index
        if self._verbose: log_start(self, '_loop0_196')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self._tmp_237()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_195(self): # type Optional[Any]
        # _gather_195: (expression ['as' star_target]) _loop0_196
        mark = self._index
        if self._verbose: log_start(self, '_gather_195')
        elem = self._tmp_237()
        if elem is not None:
            seq = self._loop0_196()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _loop0_198(self): # type Optional[Any]
        # _loop0_198: ',' (expressions ['as' star_target])
        mark = self._index
        if self._verbose: log_start(self, '_loop0_198')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self._tmp_238()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_197(self): # type Optional[Any]
        # _gather_197: (expressions ['as' star_target]) _loop0_198
        mark = self._index
        if self._verbose: log_start(self, '_gather_197')
        elem = self._tmp_238()
        if elem is not None:
            seq = self._loop0_198()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_199(self): # type Optional[Any]
        # _tmp_199: 'except' | 'finally'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_199')
        literal = self.expect_type(522)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(523)
        if literal:
            return literal
        self._index = mark
        return None

    def _loop0_200(self): # type Optional[Any]
        # _loop0_200: block
        mark = self._index
        if self._verbose: log_start(self, '_loop0_200')
        children = []
        while True:
            block = self.block()
            if not block:
                break
            children.append(block)
            mark = self._index
        self._index = mark
        return children

    def _loop1_201(self): # type Optional[Any]
        # _loop1_201: except_block
        mark = self._index
        if self._verbose: log_start(self, '_loop1_201')
        children = []
        while True:
            except_block = self.except_block()
            if not except_block:
                break
            children.append(except_block)
            mark = self._index
        self._index = mark
        return children

    def _tmp_202(self): # type Optional[Any]
        # _tmp_202: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_202')
        literal = self.expect_type(521)
        if literal:
            name = self.name()
            if name:
                return self.dummy_name()
        self._index = mark
        return None

    def _loop0_203(self): # type Optional[Any]
        # _loop0_203: block
        mark = self._index
        if self._verbose: log_start(self, '_loop0_203')
        children = []
        while True:
            block = self.block()
            if not block:
                break
            children.append(block)
            mark = self._index
        self._index = mark
        return children

    def _loop1_204(self): # type Optional[Any]
        # _loop1_204: except_star_block
        mark = self._index
        if self._verbose: log_start(self, '_loop1_204')
        children = []
        while True:
            except_star_block = self.except_star_block()
            if not except_star_block:
                break
            children.append(except_star_block)
            mark = self._index
        self._index = mark
        return children

    def _tmp_205(self): # type Optional[Any]
        # _tmp_205: expression ['as' NAME]
        mark = self._index
        if self._verbose: log_start(self, '_tmp_205')
        expression = self.expression()
        if expression:
            opt = self._tmp_239()
            return self.dummy_name()
        self._index = mark
        return None

    def _tmp_206(self): # type Optional[Any]
        # _tmp_206: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_206')
        literal = self.expect_type(521)
        if literal:
            name = self.name()
            if name:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_207(self): # type Optional[Any]
        # _tmp_207: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_207')
        literal = self.expect_type(521)
        if literal:
            name = self.name()
            if name:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_208(self): # type Optional[Any]
        # _tmp_208: NEWLINE | ':'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_208')
        _newline = self.expect_type(4)
        if _newline:
            return _newline
        self._index = mark
        literal = self.expect_type(11)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_209(self): # type Optional[Any]
        # _tmp_209: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_209')
        literal = self.expect_type(521)
        if literal:
            name = self.name()
            if name:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_210(self): # type Optional[Any]
        # _tmp_210: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_210')
        literal = self.expect_type(521)
        if literal:
            name = self.name()
            if name:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_211(self): # type Optional[Any]
        # _tmp_211: positional_patterns ','
        mark = self._index
        if self._verbose: log_start(self, '_tmp_211')
        positional_patterns = self.positional_patterns()
        if positional_patterns:
            literal = self.expect_type(12)
            if literal:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_212(self): # type Optional[Any]
        # _tmp_212: '->' expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_212')
        literal = self.expect_type(52)
        if literal:
            expression = self.expression()
            if expression:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_213(self): # type Optional[Any]
        # _tmp_213: '(' arguments? ')'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_213')
        literal = self.expect_type(7)
        if literal:
            opt = self.arguments()
            literal_1 = self.expect_type(8)
            if literal_1:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_214(self): # type Optional[Any]
        # _tmp_214: '(' arguments? ')'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_214')
        literal = self.expect_type(7)
        if literal:
            opt = self.arguments()
            literal_1 = self.expect_type(8)
            if literal_1:
                return self.dummy_name()
        self._index = mark
        return None

    def _loop0_216(self): # type Optional[Any]
        # _loop0_216: ',' double_starred_kvpair
        mark = self._index
        if self._verbose: log_start(self, '_loop0_216')
        children = []
        while True:
            literal = self.expect_type(12)
            if not literal:
                break
            elem = self.double_starred_kvpair()
            if not elem:
                break
            children.append(elem)
            mark = self._index
        self._index = mark
        return children

    def _gather_215(self): # type Optional[Any]
        # _gather_215: double_starred_kvpair _loop0_216
        mark = self._index
        if self._verbose: log_start(self, '_gather_215')
        elem = self.double_starred_kvpair()
        if elem is not None:
            seq = self._loop0_216()
            if seq is not None:
                return [elem] + seq
        self._index = mark
        return None

    def _tmp_217(self): # type Optional[Any]
        # _tmp_217: '}' | ','
        mark = self._index
        if self._verbose: log_start(self, '_tmp_217')
        literal = self.expect_type(27)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(12)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_218(self): # type Optional[Any]
        # _tmp_218: star_targets '='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_218')
        z = self.star_targets()
        if z:
            literal = self.expect_type(22)
            if literal:
                return z
        self._index = mark
        return None

    def _tmp_219(self): # type Optional[Any]
        # _tmp_219: '.' | '...'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_219')
        literal = self.expect_type(23)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(53)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_220(self): # type Optional[Any]
        # _tmp_220: '.' | '...'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_220')
        literal = self.expect_type(23)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(53)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_221(self): # type Optional[Any]
        # _tmp_221: ',' star_expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_221')
        literal = self.expect_type(12)
        if literal:
            c = self.star_expression()
            if c:
                return c
        self._index = mark
        return None

    def _tmp_222(self): # type Optional[Any]
        # _tmp_222: ',' expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_222')
        literal = self.expect_type(12)
        if literal:
            c = self.expression()
            if c:
                return c
        self._index = mark
        return None

    def _tmp_223(self): # type Optional[Any]
        # _tmp_223: 'or' conjunction
        mark = self._index
        if self._verbose: log_start(self, '_tmp_223')
        literal = self.expect_type(530)
        if literal:
            c = self.conjunction()
            if c:
                return c
        self._index = mark
        return None

    def _tmp_224(self): # type Optional[Any]
        # _tmp_224: 'and' inversion
        mark = self._index
        if self._verbose: log_start(self, '_tmp_224')
        literal = self.expect_type(531)
        if literal:
            c = self.inversion()
            if c:
                return c
        self._index = mark
        return None

    def _tmp_225(self): # type Optional[Any]
        # _tmp_225: slice | starred_expression
        mark = self._index
        if self._verbose: log_start(self, '_tmp_225')
        slice = self.slice()
        if slice:
            return slice
        self._index = mark
        starred_expression = self.starred_expression()
        if starred_expression:
            return starred_expression
        self._index = mark
        return None

    def _tmp_226(self): # type Optional[Any]
        # _tmp_226: 'if' disjunction
        mark = self._index
        if self._verbose: log_start(self, '_tmp_226')
        literal = self.expect_type(509)
        if literal:
            z = self.disjunction()
            if z:
                return z
        self._index = mark
        return None

    def _tmp_227(self): # type Optional[Any]
        # _tmp_227: 'if' disjunction
        mark = self._index
        if self._verbose: log_start(self, '_tmp_227')
        literal = self.expect_type(509)
        if literal:
            z = self.disjunction()
            if z:
                return z
        self._index = mark
        return None

    def _tmp_228(self): # type Optional[Any]
        # _tmp_228: starred_expression | (assignment_expression | expression !':=') !'='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_228')
        starred_expression = self.starred_expression()
        if starred_expression:
            return starred_expression
        self._index = mark
        _tmp_240 = self._tmp_240()
        if _tmp_240:
            if self.negative_lookahead(PythonParser.expect_type, 22):
                return _tmp_240
        self._index = mark
        return None

    def _tmp_229(self): # type Optional[Any]
        # _tmp_229: ',' star_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_229')
        literal = self.expect_type(12)
        if literal:
            c = self.star_target()
            if c:
                return c
        self._index = mark
        return None

    def _tmp_230(self): # type Optional[Any]
        # _tmp_230: ',' star_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_230')
        literal = self.expect_type(12)
        if literal:
            c = self.star_target()
            if c:
                return c
        self._index = mark
        return None

    def _tmp_231(self): # type Optional[Any]
        # _tmp_231: star_targets '='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_231')
        star_targets = self.star_targets()
        if star_targets:
            literal = self.expect_type(22)
            if literal:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_232(self): # type Optional[Any]
        # _tmp_232: star_targets '='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_232')
        star_targets = self.star_targets()
        if star_targets:
            literal = self.expect_type(22)
            if literal:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_233(self): # type Optional[Any]
        # _tmp_233: ')' | '**'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_233')
        literal = self.expect_type(8)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_234(self): # type Optional[Any]
        # _tmp_234: ':' | '**'
        mark = self._index
        if self._verbose: log_start(self, '_tmp_234')
        literal = self.expect_type(11)
        if literal:
            return literal
        self._index = mark
        literal = self.expect_type(36)
        if literal:
            return literal
        self._index = mark
        return None

    def _tmp_235(self): # type Optional[Any]
        # _tmp_235: expression ['as' star_target]
        mark = self._index
        if self._verbose: log_start(self, '_tmp_235')
        expression = self.expression()
        if expression:
            opt = self._tmp_241()
            return self.dummy_name()
        self._index = mark
        return None

    def _tmp_236(self): # type Optional[Any]
        # _tmp_236: expressions ['as' star_target]
        mark = self._index
        if self._verbose: log_start(self, '_tmp_236')
        expressions = self.expressions()
        if expressions:
            opt = self._tmp_242()
            return self.dummy_name()
        self._index = mark
        return None

    def _tmp_237(self): # type Optional[Any]
        # _tmp_237: expression ['as' star_target]
        mark = self._index
        if self._verbose: log_start(self, '_tmp_237')
        expression = self.expression()
        if expression:
            opt = self._tmp_243()
            return self.dummy_name()
        self._index = mark
        return None

    def _tmp_238(self): # type Optional[Any]
        # _tmp_238: expressions ['as' star_target]
        mark = self._index
        if self._verbose: log_start(self, '_tmp_238')
        expressions = self.expressions()
        if expressions:
            opt = self._tmp_244()
            return self.dummy_name()
        self._index = mark
        return None

    def _tmp_239(self): # type Optional[Any]
        # _tmp_239: 'as' NAME
        mark = self._index
        if self._verbose: log_start(self, '_tmp_239')
        literal = self.expect_type(521)
        if literal:
            name = self.name()
            if name:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_240(self): # type Optional[Any]
        # _tmp_240: assignment_expression | expression !':='
        mark = self._index
        if self._verbose: log_start(self, '_tmp_240')
        assignment_expression = self.assignment_expression()
        if assignment_expression:
            return assignment_expression
        self._index = mark
        expression = self.expression()
        if expression:
            if self.negative_lookahead(PythonParser.expect_type, 54):
                return expression
        self._index = mark
        return None

    def _tmp_241(self): # type Optional[Any]
        # _tmp_241: 'as' star_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_241')
        literal = self.expect_type(521)
        if literal:
            star_target = self.star_target()
            if star_target:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_242(self): # type Optional[Any]
        # _tmp_242: 'as' star_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_242')
        literal = self.expect_type(521)
        if literal:
            star_target = self.star_target()
            if star_target:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_243(self): # type Optional[Any]
        # _tmp_243: 'as' star_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_243')
        literal = self.expect_type(521)
        if literal:
            star_target = self.star_target()
            if star_target:
                return self.dummy_name()
        self._index = mark
        return None

    def _tmp_244(self): # type Optional[Any]
        # _tmp_244: 'as' star_target
        mark = self._index
        if self._verbose: log_start(self, '_tmp_244')
        literal = self.expect_type(521)
        if literal:
            star_target = self.star_target()
            if star_target:
                return self.dummy_name()
        self._index = mark
        return None

    KEYWORD_INDICES = {'return': 499, 'raise': 500, 'pass': 501, 'del': 502, 'yield': 503, 'assert': 504, 'break': 505, 'continue': 506, 'global': 507, 'nonlocal': 508, 'if': 509, 'try': 510, 'while': 511, 'import': 512, 'from': 513, 'class': 514, 'def': 515, 'elif': 516, 'else': 517, 'for': 518, 'in': 519, 'with': 520, 'as': 521, 'except': 522, 'finally': 523, 'None': 524, 'True': 525, 'False': 526, 'not': 527, 'is': 528, 'lambda': 529, 'or': 530, 'and': 531}
    KEYWORDS = ('False', 'None', 'True', 'and', 'as', 'assert', 'break', 'class', 'continue', 'def', 'del', 'elif', 'else', 'except', 'finally', 'for', 'from', 'global', 'if', 'import', 'in', 'is', 'lambda', 'nonlocal', 'not', 'or', 'pass', 'raise', 'return', 'try', 'while', 'with', 'yield')
    SOFT_KEYWORDS = ('_', 'case', 'match')

