/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import weka.core.FastVector;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.Messages;

public class DotParser
implements GraphConstants {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected Reader m_input;
    protected String m_graphName;

    public DotParser(Reader input, FastVector nodes, FastVector edges) {
        this.m_nodes = nodes;
        this.m_edges = edges;
        this.m_input = input;
    }

    public String parse() {
        StreamTokenizer tk = new StreamTokenizer(new BufferedReader(this.m_input));
        this.setSyntax(tk);
        this.graph(tk);
        return this.m_graphName;
    }

    protected void setSyntax(StreamTokenizer tk) {
        tk.resetSyntax();
        tk.eolIsSignificant(false);
        tk.slashStarComments(true);
        tk.slashSlashComments(true);
        tk.whitespaceChars(0, 32);
        tk.wordChars(33, 255);
        tk.ordinaryChar(91);
        tk.ordinaryChar(93);
        tk.ordinaryChar(123);
        tk.ordinaryChar(125);
        tk.ordinaryChar(45);
        tk.ordinaryChar(62);
        tk.ordinaryChar(47);
        tk.ordinaryChar(42);
        tk.quoteChar(34);
        tk.whitespaceChars(59, 59);
        tk.ordinaryChar(61);
    }

    protected void graph(StreamTokenizer tk) {
        GraphEdge e;
        int i;
        try {
            tk.nextToken();
            if (tk.ttype == -3) {
                if (tk.sval.equalsIgnoreCase("digraph")) {
                    tk.nextToken();
                    if (tk.ttype == -3) {
                        this.m_graphName = tk.sval;
                        tk.nextToken();
                    }
                    while (tk.ttype != 123) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("DotParser_Graph_Error_Text_First")).append(tk.lineno());
                        Messages.getInstance();
                        System.err.println(stringBuilder2.append(Messages.getString("DotParser_Graph_Error_Text_Second")).append(tk.sval).toString());
                        tk.nextToken();
                        if (tk.ttype != -1) continue;
                        return;
                    }
                    this.stmtList(tk);
                } else if (tk.sval.equalsIgnoreCase("graph")) {
                    Messages.getInstance();
                    System.err.println(Messages.getString("DotParser_Graph_Error_Text_Third"));
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("DotParser_Graph_Error_Text_Fourth")).append(tk.lineno()).toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int[] noOfEdgesOfNode = new int[this.m_nodes.size()];
        int[] noOfPrntsOfNode = new int[this.m_nodes.size()];
        for (i = 0; i < this.m_edges.size(); ++i) {
            e = (GraphEdge)this.m_edges.elementAt(i);
            int n = e.src;
            noOfEdgesOfNode[n] = noOfEdgesOfNode[n] + 1;
            int n2 = e.dest;
            noOfPrntsOfNode[n2] = noOfPrntsOfNode[n2] + 1;
        }
        for (i = 0; i < this.m_edges.size(); ++i) {
            int k;
            e = (GraphEdge)this.m_edges.elementAt(i);
            GraphNode n = (GraphNode)this.m_nodes.elementAt(e.src);
            GraphNode n2 = (GraphNode)this.m_nodes.elementAt(e.dest);
            if (n.edges == null) {
                n.edges = new int[noOfEdgesOfNode[e.src]][2];
                for (k = 0; k < n.edges.length; ++k) {
                    n.edges[k][1] = 0;
                }
            }
            if (n2.prnts == null) {
                n2.prnts = new int[noOfPrntsOfNode[e.dest]];
                for (k = 0; k < n2.prnts.length; ++k) {
                    n2.prnts[k] = -1;
                }
            }
            k = 0;
            while (n.edges[k][1] != 0) {
                ++k;
            }
            n.edges[k][0] = e.dest;
            n.edges[k][1] = e.type;
            k = 0;
            while (n2.prnts[k] != -1) {
                ++k;
            }
            n2.prnts[k] = e.src;
        }
    }

    protected void stmtList(StreamTokenizer tk) throws Exception {
        block3: {
            block2: {
                tk.nextToken();
                if (tk.ttype == 125) break block2;
                if (tk.ttype != -1) break block3;
            }
            return;
        }
        this.stmt(tk);
        this.stmtList(tk);
    }

    protected void stmt(StreamTokenizer tk) {
        if (!(tk.sval.equalsIgnoreCase("graph") || tk.sval.equalsIgnoreCase("node") || tk.sval.equalsIgnoreCase("edge"))) {
            try {
                this.nodeID(tk);
                int nodeindex = this.m_nodes.indexOf(new GraphNode(tk.sval, null));
                tk.nextToken();
                if (tk.ttype == 91) {
                    this.nodeStmt(tk, nodeindex);
                } else if (tk.ttype == 45) {
                    this.edgeStmt(tk, nodeindex);
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("DotParser_Stmt_Error_Text_First")).append(tk.lineno());
                    Messages.getInstance();
                    System.err.println(stringBuilder2.append(Messages.getString("DotParser_Stmt_Error_Text_Second")).toString());
                }
            }
            catch (Exception ex) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("DotParser_Stmt_Error_Text_Third")).append(tk.lineno());
                Messages.getInstance();
                System.err.println(stringBuilder3.append(Messages.getString("DotParser_Stmt_Error_Text_Fourth")).toString());
                ex.printStackTrace();
            }
        }
    }

    protected void nodeID(StreamTokenizer tk) throws Exception {
        if (tk.ttype != 34) {
            if (!(tk.ttype == -3 || tk.ttype >= 97 && tk.ttype <= 122 || tk.ttype >= 65 && tk.ttype <= 90)) {
                throw new Exception();
            }
        }
        if (this.m_nodes != null && !this.m_nodes.contains(new GraphNode(tk.sval, null))) {
            this.m_nodes.addElement(new GraphNode(tk.sval, tk.sval));
        }
    }

    protected void nodeStmt(StreamTokenizer tk, int nindex) throws Exception {
        block21: {
            block20: {
                tk.nextToken();
                GraphNode temp = (GraphNode)this.m_nodes.elementAt(nindex);
                if (tk.ttype == 93) break block20;
                if (tk.ttype != -1) break block21;
            }
            return;
        }
        if (tk.ttype == -3) {
            if (tk.sval.equalsIgnoreCase("label")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype == -3 || tk.ttype == 34) {
                        temp.lbl = tk.sval;
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("DotParser_NodeStmt_Error_Text_First")).append(tk.lineno()).toString());
                        tk.pushBack();
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("DotParser_NodeStmt_Error_Text_Second")).append(tk.lineno()).toString());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("color")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("DotParser_NodeStmt_Error_Text_Third")).append(tk.lineno()).toString());
                        tk.pushBack();
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("DotParser_NodeStmt_Error_Text_Fourth")).append(tk.lineno()).toString());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("style")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("DotParser_NodeStmt_Error_Text_Fifth")).append(tk.lineno()).toString());
                        tk.pushBack();
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("DotParser_NodeStmt_Error_Text_Sixth")).append(tk.lineno()).toString());
                    tk.pushBack();
                }
            }
        }
        this.nodeStmt(tk, nindex);
    }

    protected void edgeStmt(StreamTokenizer tk, int nindex) throws Exception {
        tk.nextToken();
        GraphEdge e = null;
        if (tk.ttype == 62) {
            tk.nextToken();
            if (tk.ttype == 123) {
                while (true) {
                    tk.nextToken();
                    if (tk.ttype != 125) {
                        this.nodeID(tk);
                        e = new GraphEdge(nindex, this.m_nodes.indexOf(new GraphNode(tk.sval, null)), 1);
                        if (this.m_edges == null || this.m_edges.contains(e)) continue;
                        this.m_edges.addElement(e);
                        continue;
                    }
                    break;
                }
            } else {
                this.nodeID(tk);
                e = new GraphEdge(nindex, this.m_nodes.indexOf(new GraphNode(tk.sval, null)), 1);
                if (this.m_edges != null && !this.m_edges.contains(e)) {
                    this.m_edges.addElement(e);
                }
            }
        } else {
            if (tk.ttype == 45) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("DotParser_EdgeStmt_Error_Text_First")).append(tk.lineno());
                Messages.getInstance();
                System.err.println(stringBuilder2.append(Messages.getString("DotParser_EdgeStmt_Error_Text_Second")).toString());
                if (tk.ttype == -3) {
                    tk.pushBack();
                }
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("DotParser_EdgeStmt_Error_Text_Third")).append(tk.lineno());
            Messages.getInstance();
            System.err.println(stringBuilder3.append(Messages.getString("DotParser_EdgeStmt_Error_Text_Fourth")).toString());
            if (tk.ttype == -3) {
                tk.pushBack();
            }
            return;
        }
        tk.nextToken();
        if (tk.ttype == 91) {
            this.edgeAttrib(tk, e);
        } else {
            tk.pushBack();
        }
    }

    protected void edgeAttrib(StreamTokenizer tk, GraphEdge e) throws Exception {
        block21: {
            block20: {
                tk.nextToken();
                if (tk.ttype == 93) break block20;
                if (tk.ttype != -1) break block21;
            }
            return;
        }
        if (tk.ttype == -3) {
            if (tk.sval.equalsIgnoreCase("label")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype == -3 || tk.ttype == 34) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("DotParser_EdgeAttrib_Text")).append(tk.sval).toString());
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("DotParser_EdgeAttrib_Error_Text")).append(tk.lineno()).toString());
                        tk.pushBack();
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("DotParser_EdgeAttrib_Error_Text_First")).append(tk.lineno()).toString());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("color")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("DotParser_EdgeAttrib_Error_Text_Second")).append(tk.lineno()).toString());
                        tk.pushBack();
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("DotParser_EdgeAttrib_Error_Text_Third")).append(tk.lineno()).toString());
                    tk.pushBack();
                }
            } else if (tk.sval.equalsIgnoreCase("style")) {
                tk.nextToken();
                if (tk.ttype == 61) {
                    tk.nextToken();
                    if (tk.ttype != -3 && tk.ttype != 34) {
                        StringBuilder stringBuilder = new StringBuilder();
                        Messages.getInstance();
                        System.err.println(stringBuilder.append(Messages.getString("DotParser_EdgeAttrib_Error_Text_Fourth")).append(tk.lineno()).toString());
                        tk.pushBack();
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    System.err.println(stringBuilder.append(Messages.getString("DotParser_EdgeAttrib_Error_Text_Fifth")).append(tk.lineno()).toString());
                    tk.pushBack();
                }
            }
        }
        this.edgeAttrib(tk, e);
    }

    public static void writeDOT(String filename, String graphName, FastVector nodes, FastVector edges) {
        try {
            FileWriter os = new FileWriter(filename);
            os.write("digraph ", 0, "digraph ".length());
            if (graphName != null) {
                os.write(graphName + " ", 0, graphName.length() + 1);
            }
            os.write("{\n", 0, "{\n".length());
            for (int i = 0; i < edges.size(); ++i) {
                GraphEdge e = (GraphEdge)edges.elementAt(i);
                os.write(((GraphNode)nodes.elementAt((int)e.src)).ID, 0, ((GraphNode)nodes.elementAt((int)e.src)).ID.length());
                os.write("->", 0, "->".length());
                os.write(((GraphNode)nodes.elementAt((int)e.dest)).ID + "\n", 0, ((GraphNode)nodes.elementAt((int)e.dest)).ID.length() + 1);
            }
            os.write("}\n", 0, "}\n".length());
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

