// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
    "github.com/jdcloud-api/jdcloud-sdk-go/core"
    vpc "github.com/jdcloud-api/jdcloud-sdk-go/services/vpc/models"
)

type ModifyRouteTableRulesRequest struct {

    core.JDCloudRequest

    /* Region ID  */
    RegionId string `json:"regionId"`

    /* RouteTable ID  */
    RouteTableId string `json:"routeTableId"`

    /* 路由表规则信息  */
    ModifyRouteTableRuleSpecs []vpc.ModifyRouteTableRules `json:"modifyRouteTableRuleSpecs"`
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 * param modifyRouteTableRuleSpecs: 路由表规则信息 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyRouteTableRulesRequest(
    regionId string,
    routeTableId string,
    modifyRouteTableRuleSpecs []vpc.ModifyRouteTableRules,
) *ModifyRouteTableRulesRequest {

	return &ModifyRouteTableRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/routeTables/{routeTableId}:modifyRouteTableRules",
			Method:  "POST",
			Header:  nil,
			Version: "v1",
		},
        RegionId: regionId,
        RouteTableId: routeTableId,
        ModifyRouteTableRuleSpecs: modifyRouteTableRuleSpecs,
	}
}

/*
 * param regionId: Region ID (Required)
 * param routeTableId: RouteTable ID (Required)
 * param modifyRouteTableRuleSpecs: 路由表规则信息 (Required)
 */
func NewModifyRouteTableRulesRequestWithAllParams(
    regionId string,
    routeTableId string,
    modifyRouteTableRuleSpecs []vpc.ModifyRouteTableRules,
) *ModifyRouteTableRulesRequest {

    return &ModifyRouteTableRulesRequest{
        JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}:modifyRouteTableRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
        RegionId: regionId,
        RouteTableId: routeTableId,
        ModifyRouteTableRuleSpecs: modifyRouteTableRuleSpecs,
    }
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyRouteTableRulesRequestWithoutParam() *ModifyRouteTableRulesRequest {

    return &ModifyRouteTableRulesRequest{
            JDCloudRequest: core.JDCloudRequest{
            URL:     "/regions/{regionId}/routeTables/{routeTableId}:modifyRouteTableRules",
            Method:  "POST",
            Header:  nil,
            Version: "v1",
        },
    }
}

/* param regionId: Region ID(Required) */
func (r *ModifyRouteTableRulesRequest) SetRegionId(regionId string) {
    r.RegionId = regionId
}

/* param routeTableId: RouteTable ID(Required) */
func (r *ModifyRouteTableRulesRequest) SetRouteTableId(routeTableId string) {
    r.RouteTableId = routeTableId
}

/* param modifyRouteTableRuleSpecs: 路由表规则信息(Required) */
func (r *ModifyRouteTableRulesRequest) SetModifyRouteTableRuleSpecs(modifyRouteTableRuleSpecs []vpc.ModifyRouteTableRules) {
    r.ModifyRouteTableRuleSpecs = modifyRouteTableRuleSpecs
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyRouteTableRulesRequest) GetRegionId() string {
    return r.RegionId
}

type ModifyRouteTableRulesResponse struct {
    RequestID string `json:"requestId"`
    Error core.ErrorResponse `json:"error"`
    Result ModifyRouteTableRulesResult `json:"result"`
}

type ModifyRouteTableRulesResult struct {
}