/*=========================================================================

  Program:   OpenIGTLLink Library -- Dummy trajectory data
  Module:    $RCSfile: $
  Language:  C
  Date:      $Date: $
  Version:   $Revision: $

  Copyright (c) Insight Software Consortium. All rights reserved.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __IGTL_TEST_DATA_TRAJECTORY_H
#define __IGTL_TEST_DATA_TRAJECTORY_H

char test_trajectory_message[] = {
  /*------- OpenIGTLink message header --------*/
  0x00, 0x01,                                     /* Version number */
  0x54, 0x52, 0x41, 0x4a, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* TRAJECTORY */
  0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
  0x6d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Device name */
  0x00, 0x00, 0x00, 0x00, 0x49, 0x96, 0x02, 0xd2, /* Time stamp */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc2, /* Body size */
  0x62, 0x05, 0xa3, 0x66, 0x18, 0x57, 0x76, 0x30, /* CRC */

  /*---------- TRAJECTORY message body ------------*/
  /* Trajectory data 0 */
  0x54, 0x52, 0x41, 0x4a, 0x45, 0x43, 0x54, 0x4f,
  0x52, 0x59, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x52,
  0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Trajectory description */

  0x54, 0x52, 0x41, 0x4a, 0x45, 0x43, 0x54, 0x4f,
  0x52, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Group name (Trajectory etc.) */

  0x03,                                           /* Type */
  0x00,                                           /* Reserved */
  0xff, 0x00, 0x00, 0xff,                         /* RGBA */

  0x41, 0x20, 0x00, 0x00, 0x41, 0x70, 0x00, 0x00,
  0x41, 0xa0, 0x00, 0x00,                         /* Entry position */ 
  0x41, 0xc8, 0x00, 0x00, 0x41, 0xf0, 0x00, 0x00,
  0x42, 0x0c, 0x00, 0x00,                         /* Target position */
  0x40, 0xa0, 0x00, 0x00,                         /* Radius */

  0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Owner image */

  /* Trajectory data 1 */
  0x54, 0x52, 0x41, 0x4a, 0x45, 0x43, 0x54, 0x4f,
  0x52, 0x59, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x52,
  0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x31,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Trajectory description */

  0x54, 0x52, 0x41, 0x4a, 0x45, 0x43, 0x54, 0x4f,
  0x52, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Group name (Trajectory etc.) */

  0x03,                                           /* Type */
  0x00,                                           /* Reserved */
  0x00, 0xff, 0x00, 0xff,                         /* RGBA */

  0x42, 0x20, 0x00, 0x00, 0x42, 0x34, 0x00, 0x00,
  0x42, 0x48, 0x00, 0x00,                         /* Entry position */ 
  0x42, 0x5c, 0x00, 0x00, 0x42, 0x70, 0x00, 0x00,
  0x42, 0x82, 0x00, 0x00,                         /* Target position */
  0x40, 0x20, 0x00, 0x00,                         /* Radius */

  0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Owner image */

  /* Trajectory data 2 */
  0x54, 0x52, 0x41, 0x4a, 0x45, 0x43, 0x54, 0x4f,
  0x52, 0x59, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x52,
  0x49, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x32,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Trajectory description */

  0x54, 0x52, 0x41, 0x4a, 0x45, 0x43, 0x54, 0x4f,
  0x52, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Group name (Trajectory etc.) */

  0x03,                                           /* Type */
  0x00,                                           /* Reserved */
  0x00, 0x00, 0xff, 0xff,                         /* RGBA */

  0x42, 0x8c, 0x00, 0x00, 0x42, 0x96, 0x00, 0x00,
  0x42, 0xa0, 0x00, 0x00,                         /* Entry position */ 
  0x42, 0xaa, 0x00, 0x00, 0x42, 0xb4, 0x00, 0x00,
  0x42, 0xbe, 0x00, 0x00,                         /* Target position */
  0x00, 0x00, 0x00, 0x00,                         /* Radius */

  0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Owner image */

};

#endif /* IGTL_TEST_DATA_TRAJECTORY_H */



