/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var err2json = require( './../../to-json' );
var reviveError = require( './../lib' );

var err1 = new SyntaxError( 'bad syntax' );
// returns <SyntaxError>

var json = err2json( err1 );
/* returns
    {
        'type': 'SyntaxError',
        'name': 'SyntaxError',
        'message': 'bad syntax',
        'stack': '...'
    }
*/

var str = JSON.stringify( json );
// returns '{'type':'SyntaxError','name':'SyntaxError','message':'bad syntax','stack':'...'}'

var err2 = JSON.parse( str, reviveError );
// returns <SyntaxError>

console.log( err1.message === err2.message );
// => true

console.log( err1.stack === err2.stack );
// => true
