'use strict';

var Plan = require('./plan');

/**
 * @constructor
 * Represents a join pattern over observable sequences.
 */
function Pattern(patterns) {
  this._patterns = patterns;
}

/**
 *  Creates a pattern that matches the current plan matches and when the specified observable sequences has an available value.
 *  @param other Observable sequence to match in addition to the current pattern.
 *  @return {Pattern} Pattern object that matches when all observable sequences in the pattern have an available value.
 */
Pattern.prototype.and = function (other) {
  return new Pattern(this._patterns.concat(other));
};

/**
 *  Matches when all observable sequences in the pattern (specified using a chain of and operators) have an available value and projects the values.
 *  @param {Function} selector Selector that will be invoked with available values from the source sequences, in the same order of the sequences in the pattern.
 *  @return {Plan} Plan that produces the projected values, to be fed (with other plans) to the when operator.
 */
Pattern.prototype.thenDo = function (selector) {
  return new Plan(this, selector);
};

module.exports = Pattern;
