/* ----- encode/653xint16, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_653xint16_checksums[] = {
  "17a6405c12d612963247bbf6aa8ed3cfe97cb9d2c4cbc5fed58415acee973cc8",
  "95a98a488011bfe4be2945e897c1e74d3ab4caae7a3985c5a91df7a40fa12bb0",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_653xint16_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_653xint16_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_653xint16_ITEMBYTES

static void *storage_encode_653xint16_s;
static unsigned char *test_encode_653xint16_s;
static void *storage_encode_653xint16_x;
static unsigned char *test_encode_653xint16_x;
static void *storage_encode_653xint16_s2;
static unsigned char *test_encode_653xint16_s2;
static void *storage_encode_653xint16_x2;
static unsigned char *test_encode_653xint16_x2;

#define precomputed_encode_653xint16_NUM 4

static const unsigned char precomputed_encode_653xint16_s[precomputed_encode_653xint16_NUM][crypto_encode_STRBYTES] = {
  {44,222,168,17,122,80,58,73,108,94,6,99,24,102,145,146,2,196,109,41,138,224,18,231,48,3,242,32,253,196,140,115,247,118,61,16,231,81,180,182,245,6,75,8,152,242,238,71,153,25,210,86,30,186,72,33,221,162,1,223,11,225,234,186,211,32,78,239,156,62,230,252,149,184,34,125,168,13,46,17,32,191,230,133,255,66,19,217,121,237,95,13,35,53,99,86,225,154,162,41,207,209,159,158,37,85,159,130,246,165,137,206,21,189,43,97,120,41,203,187,185,204,9,81,136,113,50,67,135,210,104,46,111,236,65,142,202,95,3,30,37,226,230,62,54,41,29,129,107,125,172,34,144,28,90,19,239,8,2,247,51,231,70,235,112,221,21,121,75,14,198,99,141,24,198,7,189,121,110,178,56,104,175,235,240,141,104,41,62,91,172,51,41,22,235,25,112,130,146,148,64,73,159,64,10,83,84,233,3,202,157,99,185,231,57,213,102,251,68,187,190,112,60,5,177,137,148,50,253,233,253,21,105,130,177,175,29,164,72,177,100,5,36,193,100,184,50,237,168,153,114,92,1,95,11,18,18,210,81,147,126,253,165,6,29,160,182,64,30,69,78,63,48,218,212,93,152,225,242,11,252,211,165,24,245,246,97,34,131,72,110,140,152,88,101,75,126,107,136,227,171,131,0,223,187,182,151,40,220,161,88,40,235,118,81,172,75,61,187,15,118,89,55,34,51,161,152,127,94,160,130,48,43,17,4,130,111,48,157,239,59,108,64,161,171,75,102,180,74,190,75,132,197,170,157,159,122,180,170,111,221,150,100,21,220,136,191,224,31,0,63,82,235,121,148,233,213,231,36,154,99,38,248,123,88,41,156,20,152,229,72,43,250,21,239,66,106,142,243,90,114,237,130,188,117,96,224,197,90,202,230,163,102,218,99,140,222,111,179,201,144,79,15,37,139,181,145,26,228,162,200,194,41,41,3,41,106,69,19,172,8,133,34,149,177,205,108,186,220,232,48,73,192,21,221,146,112,68,193,184,174,215,201,230,19,65,235,66,122,23,50,5,92,76,174,162,237,167,114,132,133,217,244,187,222,209,227,1,92,69,87,39,147,159,193,252,143,240,66,87,135,1,200,31,141,246,197,106,42,173,184,197,117,226,123,138,105,215,93,87,31,241,247,95,51,246,91,251,43,12,63,122,198,188,127,88,195,74,76,62,15,246,26,238,151,102,21,96,91,10,213,183,123,254,179,135,99,218,139,102,4,103,30,209,209,73,15,142,3,53,168,249,140,71,70,239,53,221,2,209,222,128,26,38,31,251,123,106,114,231,34,236,150,155,143,132,178,67,54,124,103,67,166,33,134,17,95,155,131,142,207,241,111,181,5,197,155,202,16,64,193,229,244,186,224,39,3,216,96,104,210,86,206,95,81,124,211,132,8,121,39,199,51,2,70,93,124,75,33,229,8,203,231,238,29,132,97,26,50,26,61,20,68,197,251,44,92,160,221,123,111,9,25,31,165,11,234,3,56,74,209,230,48,243,102,242,49,97,63,19,253,43,48,189,6,157,17,5,88,211,206,199,246,82,116,183,50,233,50,16,185,60,129,183,205,150,113,155,8,6,210,63,243,41,111,63,239,124,250,224,134,187,90,164,77,181,153,91,2,89,49,242,214,36,140,138,102,30,99,200,191,212,226,124,20,42,62,168,21,245,173,66,197,2,126,87,219,252,185,18,237,58,116,184,67,83,25,163,174,192,124,95,250,65,103,111,174,47,130,18,184,204,147,39,71,97,145,95,204,128,99,57,221,236,245,155,250,54,55,25,148,250,221,40,66,202,121,153,115,83,5,141,119,218,237,250,197,235,249,71,139,75,155,40,52,146,70,47,227,51,14,132,90,93,62,204,53,55,238,198,164,185,237,24,191,17,96,70,39,71,137,93,185,17,185,109,186,36,137,241,242,48,162,101,2,14,60,142,127,225,19,26,78,0,194,59,210,212,133,148,66,246,139,10,13,154,185,164,234,253,103,79,199,135,32,228,255,110,12,67,203,211,186,200,200,23,127,102,104,4,150,69,91,154,164,139,232,238,211,150,61,153,17,186,184,152,165,244,125,222,55,233,163,86,208,248,6,251,194,76,176,196,202,137,204,145,175,161,8,216,185,107,5,208,255,131,169,108,165,187,138,84,156,241,255,191,178,187,248,82,32,34,107,110,187,118,86,129,154,178,176,69,216,177,87,174,158,207,83,100,26,202,140,182,70,62,31,111,41,218,221,219,192,120,143,14,182,248,54,83,94,240,50,197,88,114,144,148,247,143,218,177,186,0,247,187,136,45,41,42,240,76,123,126,114,253,102,5,82,140,161,126,37,75,243,89,105,234,113,199,53,245,224,239,211,2,170,148,20,197,228,242,254,11,128,226,98,128,146,247,113,53,65,143,18,178,155,107,49,248,37,204,41,138,28,24,244,63,207,144,134,114,216,115,48,80,71,92,1,182,83,34,175,198,213,10,243,71,254,227,84,115,255,211,111,111,5,54,47,19,119,47,181,213,206,190,21,3,126,245,150,118,145,197,118,137,20,93,136,196,242,165,151,11,133,0,167,118,4,107,13,241,87,78,34,85,44,26,184,202,230,196,58,137,132,142,172,223,11,112,156,182,50,62,144,184,113,98,134,77,119,42,240,74,9,225,162,52,164,216,76,89,108,149,255,160,203,0,154,14,225,182,192,178,173,219,198,224,249,71,254,175,235,1,91,132,213,13,25,222,212,143,32,38,43,74,96,12,88,98,9,200,250,186,243,25,0,149,143,12,186,12,138,229,111,241,218,249,154,60,199,8,0,109,191,160,253,169,175,248,44,252,18,80,33,251,40,93,118,135,42,23,231,227,93,224,93,136,173,57,69,184,195,107,136,47,185,19,178,173,252,156,181,105,45,199},
  {35,77,101,149,237,8,83,239,238,158,63,200,149,65,97,36,137,210,164,252,128,236,146,208,152,27,21,15,114,219,103,99,32,142,192,159,229,134,92,200,107,249,234,64,41,81,169,180,111,121,249,61,207,145,17,27,76,65,61,145,0,211,191,142,52,99,85,192,45,202,94,72,179,141,25,42,175,128,236,3,80,35,50,174,57,185,125,5,89,241,77,175,249,50,235,67,229,244,83,9,28,126,29,250,99,70,120,48,103,169,198,165,205,40,192,172,186,15,163,207,220,17,190,167,134,130,201,52,56,163,95,252,173,140,92,211,9,81,60,225,144,207,118,72,240,143,32,11,105,30,181,10,197,192,59,191,252,185,40,221,77,242,5,165,203,92,147,214,46,13,104,213,215,31,182,135,138,230,240,62,100,50,111,151,116,149,111,81,6,179,40,190,158,56,86,215,44,151,81,183,53,33,24,124,137,203,242,53,38,81,166,195,104,62,254,8,46,22,63,85,13,239,243,251,212,53,158,205,129,45,217,32,134,112,253,213,174,115,113,15,74,72,184,54,9,199,192,9,211,215,3,58,248,94,254,20,187,76,65,58,78,73,69,239,159,98,66,112,247,4,251,200,181,76,202,64,16,50,128,27,109,254,132,81,134,200,170,178,61,1,243,245,245,122,35,89,162,24,220,228,84,105,65,130,224,202,198,105,166,62,118,128,23,107,63,12,22,129,185,84,47,183,21,135,207,91,190,154,88,126,118,153,117,17,3,194,236,166,202,27,105,66,49,4,115,154,127,111,106,222,125,153,218,234,35,220,64,19,183,103,86,45,37,67,230,108,237,29,39,115,187,224,192,212,196,171,190,130,69,209,101,69,103,201,115,71,172,236,52,249,110,237,174,27,196,155,212,131,162,24,190,82,96,206,54,217,209,213,148,126,115,163,230,138,8,182,170,1,190,255,31,5,87,134,204,31,53,12,109,76,107,112,21,192,237,62,226,158,110,149,89,11,180,218,208,174,12,176,57,172,94,8,6,210,99,232,170,68,207,140,119,193,8,51,145,50,12,208,148,153,98,226,113,29,184,187,231,205,53,192,93,158,243,104,31,110,73,215,15,234,211,35,231,41,14,205,242,52,107,142,199,120,243,143,250,205,228,72,205,187,172,236,93,10,92,153,42,222,117,118,210,91,194,176,225,110,181,182,196,39,208,18,172,162,127,57,39,154,186,253,255,239,21,193,191,33,163,252,79,138,28,180,158,221,182,98,219,62,77,150,136,156,5,237,15,148,232,249,147,254,111,72,7,210,85,212,125,43,176,255,209,157,114,246,83,92,148,44,44,226,77,13,15,181,23,130,105,45,111,175,123,93,204,18,3,7,165,17,181,220,165,168,152,76,25,199,207,39,210,126,251,222,97,79,30,110,191,156,80,11,18,237,53,31,121,179,75,174,171,216,255,107,211,42,110,61,198,201,30,70,55,129,110,151,105,124,76,28,102,202,165,2,100,174,86,161,27,226,25,164,76,39,91,157,12,10,163,133,160,14,125,10,251,195,52,255,218,149,244,140,162,228,164,253,253,14,184,226,222,91,221,83,234,145,110,244,7,237,195,80,104,62,119,227,83,113,85,151,85,26,151,220,239,33,114,232,17,179,242,8,154,166,95,247,247,0,161,170,238,253,13,159,181,1,231,38,59,176,83,130,189,107,236,140,232,233,128,111,170,154,92,130,121,91,100,221,150,249,59,30,161,9,12,254,122,237,44,97,108,116,159,58,95,116,38,49,64,56,242,20,117,182,23,226,19,84,68,204,45,89,61,142,93,54,117,165,243,134,219,182,179,23,24,250,188,209,174,95,56,182,45,51,29,183,74,6,132,139,22,240,52,153,255,197,175,40,97,41,1,22,169,231,183,141,70,31,129,143,101,252,73,10,253,131,89,55,159,157,58,4,190,144,226,198,110,113,180,162,94,129,155,147,198,238,51,210,33,27,173,84,29,67,210,142,87,89,4,72,213,33,52,216,200,163,129,75,9,212,219,71,190,94,3,130,60,66,215,232,75,17,77,43,251,98,64,109,136,110,10,215,230,254,159,245,117,191,125,122,90,70,93,65,50,235,94,42,163,252,29,211,171,54,55,241,227,115,88,38,155,44,236,16,89,232,228,231,223,220,193,155,190,200,113,129,68,117,236,220,152,83,251,53,213,169,71,164,245,59,89,56,90,145,249,183,56,53,112,15,150,12,91,7,35,113,0,173,52,86,233,149,127,149,84,82,170,175,138,101,99,173,25,3,138,233,171,205,124,151,169,255,199,81,58,1,218,244,154,232,136,120,50,112,93,33,177,233,252,122,45,168,214,160,74,30,142,157,54,70,46,94,224,242,139,190,23,32,84,97,64,214,166,140,221,40,234,99,1,6,244,25,245,155,95,54,182,49,236,128,140,118,65,91,9,159,251,225,223,198,121,1,39,176,88,205,3,97,49,61,249,58,132,252,209,95,50,48,237,132,147,212,204,141,45,21,161,92,173,221,149,225,85,37,129,126,105,84,250,162,20,12,215,112,70,245,80,150,170,116,151,45,232,203,161,7,144,72,2,11,170,38,64,205,183,229,101,62,203,205,236,225,140,100,111,29,163,208,242,98,154,66,53,51,210,2,47,166,251,33,66,212,88,221,28,111,73,100,187,241,165,223,89,105,184,140,42,51,200,131,83,68,75,212,142,77,97,11,46,8,106,247,117,198,193,107,103,73,112,253,232,113,251,52,29,251,31,200,211,65,146,142,99,85,48,39,64,216,246,55,45,36,75,0,242,25,79,40,77,153,87,129,151,97,152,138,214,199,164,82,204,186,138,104,207,67,222,59,186,86,35,2,30,107,221,76,148,118,131,1,122,180,28,48,18,127,32,149,58,219,51,137,121,67,78,82,25,128,181,79,142,63,120,206,251,175,155,207},
  {45,144,242,172,95,100,253,135,19,221,127,218,247,145,180,81,212,206,11,237,174,36,69,226,215,104,123,37,13,17,105,138,236,240,69,142,54,61,6,208,226,134,207,19,82,66,246,72,14,198,201,206,227,169,151,62,214,253,247,167,201,143,127,20,52,194,48,138,209,117,81,65,145,86,56,155,184,152,215,69,89,140,111,90,152,193,217,143,205,46,109,162,91,29,154,7,59,238,99,155,155,119,240,63,99,25,46,251,232,194,244,208,129,119,112,109,144,139,211,97,203,176,205,108,110,77,49,205,205,168,207,138,81,21,243,87,235,193,225,178,203,207,184,72,112,183,55,97,159,107,144,120,209,154,132,32,250,239,252,209,223,38,234,233,30,208,98,186,211,223,172,74,148,54,111,0,250,104,11,9,147,96,76,154,190,212,113,113,162,231,139,203,117,0,137,165,63,245,246,64,88,124,212,131,9,29,190,248,123,241,68,69,60,68,189,175,170,186,187,68,200,248,55,178,123,15,72,234,233,199,179,235,151,174,97,40,189,140,128,89,221,12,126,46,166,123,140,245,235,29,100,125,224,219,127,46,70,49,38,62,193,231,118,20,47,187,94,213,168,70,168,132,23,136,164,171,131,180,127,133,120,64,98,98,124,181,9,77,78,54,33,38,91,190,106,221,94,208,249,17,74,113,171,166,204,209,154,194,104,212,66,17,148,67,184,90,208,182,120,68,205,31,254,40,136,236,63,20,124,99,148,77,157,108,52,110,47,178,99,102,14,216,229,67,112,201,208,213,152,151,218,228,66,255,92,146,12,138,254,117,68,254,202,114,254,222,214,81,144,247,253,24,8,78,226,161,155,251,113,242,215,191,12,173,149,23,43,151,50,253,91,163,49,202,82,159,60,32,248,126,194,95,203,162,24,30,111,14,189,27,49,16,21,67,239,106,236,74,169,118,42,107,248,141,8,182,209,133,96,90,38,240,180,176,168,34,209,11,136,100,38,241,69,255,181,118,66,251,58,7,101,99,228,193,236,95,77,94,128,150,64,150,139,8,62,53,2,203,39,77,219,11,35,39,130,235,78,26,93,148,137,86,219,157,32,68,194,90,4,103,18,176,118,252,244,81,42,220,45,255,26,202,53,179,212,251,15,168,37,223,102,252,72,231,190,182,209,157,209,123,80,225,175,6,198,150,100,2,39,187,227,31,3,235,184,120,21,159,103,217,6,129,174,87,9,138,252,184,103,147,27,153,234,80,135,33,103,109,74,34,133,18,36,141,178,180,208,90,124,40,15,77,215,111,183,181,45,3,29,144,7,74,196,244,250,145,92,204,193,175,139,251,42,52,48,205,223,111,181,184,75,60,207,219,108,38,222,160,8,161,63,147,219,196,155,20,237,120,5,197,31,254,184,204,95,178,244,73,237,220,195,68,101,35,175,189,31,29,19,186,139,7,10,25,232,75,104,86,65,92,170,250,221,236,215,39,219,180,193,171,161,97,84,246,240,124,57,154,127,70,212,180,101,69,201,208,111,249,229,69,63,0,62,124,159,111,86,181,9,158,122,187,75,141,57,12,155,244,112,203,56,127,192,128,235,130,33,128,219,109,189,210,35,132,225,16,181,143,187,85,103,117,184,86,111,88,46,46,85,211,90,166,43,140,83,144,191,36,34,55,239,62,164,166,46,92,97,44,7,162,252,71,164,91,239,246,123,143,110,94,99,4,219,92,76,61,80,182,192,206,9,107,202,109,125,142,86,161,237,163,105,110,232,66,22,180,99,148,180,16,33,254,60,66,12,193,51,62,23,11,99,114,182,122,50,7,242,81,85,208,93,176,81,222,67,232,37,36,210,190,224,235,238,130,163,177,120,173,77,103,160,218,199,251,45,201,116,8,145,167,200,196,254,186,227,174,99,55,38,242,29,209,5,239,93,170,166,240,174,72,71,31,13,80,238,196,13,126,122,168,90,228,177,1,190,183,154,184,53,192,133,154,35,223,184,206,100,78,221,112,54,97,79,93,182,169,137,214,197,43,90,30,239,57,154,239,159,168,186,250,233,161,150,187,188,129,89,151,73,113,107,162,96,50,223,204,209,17,31,96,139,15,18,114,126,164,131,185,210,115,79,145,98,101,140,92,107,214,111,126,168,243,160,94,55,229,28,76,115,229,63,105,251,217,6,154,90,91,18,180,63,88,165,240,28,32,10,84,160,2,250,82,90,179,243,21,135,16,141,92,48,217,249,58,106,152,209,236,251,213,194,217,107,148,146,49,242,45,70,54,219,229,130,120,4,11,76,165,149,207,5,17,188,188,93,195,38,144,1,252,87,174,95,0,30,244,206,120,214,33,146,168,22,248,154,174,151,63,137,152,125,155,226,245,22,255,67,163,179,38,56,128,23,164,209,62,66,68,142,244,200,101,116,240,56,131,35,97,77,234,106,34,235,146,76,63,64,151,236,30,87,192,174,75,184,117,181,241,185,9,25,75,219,140,55,106,186,64,165,104,144,82,224,234,61,127,220,2,124,63,94,81,145,90,144,58,224,18,19,239,116,60,0,202,146,44,70,172,248,23,85,68,227,22,215,9,91,174,151,25,241,31,38,79,128,19,86,245,63,29,127,161,28,123,192,144,63,233,4,31,148,134,134,217,156,180,205,82,190,135,126,60,140,9,96,97,108,19,223,137,189,90,187,148,174,70,94,193,233,211,247,57,4,17,23,67,101,120,138,229,27,105,120,218,47,29,147,105,214,189,111,13,97,73,46,236,44,169,227,127,143,51,104,4,124,88,67,213,166,123,174,200,116,99,119,183,81,192,212,67,58,20,26,222,193,173,99,91,20,137,179,124,209,51,48,219,229,228,64,83,83,141,86,143,174,44,99,195,114,113,159,244,107,63,115,97,165,156,137,176,88,244,53,126,56,251,102,75,191,165,196,199,175,154,92,165},
  {36,81,67,226,109,100,200,140,89,21,99,135,41,254,177,155,245,174,7,37,17,137,49,152,177,238,178,4,96,193,178,204,70,144,200,45,113,88,203,84,191,144,119,21,10,217,94,187,7,75,221,223,134,101,223,239,92,248,234,215,244,200,126,132,89,78,187,222,215,169,122,131,107,44,201,187,221,177,170,148,70,60,187,205,82,250,239,21,210,31,103,148,165,16,10,177,216,65,169,193,213,251,247,100,246,230,109,166,75,135,203,97,57,16,60,5,217,155,84,29,206,32,226,13,170,65,228,151,175,184,252,203,47,142,143,158,12,100,233,55,89,238,26,111,116,14,62,95,11,197,141,119,224,227,237,161,115,252,171,118,228,46,19,19,148,214,50,200,247,147,5,97,31,49,239,138,111,181,150,139,110,223,61,153,201,193,14,72,59,250,138,238,6,4,32,150,234,90,107,146,157,166,154,232,63,235,37,251,249,78,11,196,164,214,11,170,251,221,142,37,19,181,200,122,145,211,58,138,108,181,170,101,1,91,7,171,207,142,254,77,204,255,66,87,100,56,226,210,57,170,10,191,91,54,20,193,182,166,12,67,216,9,128,130,116,190,221,74,104,180,29,60,0,22,125,153,169,127,200,15,93,71,47,104,200,223,64,41,247,203,229,73,135,94,105,233,122,188,109,175,223,230,224,58,94,173,142,157,35,42,234,243,43,91,170,158,179,68,222,41,255,207,9,11,1,39,7,14,52,153,69,126,138,250,210,4,163,130,110,3,240,139,34,121,25,65,46,208,208,46,79,124,136,231,225,225,104,154,167,107,162,208,162,38,122,204,120,102,99,99,23,30,105,49,22,0,111,89,172,211,14,230,184,20,244,200,219,17,206,187,91,144,201,100,72,98,148,132,219,179,5,111,188,90,178,122,174,214,202,77,188,152,249,82,182,56,89,234,43,174,243,90,202,185,204,23,104,86,81,190,16,59,40,133,131,12,184,89,154,219,1,60,241,149,17,208,88,193,100,159,112,185,168,35,75,66,142,91,175,5,235,96,34,193,218,141,229,82,45,175,235,44,249,184,182,149,198,109,87,105,38,79,127,208,97,45,198,207,224,163,41,251,7,248,62,117,219,138,244,155,169,89,62,184,28,45,243,180,10,19,33,38,27,88,230,126,111,22,151,95,0,152,154,211,18,249,27,114,155,135,6,107,118,0,244,232,77,117,23,72,254,199,251,74,129,33,152,48,32,32,145,43,168,118,137,95,14,82,65,223,232,193,198,76,53,4,44,224,123,132,5,11,138,126,53,155,105,246,138,65,48,255,130,237,7,89,58,216,6,125,241,5,106,102,252,249,253,233,129,65,121,131,32,103,14,49,122,129,245,212,83,174,226,58,233,53,18,5,118,52,175,83,248,26,182,39,104,246,47,61,216,133,159,182,86,255,224,194,215,189,34,16,156,128,25,98,49,93,114,181,94,122,196,167,153,41,48,180,133,123,175,136,35,192,185,117,68,44,87,174,149,49,62,186,66,211,39,227,99,169,211,114,173,208,69,111,60,236,247,184,40,150,76,26,232,7,93,126,169,53,134,19,172,235,111,14,132,161,100,194,81,204,25,174,225,12,201,72,211,171,183,31,17,235,207,204,91,25,43,62,72,209,207,208,209,255,219,195,99,159,98,17,154,12,28,190,5,205,208,33,239,121,117,111,79,91,218,240,46,11,223,108,181,67,125,236,32,180,23,131,248,126,43,16,27,45,85,48,19,36,249,238,156,29,27,21,166,104,213,110,82,217,193,126,205,100,6,76,13,218,137,83,99,215,159,48,68,53,220,174,25,74,123,127,81,239,51,172,103,164,96,224,204,14,65,114,72,228,229,200,223,138,100,45,5,102,43,247,177,107,197,248,184,192,83,235,71,62,98,50,65,135,138,200,102,172,109,255,40,7,72,184,81,251,253,137,223,207,190,50,32,87,148,164,1,83,218,187,204,180,181,255,36,95,106,172,28,243,194,35,116,154,119,78,226,222,174,5,133,216,119,127,87,110,107,169,105,74,105,56,24,244,22,40,96,16,238,125,90,255,131,132,92,162,53,196,179,117,71,48,149,211,95,125,120,117,28,52,49,30,31,151,147,63,9,133,107,195,189,9,172,207,25,147,94,238,155,79,165,208,184,190,68,121,7,201,181,173,205,144,137,225,150,120,28,237,208,132,65,117,148,141,92,88,119,89,214,143,166,94,149,109,59,15,97,35,224,210,176,182,8,150,28,35,218,131,20,245,140,180,203,104,129,106,181,80,17,186,137,180,30,42,194,157,82,89,20,145,25,50,197,221,79,80,219,19,199,236,224,156,67,232,139,227,219,152,3,120,33,103,134,188,223,242,2,113,210,236,203,170,151,54,196,39,185,49,86,216,180,49,165,53,119,163,115,136,228,164,212,213,178,188,115,212,88,148,187,113,199,254,170,89,222,231,172,169,122,190,109,235,37,7,23,179,26,159,115,128,207,47,176,204,173,13,103,244,177,174,201,12,156,38,164,70,76,59,175,41,171,115,53,177,163,36,62,182,102,154,55,79,68,35,147,145,238,194,227,79,112,129,211,205,78,127,19,19,243,195,164,98,87,188,1,248,242,104,109,60,31,115,187,129,211,81,166,57,117,36,206,242,47,57,4,100,83,131,94,37,18,189,199,137,152,15,113,103,204,22,227,237,26,193,2,20,234,217,145,53,56,153,13,149,57,131,130,173,91,254,203,129,223,32,102,169,81,254,208,95,56,131,189,14,80,165,18,11,153,224,127,181,15,9,135,56,33,81,142,17,18,91,35,124,56,82,238,78,175,89,131,191,145,129,219,197,238,107,21,219,115,133,164,124,112,123,198,225,117,217,6,167,75,129,195,255,10,108,233,31,193,230,243,193,21,171,78,91,174,9,177,35,4,21,222,172,138,3},
} ;

static const uint16_t precomputed_encode_653xint16_x[precomputed_encode_653xint16_NUM][crypto_encode_ITEMS] = {
  {56876,4520,20602,18746,24172,25350,26136,37521,50178,10605,57482,59154,816,8434,50429,29580,30455,4157,20967,46772,1781,2123,62104,18414,6553,22226,47646,8520,41693,57089,57611,47850,8403,61262,16028,64742,47253,32034,3496,4398,48928,34278,17151,55571,60793,3423,13603,22115,39649,10658,53711,40607,21797,33439,42486,52873,48405,24875,10616,48075,52409,20745,29064,17202,53895,11880,60527,36417,24522,7683,57893,16102,10550,33053,32107,8876,7312,4954,2287,63234,59187,60230,56688,30997,3659,25542,6285,1990,31165,45678,26680,60335,36336,10600,23358,13228,5673,6635,33392,38034,18752,16543,21258,59732,51715,25501,59321,54585,64358,47940,28862,1340,35249,12948,59901,5629,33385,44977,42013,45384,1380,49444,47204,60722,39336,23666,24321,4619,53778,37713,64894,1701,40989,16566,17694,16206,55856,24020,57752,3058,54268,6309,63221,8801,18563,35950,22680,19301,27518,58248,33707,57088,46779,10391,41436,10328,30443,44113,15691,4027,22902,8759,41267,32664,41054,12418,4395,33284,12399,61341,27707,41280,19371,46182,48714,33867,43717,40861,46202,28586,38621,5476,35036,57535,31,21055,31211,59796,59349,39460,9827,31736,10584,5276,58776,11080,5626,17135,36458,23283,60786,48258,24693,50656,51802,41958,55910,35939,28638,51635,20368,9487,46475,6801,41700,49864,10537,10499,17770,44051,34056,38178,52657,47724,59612,18736,5568,37597,17520,47297,55214,59081,16659,17131,6010,1330,19548,41646,42989,33906,55685,48116,53726,483,17756,10071,40851,64705,61583,22338,391,8136,63117,27333,44330,50616,57973,35451,55145,22365,61727,24567,63027,64347,3115,31295,48326,22655,19139,15948,62991,60954,26263,24597,2651,47061,65147,34739,55907,26251,26372,53534,18897,36367,13571,63912,18316,61254,56629,53506,32990,9754,64287,27259,59250,60450,39830,33935,17330,31798,17255,8614,4486,39775,36483,61903,46447,50437,51867,16400,58817,47860,10208,55299,26720,22226,24526,31825,34003,30984,50983,563,23878,19324,58657,51976,61159,33821,6753,6706,5181,50500,11515,41052,31709,2415,7961,2981,1002,19000,59089,62256,62054,24881,4927,11261,48432,40198,1297,54104,51150,21238,46964,59698,4146,15545,46977,38605,39793,1544,16338,10739,16239,31983,57594,48006,42074,46413,23449,22786,62001,9430,35468,7782,51299,54463,31970,10772,43070,62741,17069,709,22398,64731,4793,15085,47220,21315,41753,49326,24444,16890,28519,12206,4738,52408,10131,24903,24465,32972,14691,60637,39925,14074,6455,64148,10461,51778,39289,21363,36101,55927,64237,60357,18425,19339,10395,37428,12102,13283,33806,23898,52286,14133,50926,47524,6381,4543,18016,18215,23945,4537,28089,9402,61833,12530,26018,3586,36412,57727,6675,78,15298,54482,38021,63042,2699,39437,42169,65002,20327,34759,58400,28415,17164,54219,51386,6088,26239,1128,17814,39515,35748,61160,38611,39229,47633,39096,62629,56957,59703,22179,63696,64262,19650,50352,35274,37324,41391,55304,27577,53253,33791,27817,48037,21642,61852,49151,48050,21240,8736,28267,30395,33110,45722,17840,45528,44631,53150,25683,51738,46732,15942,28447,55849,56285,30912,3727,63670,21302,61534,50482,29272,38032,36855,45530,186,48119,11656,10793,19696,32379,64882,1382,35922,32417,19237,23027,60009,51057,62773,61408,723,38058,50452,62180,3070,57984,32866,63378,13681,36673,45586,27547,63537,52261,35369,6172,16372,37071,29318,29656,20528,23623,46593,8787,50863,2773,18419,58366,29524,54271,28527,13829,4911,12151,54709,48846,789,62846,30358,50577,35190,23828,50312,42482,2967,133,30375,27396,61709,20055,21794,6700,51896,50406,35130,36484,57260,28683,46748,15922,47248,25201,19846,10871,19184,57609,13474,55460,22860,38252,41215,203,3738,46817,45760,56237,57542,18425,45054,491,33883,3541,56857,36820,9760,18987,3168,25176,51209,47866,6643,38144,3215,3258,58762,61807,63962,15514,2247,27904,41151,43517,63663,64556,20498,64289,23848,34678,5930,58343,57437,34909,14765,47173,27587,12168,5049,44466,40188,27061,50989},
  {19747,38245,2285,61267,40686,51263,16789,9313,53897,64676,60544,53394,7064,3861,56178,25447,36384,40896,34533,51292,63851,16618,20777,46249,31087,15865,37327,6929,16716,37181,54016,36543,25396,49237,51757,18526,36275,10777,32943,1004,9040,44594,47417,1405,61785,44877,13049,17387,62693,2387,32284,64029,18019,12408,43367,42438,10445,44224,4026,53155,4572,42942,33414,13513,41784,64607,36013,54108,20745,57660,53136,18550,36848,2848,7785,2741,49349,48955,47612,56616,62029,42245,23755,54931,3374,54632,8151,34742,59018,16112,12900,38767,38260,20847,45830,48680,14494,55126,38700,46929,8501,31768,52105,13810,20774,50086,15976,2302,5678,21823,61197,64499,13780,52638,11649,8409,28806,54781,29614,3953,18506,14008,50953,2496,55251,14851,24312,5374,19643,14913,18766,61253,25247,28738,1271,51451,19637,16586,12816,7040,65133,20868,51334,45738,317,62963,31477,22819,6306,58588,26964,33345,51936,27078,16038,32886,27415,3135,33046,21689,46895,34581,23503,39614,32344,39286,4469,49667,42732,7114,17001,1073,39539,28543,56938,39293,60122,56355,4928,26551,11606,17189,27878,7661,29479,57531,54464,43972,33470,53573,17765,51559,18291,60588,63796,60782,7086,39876,33748,6306,21182,52832,55606,54737,32404,41843,35558,46600,426,65470,1311,34391,8140,3125,19565,28779,49173,16109,40674,38254,2905,55988,44752,45068,44089,2142,53766,59491,17578,36047,49527,13064,12945,53260,39316,57954,7537,48056,52711,49205,40541,26867,28191,55113,59919,9171,10727,52494,13554,36459,30919,36851,52730,18660,48077,60588,2653,39260,56874,30325,23506,45250,28385,46773,10180,4816,41644,14719,39463,64954,61439,49429,8639,64675,35407,46108,56734,25270,16091,38477,40072,60677,37903,63976,65171,18543,53767,54357,11133,65456,40401,63090,23635,11412,57900,3405,46351,33303,11625,44911,23931,4812,1795,4517,56501,43173,19608,50969,10191,32466,57083,20321,28190,40127,2896,60690,7989,45945,44619,55467,27647,10963,15726,51654,17950,33079,38766,31849,7244,51814,677,44644,41302,57883,42009,10060,40283,2572,34211,3744,2685,50171,65332,38362,36084,58530,64932,3837,58040,23518,21469,37354,62574,60679,20675,15976,58231,29011,38741,6741,56471,8687,59506,45841,2290,42650,63327,247,43681,65006,40717,437,9959,45115,33363,27581,36076,59880,28544,39594,33372,23417,56676,63894,7739,2465,65036,60794,24876,29804,15007,29791,12582,14400,5362,46709,57879,21523,52292,22829,36413,13917,42357,34547,46811,6067,64024,53692,24494,46648,13101,46877,1610,35716,61462,39220,50687,10415,10593,5633,59305,36279,8006,36737,64613,2633,33789,14169,40351,1082,37054,50914,29038,41652,33118,37787,61126,53811,6945,21677,17181,36562,22871,18436,8661,55348,41928,19329,54281,18395,24254,33283,16956,59607,4427,11085,25339,27968,28296,55050,65254,62879,49013,31357,18010,16733,60210,10846,64675,54045,13995,61751,29667,9816,11419,4332,59481,59364,56543,39873,51390,33137,30020,56556,21400,13819,43477,42055,15349,14425,37210,47097,13624,3952,3222,1883,28963,44288,22068,38377,38271,21076,44970,25994,44387,793,59786,52651,38780,65449,20935,314,62682,59546,30856,28722,8541,59825,31484,43053,41174,7754,40334,17974,24110,62176,48779,8215,24916,54848,36006,10461,25578,1537,6644,39925,13919,12726,33004,30348,23361,40713,57851,50911,377,45095,52568,24835,15665,15097,64644,24529,12338,34029,54419,36300,5421,23713,56749,57749,9557,32385,21609,41722,3092,28887,62790,38480,29866,11671,52200,1953,18576,2818,9898,52544,58807,15973,52683,57836,25740,7535,53411,25330,17050,13109,722,42543,8699,54338,56664,28444,25673,61883,57253,26969,36024,13098,33736,17491,54347,19854,2913,2094,63338,50805,27585,18791,64880,29160,13563,64285,51231,16851,36498,21859,10032,55360,14326,9261,75,6642,10319,39245,33111,24983,35480,51158,21156,47820,26762,17359,15326,22202,547,27422,19677,30356,387,46202,12316,32530,38176,56122,35123,17273,21070,32793,20405,16270,52856,45051,53147},
  {36909,44274,25695,34813,56595,55935,37367,20916,52948,60683,9390,57925,26839,9595,4365,35433,61676,36421,15670,53254,34530,5071,16978,18678,50702,52937,43491,16023,64982,42999,36809,5247,49716,35376,30161,16721,22161,39736,39096,17879,35929,23151,49560,36825,11981,41581,7515,1946,60987,39779,30619,16368,6499,64302,49896,53492,30593,28016,35728,25043,45259,27853,19822,52529,43213,35535,5457,22515,49643,45793,53195,18616,46960,24887,27551,30864,39633,8324,61434,53756,9951,59882,53278,47714,57299,19116,13972,111,26874,2315,24723,39500,54462,29041,59298,52107,117,42377,62783,16630,31832,33748,7433,63678,61819,17732,17468,44989,47786,17595,63688,45623,3963,59976,51177,60339,44695,10337,36029,22912,3293,11902,31654,62860,7659,32100,56288,11903,12614,15910,59329,5238,47919,54622,18088,33960,34839,43940,46211,34175,16504,25186,46460,19721,13902,9761,48731,56682,53342,4601,29002,42667,53708,49818,54376,4418,17300,23224,46800,17528,8141,10494,60552,5183,25468,19860,27805,28212,45615,26211,55310,17381,51568,54736,38808,58586,65346,37468,35340,30206,65092,29386,57086,20950,63376,6397,19976,41442,64411,62065,49111,44300,6037,38699,64818,41819,51761,40786,8252,32504,24514,41675,7704,3695,7101,4145,17173,27375,19180,30377,27434,36344,46600,34257,23136,61478,45236,8872,3025,25736,61734,65349,30389,64322,1850,25445,49636,24556,24141,38528,38464,2187,13630,51970,19751,3035,10019,60290,6734,37981,22153,40411,17440,23234,26372,45074,64630,20980,56362,65325,51738,45877,64468,43023,57125,64614,59208,46782,40401,31697,57680,1711,38598,612,47911,8163,60163,30904,40725,55655,33030,22446,35337,47356,37735,39195,20714,8583,28007,8778,4741,36132,46258,23248,10364,19727,28631,46519,813,36893,18951,62660,37370,52316,44993,64395,13354,52528,28639,47285,15435,56271,9836,41182,41224,37695,50395,5275,30957,50437,65055,52408,45663,18932,56557,17603,9061,48559,7455,47635,1931,6410,19432,22120,23617,64170,60637,10199,46299,43969,24993,63060,31984,39481,18047,46292,17765,53449,63855,17893,63,31806,28575,46422,40457,47994,36171,3129,62619,52080,32568,32960,33515,32801,28123,53949,33827,4321,36789,21947,30055,22200,22639,11822,54101,42586,35883,36947,9407,14114,16111,42660,23598,11361,41479,18428,23460,63215,36731,24174,1123,23771,15692,46672,52928,27401,28106,36477,41302,41965,28265,17128,46102,37987,4276,65057,16956,49420,15923,2839,29283,31414,1842,20978,53333,45149,56913,59459,9253,48850,60384,33518,45475,44408,26445,55968,64455,51501,2164,42897,50376,47870,44771,14179,61990,53533,61189,43613,61606,18606,8007,20493,50414,32269,43130,58458,433,47038,47258,49205,39557,57123,52920,20068,28893,24886,23887,43446,54921,11205,7770,14831,61338,43167,64186,41449,48022,33212,38745,29001,41579,12896,52447,4561,24607,3979,29202,42110,47491,29650,37199,25954,23692,54891,32367,62376,24224,58679,19484,58739,26943,55803,39430,23386,46098,22591,61605,8220,21514,672,21242,45914,5619,4231,23693,55600,15097,39018,60625,54779,55746,37995,12690,11762,13894,58843,30850,2820,42316,53141,4357,48316,50013,36902,64513,44631,95,62494,30926,8662,43154,63510,44698,16279,39049,39805,62946,65302,41795,9907,32824,42007,16081,17474,62606,26056,61556,33592,24867,59981,8810,37611,16204,38720,7916,49239,19374,30136,61877,2489,19225,36059,27191,16570,26789,21136,60128,32573,732,16252,20830,23185,14992,4832,61203,15476,51712,11410,44102,6136,17493,5859,2519,44635,6551,8177,20262,4992,62806,7487,41343,31516,37056,59711,7940,34452,55686,46236,21197,34750,15486,2444,24928,4972,35295,23229,38075,18094,49502,54249,14839,4356,17175,30821,58762,26907,55928,7471,27027,48598,3439,18785,60462,43308,32739,13199,1128,22652,54595,31654,51374,25460,46967,49233,17364,5178,56858,44481,23395,35092,31923,13265,56112,58597,21312,36179,36694,11438,50019,29042,62623,16235,24947,40101,45193,62552,32309,64312,19302,42431,51140,39599,42332},
  {20772,57923,25709,36040,5465,34659,65065,39857,44789,9479,35089,38961,61105,1202,49504,52402,36934,11720,22641,21707,37055,5495,55562,47966,19207,57309,25990,61407,63580,55274,51444,33918,20057,57019,43479,33658,11371,48073,45533,38058,15430,52667,64082,5615,8146,37991,4261,45322,16856,49577,64469,25847,59126,42605,34635,25035,4153,1340,39897,7508,8398,3554,16810,38884,47279,52220,36399,40591,25612,14313,61017,28442,3700,24382,50443,30605,58336,41453,64627,30379,12004,4883,54932,51250,37879,24837,12575,35567,46447,35734,57198,39229,49609,18446,64059,61066,1030,38432,23274,37483,42653,59546,60223,64293,20217,50187,54948,43531,56827,9614,46355,31432,54161,35386,46444,26026,23297,43783,36559,19966,65484,22338,14436,53986,43577,48906,13915,49428,42678,17164,2520,33408,48756,19165,46184,15389,5632,39293,32681,4040,18269,26671,57288,10560,52215,18917,24199,59753,48250,44909,59103,15072,44382,40334,10787,62442,23339,40618,17587,10718,53247,2825,9985,3591,39220,32325,64138,1234,33443,878,35824,31010,16665,53294,11984,31823,59272,57825,39528,27559,53410,9890,52346,26232,25443,7703,12649,22,22895,54188,58894,5304,51444,4571,48078,36955,25801,25160,33940,46043,28421,23228,31410,54958,19914,39100,21241,14518,59993,44587,23283,47562,6092,22120,48721,15120,34088,3203,22968,56218,15361,38385,53265,49496,40804,47472,9128,16971,23438,1455,24811,49442,36314,21221,44845,11499,47353,38326,28102,26967,20262,53375,11617,53190,41952,64297,63495,30014,35547,39924,22953,47166,11548,46323,4874,9761,22555,32486,5743,24471,38912,54170,63762,29211,34715,27398,118,59636,30029,18455,51198,19195,8577,12440,8224,11153,30376,24457,21006,57153,49640,19654,1077,57388,33915,2821,32394,39733,63081,16778,65328,60802,22791,55354,32006,1521,26218,63996,59901,16769,33657,26400,12558,33146,54517,44627,15074,13801,1298,13430,21423,6904,10166,63080,15663,34264,46751,65366,49888,48599,4130,32924,25113,23857,46450,31326,42948,10649,46128,31621,34991,49187,30137,11332,44631,12693,47678,54082,58151,43363,29395,53421,28485,60476,47351,38440,6732,2024,32349,13737,4998,60332,3695,41348,49764,52305,44569,3297,18633,43987,8119,60177,52431,6491,15915,53576,53455,65489,50139,40803,4450,3226,48668,52485,8656,31215,28533,23375,61658,2862,27871,17333,60541,46112,33559,32504,4139,11547,12373,9235,61177,7580,5403,26790,28373,55634,32449,25805,19462,55821,21385,55139,12447,13636,44764,18969,32635,61265,44083,42087,57440,3788,29249,58440,51429,35551,11620,26117,63275,27569,63685,49336,60243,15943,12898,34625,51338,44134,65389,1832,47176,64337,35325,53215,12990,22304,42132,21249,48090,46284,65461,24356,44138,62236,9154,39540,20087,57058,1454,55429,32631,28247,43371,19049,14441,62488,10262,4192,32238,65370,33923,41564,50229,30131,12359,54165,32095,30072,13340,7729,38687,16275,34057,50027,2493,53164,37657,61022,20379,53413,48824,31044,51463,44469,37069,57737,30870,60700,34000,30017,36244,22620,22903,36822,24230,28053,3899,9057,53984,46768,38408,8988,33754,62740,46220,26827,27265,20661,47633,46217,10782,40386,22866,37140,12825,56773,20559,5083,60615,40160,59459,58251,39131,30723,26401,48262,62175,28930,60626,43723,13975,10180,12729,55382,12724,13733,41847,34931,42212,54740,48306,54387,37976,29115,65223,22954,59358,43436,48762,60269,1829,45847,40730,32883,12239,52400,3501,62567,44721,3273,9884,18084,15180,10671,29611,45365,9379,46654,39526,20279,9028,37267,49902,20451,33136,52691,32590,4883,50163,25252,48215,63489,26866,15469,29471,33211,20947,14758,9333,62158,14639,25604,33619,9566,48402,35271,3992,26481,5836,60899,49434,5122,55786,13713,39224,38157,33593,44418,65115,33227,8415,43366,65105,24528,33592,3773,42320,2834,57497,46463,2319,14471,20769,4494,23314,31779,21048,20206,22959,49027,33169,50651,27630,56085,34163,31908,31600,57798,55669,42758,33099,65475,27658,8169,59073,49651,43797,23374,2478,9137,5380,44254,906},
} ;

static void test_encode_653xint16_impl(long long impl)
{
  unsigned char *s = test_encode_653xint16_s;
  unsigned char *x = test_encode_653xint16_x;
  unsigned char *s2 = test_encode_653xint16_s2;
  unsigned char *x2 = test_encode_653xint16_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_653xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_653xint16(impl);
    printf("encode_653xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_653xint16_implementation(impl),ntruprime_dispatch_encode_653xint16_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_653xint16;
    printf("encode_653xint16 selected implementation %s compiler %s\n",ntruprime_encode_653xint16_implementation(),ntruprime_encode_653xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_653xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_653xint16_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_653xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_653xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_653xint16_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_653xint16_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_653xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"653xint16")) return;
  storage_encode_653xint16_s = callocplus(crypto_encode_STRBYTES);
  test_encode_653xint16_s = aligned(storage_encode_653xint16_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_653xint16_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_653xint16_x = aligned(storage_encode_653xint16_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_653xint16_s2 = callocplus(maxalloc);
  test_encode_653xint16_s2 = aligned(storage_encode_653xint16_s2,crypto_encode_STRBYTES);
  storage_encode_653xint16_x2 = callocplus(maxalloc);
  test_encode_653xint16_x2 = aligned(storage_encode_653xint16_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_653xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_653xint16();++impl)
      forked(test_encode_653xint16_impl,impl);
    ++test_encode_653xint16_s;
    ++test_encode_653xint16_x;
    ++test_encode_653xint16_s2;
    ++test_encode_653xint16_x2;
  }
  free(storage_encode_653xint16_x2);
  free(storage_encode_653xint16_s2);
  free(storage_encode_653xint16_x);
  free(storage_encode_653xint16_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

