/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import impl.org.controlsfx.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TreeItem;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.util.Callback;
import org.controlsfx.control.BreadCrumbBar;

public class BreadCrumbBarSkin<T>
extends SkinBase<BreadCrumbBar<T>> {
    private static final String STYLE_CLASS_FIRST = "first";
    private final ChangeListener<TreeItem<T>> selectedPathChangeListener = (obs, oldItem, newItem) -> this.updateSelectedPath((TreeItem<T>)newItem, (TreeItem<T>)oldItem);
    private final EventHandler<TreeItem.TreeModificationEvent<Object>> treeChildrenModifiedHandler = args -> this.updateBreadCrumbs();

    public BreadCrumbBarSkin(BreadCrumbBar<T> control) {
        super(control);
        control.selectedCrumbProperty().addListener(this.selectedPathChangeListener);
        this.updateSelectedPath((TreeItem)((BreadCrumbBar)this.getSkinnable()).selectedCrumbProperty().get(), null);
        this.fixFocusTraversal();
    }

    private void fixFocusTraversal() {
        ParentTraversalEngine engine = new ParentTraversalEngine((Parent)this.getSkinnable(), new Algorithm(){

            public Node select(Node owner, Direction dir, TraversalContext context) {
                Node node = null;
                int idx = BreadCrumbBarSkin.this.getChildren().indexOf((Object)owner);
                switch (dir) {
                    case NEXT: 
                    case NEXT_IN_LINE: 
                    case RIGHT: {
                        if (idx >= BreadCrumbBarSkin.this.getChildren().size() - 1) break;
                        node = (Node)BreadCrumbBarSkin.this.getChildren().get(idx + 1);
                        break;
                    }
                    case PREVIOUS: 
                    case LEFT: {
                        if (idx <= 0) break;
                        node = (Node)BreadCrumbBarSkin.this.getChildren().get(idx - 1);
                    }
                }
                return node;
            }

            public Node selectFirst(TraversalContext context) {
                Node first = null;
                if (!BreadCrumbBarSkin.this.getChildren().isEmpty()) {
                    first = (Node)BreadCrumbBarSkin.this.getChildren().get(0);
                }
                return first;
            }

            public Node selectLast(TraversalContext context) {
                Node last = null;
                if (!BreadCrumbBarSkin.this.getChildren().isEmpty()) {
                    last = (Node)BreadCrumbBarSkin.this.getChildren().get(BreadCrumbBarSkin.this.getChildren().size() - 1);
                }
                return last;
            }
        });
        engine.setOverriddenFocusTraversability(Boolean.valueOf(false));
        ReflectionUtils.setTraversalEngine(this.getSkinnable(), engine);
    }

    private void updateSelectedPath(TreeItem<T> newTarget, TreeItem<T> oldTarget) {
        if (oldTarget != null) {
            oldTarget.removeEventHandler(TreeItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        if (newTarget != null) {
            newTarget.addEventHandler(TreeItem.childrenModificationEvent(), this.treeChildrenModifiedHandler);
        }
        this.updateBreadCrumbs();
    }

    private void updateBreadCrumbs() {
        BreadCrumbBar buttonBar = (BreadCrumbBar)this.getSkinnable();
        TreeItem pathTarget = buttonBar.getSelectedCrumb();
        Callback factory = buttonBar.getCrumbFactory();
        this.getChildren().clear();
        if (pathTarget != null) {
            List crumbs = this.constructFlatPath(pathTarget);
            for (int i = 0; i < crumbs.size(); ++i) {
                Button crumb = this.createCrumb(factory, crumbs.get(i));
                crumb.setMnemonicParsing(false);
                if (i == 0) {
                    if (!crumb.getStyleClass().contains((Object)STYLE_CLASS_FIRST)) {
                        crumb.getStyleClass().add((Object)STYLE_CLASS_FIRST);
                    }
                } else {
                    crumb.getStyleClass().remove((Object)STYLE_CLASS_FIRST);
                }
                this.getChildren().add((Object)crumb);
            }
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node n = (Node)this.getChildren().get(i);
            double nw = this.snapSize(n.prefWidth(h));
            double nh = this.snapSize(n.prefHeight(-1.0));
            if (i > 0) {
                double ins = n instanceof BreadCrumbButton ? ((BreadCrumbButton)n).getArrowWidth() : 0.0;
                x = this.snapPosition(x - ins);
            }
            n.resize(nw, nh);
            n.relocate(x, y);
            x += nw;
        }
    }

    private List<TreeItem<T>> constructFlatPath(TreeItem<T> bottomMost) {
        ArrayList<TreeItem<T>> path = new ArrayList<TreeItem<T>>();
        TreeItem current = bottomMost;
        do {
            path.add(current);
        } while ((current = current.getParent()) != null);
        Collections.reverse(path);
        return path;
    }

    private Button createCrumb(Callback<TreeItem<T>, Button> factory, TreeItem<T> selectedCrumb) {
        Button crumb = (Button)factory.call(selectedCrumb);
        crumb.getStyleClass().add((Object)"crumb");
        crumb.setOnAction(ae -> this.onBreadCrumbAction(selectedCrumb));
        return crumb;
    }

    protected void onBreadCrumbAction(TreeItem<T> crumbModel) {
        BreadCrumbBar breadCrumbBar = (BreadCrumbBar)this.getSkinnable();
        Event.fireEvent((EventTarget)breadCrumbBar, new BreadCrumbBar.BreadCrumbActionEvent<T>(crumbModel));
        if (breadCrumbBar.isAutoNavigationEnabled()) {
            breadCrumbBar.setSelectedCrumb(crumbModel);
        }
    }

    public static class BreadCrumbButton
    extends Button {
        private final ObjectProperty<Boolean> first = new SimpleObjectProperty((Object)this, "first");
        private final double arrowWidth = 5.0;
        private final double arrowHeight = 20.0;

        public BreadCrumbButton(String text) {
            this(text, null);
        }

        public BreadCrumbButton(String text, Node gfx) {
            super(text, gfx);
            this.first.set((Object)false);
            this.getStyleClass().addListener(new InvalidationListener(){

                public void invalidated(Observable arg0) {
                    this.updateShape();
                }
            });
            this.updateShape();
        }

        private void updateShape() {
            this.setShape((Shape)this.createButtonShape());
        }

        public double getArrowWidth() {
            return 5.0;
        }

        private Path createButtonShape() {
            Path path = new Path();
            MoveTo e1 = new MoveTo(0.0, 0.0);
            path.getElements().add((Object)e1);
            HLineTo e2 = new HLineTo();
            e2.xProperty().bind((ObservableValue)this.widthProperty().subtract(5.0));
            path.getElements().add((Object)e2);
            LineTo e3 = new LineTo();
            e3.xProperty().bind((ObservableValue)e2.xProperty().add(5.0));
            e3.setY(10.0);
            path.getElements().add((Object)e3);
            LineTo e4 = new LineTo();
            e4.xProperty().bind((ObservableValue)e2.xProperty());
            e4.setY(20.0);
            path.getElements().add((Object)e4);
            HLineTo e5 = new HLineTo(0.0);
            path.getElements().add((Object)e5);
            if (!this.getStyleClass().contains((Object)BreadCrumbBarSkin.STYLE_CLASS_FIRST)) {
                LineTo e6 = new LineTo(5.0, 10.0);
                path.getElements().add((Object)e6);
            } else {
                ArcTo arcTo = new ArcTo();
                arcTo.setSweepFlag(true);
                arcTo.setX(0.0);
                arcTo.setY(0.0);
                arcTo.setRadiusX(15.0);
                arcTo.setRadiusY(15.0);
                path.getElements().add((Object)arcTo);
            }
            ClosePath e7 = new ClosePath();
            path.getElements().add((Object)e7);
            path.setFill((Paint)Color.BLACK);
            return path;
        }
    }
}

