/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

/*
 * fcombautogen.c
 *
 *    This program is used to generate the two files of dwa code for combs,
 *    that are used in linear composite dwa operations for brick Sels.
 *    If filename is not given, the files are:
 *         dwacomb.<n>.c
 *         dwacomblow.<n>.c
 *    Otherwise they are:
 *         <filename>.<n>.c
 *         <filename>low.<n>.c
 *    where <n> is the input index.
 *    These two files, when compiled, are used to implement all
 *    the composite dwa operations for brick Sels, that are
 *    generated by selaAddDwaCombs().
 *
 *    The library files dwacomp.2.c and dwacomblow.2.c were made
 *    using <n> = 2.
 */

#ifdef HAVE_CONFIG_H
#include <config_auto.h>
#endif  /* HAVE_CONFIG_H */

#include "allheaders.h"

int main(int    argc,
         char **argv)
{
char        *filename;
l_int32      index, ret;
SELA        *sela;
static char  mainName[] = "fcombautogen";

    if (argc != 2 && argc != 3)
        return ERROR_INT(" Syntax:  fcombautogen index <filename>",
                         mainName, 1);

    setLeptDebugOK(1);
    index = atoi(argv[1]);
    sela = selaAddDwaCombs(NULL);

    if (argc == 2)
        filename = stringNew("dwacomb");
    else
        filename = argv[2];
    ret = fmorphautogen(sela, index, filename);

    if (argc == 2)
        lept_free(filename);
    selaDestroy(&sela);
    return ret;
}

