#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-car-porsche911@example.com"
SENDER="mailto:paul.boddie@example.com"
QUOTA=cars

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"
cat > "$PREFS/$USER/scheduling_function" <<EOF
schedule_in_freebusy
check_quota $QUOTA
EOF

# Employ a quota.

cat <<EOF | "$SET_QUOTA_LIMITS" "$QUOTA" $SET_QUOTA_LIMITS_ARGS
* PT10H
EOF

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-car-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

# Attempt to schedule an event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out0f.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out0f.tmp" \
&& grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out0f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-car-recurring.txt" 2>> $ERROR \
| tee out1r.tmp \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out1f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1f.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out1f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is not confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out1e.tmp

   ! grep -q "event24@example.com" "out1e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Modify the event and attempt to schedule it again.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=11/;' "$TEMPLATES/event-request-car-recurring.txt" \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out1s.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out1s.tmp" \
&& grep -q "^20141205T150000Z${TAB}20141205T160000Z" "out1s.tmp" \
&& grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out1s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=11/;' "$TEMPLATES/event-request-car-recurring.txt" \
| "$RESOURCE_SCRIPT" $ARGS 2>> $ERROR \
| tee out2r.tmp \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=DECLINED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out2f.tmp

   ! grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2f.tmp" \
&& ! grep -q "^20141205T150000Z${TAB}20141205T160000Z" "out2f.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out2f.tmp"  \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out2e.tmp

   ! grep -q "event24@example.com" "out2e.tmp" \
&& echo "Success" \
|| echo "Failed"

# Modify the event and attempt to schedule it again.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=10/;' "$TEMPLATES/event-request-car-recurring.txt" \
| "$OUTGOING_SCRIPT" $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out2s.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out2s.tmp" \
&& grep -q "^20141205T150000Z${TAB}20141205T160000Z" "out2s.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out2s.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the resource.

  sed 's/FREQ=DAILY/FREQ=DAILY;COUNT=10/;' "$TEMPLATES/event-request-car-recurring.txt" \
| "$RESOURCE_SCRIPT" $ARGS 2>> $ERROR \
| tee out3r.tmp \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'ATTENDEE.*;PARTSTAT=ACCEPTED' out3.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out3f.tmp

   grep -q "^20141126T150000Z${TAB}20141126T160000Z" "out3f.tmp" \
&& grep -q "^20141205T150000Z${TAB}20141205T160000Z" "out3f.tmp" \
&& ! grep -q "^20141206T150000Z${TAB}20141206T160000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Check the quota (event is confirmed).

   "$LIST_SCRIPT" $LIST_ARGS "$QUOTA" "entries" "$SENDER" \
>  out3e.tmp

   grep -q "event24@example.com" "out3e.tmp" \
&& echo "Success" \
|| echo "Failed"
