#pragma once
/*
 *  $Id: graph-window.h 28652 2025-10-16 14:04:50Z yeti-dn $
 *  Copyright (C) 2004-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_WINDOW_H__
#define __GWYUI_GRAPH_WINDOW_H__

#include <gtk/gtk.h>
#include <libgwyui/graph.h>

G_BEGIN_DECLS

#define GWY_TYPE_GRAPH_WINDOW            (gwy_graph_window_get_type())
#define GWY_GRAPH_WINDOW(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_WINDOW, GwyGraphWindow))
#define GWY_GRAPH_WINDOW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_WINDOW, GwyGraphWindowClass))
#define GWY_IS_GRAPH_WINDOW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_WINDOW))
#define GWY_IS_GRAPH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_WINDOW))
#define GWY_GRAPH_WINDOW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_WINDOW, GwyGraphWindowClass))

typedef struct _GwyGraphWindow             GwyGraphWindow;
typedef struct _GwyGraphWindowClass        GwyGraphWindowClass;
typedef struct _GwyGraphWindowPrivate      GwyGraphWindowPrivate;

struct _GwyGraphWindow {
    GtkWindow parent_instance;
    GwyGraphWindowPrivate *priv;
};

struct _GwyGraphWindowClass {
    GtkWindowClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
};

GType      gwy_graph_window_get_type        (void)                    G_GNUC_CONST;
GtkWidget* gwy_graph_window_new             (GwyGraphModel *gmodel);
GtkWidget* gwy_graph_window_get_graph       (GwyGraphWindow *window);
GtkWidget* gwy_graph_window_get_graph_data  (GwyGraphWindow *window);
GtkWidget* gwy_graph_window_get_graph_curves(GwyGraphWindow *window);
void       gwy_graph_window_set_data_name   (GwyGraphWindow *window,
                                             const gchar *name);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
