#pragma once
/*
 *  $Id: tip-model.h 28777 2025-11-04 16:46:05Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_TIP_MODEL_H__
#define __GWY_TIP_MODEL_H__

#include <libgwyddion/resource.h>
#include <libgwyddion/inventory.h>
#include <libgwyddion/field.h>

G_BEGIN_DECLS

typedef enum {
    GWY_TIP_PARAM_HEIGHT     = 0,
    GWY_TIP_PARAM_RADIUS     = 1,
    GWY_TIP_PARAM_ROTATION   = 2,
    GWY_TIP_PARAM_NSIDES     = 3,
    GWY_TIP_PARAM_SLOPE      = 4,
    GWY_TIP_PARAM_ANISOTROPY = 5,
} GwyTipParamType;

#define GWY_TYPE_TIP_MODEL            (gwy_tip_model_get_type())
#define GWY_TIP_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_TIP_MODEL, GwyTipModel))
#define GWY_TIP_MODEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_TIP_MODEL, GwyTipModelClass))
#define GWY_IS_TIP_MODEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_TIP_MODEL))
#define GWY_IS_TIP_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_TIP_MODEL))
#define GWY_TIP_MODEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_TIP_MODEL, GwyTipModelClass))

typedef struct _GwyTipModel        GwyTipModel;
typedef struct _GwyTipModelClass   GwyTipModelClass;
typedef struct _GwyTipModelPrivate GwyTipModelPrivate;

struct _GwyTipModel {
    GwyResource parent_instance;
    struct _GwyTipModelPrivate *priv;
};

struct _GwyTipModelClass {
    GwyResourceClass parent_class;
};

GwyInventory*          gwy_tip_models                 (void)                   G_GNUC_PURE;
GType                  gwy_tip_model_get_type         (void)                   G_GNUC_CONST;
const gchar*           gwy_tip_model_get_group_name   (GwyTipModel* model);
gint                   gwy_tip_model_get_nparams      (GwyTipModel* model);
const GwyTipParamType* gwy_tip_model_get_params       (GwyTipModel* model);
void                   gwy_tip_model_create           (GwyTipModel* model,
                                                       GwyField *tip,
                                                       const gdouble *params);
void                   gwy_tip_model_create_for_zrange(GwyTipModel* model,
                                                       GwyField *tip,
                                                       gdouble zrange,
                                                       gboolean square,
                                                       const gdouble *params);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
