#pragma once
/*
 *  $Id: gl-material.h 28777 2025-11-04 16:46:05Z yeti-dn $
 *  Copyright (C) 2005-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_GL_MATERIAL_H__
#define __GWY_GL_MATERIAL_H__

#include <glib-object.h>
#include <libgwyddion/resource.h>
#include <libgwyddion/rgba.h>

G_BEGIN_DECLS

#define GWY_GL_MATERIAL_DEFAULT "OpenGL-Default"
#define GWY_GL_MATERIAL_NONE    "None"

#define GWY_TYPE_GL_MATERIAL            (gwy_gl_material_get_type())
#define GWY_GL_MATERIAL(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GL_MATERIAL, GwyGLMaterial))
#define GWY_GL_MATERIAL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GL_MATERIAL, GwyGLMaterialClass))
#define GWY_IS_GL_MATERIAL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GL_MATERIAL))
#define GWY_IS_GL_MATERIAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GL_MATERIAL))
#define GWY_GL_MATERIAL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GL_MATERIAL, GwyGLMaterialClass))

typedef struct _GwyGLMaterial        GwyGLMaterial;
typedef struct _GwyGLMaterialClass   GwyGLMaterialClass;
typedef struct _GwyGLMaterialPrivate GwyGLMaterialPrivate;

struct _GwyGLMaterial {
    GwyResource parent_instance;
    GwyGLMaterialPrivate *priv;
};

struct _GwyGLMaterialClass {
    GwyResourceClass parent_class;

    void (*reserved1)(void);
    void (*reserved2)(void);
};

GType          gwy_gl_material_get_type     (void)                       G_GNUC_CONST;
const GwyRGBA* gwy_gl_material_get_ambient  (GwyGLMaterial *glmaterial);
void           gwy_gl_material_set_ambient  (GwyGLMaterial *glmaterial,
                                             const GwyRGBA *ambient);
const GwyRGBA* gwy_gl_material_get_diffuse  (GwyGLMaterial *glmaterial);
void           gwy_gl_material_set_diffuse  (GwyGLMaterial *glmaterial,
                                             const GwyRGBA *diffuse);
const GwyRGBA* gwy_gl_material_get_specular (GwyGLMaterial *glmaterial);
void           gwy_gl_material_set_specular (GwyGLMaterial *glmaterial,
                                             const GwyRGBA *specular);
const GwyRGBA* gwy_gl_material_get_emission (GwyGLMaterial *glmaterial);
void           gwy_gl_material_set_emission (GwyGLMaterial *glmaterial,
                                             const GwyRGBA *emission);
gdouble        gwy_gl_material_get_shininess(GwyGLMaterial *glmaterial);
void           gwy_gl_material_set_shininess(GwyGLMaterial *glmaterial,
                                             gdouble shininess);
void           gwy_gl_material_reset        (GwyGLMaterial *glmaterial);

GwyInventory*  gwy_gl_materials                (void)               G_GNUC_PURE;
GwyGLMaterial* gwy_gl_materials_get_gl_material(const gchar *name);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
