/*
 *  $Id: mac_integration.c 27928 2025-05-07 17:08:43Z yeti-dn $
 *  Copyright (C) 2009 Andrey Gruzdev.
 *  E-mail: gruzdev@ntmdt.ru.
 *
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* FIXME: See
 * https://github.com/GNOME/gtk-mac-integration/blob/master/src/test-integration.c
 * for example code with all kinds of integration stuff (some should be handled by the libraries already, but extra
 * work may be needed). We need a way to build and test the Mac code.
 */

#include "config.h"
#include <AppKit/AppKit.h>
#include <CoreFoundation/CoreFoundation.h>
#include <gtkmacintegration/gtkosxapplication.h>
#include "libgwyapp/gwyapp.h"
#include "gwyddion/mac_integration.h"

static GtkosxApplication *theApp = NULL;

void
gwyddion_mac_startup(void)
{
    g_assert(!theApp);
    theApp = g_object_new(GTKOSX_TYPE_APPLICATION, NULL);
}

void
gwyddion_mac_shutdown(void)
{
    g_assert(theApp);
    g_clear_object(&theApp);
}

/* FIXME: This should be probably recursive or something. Look at the examples. */
void
gwyddion_mac_build_menu(GtkWidget *container)
{
    GList *children;
    GList *l, *ll, *lll;
    GtkWidget *menubar = gtk_menu_bar_new();

    gtk_widget_set_name(menubar, "toolboxmenubar");
    children = gtk_container_get_children(GTK_CONTAINER(container));
    for (l = children; l; l = l->next) {
        GtkWidget *widget = l->data;

        if (GTK_IS_CONTAINER(widget)) {
            children = gtk_container_get_children(GTK_CONTAINER(widget));
            for (ll = children; ll; ll = ll->next) {
                GtkWidget *subwidget = ll->data;

                if (GTK_IS_CONTAINER(subwidget)) {
                    children = gtk_container_get_children(GTK_CONTAINER(subwidget));
                    for (lll = children; lll; lll = lll->next) {
                        GtkWidget *subsubwidget = lll->data;

                        if (GTK_IS_MENU_ITEM(subsubwidget)) {
                            gtk_widget_hide(widget);
                            g_object_ref(subsubwidget);
                            gtk_container_remove(GTK_CONTAINER(subwidget), subsubwidget);
                            gtk_menu_shell_append(GTK_MENU_SHELL(menubar), subsubwidget);
                            g_object_unref(subsubwidget);
                        }
                    }
                }
            }
        }
    }
    gtk_container_add(GTK_CONTAINER(container), menubar);
    gtk_widget_hide(menubar);
    gtkosx_application_set_menu_bar(theApp, GTK_MENU_SHELL(menubar));
    gtkosx_application_ready(theApp);
}

void
gwyddion_mac_set_locale(void)
{
    static const struct {
        const gchar *locale;
        const gchar *lang;
    }
    locales[] = {
/* The following generated part is updated by running utils/update-langs.py */
/* @@@ GENERATED LANG OS X BEGIN @@@ */
        { "en_US.UTF-8", "en" },
        { "cs_CZ.UTF-8", "cs" },
        { "de_DE.UTF-8", "de" },
        { "en_GB.UTF-8", "en_GB" },
        { "fr_FR.UTF-8", "fr" },
        { "it_IT.UTF-8", "it" },
        { "ja_JP.UTF-8", "ja" },
        { "ko_KR.UTF-8", "ko" },
        { "pt_BR.UTF-8", "pt_BR" },
        { "ru_RU.UTF-8", "ru" },
        { "es_ES.UTF-8", "es" },
/* @@@ GENERATED LANG OS X END @@@ */
    };

    CFTypeRef preferences = CFPreferencesCopyAppValue(CFSTR("AppleLanguages"), kCFPreferencesCurrentApplication);

    if (preferences != NULL && CFGetTypeID(preferences) == CFArrayGetTypeID()) {
        CFArrayRef prefArray = (CFArrayRef) preferences;
        int n = CFArrayGetCount(prefArray);
        static char buf[256];

        for (int i = 0; i < n; i++) {
            CFTypeRef element = CFArrayGetValueAtIndex(prefArray, i);

            if (element != NULL
                && CFGetTypeID(element) == CFStringGetTypeID()
                && CFStringGetCString((CFStringRef) element, buf, sizeof(buf), kCFStringEncodingASCII)) {

                for (int j = 0; j < G_N_ELEMENTS(locales); j++) {
                    if (gwy_strequal(locales[j].lang, buf)) {
                        g_setenv("LANG", locales[j].locale, TRUE);
                        goto exit;
                    }
                }
            }
        }
exit:
        CFRelease(preferences);
    }
}

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
