//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementGetAuthorizationLoginRequest.json
func ExampleAuthorizationLoginLinksClient_Post() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAuthorizationLoginLinksClient().Post(ctx, "rg1", "apimService1", "aadwithauthcode", "authz1", armapimanagement.AuthorizationLoginRequestContract{
		PostLoginRedirectURL: to.Ptr("https://www.bing.com/"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AuthorizationLoginResponseContract = armapimanagement.AuthorizationLoginResponseContract{
	// 	LoginLink: to.Ptr("https://authorization-manager.consent.azure-apim.net/redirect/apim/apimService1/login?data=eyJMb2dpbklkIjoiY2YtODNmYzQ5N2YyZWYxNDA4MzlmNDdjZDU3YWY3MmZmODctYW5nYW50aS1wcmV2aWV3X2FhZC1hdXRoY29kZV9vYXV0aDItY29kZV90b2tlbiIsIlNlc3Npb25JZCI6IiIsIkxvZ0Nvbm5lY3Rpb25JZCI6ImF1dGh6MiIsIkxvZ0Nvbm5lY3RvcklkIjoiYWFkLWF1dGhjb2RlIiwiTG9nRW52aXJvbm1lbnRJZCI6ImFuZ2FudGktcHJld"),
	// }
}
