// Code generated by smithy-go-codegen DO NOT EDIT.

package appconfig

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appconfig/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateApplication struct {
}

func (*validateOpCreateApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateConfigurationProfile struct {
}

func (*validateOpCreateConfigurationProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateConfigurationProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateConfigurationProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateConfigurationProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDeploymentStrategy struct {
}

func (*validateOpCreateDeploymentStrategy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDeploymentStrategy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDeploymentStrategyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDeploymentStrategyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateEnvironment struct {
}

func (*validateOpCreateEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateExtensionAssociation struct {
}

func (*validateOpCreateExtensionAssociation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateExtensionAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateExtensionAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateExtensionAssociationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateExtension struct {
}

func (*validateOpCreateExtension) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateExtension) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateExtensionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateExtensionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateHostedConfigurationVersion struct {
}

func (*validateOpCreateHostedConfigurationVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateHostedConfigurationVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateHostedConfigurationVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateHostedConfigurationVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApplication struct {
}

func (*validateOpDeleteApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteConfigurationProfile struct {
}

func (*validateOpDeleteConfigurationProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteConfigurationProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteConfigurationProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteConfigurationProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDeploymentStrategy struct {
}

func (*validateOpDeleteDeploymentStrategy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDeploymentStrategy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDeploymentStrategyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDeploymentStrategyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteEnvironment struct {
}

func (*validateOpDeleteEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteExtensionAssociation struct {
}

func (*validateOpDeleteExtensionAssociation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteExtensionAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteExtensionAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteExtensionAssociationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteExtension struct {
}

func (*validateOpDeleteExtension) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteExtension) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteExtensionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteExtensionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteHostedConfigurationVersion struct {
}

func (*validateOpDeleteHostedConfigurationVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteHostedConfigurationVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteHostedConfigurationVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteHostedConfigurationVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetApplication struct {
}

func (*validateOpGetApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetConfiguration struct {
}

func (*validateOpGetConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetConfigurationProfile struct {
}

func (*validateOpGetConfigurationProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetConfigurationProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetConfigurationProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetConfigurationProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDeployment struct {
}

func (*validateOpGetDeployment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDeployment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDeploymentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDeploymentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDeploymentStrategy struct {
}

func (*validateOpGetDeploymentStrategy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDeploymentStrategy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDeploymentStrategyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDeploymentStrategyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetEnvironment struct {
}

func (*validateOpGetEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetExtensionAssociation struct {
}

func (*validateOpGetExtensionAssociation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetExtensionAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetExtensionAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetExtensionAssociationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetExtension struct {
}

func (*validateOpGetExtension) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetExtension) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetExtensionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetExtensionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetHostedConfigurationVersion struct {
}

func (*validateOpGetHostedConfigurationVersion) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetHostedConfigurationVersion) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetHostedConfigurationVersionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetHostedConfigurationVersionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListConfigurationProfiles struct {
}

func (*validateOpListConfigurationProfiles) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListConfigurationProfiles) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListConfigurationProfilesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListConfigurationProfilesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListDeployments struct {
}

func (*validateOpListDeployments) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListDeployments) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListDeploymentsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListDeploymentsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListEnvironments struct {
}

func (*validateOpListEnvironments) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListEnvironments) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListEnvironmentsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListEnvironmentsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListHostedConfigurationVersions struct {
}

func (*validateOpListHostedConfigurationVersions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListHostedConfigurationVersions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListHostedConfigurationVersionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListHostedConfigurationVersionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartDeployment struct {
}

func (*validateOpStartDeployment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartDeployment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartDeploymentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartDeploymentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStopDeployment struct {
}

func (*validateOpStopDeployment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStopDeployment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StopDeploymentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStopDeploymentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateApplication struct {
}

func (*validateOpUpdateApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateConfigurationProfile struct {
}

func (*validateOpUpdateConfigurationProfile) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateConfigurationProfile) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateConfigurationProfileInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateConfigurationProfileInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDeploymentStrategy struct {
}

func (*validateOpUpdateDeploymentStrategy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDeploymentStrategy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDeploymentStrategyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDeploymentStrategyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateEnvironment struct {
}

func (*validateOpUpdateEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateExtensionAssociation struct {
}

func (*validateOpUpdateExtensionAssociation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateExtensionAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateExtensionAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateExtensionAssociationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateExtension struct {
}

func (*validateOpUpdateExtension) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateExtension) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateExtensionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateExtensionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpValidateConfiguration struct {
}

func (*validateOpValidateConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpValidateConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ValidateConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpValidateConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateApplication{}, middleware.After)
}

func addOpCreateConfigurationProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateConfigurationProfile{}, middleware.After)
}

func addOpCreateDeploymentStrategyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDeploymentStrategy{}, middleware.After)
}

func addOpCreateEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateEnvironment{}, middleware.After)
}

func addOpCreateExtensionAssociationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateExtensionAssociation{}, middleware.After)
}

func addOpCreateExtensionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateExtension{}, middleware.After)
}

func addOpCreateHostedConfigurationVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateHostedConfigurationVersion{}, middleware.After)
}

func addOpDeleteApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApplication{}, middleware.After)
}

func addOpDeleteConfigurationProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteConfigurationProfile{}, middleware.After)
}

func addOpDeleteDeploymentStrategyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDeploymentStrategy{}, middleware.After)
}

func addOpDeleteEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteEnvironment{}, middleware.After)
}

func addOpDeleteExtensionAssociationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteExtensionAssociation{}, middleware.After)
}

func addOpDeleteExtensionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteExtension{}, middleware.After)
}

func addOpDeleteHostedConfigurationVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteHostedConfigurationVersion{}, middleware.After)
}

func addOpGetApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetApplication{}, middleware.After)
}

func addOpGetConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetConfiguration{}, middleware.After)
}

func addOpGetConfigurationProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetConfigurationProfile{}, middleware.After)
}

func addOpGetDeploymentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDeployment{}, middleware.After)
}

func addOpGetDeploymentStrategyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDeploymentStrategy{}, middleware.After)
}

func addOpGetEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetEnvironment{}, middleware.After)
}

func addOpGetExtensionAssociationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetExtensionAssociation{}, middleware.After)
}

func addOpGetExtensionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetExtension{}, middleware.After)
}

func addOpGetHostedConfigurationVersionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetHostedConfigurationVersion{}, middleware.After)
}

func addOpListConfigurationProfilesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListConfigurationProfiles{}, middleware.After)
}

func addOpListDeploymentsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListDeployments{}, middleware.After)
}

func addOpListEnvironmentsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListEnvironments{}, middleware.After)
}

func addOpListHostedConfigurationVersionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListHostedConfigurationVersions{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpStartDeploymentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartDeployment{}, middleware.After)
}

func addOpStopDeploymentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStopDeployment{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateApplication{}, middleware.After)
}

func addOpUpdateConfigurationProfileValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateConfigurationProfile{}, middleware.After)
}

func addOpUpdateDeploymentStrategyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDeploymentStrategy{}, middleware.After)
}

func addOpUpdateEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateEnvironment{}, middleware.After)
}

func addOpUpdateExtensionAssociationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateExtensionAssociation{}, middleware.After)
}

func addOpUpdateExtensionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateExtension{}, middleware.After)
}

func addOpValidateConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpValidateConfiguration{}, middleware.After)
}

func validateMonitor(v *types.Monitor) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Monitor"}
	if v.AlarmArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AlarmArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMonitorList(v []types.Monitor) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MonitorList"}
	for i := range v {
		if err := validateMonitor(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateValidator(v *types.Validator) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Validator"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateValidatorList(v []types.Validator) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ValidatorList"}
	for i := range v {
		if err := validateValidator(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateApplicationInput(v *CreateApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateApplicationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateConfigurationProfileInput(v *CreateConfigurationProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateConfigurationProfileInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.LocationUri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LocationUri"))
	}
	if v.Validators != nil {
		if err := validateValidatorList(v.Validators); err != nil {
			invalidParams.AddNested("Validators", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDeploymentStrategyInput(v *CreateDeploymentStrategyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDeploymentStrategyInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.DeploymentDurationInMinutes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentDurationInMinutes"))
	}
	if v.GrowthFactor == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GrowthFactor"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateEnvironmentInput(v *CreateEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateEnvironmentInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Monitors != nil {
		if err := validateMonitorList(v.Monitors); err != nil {
			invalidParams.AddNested("Monitors", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateExtensionAssociationInput(v *CreateExtensionAssociationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateExtensionAssociationInput"}
	if v.ExtensionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExtensionIdentifier"))
	}
	if v.ResourceIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateExtensionInput(v *CreateExtensionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateExtensionInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Actions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Actions"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateHostedConfigurationVersionInput(v *CreateHostedConfigurationVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateHostedConfigurationVersionInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if v.Content == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Content"))
	}
	if v.ContentType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ContentType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApplicationInput(v *DeleteApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApplicationInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteConfigurationProfileInput(v *DeleteConfigurationProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteConfigurationProfileInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDeploymentStrategyInput(v *DeleteDeploymentStrategyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDeploymentStrategyInput"}
	if v.DeploymentStrategyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentStrategyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteEnvironmentInput(v *DeleteEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteEnvironmentInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteExtensionAssociationInput(v *DeleteExtensionAssociationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteExtensionAssociationInput"}
	if v.ExtensionAssociationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExtensionAssociationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteExtensionInput(v *DeleteExtensionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteExtensionInput"}
	if v.ExtensionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExtensionIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteHostedConfigurationVersionInput(v *DeleteHostedConfigurationVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteHostedConfigurationVersionInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetApplicationInput(v *GetApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetApplicationInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetConfigurationInput(v *GetConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetConfigurationInput"}
	if v.Application == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Application"))
	}
	if v.Environment == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Environment"))
	}
	if v.Configuration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Configuration"))
	}
	if v.ClientId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetConfigurationProfileInput(v *GetConfigurationProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetConfigurationProfileInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDeploymentInput(v *GetDeploymentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDeploymentInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.DeploymentNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDeploymentStrategyInput(v *GetDeploymentStrategyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDeploymentStrategyInput"}
	if v.DeploymentStrategyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentStrategyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetEnvironmentInput(v *GetEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetEnvironmentInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetExtensionAssociationInput(v *GetExtensionAssociationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetExtensionAssociationInput"}
	if v.ExtensionAssociationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExtensionAssociationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetExtensionInput(v *GetExtensionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetExtensionInput"}
	if v.ExtensionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExtensionIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetHostedConfigurationVersionInput(v *GetHostedConfigurationVersionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetHostedConfigurationVersionInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListConfigurationProfilesInput(v *ListConfigurationProfilesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListConfigurationProfilesInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListDeploymentsInput(v *ListDeploymentsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListDeploymentsInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListEnvironmentsInput(v *ListEnvironmentsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListEnvironmentsInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListHostedConfigurationVersionsInput(v *ListHostedConfigurationVersionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListHostedConfigurationVersionsInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartDeploymentInput(v *StartDeploymentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartDeploymentInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.DeploymentStrategyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentStrategyId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if v.ConfigurationVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStopDeploymentInput(v *StopDeploymentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StopDeploymentInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.DeploymentNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateApplicationInput(v *UpdateApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateApplicationInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateConfigurationProfileInput(v *UpdateConfigurationProfileInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateConfigurationProfileInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if v.Validators != nil {
		if err := validateValidatorList(v.Validators); err != nil {
			invalidParams.AddNested("Validators", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDeploymentStrategyInput(v *UpdateDeploymentStrategyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDeploymentStrategyInput"}
	if v.DeploymentStrategyId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentStrategyId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateEnvironmentInput(v *UpdateEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateEnvironmentInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.Monitors != nil {
		if err := validateMonitorList(v.Monitors); err != nil {
			invalidParams.AddNested("Monitors", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateExtensionAssociationInput(v *UpdateExtensionAssociationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateExtensionAssociationInput"}
	if v.ExtensionAssociationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExtensionAssociationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateExtensionInput(v *UpdateExtensionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateExtensionInput"}
	if v.ExtensionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExtensionIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpValidateConfigurationInput(v *ValidateConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ValidateConfigurationInput"}
	if v.ApplicationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationId"))
	}
	if v.ConfigurationProfileId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationProfileId"))
	}
	if v.ConfigurationVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConfigurationVersion"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
