/*
 * Copyright (C) 2023 Chris Talbot
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <adwaita.h>
#define METERS_TO_SECOND_TO_MPH 2.236936
#define METERS_T0_MILES 0.0006213712
#define METERS_TO_FEET 3.28084

G_BEGIN_DECLS

#define GEOCLUE_STUMBLER_TYPE_PATH_PAGE (geoclue_stumbler_path_page_get_type())
G_DECLARE_FINAL_TYPE (GeoclueStumblerPathPage, geoclue_stumbler_path_page, GEOCLUE_STUMBLER, PATH_PAGE, AdwBin)

void
geoclue_stumbler_path_page_set_toast_overlay (GeoclueStumblerPathPage *self,
                                             AdwToastOverlay         *toast_overlay);

void
geoclue_stumbler_path_page_set_maps_page (GeoclueStumblerPathPage *self,
                                          GtkWidget               *maps_page_bin);

gboolean
geoclue_stumbler_path_page_get_recording_path (GeoclueStumblerPathPage *self);

void
geoclue_stumbler_path_page_set_gps_lock (GeoclueStumblerPathPage *self,
                                         gboolean                 lock);

void
geoclue_stumbler_path_page_update_page (GeoclueStumblerPathPage *self,
                                        double latitude,
                                        double longitude,
                                        double speed_meters_per_second,
                                        double altitude);

G_END_DECLS
