/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007-2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>

#ifndef backup_menu_H
#define backup_menu_H

extern struct w *widgets;

void show_backup_menu(struct w *widgets);

void show_server_menu(char type[128], struct w *widgets);

void show_src_filesel(struct w *widgets);
void show_dst_filesel(struct w *widgets);

void src_filesel_ok(struct w *widgets);
void dst_filesel_ok(struct w *widgets);

void src_filesel_cancel(struct w *widgets);
void dst_filesel_cancel(struct w *widgets);

void scroll_to_last_row(GtkTreeView *treeview);

void backup_local_checkbutton_toggled(GtkButton *button, struct w *widgets);
void backup_local_remote_checkbutton_toggled(GtkButton *button, struct w *widgets);
void backup_remote_local_checkbutton_toggled(GtkButton *button, struct w *widgets);

#endif
