/*
  DB Mixer
  ========
  Description: 
    a DJ Mixer style GUI interface to the DBMix system.

	Copyright (c) 1999, 2000 Robert Michael S Dean

	Author: Robert Michael S Dean
	Version: 1.0


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <dbchannel.h>
#include <dbdebug.h>

#include "dbmixer.h"
#include "save_prefs.h"

#ifdef EXT_MIXER
#include "exmixer.h"
#include "exmixer_prefs.h"
extern int exmixer_enabled;
#endif

static GtkWidget *dialog, *label;
static gint main_device_index, cue_device_index, main_mixer_index, cue_mixer_index;
static GtkSpinButton * clip_spin_button, * numbuffs_spin_button, * skip_spin_button;
extern dbfsd_data *sysdata;
extern gint fade_time_base;


GtkWidget *exmixer_toggle_button; 
GtkWidget *exmixer_config_button; 

void dbmixer_prefs_save(GtkWidget * w, gpointer data)
{
	sprintf(sysdata->main_audio_device,"/dev/dsp%d",main_device_index);
	sprintf(sysdata->cue_audio_device,"/dev/dsp%d",cue_device_index);
	sprintf(sysdata->main_mixer_device,"/dev/mixer%d",main_mixer_index);
	sprintf(sysdata->cue_mixer_device,"/dev/mixer%d",cue_mixer_index);

	Debug("%s",sysdata->main_audio_device);
	Debug("%s",sysdata->cue_audio_device);
	Debug("%s",sysdata->main_mixer_device);
	Debug("%s",sysdata->cue_mixer_device);

	sysdata->num_main_buffs = gtk_spin_button_get_value_as_int(numbuffs_spin_button);
	sysdata->num_cue_buffs = gtk_spin_button_get_value_as_int(numbuffs_spin_button);

	sysdata->skip_max = gtk_spin_button_get_value_as_int(skip_spin_button);


	if (sysdata->num_main_buffs < DB_MIN_AUDIO_BUFFS)
	{
		sysdata->num_main_buffs = DB_MIN_AUDIO_BUFFS;
		sysdata->num_cue_buffs = DB_MIN_AUDIO_BUFFS;
	}

	Debug("num main buffs: %d  num cue buffs: %d",
		  sysdata->num_main_buffs, sysdata->num_cue_buffs);

	sysdata->clipping_threshold = (gtk_spin_button_get_value_as_float(clip_spin_button) 
								   * DB_BUFSIZE_SHORT * DB_CHANNEL_NUM_CHANNELS) / 100 ;
	Debug("clipping threshold %d",sysdata->clipping_threshold);

	

/* 	fade_time_base = gtk_spin_button_get_value_as_int(fade_time_spin_button); */

	/* #ifdef EXT_MIXER */
	write_settings();
	/* #endif */

	gtk_widget_destroy(dialog);
}

void dbmixer_prefs_cancel(GtkWidget * w, gpointer data)
{
	gtk_widget_destroy(dialog);
}


void main_audio_selected(GtkWidget* widget, gint device)
{
	Debug("main audio device is: %d\n",device);
	main_device_index = device;
}


void main_mixer_selected(GtkWidget* widget, gint device)
{
	Debug("main mixer device is: %d\n",device);
	main_mixer_index = device;
}


void cue_audio_selected(GtkWidget* widget, gint device)
{
	Debug("cue audio device is: %d\n",device);
	cue_device_index = device;
}


void cue_mixer_selected(GtkWidget* widget, gint device)
{
	Debug("cue mixer device is: %d\n",device);
	cue_mixer_index = device;
}

void clipping_changed(GtkAdjustment * adj)
{
	sysdata->clipping_threshold = (gtk_spin_button_get_value_as_float(clip_spin_button) 
								   * DB_BUFSIZE_SHORT * DB_CHANNEL_NUM_CHANNELS) / 100 ;
	Debug("clipping threshold %d",sysdata->clipping_threshold);
}


void skip_changed(GtkAdjustment * adj)
{
	sysdata->skip_max = gtk_spin_button_get_value_as_int(skip_spin_button);
	Debug("skip setting %d",sysdata->skip_max);
}


#ifdef EXT_MIXER 
void exmixer_toggle_clicked(GtkWidget *widget) 
{ 
    if (GTK_TOGGLE_BUTTON (widget)->active) 
    { 
       exmixer_enabled = TRUE; 
       exmixer_start(); 
    } 
    else 
    { 
       exmixer_enabled = FALSE; 
       exmixer_stop(); 
    } 
    
    /* Grey out the button if needed */ 
    gtk_widget_set_sensitive( GTK_WIDGET(exmixer_config_button), exmixer_enabled); 
} 
#endif 


/*  The following functions are shamelessly borrowed from xmms =) */
static void scan_devices(gchar * type, GtkWidget * option_menu, GtkSignalFunc sigfunc)
{
	GtkWidget *menu, *item;
	FILE *file;
	gchar buffer[256], *temp, *tmp2;
	gboolean found = FALSE;
	gint index = 0;

	menu = gtk_menu_new();

	if ((file = fopen("/dev/sndstat", "r")))
	{
		while (fgets(buffer, 255, file))
		{
			if (found && buffer[0] == '\n')
				break;

			if (buffer[strlen(buffer) - 1] == '\n')
				buffer[strlen(buffer) - 1] = '\0';

			if (found)
			{
				if (index == 0)
				{
					tmp2 = strchr(buffer, ':');
					if (tmp2)
					{
						tmp2++;
						while (*tmp2 == ' ')
						{
							tmp2++;
						}
					}
					else
					{
						tmp2 = buffer;
					}

					temp = g_strdup_printf("Default (%s)", tmp2);

					if (strstr(temp,"Open by") == NULL)
					{
						item = gtk_menu_item_new_with_label(temp);
					}
					else
					{
						item = NULL;
					}

					g_free(temp);
				}
				else
				{
					if (strstr(buffer,"Open by") == NULL)
					{
						item = gtk_menu_item_new_with_label(buffer);
					}
					else
					{
						item = NULL;
					}
				}

				if (item)
				{
					gtk_signal_connect(GTK_OBJECT(item), "activate", sigfunc, (gpointer) index++);
					gtk_widget_show(item);
					gtk_menu_append(GTK_MENU(menu), item);
				}
			}
			if (!strcasecmp(buffer, type))
				found = 1;

		}
		fclose(file);
	}
	else
	{
		item = gtk_menu_item_new_with_label("Default");
		gtk_signal_connect(GTK_OBJECT(item), "activate", sigfunc, (gpointer) 0);
		gtk_widget_show(item);
		gtk_menu_append(GTK_MENU(menu), item);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), menu);
}

/* end shameless borrowing =) */


void preferences_dialog(void)
{
	GtkWidget * main_box, *hbox, *vbox;
	GtkWidget * master_device_menu, * cue_device_menu;
	GtkWidget * main_mixer_menu, * cue_mixer_menu;
	GtkWidget * button;
	GtkWidget * soundcard_frame;
	GtkWidget * tune_frame;
	GtkAdjustment * adj;
/*     char *buf = (char *)malloc(30);  */

	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), "DBMix Preferences");
	gtk_container_border_width(GTK_CONTAINER(dialog), 5);

	main_box = gtk_vbox_new(FALSE,10);

	sscanf(sysdata->main_audio_device,"/dev/dsp%d",&main_device_index);
	sscanf(sysdata->cue_audio_device,"/dev/dsp%d",&cue_device_index);

	sscanf(sysdata->main_mixer_device,"/dev/mixer%d",&main_mixer_index);
	sscanf(sysdata->cue_mixer_device,"/dev/mixer%d",&cue_mixer_index);

	/* add frame for audio devices */
	{
		soundcard_frame = gtk_frame_new(SOUNDCARD_FRAME_STR);

		vbox = gtk_vbox_new(TRUE,0);

		label = gtk_label_new("Any change made here will not take effect until the soundcards are reset.\n To do this, choose \"Reset Soundcard\" from the Options menu.");

		gtk_label_set_justify((GtkLabel*)label,GTK_JUSTIFY_LEFT);
		gtk_widget_show(label);
		gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);

		/* add master audio device selector */
		{
			hbox = gtk_hbox_new(TRUE,10);
		
			label = gtk_label_new("Main Audio Device:");
			gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,10);
			gtk_widget_show(label);
  		
			master_device_menu = gtk_option_menu_new();
   
			scan_devices("Audio devices:", master_device_menu, main_audio_selected);
			gtk_option_menu_set_history(GTK_OPTION_MENU(master_device_menu),main_device_index);
			gtk_box_pack_start(GTK_BOX(hbox),master_device_menu,FALSE,FALSE,10);
			gtk_widget_show(master_device_menu);

			gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
		}

		/* add main mixer device selector */
		{
			hbox = gtk_hbox_new(TRUE,10);
		
			label = gtk_label_new("Main Mixer Device:");
			gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,10);
			gtk_widget_show(label);
  		
			main_mixer_menu = gtk_option_menu_new();
   
			scan_devices("Mixers:", main_mixer_menu, main_mixer_selected);
			gtk_option_menu_set_history(GTK_OPTION_MENU(main_mixer_menu),main_mixer_index);
			gtk_box_pack_start(GTK_BOX(hbox),main_mixer_menu,FALSE,FALSE,10);
			gtk_widget_show(main_mixer_menu);

			gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		}

		/* add cue audio device selector */
		{
			hbox = gtk_hbox_new(TRUE,10);
		
			label = gtk_label_new("Cue Audio Device:");
			gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,10);
			gtk_widget_show(label);
  		
			cue_device_menu = gtk_option_menu_new();
   
			scan_devices("Audio devices:", cue_device_menu, cue_audio_selected);
			gtk_option_menu_set_history(GTK_OPTION_MENU(cue_device_menu),cue_device_index);
			gtk_box_pack_start(GTK_BOX(hbox),cue_device_menu,FALSE,FALSE,10);
			gtk_widget_show(cue_device_menu);

			gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		}

		/* add main mixer device selector */
		{
			hbox = gtk_hbox_new(TRUE,10);
		
			label = gtk_label_new("Cue Mixer Device:");
			gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,10);
			gtk_widget_show(label);
  		
			cue_mixer_menu = gtk_option_menu_new();
   
			scan_devices("Mixers:", cue_mixer_menu, cue_mixer_selected);
			gtk_option_menu_set_history(GTK_OPTION_MENU(cue_mixer_menu),cue_mixer_index);
			gtk_box_pack_start(GTK_BOX(hbox),cue_mixer_menu,FALSE,FALSE,10);
			gtk_widget_show(cue_mixer_menu);

			gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		}

		gtk_widget_show(vbox);
		gtk_container_add(GTK_CONTAINER(soundcard_frame),vbox);
		gtk_widget_show(soundcard_frame);
		gtk_box_pack_start(GTK_BOX(main_box),soundcard_frame,FALSE,FALSE,0);

	}

	/* add dbmix tuning options */
	{
		float clip_value;

		tune_frame = gtk_frame_new(TUNE_STR);
		vbox = gtk_vbox_new(FALSE,10);

		/* add description string */
		label = gtk_label_new("Tuning Directions: Adjust the following variables to tune dbmix to your tastes.\n\n \
Clipping Threshold is the percentage of samples that are allowed to be clipped \n \
before triggering the Clipping Light\n\n \
 Number of Audio Buffers has to do with the lag between performing an action on \n \
an audio stream, and the results of that action being heard.  Reducing the number \n \
of buffers will reduce the lag. This is the same as the -r option for dbfsd, and the \n \
soundcard must be reset with dbmixer->Options->Reset Soundcard for changes to take effect.\n\n \
Skip Value: If your audio output skips like a CD with multiple audio streams at pitches other \n \
than 100%, increase this value. If not, decrease it. For example, my PC is fast and uses a \n \
skip value of 10.");
		
		gtk_label_set_justify((GtkLabel*)label,GTK_JUSTIFY_LEFT);
		gtk_widget_show(label);
		gtk_box_pack_start(GTK_BOX(vbox),label,FALSE,FALSE,0);
		
		/* add clipping threshold spin button */

		clip_value = ((float) (sysdata->clipping_threshold  * 100)) / 
			DB_BUFSIZE_SHORT / DB_CHANNEL_NUM_CHANNELS;

		hbox = gtk_hbox_new(FALSE,10);
		
		adj = (GtkAdjustment*) gtk_adjustment_new(clip_value,0.0,100,0.5,1.0,1.0);

		label = gtk_label_new("Clipping Threshold");
		gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);
  		
		clip_spin_button = (GtkSpinButton*) gtk_spin_button_new(adj,0.5,1);
		gtk_box_pack_start(GTK_BOX(hbox),(GtkWidget*)clip_spin_button,FALSE,FALSE,10);		

		gtk_signal_connect (GTK_OBJECT(adj), "value_changed", 
							GTK_SIGNAL_FUNC(clipping_changed),NULL);
 
		/* add num audio buffs spin button */
		
		adj = (GtkAdjustment*) gtk_adjustment_new(
				 sysdata->num_main_buffs,0.0,DB_NUM_FRAGMENTS,1.0,1.0,1.0);

		label = gtk_label_new("Number of Audio Buffers:");
		gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);
  		
		numbuffs_spin_button = (GtkSpinButton*) gtk_spin_button_new(adj,1.0,0);
		gtk_box_pack_start(GTK_BOX(hbox),(GtkWidget*)numbuffs_spin_button,FALSE,FALSE,10); 

/* 		gtk_widget_show(hbox); */
/* 		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);		 */

/* 		hbox = gtk_hbox_new(TRUE,10); */

		/* add default audiofade speed button */
#if 0
		adj = (GtkAdjustment*) gtk_adjustment_new(
				 fade_time_base,0.0,fade_time_base*4,1.0,1.0,1.0);

		label = gtk_label_new("Base Autofade Spd.:");
		gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);
  		
	    fade_time_spin_button = (GtkSpinButton*) gtk_spin_button_new(adj,1.0,0);
		gtk_box_pack_start(GTK_BOX(hbox),(GtkWidget*)fade_time_spin_button,FALSE,FALSE,10); 
#endif

		/* add skip value button */
		adj = (GtkAdjustment*) gtk_adjustment_new(
				 sysdata->skip_max,0.0,MAX_SKIP_MAX,1.0,1.0,1.0);

		label = gtk_label_new("Skip Value:");
		gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,0);
		gtk_widget_show(label);
  		
	    skip_spin_button = (GtkSpinButton*) gtk_spin_button_new(adj,1.0,0);
		gtk_box_pack_start(GTK_BOX(hbox),(GtkWidget*)skip_spin_button,FALSE,FALSE,10); 


		gtk_signal_connect (GTK_OBJECT(adj), "value_changed", 
							GTK_SIGNAL_FUNC(skip_changed),NULL);

		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
		gtk_widget_show(hbox);

		gtk_container_add(GTK_CONTAINER(tune_frame),vbox);
		gtk_widget_show(vbox);
		gtk_widget_show(tune_frame);
		gtk_box_pack_start(GTK_BOX(main_box),tune_frame,FALSE,FALSE,0);
	}



#ifdef EXT_MIXER 
    /* add external mixer toggle button and device text entries*/ 
    { 
 
       hbox = gtk_hbox_new(FALSE,10); 
        
       exmixer_toggle_button = gtk_check_button_new_with_label ("Enable external mixer"); 
       gtk_widget_show (exmixer_toggle_button); 
       gtk_signal_connect(GTK_OBJECT(exmixer_toggle_button), "clicked", 
           GTK_SIGNAL_FUNC(exmixer_toggle_clicked), NULL); 
       gtk_box_pack_start(GTK_BOX(hbox),exmixer_toggle_button,FALSE,FALSE,0); 
        
       exmixer_config_button = gtk_button_new_with_label("  Config exmixer ...  "); 
       gtk_widget_show(GTK_WIDGET(exmixer_config_button)); 
       gtk_box_pack_start(GTK_BOX(hbox), exmixer_config_button, FALSE, FALSE, 0); 
 
       gtk_box_pack_start(GTK_BOX(main_box), hbox, FALSE, FALSE, 0); 
        
       /* Grey out the button if needed */ 
       gtk_widget_set_sensitive( GTK_WIDGET(exmixer_config_button), exmixer_enabled); 
    
       gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(exmixer_toggle_button), exmixer_enabled); 
        gtk_signal_connect (GTK_OBJECT (exmixer_config_button), "clicked", 
         GTK_SIGNAL_FUNC (start_exmixer_config), NULL); 
    } 
#endif 


	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), main_box, FALSE, FALSE, 0);
	gtk_widget_show(label);

	button = gtk_button_new_with_label("  SAVE  ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(dbmixer_prefs_save), NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);

	button = gtk_button_new_with_label(" CANCEL ");
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(dbmixer_prefs_cancel), NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button, FALSE, FALSE, 0);

	gtk_widget_show(button);

	gtk_widget_show_all(dialog);
	gtk_widget_grab_focus(button);

/* 	free(buf); */
}
