/*============================================================================
 * Code_Saturne documentation page
 *============================================================================*/

/*
  This file is part of Code_Saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2019 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*-----------------------------------------------------------------------------*/

/*!
  \page us_vort Unsteady inlet boundary condition for LES with the vortex method (usvort.f90)

  The subroutine \ref usvort allows generating an unsteady inlet boundary condition for LES with the
  vortex method. This method is based on the generation of vortices in the 2D inlet plane with help
  from pre-defined functions. The fluctuation normal to the inlet plane is generated by a Langevin
  equation. The subroutine \ref usvort specifies the parameters of this method.

  To allow the application of the vortex method, \c ivrtex must set to 1 in the
  \ref usipsu subroutine in the \ref cs_user_parameters.f90 file.

  \section usvort_h Vortex method parameters setting

  \subsection usvort_h_arg Arguments of usvort

  The function \ref usvort has the following arguments :

  \snippet usvort.f90 arg

  \subsection usvort_h_loc_var Local variables declaration

  Some local variables need to be declared as follows :

  \snippet usvort.f90 loc_var_dec

  \subsection usvort_h_allocate Allocation

  The \c lstelt array is allocated.

  \snippet usvort.f90 allocate

  \subsection usvort_h_glob_param Global parameters

  The following part defines the number of inlets concerned by the
  vortex method (\c nnentt) and the number of vortices for each
  inlet (\c nvort).

  \snippet usvort.f90 glob_param

  \subsection usvort_h_inlet Inlets definition

  Then, at the first call of \ref usvort (\c iappel=1), one defines the
  boundary faces at which the vortex method is applicable. The \c irepvo
  array, which defines the number of inlets concerned with the vortex,
  is filled with \c ient .

  \snippet usvort.f90 inlet

  \subsection usvort_h_bc Boundary conditions

  The following part defines the complexity of the geometry.

  \snippet usvort.f90 bc

  \subsection usvort_h_param Physical and time parameters

  Depending on the complexity of the geometry, the main parameters
  of the method are defined.

  \snippet usvort.f90 param

  \subsection usvort_h_input Input/Output parameters

  As \c icas is equal to 1 or 2 (see \ref usvort_h_bc), a data file
  \c ficvor must be defined for each inlet.

  \snippet usvort.f90 input

  \subsection usvort_h_deallocate Deallocation

  The \c lstelt array needs to be deallocated.

  \snippet usvort.f90 deallocate

  \section usvort_h_phidat Definition of the phidat function (interpolation)

  The \c phidat function allows to define the interpolation used
  in the vortex method. It is called by the subroutines \ref vorlgv,
  \ref vorvit, \ref vordep, and \ref vorini.

  \snippet usvort.f90 phidat

*/
